/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_map;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdMapULongType;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.JavaIterator;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapConstIterator;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.ir.FunctionSummary;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.GlobalValueSummary;
import org.llvm.ir.Module$IR;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public class ModuleSummaryIndex
implements Iterable<std_pair.pairULongType<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>>>,
Destructors.ClassWithDestructor {
    private std_map.mapULongType<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> GlobalValueMap;
    private StringMap<std_pair.pairULongType<std.arrayUInt>> ModulePathStringTable;

    public ModuleSummaryIndex() {
        this.GlobalValueMap = new std_map.mapULongType((Object)new std.vector(() -> new std_ptr.unique_ptr()));
        this.ModulePathStringTable = new StringMap((Object)new std_pair.pairULongType());
    }

    public ModuleSummaryIndex(ModuleSummaryIndex $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public void $assign(ModuleSummaryIndex $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public StdMapULongType.iterator<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> begin() {
        return this.GlobalValueMap.begin();
    }

    public StdMapULongType.iterator<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> begin$Const() {
        return this.GlobalValueMap.begin$Const();
    }

    public StdMapULongType.iterator<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> end() {
        return this.GlobalValueMap.end();
    }

    public StdMapULongType.iterator<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> end$Const() {
        return this.GlobalValueMap.end$Const();
    }

    public std.vector<std_ptr.unique_ptr<GlobalValueSummary>> getGlobalValueSummaryList(StringRef ValueName) {
        return (std.vector)this.GlobalValueMap.$at_T$RR(Long.valueOf(GlobalValue.getGUID(new StringRef(ValueName))));
    }

    public StdMapULongType.iterator<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> findGlobalValueSummaryList(StringRef ValueName) {
        return this.GlobalValueMap.find$Const(Long.valueOf(GlobalValue.getGUID(new StringRef(ValueName))));
    }

    public StdMapULongType.iterator<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> findGlobalValueSummaryList(long ValueGUID) {
        return this.GlobalValueMap.find$Const(Long.valueOf(ValueGUID));
    }

    public void addGlobalValueSummary(StringRef ValueName, std_ptr.unique_ptr<GlobalValueSummary> Summary) {
        ((std.vector)this.GlobalValueMap.$at_T$RR(Long.valueOf(GlobalValue.getGUID(new StringRef(ValueName))))).push_back_T$RR((Object)((std_ptr.unique_ptr)std.move(Summary)));
    }

    public void addGlobalValueSummary(long ValueGUID, std_ptr.unique_ptr<GlobalValueSummary> Summary) {
        ((std.vector)this.GlobalValueMap.$at_T$C$R(Long.valueOf(ValueGUID))).push_back_T$RR((Object)((std_ptr.unique_ptr)std.move(Summary)));
    }

    public GlobalValueSummary findSummaryInModule(long ValueGUID, StringRef ModuleId) {
        StdMapULongType.iterator<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> CalleeInfoList = this.findGlobalValueSummaryList(ValueGUID);
        if (CalleeInfoList.$eq(this.end$Const())) {
            return null;
        }
        StdVector.iterator Summary = (StdVector.iterator)llvm.find_if((Native.NativeIterable)((Native.NativeIterable)CalleeInfoList.$arrow().second), Summary$1 -> llvm.$eq_StringRef((StringRef)((GlobalValueSummary)Summary$1.$arrow()).modulePath(), (StringRef)ModuleId));
        if (std.$eq___normal_iterator$C((StdVector.iterator)Summary, (StdVector.iterator)((std.vector)CalleeInfoList.$arrow().second).end$Const())) {
            return null;
        }
        return (GlobalValueSummary)((std_ptr.unique_ptr)Summary.$arrow()).get();
    }

    public GlobalValueSummary getGlobalValueSummary(GlobalValue GV) {
        return this.getGlobalValueSummary(GV, true);
    }

    public GlobalValueSummary getGlobalValueSummary(GlobalValue GV, boolean PerModuleIndex) {
        assert (GV.hasName()) : "Can't get GlobalValueSummary for GV with no name";
        return this.getGlobalValueSummary(GlobalValue.getGUID(GV.getName()), PerModuleIndex);
    }

    public GlobalValueSummary getGlobalValueSummary(long ValueGUID) {
        return this.getGlobalValueSummary(ValueGUID, true);
    }

    public GlobalValueSummary getGlobalValueSummary(long ValueGUID, boolean PerModuleIndex) {
        StdMapULongType.iterator<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> SummaryList = this.findGlobalValueSummaryList(ValueGUID);
        assert (SummaryList.$noteq(this.end$Const())) : "GlobalValue not found in index";
        assert (!PerModuleIndex || ((std.vector)SummaryList.$arrow().second).size() == 1) : "Expected a single entry per global value in per-module index";
        std_ptr.unique_ptr Summary = (std_ptr.unique_ptr)((std.vector)SummaryList.$arrow().second).$at$Const(0);
        return (GlobalValueSummary)Summary.get();
    }

    public StringMap<std_pair.pairULongType<std.arrayUInt>> modulePaths$Const() {
        return this.ModulePathStringTable;
    }

    public StringMap<std_pair.pairULongType<std.arrayUInt>> modulePaths() {
        return this.ModulePathStringTable;
    }

    public long getModuleId(StringRef ModPath) {
        return ((std_pair.pairULongType)this.ModulePathStringTable.lookup((StringRef)new StringRef((StringRef)ModPath))).first;
    }

    public std.arrayUInt getModuleHash(StringRef ModPath) {
        StringMapIterator It = this.ModulePathStringTable.find$Const(ModPath);
        assert (It.$noteq((StringMapConstIterator)this.ModulePathStringTable.end$Const())) : "Module not registered";
        return (std.arrayUInt)((std_pair.pairULongType)It.$arrow().second).second;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFrom(std_ptr.unique_ptr<ModuleSummaryIndex> Other, long NextModuleId) {
        StringRef ModPath = new StringRef();
        for (std_pair.pairULongType<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> OtherGlobalValSummaryLists : (ModuleSummaryIndex)Other.$star()) {
            std_ptr.unique_ptr Summary = null;
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                long ValueGUID = OtherGlobalValSummaryLists.first;
                std.vector List2 = (std.vector)OtherGlobalValSummaryLists.second;
                assert (List2.size() == 1);
                Summary = new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, (std_ptr.unique_ptr)std.move((Object)((std_ptr.unique_ptr)List2.front())));
                if (ModPath.empty()) {
                    StringRef Path = ((GlobalValueSummary)Summary.$arrow()).modulePath();
                    ModPath.$assignMove(this.addModulePath(new StringRef(Path), NextModuleId, new std.arrayUInt(((ModuleSummaryIndex)Other.$arrow()).getModuleHash(new StringRef(Path)))).$arrow().first());
                } else assert (llvm.$eq_StringRef((StringRef)ModPath, (StringRef)((GlobalValueSummary)Summary.$arrow()).modulePath())) : "Each module in the combined map should have a unique ID";
                ((GlobalValueSummary)Summary.$arrow()).setModulePath(new StringRef(ModPath));
                this.addGlobalValueSummary(ValueGUID, (std_ptr.unique_ptr<GlobalValueSummary>)$c$.track(new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, (std_ptr.unique_ptr)std.move((Object)Summary))));
                $c$.clean();
            }
            finally {
                if (Summary != null) {
                    Summary.$destroy();
                }
                $c$.$destroy();
            }
        }
    }

    public static std.string getGlobalNameForLocal(StringRef Name, std.arrayUInt ModHash) {
        SmallString NewName = new SmallString(256, new StringRef(Name));
        NewName.$addassign(".llvm.");
        NewName.$addassign(new StringRef(llvm.utohexstr((long)Unsigned.$uint2ulong((int)ModHash.$at(0)))));
        return NewName.str().$string();
    }

    public static StringRef getOriginalNameBeforePromote(StringRef Name) {
        std_pair.pairTypeType Pair = Name.split(".llvm.");
        return new StringRef((StringRef)Pair.first);
    }

    public StringMapIterator<std_pair.pairULongType<std.arrayUInt>> addModulePath(StringRef ModPath, long ModId) {
        return this.addModulePath(ModPath, ModId, new std.arrayUInt(5, new int[]{0}));
    }

    public StringMapIterator<std_pair.pairULongType<std.arrayUInt>> addModulePath(StringRef ModPath, long ModId, std.arrayUInt Hash) {
        return new StringMapIterator(JavaDifferentiators.JD.Move.INSTANCE, (StringMapIterator)this.ModulePathStringTable.insert((std_pair.pair)std.make_pair((Object)((StringRef)Native.$Clone((NativeCloneable)ModPath)), (Object)((std_pair.pairULongType)Native.$Move((NativeMoveable)std.make_pair_ulong_T((long)ModId, (Object)((std.arrayUInt)Native.$Clone((NativeCloneable)Hash))))))).first);
    }

    public boolean hasExportedFunctions(Module$IR M) {
        return this.ModulePathStringTable.count(new StringRef(M.getModuleIdentifier())) != 0;
    }

    public void removeEmptySummaryEntries() {
        StdMapULongType.iterator<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> MI = this.begin();
        StdMapULongType.iterator<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> MIE = this.end();
        while (MI.$noteq(MIE)) {
            assert (((std.vector)MI.$arrow().second).size() == 1);
            if (!((std_ptr.unique_ptr)((std.vector)MI.$arrow().second).$at(0)).$bool()) {
                this.GlobalValueMap.erase((StdMapULongType.iterator)Native.$Clone(MI));
                MI.$preInc();
                continue;
            }
            MI.$preInc();
        }
    }

    public void collectDefinedFunctionsForModule(StringRef ModulePath, std_map.mapULongPtr<GlobalValueSummary> GVSummaryMap) {
        for (std_pair.pairULongType<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> GlobalList : this) {
            long GUID = GlobalList.first;
            for (std_ptr.unique_ptr GlobSummary : (std.vector)GlobalList.second) {
                FunctionSummary Summary = IrRTTI.dyn_cast_or_null_FunctionSummary((GlobalValueSummary)GlobSummary.get());
                if (Summary == null || llvm.$noteq_StringRef((StringRef)Summary.modulePath(), (StringRef)ModulePath)) continue;
                GVSummaryMap.$set(Long.valueOf(GUID), (Object)Summary);
            }
        }
    }

    public void collectDefinedGVSummariesPerModule(StringMap<std_map.mapULongPtr<GlobalValueSummary>> ModuleToDefinedGVSummaries) {
        for (std_pair.pairULongType<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>> GlobalList : this) {
            long GUID = GlobalList.first;
            for (std_ptr.unique_ptr Summary : (std.vector)GlobalList.second) {
                ((std_map.mapULongPtr)ModuleToDefinedGVSummaries.$at(((GlobalValueSummary)Summary.$arrow()).modulePath())).$set(Long.valueOf(GUID), (Object)((GlobalValueSummary)Summary.get()));
            }
        }
    }

    public void $destroy() {
        this.ModulePathStringTable.$destroy();
        this.GlobalValueMap.$destroy();
    }

    @Override
    public Iterator<std_pair.pairULongType<std.vector<std_ptr.unique_ptr<GlobalValueSummary>>>> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public String toString() {
        return "GlobalValueMap=" + this.GlobalValueMap + ", ModulePathStringTable=" + this.ModulePathStringTable;
    }
}

