/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.aliases.type;
import org.llvm.adt.PointerUnion;
import org.llvm.ir.DistinctMDOperandPlaceholder;
import org.llvm.ir.Metadata;
import org.llvm.ir.MetadataAsValue;
import org.llvm.ir.ReplaceableMetadataImpl;
import org.llvm.ir.java.IrRTTI;

public class MetadataTracking {
    public static boolean track(type.ptr<Metadata> MD) {
        return MetadataTracking.track(MD, (Metadata)Native.$Deref(MD), (PointerUnion<MetadataAsValue, Metadata>)new PointerUnion(JavaDifferentiators.JD$T1.INSTANCE, Metadata.class, (Object)null));
    }

    public static boolean track(type.ptr<Metadata> Ref, Metadata MD, Metadata Owner) {
        return MetadataTracking.track(Ref, MD, (PointerUnion<MetadataAsValue, Metadata>)new PointerUnion(JavaDifferentiators.JD$T1.INSTANCE, Metadata.class, (Object)((Metadata)Native.$AddrOf((Object)Owner))));
    }

    public static boolean track(type.ptr<Metadata> Ref, Metadata MD, MetadataAsValue Owner) {
        return MetadataTracking.track(Ref, MD, (PointerUnion<MetadataAsValue, Metadata>)new PointerUnion(JavaDifferentiators.JD$T.INSTANCE, MetadataAsValue.class, (Object)((MetadataAsValue)Native.$AddrOf((Object)Owner))));
    }

    public static void untrack(type.ptr<Metadata> MD) {
        MetadataTracking.untrack(MD, (Metadata)Native.$Deref(MD));
    }

    public static void untrack(type.ptr<Metadata> Ref, Metadata MD) {
        assert (Ref != null) : "Expected live reference";
        ReplaceableMetadataImpl R = ReplaceableMetadataImpl.getIfExists(MD);
        if (R != null) {
            R.dropRef(Ref);
        } else {
            DistinctMDOperandPlaceholder PH = IrRTTI.dyn_cast_DistinctMDOperandPlaceholder((Metadata)Native.$AddrOf((Object)MD));
            if (PH != null) {
                PH.Use = null;
            }
        }
    }

    public static boolean retrack(type.ptr<Metadata> MD, type.ptr<Metadata> New2) {
        return MetadataTracking.retrack(MD, (Metadata)Native.$Deref(MD), New2);
    }

    public static boolean retrack(type.ptr<Metadata> Ref, Metadata MD, type.ptr<Metadata> New2) {
        assert (Ref != null) : "Expected live reference";
        assert (New2 != null) : "Expected live reference";
        assert (Ref != New2) : "Expected change";
        ReplaceableMetadataImpl R = ReplaceableMetadataImpl.getIfExists(MD);
        if (R != null) {
            R.moveRef(Ref, New2, MD);
            return true;
        }
        assert (!IrRTTI.isa_DistinctMDOperandPlaceholder(MD)) : "Unexpected move of an MDOperand";
        assert (!MetadataTracking.isReplaceable(MD)) : "Expected un-replaceable metadata, since we didn't move a reference";
        return false;
    }

    public static boolean isReplaceable(Metadata MD) {
        return ReplaceableMetadataImpl.isReplaceable(MD);
    }

    private static boolean track(type.ptr<Metadata> Ref, Metadata MD, PointerUnion<MetadataAsValue, Metadata> Owner) {
        assert (Ref != null) : "Expected live reference";
        assert (Ref.$star() == MD) : "Expected address of MD";
        assert (Owner.$bool() || Ref.$star() == Native.$AddrOf((Object)MD)) : "Reference without owner must be direct";
        ReplaceableMetadataImpl R = ReplaceableMetadataImpl.getOrCreate(MD);
        if (R != null) {
            R.addRef(Ref, (PointerUnion<MetadataAsValue, Metadata>)new PointerUnion(Owner));
            return true;
        }
        DistinctMDOperandPlaceholder PH = IrRTTI.dyn_cast_DistinctMDOperandPlaceholder((Metadata)Native.$AddrOf((Object)MD));
        if (PH != null) {
            assert (PH.Use == null) : "Placeholders can only be used once";
            assert (!Owner.$bool()) : "Unexpected callback to owner";
            PH.Use = (type.ptr)Native.$noClone(Ref);
            return true;
        }
        return false;
    }

    public String toString() {
        return "";
    }
}

