/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.ir.FunctionType;
import org.llvm.ir.PointerType;
import org.llvm.ir.StructType;
import org.llvm.ir.Value;
import org.llvm.ir.impl.InlineAsmKeyType;
import org.llvm.ir.impl.LLVMContextImpl;
import org.llvm.ir.java.IrRTTI;

public class InlineAsm
extends Value
implements Destructors.ClassWithDestructor {
    private std.string AsmString;
    private std.string Constraints;
    private FunctionType FTy;
    private boolean HasSideEffects;
    private boolean IsAlignStack;
    private AsmDialect Dialect;
    public static final int Op_InputChain = 0;
    public static final int Op_AsmString = 1;
    public static final int Op_MDNode = 2;
    public static final int Op_ExtraInfo = 3;
    public static final int Op_FirstOperand = 4;
    public static final int MIOp_AsmString = 0;
    public static final int MIOp_ExtraInfo = 1;
    public static final int MIOp_FirstOperand = 2;
    public static final int Extra_HasSideEffects = 1;
    public static final int Extra_IsAlignStack = 2;
    public static final int Extra_AsmDialect = 4;
    public static final int Extra_MayLoad = 8;
    public static final int Extra_MayStore = 16;
    public static final int Extra_IsConvergent = 32;
    public static final int Kind_RegUse = 1;
    public static final int Kind_RegDef = 2;
    public static final int Kind_RegDefEarlyClobber = 3;
    public static final int Kind_Clobber = 4;
    public static final int Kind_Imm = 5;
    public static final int Kind_Mem = 6;
    public static final int Constraint_Unknown = 0;
    public static final int Constraint_es = 1;
    public static final int Constraint_i = 2;
    public static final int Constraint_m = 3;
    public static final int Constraint_o = 4;
    public static final int Constraint_v = 5;
    public static final int Constraint_Q = 6;
    public static final int Constraint_R = 7;
    public static final int Constraint_S = 8;
    public static final int Constraint_T = 9;
    public static final int Constraint_Um = 10;
    public static final int Constraint_Un = 11;
    public static final int Constraint_Uq = 12;
    public static final int Constraint_Us = 13;
    public static final int Constraint_Ut = 14;
    public static final int Constraint_Uv = 15;
    public static final int Constraint_Uy = 16;
    public static final int Constraint_X = 17;
    public static final int Constraint_Z = 18;
    public static final int Constraint_ZC = 19;
    public static final int Constraint_Zy = 20;
    public static final int Constraints_Max = 20;
    public static final int Constraints_ShiftAmount = 16;
    public static final int Flag_MatchingOperand = Integer.MIN_VALUE;

    protected InlineAsm(InlineAsm $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(InlineAsm $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public InlineAsm(FunctionType FTy, std.string asmString, std.string constraints, boolean hasSideEffects, boolean isAlignStack, AsmDialect asmDialect) {
        super(PointerType.getUnqual(FTy), Value.ValueTy.InlineAsmVal.getValue());
        this.AsmString = new std.string(asmString);
        this.Constraints = new std.string(constraints);
        this.FTy = FTy;
        this.HasSideEffects = hasSideEffects;
        this.IsAlignStack = isAlignStack;
        this.Dialect = asmDialect;
        assert (InlineAsm.Verify(this.getFunctionType(), new StringRef(constraints))) : "Function type not legal for constraints!";
    }

    @Override
    public void $destroy() {
        this.Constraints.$destroy();
        this.AsmString.$destroy();
        super.$destroy();
    }

    private void destroyConstant() {
        this.getType().getContext().pImpl.InlineAsms.remove(this);
        Destructors.$destroy((Destructors.ClassWithDestructor)this);
    }

    public static InlineAsm get(FunctionType FTy, StringRef AsmString, StringRef Constraints, boolean hasSideEffects) {
        return InlineAsm.get(FTy, AsmString, Constraints, hasSideEffects, false, AsmDialect.AD_ATT);
    }

    public static InlineAsm get(FunctionType FTy, StringRef AsmString, StringRef Constraints, boolean hasSideEffects, boolean isAlignStack) {
        return InlineAsm.get(FTy, AsmString, Constraints, hasSideEffects, isAlignStack, AsmDialect.AD_ATT);
    }

    public static InlineAsm get(FunctionType FTy, StringRef AsmString, StringRef Constraints, boolean hasSideEffects, boolean isAlignStack, AsmDialect asmDialect) {
        InlineAsmKeyType Key = new InlineAsmKeyType(new StringRef(AsmString), new StringRef(Constraints), FTy, hasSideEffects, isAlignStack, asmDialect);
        LLVMContextImpl pImpl = FTy.getContext().pImpl;
        return pImpl.InlineAsms.getOrCreate(PointerType.getUnqual(FTy), new InlineAsmKeyType(Key));
    }

    public boolean hasSideEffects() {
        return this.HasSideEffects;
    }

    public boolean isAlignStack() {
        return this.IsAlignStack;
    }

    public AsmDialect getDialect() {
        return this.Dialect;
    }

    @Override
    public PointerType getType() {
        return (PointerType)Casts.reinterpret_cast(PointerType.class, (Object)super.getType());
    }

    public FunctionType getFunctionType() {
        return this.FTy;
    }

    public std.string getAsmString() {
        return this.AsmString;
    }

    public std.string getConstraintString() {
        return this.Constraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Verify(FunctionType Ty, StringRef ConstStr) {
        std.vector<ConstraintInfo> Constraints = null;
        try {
            boolean bl;
            int i;
            if (Ty.isVarArg()) {
                boolean bl2 = false;
                return bl2;
            }
            Constraints = InlineAsm.ParseConstraints(new StringRef(ConstStr));
            if (Constraints.empty() && !ConstStr.empty()) {
                boolean bl3 = false;
                return bl3;
            }
            int NumOutputs = 0;
            int NumInputs = 0;
            int NumClobbers = 0;
            int NumIndirect = 0;
            int e = Constraints.size();
            block20: for (i = 0; i != e; ++i) {
                switch (((ConstraintInfo)Constraints.$at((int)i)).Type) {
                    case isOutput: {
                        if (NumInputs - NumIndirect != 0 || NumClobbers != 0) {
                            boolean bl4 = false;
                            return bl4;
                        }
                        if (!((ConstraintInfo)Constraints.$at((int)i)).isIndirect) {
                            ++NumOutputs;
                            continue block20;
                        }
                        ++NumIndirect;
                    }
                    case isInput: {
                        if (NumClobbers != 0) {
                            boolean bl5 = false;
                            return bl5;
                        }
                        ++NumInputs;
                        continue block20;
                    }
                    case isClobber: {
                        ++NumClobbers;
                    }
                }
            }
            switch (NumOutputs) {
                case 0: {
                    if (Ty.getReturnType().isVoidTy()) break;
                    i = 0;
                    return i != 0;
                }
                case 1: {
                    if (!Ty.getReturnType().isStructTy()) break;
                    i = 0;
                    return i != 0;
                }
                default: {
                    StructType STy = IrRTTI.dyn_cast_StructType(Ty.getReturnType());
                    if (STy != null && STy.getNumElements() == NumOutputs) break;
                    boolean bl6 = false;
                    return bl6;
                }
            }
            if (Ty.getNumParams() != NumInputs) {
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            if (Constraints != null) {
                Constraints.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.vector<ConstraintInfo> ParseConstraints(StringRef Constraints) {
        std.vector Result2 = null;
        try {
            Result2 = new std.vector((Object)new ConstraintInfo());
            char.ptr I = Native.$tryClone((char.ptr)Constraints.begin());
            char.ptr E = Native.$tryClone((char.ptr)Constraints.end());
            while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
                ConstraintInfo Info = null;
                try {
                    Info = new ConstraintInfo();
                    char.ptr ConstraintEnd = Native.$tryClone((char.ptr)std.find((char.ptr)I, (char.ptr)E, (byte)44));
                    if (Native.$eq_ptr((void.ptr)ConstraintEnd, (void.ptr)I) || Info.Parse(new StringRef(I, ConstraintEnd.$sub((abstract_iterator)I)), (std.vector<ConstraintInfo>)Result2)) {
                        Result2.clear();
                        break;
                    }
                    Result2.push_back_T$C$R((Object)Info);
                    I = Native.$tryClone((char.ptr)ConstraintEnd);
                    if (!Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) continue;
                    I.$preInc();
                    if (!Native.$eq_ptr((void.ptr)I, (void.ptr)E)) continue;
                    Result2.clear();
                    break;
                }
                finally {
                    if (Info == null) continue;
                    Info.$destroy();
                }
            }
            std.vector vector2 = new std.vector(JavaDifferentiators.JD.Move.INSTANCE, Result2);
            return vector2;
        }
        finally {
            if (Result2 != null) {
                Result2.$destroy();
            }
        }
    }

    public std.vector<ConstraintInfo> ParseConstraints() {
        return InlineAsm.ParseConstraints(new StringRef(this.Constraints));
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.InlineAsmVal.getValue();
    }

    public static int getFlagWord(int Kind2, int NumOps) {
        assert ((NumOps << 3 & 0xFFFF0000) == 0) : "Too many inline asm operands!";
        assert (Unsigned.$greatereq_uint((int)Kind2, (int)1) && Unsigned.$lesseq_uint((int)Kind2, (int)6)) : "Invalid Kind";
        return Kind2 | NumOps << 3;
    }

    public static boolean isRegDefKind(int Flag) {
        return InlineAsm.getKind(Flag) == 2;
    }

    public static boolean isImmKind(int Flag) {
        return InlineAsm.getKind(Flag) == 5;
    }

    public static boolean isMemKind(int Flag) {
        return InlineAsm.getKind(Flag) == 6;
    }

    public static boolean isRegDefEarlyClobberKind(int Flag) {
        return InlineAsm.getKind(Flag) == 3;
    }

    public static boolean isClobberKind(int Flag) {
        return InlineAsm.getKind(Flag) == 4;
    }

    public static int getFlagWordForMatchingOp(int InputFlag, int MatchedOperandNo) {
        assert (Unsigned.$lesseq_uint((int)MatchedOperandNo, (int)Short.MAX_VALUE)) : "Too big matched operand";
        assert ((InputFlag & 0xFFFF0000) == 0) : "High bits already contain data";
        return InputFlag | Integer.MIN_VALUE | MatchedOperandNo << 16;
    }

    public static int getFlagWordForRegClass(int InputFlag, int RC) {
        ++RC;
        assert (!InlineAsm.isImmKind(InputFlag)) : "Immediates cannot have a register class";
        assert (!InlineAsm.isMemKind(InputFlag)) : "Memory operand cannot have a register class";
        assert (Unsigned.$lesseq_uint((int)RC, (int)Short.MAX_VALUE)) : "Too large register class ID";
        assert ((InputFlag & 0xFFFF0000) == 0) : "High bits already contain data";
        return InputFlag | RC << 16;
    }

    public static int getFlagWordForMem(int InputFlag, int Constraint) {
        assert (InlineAsm.isMemKind(InputFlag)) : "InputFlag is not a memory constraint!";
        assert (Unsigned.$lesseq_uint((int)Constraint, (int)Short.MAX_VALUE)) : "Too large a memory constraint ID";
        assert (Unsigned.$lesseq_uint((int)Constraint, (int)20)) : "Unknown constraint ID";
        assert ((InputFlag & 0xFFFF0000) == 0) : "High bits already contain data";
        return InputFlag | Constraint << 16;
    }

    public static int convertMemFlagWordToMatchingFlagWord(int InputFlag) {
        assert (InlineAsm.isMemKind(InputFlag));
        return InputFlag & 0x8000FFFF;
    }

    public static int getKind(int Flags) {
        return Flags & 7;
    }

    public static int getMemoryConstraintID(int Flag) {
        assert (InlineAsm.isMemKind(Flag));
        return Flag >>> 16 & Short.MAX_VALUE;
    }

    public static int getNumOperandRegisters(int Flag) {
        return (Flag & 0xFFFF) >>> 3;
    }

    public static boolean isUseOperandTiedToDef(int Flag, uint.ref Idx) {
        if ((Flag & Integer.MIN_VALUE) == 0) {
            return false;
        }
        Idx.$set((Flag & Integer.MAX_VALUE) >>> 16);
        return true;
    }

    public static boolean hasRegClassConstraint(int Flag, uint.ref RC) {
        if ((Flag & Integer.MIN_VALUE) != 0) {
            return false;
        }
        int High = Flag >>> 16;
        if (High == 0) {
            return false;
        }
        RC.$set(High - 1);
        return true;
    }

    @Override
    public String toString() {
        return "AsmString=" + this.AsmString + ", Constraints=" + this.Constraints + ", FTy=" + this.FTy + ", HasSideEffects=" + this.HasSideEffects + ", IsAlignStack=" + this.IsAlignStack + ", Dialect=" + (Object)((Object)this.Dialect) + super.toString();
    }

    public static class ConstraintInfo
    implements NativeCloneable<ConstraintInfo>,
    Destructors.ClassWithDestructor {
        public ConstraintPrefix Type;
        public boolean isEarlyClobber;
        public byte MatchingInput;
        public boolean isCommutative;
        public boolean isIndirect;
        public std.vectorString Codes;
        public boolean isMultipleAlternative;
        public std.vector<SubConstraintInfo> multipleAlternatives;
        public int currentAlternativeIndex;

        public boolean hasMatchingInput() {
            return this.MatchingInput != -1;
        }

        public ConstraintInfo() {
            this.Type = ConstraintPrefix.isInput;
            this.isEarlyClobber = false;
            this.MatchingInput = Unsigned.$int2schar((int)-1);
            this.isCommutative = false;
            this.isIndirect = false;
            this.Codes = new std.vectorString(std.string.EMPTY);
            this.isMultipleAlternative = false;
            this.multipleAlternatives = new std.vector((Object)new SubConstraintInfo());
            this.currentAlternativeIndex = 0;
        }

        public boolean Parse(StringRef Str, std.vector<ConstraintInfo> ConstraintsSoFar) {
            char.ptr I = Native.$tryClone((char.ptr)Str.begin());
            char.ptr E = Native.$tryClone((char.ptr)Str.end());
            int multipleAlternativeCount = Str.count((byte)124) + 1;
            int multipleAlternativeIndex = 0;
            std.vectorString pCodes = (std.vectorString)Native.$AddrOf((Object)this.Codes);
            this.isMultipleAlternative = Unsigned.$greater_uint((int)multipleAlternativeCount, (int)1);
            if (this.isMultipleAlternative) {
                this.multipleAlternatives.resize(multipleAlternativeCount);
                pCodes = (std.vectorString)Native.$AddrOf((Object)((SubConstraintInfo)this.multipleAlternatives.$at((int)0)).Codes);
            }
            this.Type = ConstraintPrefix.isInput;
            this.isEarlyClobber = false;
            this.MatchingInput = Unsigned.$int2schar((int)-1);
            this.isCommutative = false;
            this.isIndirect = false;
            this.currentAlternativeIndex = 0;
            if (I.$star() == 126) {
                this.Type = ConstraintPrefix.isClobber;
                I.$preInc();
                if (Native.$noteq_ptr((void.ptr)I, (void.ptr)E) && I.$star() != 123) {
                    return true;
                }
            } else if (I.$star() == 61) {
                I.$preInc();
                this.Type = ConstraintPrefix.isOutput;
            }
            if (I.$star() == 42) {
                this.isIndirect = true;
                I.$preInc();
            }
            if (Native.$eq_ptr((void.ptr)I, (void.ptr)E)) {
                return true;
            }
            boolean DoneWithModifiers = false;
            while (!DoneWithModifiers) {
                switch (I.$star()) {
                    default: {
                        DoneWithModifiers = true;
                        break;
                    }
                    case 38: {
                        if (this.Type != ConstraintPrefix.isOutput || this.isEarlyClobber) {
                            return true;
                        }
                        this.isEarlyClobber = true;
                        break;
                    }
                    case 37: {
                        if (this.Type == ConstraintPrefix.isClobber || this.isCommutative) {
                            return true;
                        }
                        this.isCommutative = true;
                        break;
                    }
                    case 35: 
                    case 42: {
                        return true;
                    }
                }
                if (DoneWithModifiers) continue;
                I.$preInc();
                if (!Native.$eq_ptr((void.ptr)I, (void.ptr)E)) continue;
                return true;
            }
            while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
                if (I.$star() == 123) {
                    char.ptr ConstraintEnd = Native.$tryClone((char.ptr)std.find((char.ptr)((char.ptr)I.$add(1)), (char.ptr)E, (byte)125));
                    if (Native.$eq_ptr((void.ptr)ConstraintEnd, (void.ptr)E)) {
                        return true;
                    }
                    pCodes.push_back_T$RR(new StringRef(I, ((char.ptr)ConstraintEnd.$add(1)).$sub((abstract_iterator)I)).$string());
                    I = Native.$tryClone((char.ptr)((char.ptr)ConstraintEnd.$add(1)));
                    continue;
                }
                if (std.isdigit((int)Unsigned.$uchar2int((byte)I.$star())) != 0) {
                    char.ptr NumStart = Native.$tryClone((char.ptr)I);
                    while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E) && std.isdigit((int)Unsigned.$uchar2int((byte)I.$star())) != 0) {
                        I.$preInc();
                    }
                    pCodes.push_back_T$RR(new StringRef(NumStart, I.$sub((abstract_iterator)NumStart)).$string());
                    int N = std.atoi((char.ptr)pCodes.back().c_str());
                    if (Unsigned.$greatereq_uint((int)N, (int)ConstraintsSoFar.size()) || ((ConstraintInfo)ConstraintsSoFar.$at((int)N)).Type != ConstraintPrefix.isOutput || this.Type != ConstraintPrefix.isInput) {
                        return true;
                    }
                    if (this.isMultipleAlternative) {
                        if (Unsigned.$greatereq_uint((int)multipleAlternativeIndex, (int)((ConstraintInfo)ConstraintsSoFar.$at((int)N)).multipleAlternatives.size())) {
                            return true;
                        }
                        SubConstraintInfo scInfo = (SubConstraintInfo)((ConstraintInfo)ConstraintsSoFar.$at((int)N)).multipleAlternatives.$at(multipleAlternativeIndex);
                        if (scInfo.MatchingInput != -1) {
                            return true;
                        }
                        scInfo.MatchingInput = Unsigned.$uint2schar((int)ConstraintsSoFar.size());
                        continue;
                    }
                    if (((ConstraintInfo)ConstraintsSoFar.$at(N)).hasMatchingInput() && Unsigned.$schar2uint((byte)((ConstraintInfo)ConstraintsSoFar.$at((int)N)).MatchingInput) != ConstraintsSoFar.size()) {
                        return true;
                    }
                    ((ConstraintInfo)ConstraintsSoFar.$at((int)N)).MatchingInput = Unsigned.$uint2schar((int)ConstraintsSoFar.size());
                    continue;
                }
                if (I.$star() == 124) {
                    pCodes = (std.vectorString)Native.$AddrOf((Object)((SubConstraintInfo)this.multipleAlternatives.$at((int)(++multipleAlternativeIndex))).Codes);
                    I.$preInc();
                    continue;
                }
                if (I.$star() == 94) {
                    pCodes.push_back_T$RR(new StringRef((char.ptr)I.$add(1), 2).$string());
                    I.$inc(3);
                    continue;
                }
                pCodes.push_back_T$RR(new StringRef(I, 1).$string());
                I.$preInc();
            }
            return false;
        }

        public void selectAlternative(int index) {
            if (Unsigned.$less_uint((int)index, (int)this.multipleAlternatives.size())) {
                this.currentAlternativeIndex = index;
                SubConstraintInfo scInfo = (SubConstraintInfo)this.multipleAlternatives.$at(this.currentAlternativeIndex);
                this.MatchingInput = scInfo.MatchingInput;
                this.Codes.$assign(scInfo.Codes);
            }
        }

        public ConstraintInfo(JavaDifferentiators.JD.Move _dparam, ConstraintInfo $Prm0) {
            this.Type = $Prm0.Type;
            this.isEarlyClobber = $Prm0.isEarlyClobber;
            this.MatchingInput = $Prm0.MatchingInput;
            this.isCommutative = $Prm0.isCommutative;
            this.isIndirect = $Prm0.isIndirect;
            this.Codes = new std.vectorString(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Codes);
            this.isMultipleAlternative = $Prm0.isMultipleAlternative;
            this.multipleAlternatives = new std.vector(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.multipleAlternatives);
            this.currentAlternativeIndex = $Prm0.currentAlternativeIndex;
        }

        public void $destroy() {
            this.multipleAlternatives.$destroy();
            this.Codes.$destroy();
        }

        public ConstraintInfo(ConstraintInfo $Prm0) {
            this.Type = $Prm0.Type;
            this.isEarlyClobber = $Prm0.isEarlyClobber;
            this.MatchingInput = $Prm0.MatchingInput;
            this.isCommutative = $Prm0.isCommutative;
            this.isIndirect = $Prm0.isIndirect;
            this.Codes = new std.vectorString($Prm0.Codes);
            this.isMultipleAlternative = $Prm0.isMultipleAlternative;
            this.multipleAlternatives = new std.vector($Prm0.multipleAlternatives);
            this.currentAlternativeIndex = $Prm0.currentAlternativeIndex;
        }

        public ConstraintInfo clone() {
            return new ConstraintInfo(this);
        }

        public String toString() {
            return "Type=" + (Object)((Object)this.Type) + ", isEarlyClobber=" + this.isEarlyClobber + ", MatchingInput=" + this.MatchingInput + ", isCommutative=" + this.isCommutative + ", isIndirect=" + this.isIndirect + ", Codes=" + this.Codes + ", isMultipleAlternative=" + this.isMultipleAlternative + ", multipleAlternatives=" + this.multipleAlternatives + ", currentAlternativeIndex=" + this.currentAlternativeIndex;
        }
    }

    public static class SubConstraintInfo
    implements Destructors.ClassWithDestructor {
        public byte MatchingInput;
        public std.vectorString Codes;

        public SubConstraintInfo() {
            this.MatchingInput = Unsigned.$int2schar((int)-1);
            this.Codes = new std.vectorString(std.string.EMPTY);
        }

        public SubConstraintInfo(JavaDifferentiators.JD.Move _dparam, SubConstraintInfo $Prm0) {
            this.MatchingInput = $Prm0.MatchingInput;
            this.Codes = new std.vectorString(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Codes);
        }

        public void $destroy() {
            this.Codes.$destroy();
        }

        public SubConstraintInfo(SubConstraintInfo $Prm0) {
            this.MatchingInput = $Prm0.MatchingInput;
            this.Codes = new std.vectorString($Prm0.Codes);
        }

        public String toString() {
            return "MatchingInput=" + this.MatchingInput + ", Codes=" + this.Codes;
        }
    }

    public static final class ConstraintPrefix
    extends Enum<ConstraintPrefix>
    implements Native.NativeUIntEnum {
        public static final /* enum */ ConstraintPrefix isInput = new ConstraintPrefix(0);
        public static final /* enum */ ConstraintPrefix isOutput = new ConstraintPrefix(isInput.getValue() + 1);
        public static final /* enum */ ConstraintPrefix isClobber = new ConstraintPrefix(isOutput.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ConstraintPrefix[] $VALUES;

        public static ConstraintPrefix[] values() {
            return (ConstraintPrefix[])$VALUES.clone();
        }

        public static ConstraintPrefix valueOf(String name) {
            return Enum.valueOf(ConstraintPrefix.class, name);
        }

        public static ConstraintPrefix valueOf(int val) {
            ConstraintPrefix out;
            ConstraintPrefix constraintPrefix = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ConstraintPrefix(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ConstraintPrefix[]{isInput, isOutput, isClobber};
        }

        private static final class Values {
            private static final ConstraintPrefix[] VALUES;
            private static final ConstraintPrefix[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ConstraintPrefix kind : ConstraintPrefix.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ConstraintPrefix[min < 0 ? 1 - min : 0];
                VALUES = new ConstraintPrefix[max >= 0 ? 1 + max : 0];
                for (ConstraintPrefix kind : ConstraintPrefix.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((ConstraintPrefix)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((ConstraintPrefix)kind).value] = kind;
                }
            }
        }
    }

    public static final class AsmDialect
    extends Enum<AsmDialect>
    implements Native.NativeUIntEnum {
        public static final /* enum */ AsmDialect AD_ATT = new AsmDialect(0);
        public static final /* enum */ AsmDialect AD_Intel = new AsmDialect(AD_ATT.getValue() + 1);
        private final int value;
        private static final /* synthetic */ AsmDialect[] $VALUES;

        public static AsmDialect[] values() {
            return (AsmDialect[])$VALUES.clone();
        }

        public static AsmDialect valueOf(String name) {
            return Enum.valueOf(AsmDialect.class, name);
        }

        public static AsmDialect valueOf(int val) {
            AsmDialect out;
            AsmDialect asmDialect = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private AsmDialect(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new AsmDialect[]{AD_ATT, AD_Intel};
        }

        private static final class Values {
            private static final AsmDialect[] VALUES;
            private static final AsmDialect[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (AsmDialect kind : AsmDialect.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new AsmDialect[min < 0 ? 1 - min : 0];
                VALUES = new AsmDialect[max >= 0 ? 1 + max : 0];
                for (AsmDialect kind : AsmDialect.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((AsmDialect)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((AsmDialect)kind).value] = kind;
                }
            }
        }
    }
}

