/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.Instruction;
import org.llvm.ir.OperandTraitsIndirectBrInst;
import org.llvm.ir.TerminatorInst;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;

public class IndirectBrInst
extends TerminatorInst
implements Destructors.ClassWithDestructor {
    private int ReservedSpace;

    protected static Object $new(int $Prm0, int $Prm1) {
        throw new UnsupportedOperationException("Deleted");
    }

    private IndirectBrInst(IndirectBrInst IBI) {
        super(Type.getVoidTy(IBI.getContext()), 4, (type.ptr<Use>)((type.ptr)null), IBI.getNumOperands());
        this.allocHungoffUses(IBI.getNumOperands());
        type.ptr OL = (type.ptr)Native.$tryClone(this.getOperandList());
        type.ptr InOL = (type.ptr)Native.$tryClone(IBI.getOperandList$Const());
        int E = IBI.getNumOperands();
        for (int i = 0; i != E; ++i) {
            ((Use)OL.$at(i)).$assign((Use)InOL.$at(i));
        }
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$7bits_uchar2uchar((byte)IBI.SubclassOptionalData));
    }

    private void init(Value Address, int NumDests) {
        assert (Address != null && Address.getType().isPointerTy()) : "Address of indirectbr must be a pointer";
        this.ReservedSpace = 1 + NumDests;
        this.setNumHungOffUseOperands(1);
        this.allocHungoffUses(this.ReservedSpace);
        this.Op(0).$assign(Address);
    }

    private void growOperands() {
        int NumOps;
        int e = this.getNumOperands();
        this.ReservedSpace = NumOps = e * 2;
        this.growHungoffUses(this.ReservedSpace);
    }

    private static <T extends IndirectBrInst> T $new_IndirectBrInst(NativeCallback.New.ConstructorCallback<T> $Ctor) {
        return (T)((IndirectBrInst)User.$new_HangOffUses($Ctor));
    }

    private IndirectBrInst(Value Address, int NumCases, Instruction InsertBefore) {
        super(Type.getVoidTy(Address.getContext()), 4, (type.ptr<Use>)((type.ptr)null), 0, InsertBefore);
        this.init(Address, NumCases);
    }

    private IndirectBrInst(Value Address, int NumCases, BasicBlock InsertAtEnd) {
        super(Type.getVoidTy(Address.getContext()), 4, (type.ptr<Use>)((type.ptr)null), 0, InsertAtEnd);
        this.init(Address, NumCases);
    }

    protected IndirectBrInst cloneImpl() {
        return IndirectBrInst.$new_IndirectBrInst(New$Mem -> new IndirectBrInst(this));
    }

    public static IndirectBrInst Create(Value Address, int NumDests) {
        return IndirectBrInst.Create(Address, NumDests, (Instruction)null);
    }

    public static IndirectBrInst Create(Value Address, int NumDests, Instruction InsertBefore) {
        return IndirectBrInst.$new_IndirectBrInst(New$Mem -> new IndirectBrInst(Address, NumDests, InsertBefore));
    }

    public static IndirectBrInst Create(Value Address, int NumDests, BasicBlock InsertAtEnd) {
        return IndirectBrInst.$new_IndirectBrInst(New$Mem -> new IndirectBrInst(Address, NumDests, InsertAtEnd));
    }

    @Override
    public Value getOperand(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsIndirectBrInst.operands(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Value(((Use)OperandTraitsIndirectBrInst.op_begin(this).$at(i_nocapture)).get());
    }

    @Override
    public void setOperand(int i_nocapture, Value Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsIndirectBrInst.operands(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsIndirectBrInst.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsIndirectBrInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsIndirectBrInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsIndirectBrInst.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsIndirectBrInst.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsIndirectBrInst.operands(this);
    }

    public Value getAddress() {
        return this.getOperand(0);
    }

    public Value getAddress$Const() {
        return this.getOperand(0);
    }

    public void setAddress(Value V) {
        this.setOperand(0, V);
    }

    public int getNumDestinations() {
        return this.getNumOperands() - 1;
    }

    public BasicBlock getDestination(int i) {
        return this.getSuccessor(i);
    }

    public BasicBlock getDestination$Const(int i) {
        return this.getSuccessor(i);
    }

    public void addDestination(BasicBlock DestBB) {
        int OpNo = this.getNumOperands();
        if (Unsigned.$greater_uint((int)(OpNo + 1), (int)this.ReservedSpace)) {
            this.growOperands();
        }
        assert (Unsigned.$less_uint((int)OpNo, (int)this.ReservedSpace)) : "Growing didn't work!";
        this.setNumHungOffUseOperands(OpNo + 1);
        ((Use)this.getOperandList().$at(OpNo)).$assign(DestBB);
    }

    public void removeDestination(int idx) {
        assert (Unsigned.$less_uint((int)idx, (int)(this.getNumOperands() - 1))) : "Successor index out of range!";
        int NumOps = this.getNumOperands();
        type.ptr OL = (type.ptr)Native.$tryClone(this.getOperandList());
        ((Use)OL.$at(idx + 1)).$assign((Use)OL.$at(NumOps - 1));
        ((Use)OL.$at(NumOps - 1)).set(null);
        this.setNumHungOffUseOperands(NumOps - 1);
    }

    @Override
    public int getNumSuccessors() {
        return this.getNumOperands() - 1;
    }

    @Override
    public BasicBlock getSuccessor(int i) {
        return IrRTTI.cast_BasicBlock(this.getOperand(i + 1));
    }

    @Override
    public void setSuccessor(int i, BasicBlock NewSucc) {
        this.setOperand(i + 1, NewSucc);
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 4;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && IndirectBrInst.classof(IrRTTI.cast_Instruction(V));
    }

    @Override
    protected BasicBlock getSuccessorV(int idx) {
        return this.getSuccessor(idx);
    }

    @Override
    protected int getNumSuccessorsV() {
        return this.getNumSuccessors();
    }

    @Override
    protected void setSuccessorV(int idx, BasicBlock B2) {
        this.setSuccessor(idx, B2);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "ReservedSpace=" + this.ReservedSpace + super.toString();
    }
}

