/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.ir.DiagnosticInfo;
import org.llvm.ir.DiagnosticKind;
import org.llvm.ir.DiagnosticPrinter;
import org.llvm.ir.DiagnosticSeverity;
import org.llvm.ir.Function;

public class DiagnosticInfoResourceLimit
extends DiagnosticInfo
implements Destructors.ClassWithDestructor {
    private final Function Fn;
    private char.ptr ResourceName;
    private long ResourceSize;
    private long ResourceLimit;

    public DiagnosticInfoResourceLimit(Function Fn, char.ptr ResourceName, long ResourceSize) {
        this(Fn, ResourceName, ResourceSize, DiagnosticSeverity.DS_Warning, DiagnosticKind.DK_ResourceLimit, Unsigned.$int2ulong((int)0));
    }

    public DiagnosticInfoResourceLimit(Function Fn, char.ptr ResourceName, long ResourceSize, DiagnosticSeverity Severity) {
        this(Fn, ResourceName, ResourceSize, Severity, DiagnosticKind.DK_ResourceLimit, Unsigned.$int2ulong((int)0));
    }

    public DiagnosticInfoResourceLimit(Function Fn, char.ptr ResourceName, long ResourceSize, DiagnosticSeverity Severity, DiagnosticKind Kind2) {
        this(Fn, ResourceName, ResourceSize, Severity, Kind2, Unsigned.$int2ulong((int)0));
    }

    public DiagnosticInfoResourceLimit(Function Fn, char.ptr ResourceName, long ResourceSize, DiagnosticSeverity Severity, DiagnosticKind Kind2, long ResourceLimit) {
        super(Kind2.getValue(), Severity);
        this.Fn = Fn;
        this.ResourceName = Native.$tryClone((char.ptr)ResourceName);
        this.ResourceSize = ResourceSize;
        this.ResourceLimit = ResourceLimit;
    }

    public Function getFunction() {
        return this.Fn;
    }

    public char.ptr getResourceName() {
        return this.ResourceName;
    }

    public long getResourceSize() {
        return this.ResourceSize;
    }

    public long getResourceLimit() {
        return this.ResourceLimit;
    }

    @Override
    public void print(DiagnosticPrinter DP) {
        DP.$out(this.getResourceName()).$out(" limit");
        if (this.getResourceLimit() != Unsigned.$int2ullong((int)0)) {
            DP.$out(" of ").$out_ullong(this.getResourceLimit());
        }
        DP.$out(" exceeded (").$out_ullong(this.getResourceSize()).$out(") in ").$out(this.getFunction());
    }

    public static boolean classof(DiagnosticInfo DI) {
        return DI.getKind() == DiagnosticKind.DK_ResourceLimit.getValue() || DI.getKind() == DiagnosticKind.DK_StackSize.getValue();
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Fn=" + this.Fn + ", ResourceName=" + this.ResourceName + ", ResourceSize=" + this.ResourceSize + ", ResourceLimit=" + this.ResourceLimit + super.toString();
    }
}

