/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.DiagnosticInfo;
import org.llvm.ir.DiagnosticKind;
import org.llvm.ir.DiagnosticPrinter;
import org.llvm.ir.DiagnosticSeverity;
import org.llvm.ir.Instruction;
import org.llvm.ir.MDNode;
import org.llvm.ir.mdconst.MdconstGlobals;

public class DiagnosticInfoInlineAsm
extends DiagnosticInfo
implements Destructors.ClassWithDestructor {
    private int LocCookie;
    private final Twine MsgStr;
    private Instruction Instr;

    public DiagnosticInfoInlineAsm(Twine MsgStr) {
        this(MsgStr, DiagnosticSeverity.DS_Error);
    }

    public DiagnosticInfoInlineAsm(Twine MsgStr, DiagnosticSeverity Severity) {
        super(DiagnosticKind.DK_InlineAsm.getValue(), Severity);
        this.LocCookie = 0;
        this.MsgStr = MsgStr;
        this.Instr = null;
    }

    public DiagnosticInfoInlineAsm(int LocCookie, Twine MsgStr) {
        this(LocCookie, MsgStr, DiagnosticSeverity.DS_Error);
    }

    public DiagnosticInfoInlineAsm(int LocCookie, Twine MsgStr, DiagnosticSeverity Severity) {
        super(DiagnosticKind.DK_InlineAsm.getValue(), Severity);
        this.LocCookie = LocCookie;
        this.MsgStr = MsgStr;
        this.Instr = null;
    }

    public DiagnosticInfoInlineAsm(Instruction I, Twine MsgStr) {
        this(I, MsgStr, DiagnosticSeverity.DS_Error);
    }

    public DiagnosticInfoInlineAsm(Instruction I, Twine MsgStr, DiagnosticSeverity Severity) {
        super(DiagnosticKind.DK_InlineAsm.getValue(), Severity);
        ConstantInt CI;
        this.LocCookie = 0;
        this.MsgStr = MsgStr;
        this.Instr = (Instruction)Native.$AddrOf((Object)I);
        MDNode SrcLoc = I.getMetadata(new StringRef("srcloc"));
        if (SrcLoc != null && SrcLoc.getNumOperands() != 0 && (CI = MdconstGlobals.dyn_extract$ValidPointer(ConstantInt.class, SrcLoc.getOperand(0))) != null) {
            this.LocCookie = Unsigned.$ulong2uint((long)CI.getZExtValue());
        }
    }

    public int getLocCookie() {
        return this.LocCookie;
    }

    public Twine getMsgStr() {
        return this.MsgStr;
    }

    public Instruction getInstruction() {
        return this.Instr;
    }

    @Override
    public void print(DiagnosticPrinter DP) {
        DP.$out(this.getMsgStr());
        if (this.getLocCookie() != 0) {
            DP.$out(" at line ").$out_uint(this.getLocCookie());
        }
    }

    public static boolean classof(DiagnosticInfo DI) {
        return DI.getKind() == DiagnosticKind.DK_InlineAsm.getValue();
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "LocCookie=" + this.LocCookie + ", MsgStr=" + this.MsgStr + ", Instr=" + this.Instr + super.toString();
    }
}

