/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplUChar;
import org.llvm.adt.aliases.SmallVectorUChar;
import org.llvm.ir.ArrayType;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.IntegerType;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.LayoutAlignElem;
import org.llvm.ir.Module$IR;
import org.llvm.ir.PointerAlignElem;
import org.llvm.ir.StructLayout;
import org.llvm.ir.StructType;
import org.llvm.ir.Type;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.DataLayoutStatics;
import org.llvm.ir.impl.StructLayoutMap;
import org.llvm.ir.java.IrRTTI;
import org.llvm.llvmc.LLVMOpaqueTargetData;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class DataLayout
implements Destructors.ClassWithDestructor,
Native.NativeComparable<DataLayout>,
LLVMOpaqueTargetData {
    private boolean BigEndian;
    private int StackNaturalAlign;
    private ManglingModeT ManglingMode;
    private SmallVectorUChar LegalIntWidths = new SmallVectorUChar(8, 0);
    private SmallVector<LayoutAlignElem> Alignments = new SmallVector(16, (Object)new LayoutAlignElem());
    private std.string StringRepresentation = new std.string();
    private SmallVector<PointerAlignElem> Pointers = new SmallVector(8, (Object)new PointerAlignElem());
    private static LayoutAlignElem InvalidAlignmentElem = new LayoutAlignElem(0, 0, 0, 0);
    private static PointerAlignElem InvalidPointerElem = new PointerAlignElem(0, 0, 0, -1);
    private Object LayoutMap = null;

    private type.ptr<PointerAlignElem> findPointerLowerBound$Const(int AddressSpace) {
        return this.findPointerLowerBound(AddressSpace);
    }

    private type.ptr<PointerAlignElem> findPointerLowerBound(int AddressSpace) {
        return (type.ptr)std.lower_bound((type.iterator)this.Pointers.begin(), (type.iterator)this.Pointers.end(), (Object)AddressSpace, (A2, AddressSpace$1) -> Unsigned.$less_uint((int)A2.AddressSpace, (int)AddressSpace$1));
    }

    private void setAlignment(byte align_type, int abi_align, int pref_align, int bit_width) {
        if (!llvm.isUInt24((long)Unsigned.$uint2ulong((int)bit_width))) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Invalid bit width, must be a 24bit integer"));
        }
        if (!llvm.isUInt16((long)Unsigned.$uint2ulong((int)abi_align))) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Invalid ABI alignment, must be a 16bit integer"));
        }
        if (!llvm.isUInt16((long)Unsigned.$uint2ulong((int)pref_align))) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Invalid preferred alignment, must be a 16bit integer"));
        }
        if (abi_align != 0 && !llvm.isPowerOf2_64((long)Unsigned.$uint2ulong((int)abi_align))) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Invalid ABI alignment, must be a power of 2"));
        }
        if (pref_align != 0 && !llvm.isPowerOf2_64((long)Unsigned.$uint2ulong((int)pref_align))) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Invalid preferred alignment, must be a power of 2"));
        }
        if (Unsigned.$less_uint((int)pref_align, (int)abi_align)) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Preferred alignment cannot be less than the ABI alignment"));
        }
        for (LayoutAlignElem Elem : this.Alignments) {
            if (Unsigned.$8bits_uint2uint((byte)Elem.AlignType) != align_type || Elem.TypeBitWidth != bit_width) continue;
            Elem.ABIAlign = Unsigned.$uint2uint_16bits((int)abi_align);
            Elem.PrefAlign = Unsigned.$uint2uint_16bits((int)pref_align);
            return;
        }
        this.Alignments.push_back((Object)LayoutAlignElem.get(align_type, abi_align, pref_align, bit_width));
    }

    private int getAlignmentInfo(byte AlignType, int BitWidth, boolean ABIInfo, Type Ty) {
        int Align;
        int BestMatchIdx = -1;
        int LargestInt = -1;
        int e = this.Alignments.size();
        for (int i = 0; i != e; ++i) {
            if (Unsigned.$8bits_uint2uint((byte)((LayoutAlignElem)this.Alignments.$at$Const((int)i)).AlignType) == AlignType && ((LayoutAlignElem)this.Alignments.$at$Const((int)i)).TypeBitWidth == BitWidth) {
                return ABIInfo ? Unsigned.$16bits_uint2uint((char)((LayoutAlignElem)this.Alignments.$at$Const((int)i)).ABIAlign) : Unsigned.$16bits_uint2uint((char)((LayoutAlignElem)this.Alignments.$at$Const((int)i)).PrefAlign);
            }
            if (AlignType != 105 || Unsigned.$8bits_uint2uint((byte)((LayoutAlignElem)this.Alignments.$at$Const((int)i)).AlignType) != 105) continue;
            if (Unsigned.$greater_uint((int)((LayoutAlignElem)this.Alignments.$at$Const((int)i)).TypeBitWidth, (int)BitWidth) && (BestMatchIdx == -1 || ((LayoutAlignElem)this.Alignments.$at$Const((int)i)).TypeBitWidth < ((LayoutAlignElem)this.Alignments.$at$Const((int)BestMatchIdx)).TypeBitWidth)) {
                BestMatchIdx = i;
            }
            if (LargestInt != -1 && ((LayoutAlignElem)this.Alignments.$at$Const((int)i)).TypeBitWidth <= ((LayoutAlignElem)this.Alignments.$at$Const((int)LargestInt)).TypeBitWidth) continue;
            LargestInt = i;
        }
        if (BestMatchIdx == -1) {
            if (AlignType == 105) {
                BestMatchIdx = LargestInt;
            } else if (AlignType == 118) {
                Align = Unsigned.$ulong2uint((long)this.getTypeAllocSize(IrRTTI.cast_VectorType(Ty).getElementType()));
                if (((Align *= IrRTTI.cast_VectorType(Ty).getNumElements()) & Align - 1) != 0) {
                    Align = Unsigned.$ulong2uint((long)llvm.NextPowerOf2((long)Unsigned.$uint2ulong((int)Align)));
                }
                return Align;
            }
        }
        if (BestMatchIdx == -1) {
            Align = Unsigned.$ulong2uint((long)this.getTypeStoreSize(Ty));
            if ((Align & Align - 1) != 0) {
                Align = Unsigned.$ulong2uint((long)llvm.NextPowerOf2((long)Unsigned.$uint2ulong((int)Align)));
            }
            return Align;
        }
        return ABIInfo ? Unsigned.$16bits_uint2uint((char)((LayoutAlignElem)this.Alignments.$at$Const((int)BestMatchIdx)).ABIAlign) : Unsigned.$16bits_uint2uint((char)((LayoutAlignElem)this.Alignments.$at$Const((int)BestMatchIdx)).PrefAlign);
    }

    private void setPointerAlignment(int AddrSpace, int ABIAlign, int PrefAlign, int TypeByteWidth) {
        type.ptr I;
        if (Unsigned.$less_uint((int)PrefAlign, (int)ABIAlign)) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Preferred alignment cannot be less than the ABI alignment"));
        }
        if (Native.$eq_ptr((void.ptr)(I = (type.ptr)Native.$tryClone(this.findPointerLowerBound(AddrSpace))), (void.ptr)this.Pointers.end()) || ((PointerAlignElem)I.$star()).AddressSpace != AddrSpace) {
            this.Pointers.insert(I, (Object)PointerAlignElem.get(AddrSpace, ABIAlign, PrefAlign, TypeByteWidth));
        } else {
            ((PointerAlignElem)I.$star()).ABIAlign = ABIAlign;
            ((PointerAlignElem)I.$star()).PrefAlign = PrefAlign;
            ((PointerAlignElem)I.$star()).TypeByteWidth = TypeByteWidth;
        }
    }

    private int getAlignment(Type Ty, boolean abi_or_pref) {
        int AlignType = -1;
        assert (Ty.isSized()) : "Cannot getTypeInfo() on a type that is unsized!";
        switch (Ty.getTypeID()) {
            case LabelTyID: {
                return abi_or_pref ? this.getPointerABIAlignment(0) : this.getPointerPrefAlignment(0);
            }
            case PointerTyID: {
                int AS = IrRTTI.cast_PointerType(Ty).getAddressSpace();
                return abi_or_pref ? this.getPointerABIAlignment(AS) : this.getPointerPrefAlignment(AS);
            }
            case ArrayTyID: {
                return this.getAlignment(IrRTTI.cast_ArrayType(Ty).getElementType(), abi_or_pref);
            }
            case StructTyID: {
                if (IrRTTI.cast_StructType(Ty).isPacked() && abi_or_pref) {
                    return 1;
                }
                StructLayout Layout = this.getStructLayout(IrRTTI.cast_StructType(Ty));
                int Align = this.getAlignmentInfo((byte)97, 0, abi_or_pref, Ty);
                return std.max((int)Align, (int)Layout.getAlignment());
            }
            case IntegerTyID: {
                AlignType = 105;
                break;
            }
            case HalfTyID: 
            case FloatTyID: 
            case DoubleTyID: 
            case PPC_FP128TyID: 
            case FP128TyID: 
            case X86_FP80TyID: {
                AlignType = 102;
                break;
            }
            case X86_MMXTyID: 
            case VectorTyID: {
                AlignType = 118;
                break;
            }
            default: {
                throw new llvm_unreachable("Bad type for getAlignment!!!");
            }
        }
        return this.getAlignmentInfo((byte)AlignType, Unsigned.$ulong2uint((long)this.getTypeSizeInBits(Ty)), abi_or_pref, Ty);
    }

    private boolean validAlignment(LayoutAlignElem align) {
        return align != InvalidAlignmentElem;
    }

    private boolean validPointer(PointerAlignElem align) {
        return align != InvalidPointerElem;
    }

    private void parseSpecifier(StringRef Desc) {
        this.StringRepresentation.$assignMove(Desc.$string());
        while (!Desc.empty()) {
            std_pair.pair<StringRef, StringRef> Split = DataLayoutStatics.split(new StringRef(Desc), (byte)45);
            Desc.$assign((StringRef)Split.second);
            Split.$assignMove(DataLayoutStatics.split(new StringRef((StringRef)Split.first), (byte)58));
            StringRef Tok = (StringRef)Split.first;
            StringRef Rest = (StringRef)Split.second;
            char Specifier = Unsigned.$uchar2ushort((byte)Tok.front());
            Tok.$assignMove(Tok.substr(1));
            block0 : switch (Specifier) {
                case 's': {
                    break;
                }
                case 'E': {
                    this.BigEndian = true;
                    break;
                }
                case 'e': {
                    this.BigEndian = false;
                    break;
                }
                case 'p': {
                    int AddrSpace;
                    int n = AddrSpace = Tok.empty() ? 0 : DataLayoutStatics.getInt(new StringRef(Tok));
                    if (!llvm.isUInt24((long)Unsigned.$uint2ulong((int)AddrSpace))) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Invalid address space, must be a 24bit integer"));
                    }
                    if (Rest.empty()) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Missing size specification for pointer in datalayout string"));
                    }
                    Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                    assert (Tok == Split.first);
                    assert (Rest == Split.second);
                    int PointerMemSize = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                    if (PointerMemSize == 0) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Invalid pointer size of 0 bytes"));
                    }
                    if (Rest.empty()) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Missing alignment specification for pointer in datalayout string"));
                    }
                    Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                    assert (Tok == Split.first);
                    assert (Rest == Split.second);
                    int PointerABIAlign = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                    if (!llvm.isPowerOf2_64((long)Unsigned.$uint2ulong((int)PointerABIAlign))) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Pointer ABI alignment must be a power of 2"));
                    }
                    int PointerPrefAlign = PointerABIAlign;
                    if (!Rest.empty()) {
                        Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                        assert (Tok == Split.first);
                        assert (Rest == Split.second);
                        PointerPrefAlign = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                        if (!llvm.isPowerOf2_64((long)Unsigned.$uint2ulong((int)PointerPrefAlign))) {
                            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Pointer preferred alignment must be a power of 2"));
                        }
                    }
                    this.setPointerAlignment(AddrSpace, PointerABIAlign, PointerPrefAlign, PointerMemSize);
                    break;
                }
                case 'a': 
                case 'f': 
                case 'i': 
                case 'v': {
                    int Size;
                    byte AlignType;
                    switch (Specifier) {
                        default: {
                            AlignType = 105;
                            break;
                        }
                        case 'v': {
                            AlignType = 118;
                            break;
                        }
                        case 'f': {
                            AlignType = 102;
                            break;
                        }
                        case 'a': {
                            AlignType = 97;
                        }
                    }
                    int n = Size = Tok.empty() ? 0 : DataLayoutStatics.getInt(new StringRef(Tok));
                    if (AlignType == 97 && Size != 0) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Sized aggregate specification in datalayout string"));
                    }
                    if (Rest.empty()) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Missing alignment specification in datalayout string"));
                    }
                    Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                    assert (Tok == Split.first);
                    assert (Rest == Split.second);
                    int ABIAlign = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                    if (AlignType != 97 && ABIAlign == 0) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"ABI alignment specification must be >0 for non-aggregate types"));
                    }
                    int PrefAlign = ABIAlign;
                    if (!Rest.empty()) {
                        Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                        assert (Tok == Split.first);
                        assert (Rest == Split.second);
                        PrefAlign = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                    }
                    this.setAlignment(AlignType, ABIAlign, PrefAlign, Size);
                    break;
                }
                case 'n': {
                    while (true) {
                        int Width;
                        if ((Width = DataLayoutStatics.getInt(new StringRef(Tok))) == 0) {
                            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Zero width native integer type in datalayout string"));
                        }
                        this.LegalIntWidths.push_back(Unsigned.$uint2uchar((int)Width));
                        if (Rest.empty()) break block0;
                        Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                        assert (Tok == Split.first);
                        assert (Rest == Split.second);
                    }
                }
                case 'S': {
                    this.StackNaturalAlign = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                    break;
                }
                case 'm': {
                    if (!Tok.empty()) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Unexpected trailing characters after mangling specifier in datalayout string"));
                    }
                    if (Rest.empty()) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Expected mangling specifier in datalayout string"));
                    }
                    if (Unsigned.$greater_uint((int)Rest.size(), (int)1)) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Unknown mangling specifier in datalayout string"));
                    }
                    switch (Rest.$at(0)) {
                        default: {
                            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Unknown mangling in datalayout string"));
                        }
                        case 101: {
                            this.ManglingMode = ManglingModeT.MM_ELF;
                            break block0;
                        }
                        case 111: {
                            this.ManglingMode = ManglingModeT.MM_MachO;
                            break block0;
                        }
                        case 109: {
                            this.ManglingMode = ManglingModeT.MM_Mips;
                            break block0;
                        }
                        case 119: {
                            this.ManglingMode = ManglingModeT.MM_WinCOFF;
                            break block0;
                        }
                        case 120: 
                    }
                    this.ManglingMode = ManglingModeT.MM_WinCOFFX86;
                    break;
                }
                default: {
                    llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Unknown specifier in datalayout string"));
                }
            }
        }
    }

    private void clear() {
        this.LegalIntWidths.clear();
        this.Alignments.clear();
        this.Pointers.clear();
        Destructors.$destroy((Destructors.ClassWithDestructor)((StructLayoutMap)this.LayoutMap));
        this.LayoutMap = null;
    }

    public DataLayout(StringRef LayoutDescription) {
        this.reset(new StringRef(LayoutDescription));
    }

    public DataLayout(Module$IR M) {
        this.init(M);
    }

    public void init(Module$IR M) {
        this.$assign(M.getDataLayout());
    }

    public DataLayout(DataLayout DL) {
        this.$assign(DL);
    }

    public DataLayout $assign(DataLayout DL) {
        this.clear();
        this.StringRepresentation.$assign(DL.StringRepresentation);
        this.BigEndian = DL.isBigEndian();
        this.StackNaturalAlign = DL.StackNaturalAlign;
        this.ManglingMode = DL.ManglingMode;
        this.LegalIntWidths.$assign((SmallVectorImplUChar)DL.LegalIntWidths);
        this.Alignments.$assign(DL.Alignments);
        this.Pointers.$assign(DL.Pointers);
        return this;
    }

    public boolean $eq(DataLayout Other) {
        if (Other == null) {
            return false;
        }
        boolean Ret = this.BigEndian == Other.BigEndian && this.StackNaturalAlign == Other.StackNaturalAlign && this.ManglingMode == Other.ManglingMode && this.LegalIntWidths.$eq((SmallVectorImplUChar)Other.LegalIntWidths) && this.Alignments.$eq(Other.Alignments) && this.Pointers.$eq(Other.Pointers);
        return Ret;
    }

    public boolean $noteq(DataLayout Other) {
        return !this.$eq(Other);
    }

    public void $destroy() {
        this.clear();
        this.Pointers.$destroy();
        this.StringRepresentation.$destroy();
        this.Alignments.$destroy();
        this.LegalIntWidths.$destroy();
    }

    public void reset(StringRef Desc) {
        this.clear();
        this.LayoutMap = null;
        this.BigEndian = false;
        this.StackNaturalAlign = 0;
        this.ManglingMode = ManglingModeT.MM_None;
        for (LayoutAlignElem E : DataLayoutStatics.DefaultAlignments) {
            this.setAlignment((byte)Unsigned.$8bits_uint2uint((byte)E.AlignType), Unsigned.$16bits_uint2uint((char)E.ABIAlign), Unsigned.$16bits_uint2uint((char)E.PrefAlign), E.TypeBitWidth);
        }
        this.setPointerAlignment(0, 8, 8, 8);
        this.parseSpecifier(new StringRef(Desc));
    }

    public boolean isLittleEndian() {
        return !this.BigEndian;
    }

    public boolean isBigEndian() {
        return this.BigEndian;
    }

    public std.string getStringRepresentation() {
        return this.StringRepresentation;
    }

    public boolean isDefault() {
        return this.StringRepresentation.empty();
    }

    public boolean isLegalInteger(long Width) {
        Iterator iterator2 = this.LegalIntWidths.iterator();
        while (iterator2.hasNext()) {
            byte LegalIntWidth = (Byte)iterator2.next();
            if (Unsigned.$uint2ullong((int)LegalIntWidth) != Width) continue;
            return true;
        }
        return false;
    }

    public boolean isIllegalInteger(long Width) {
        return !this.isLegalInteger(Width);
    }

    public boolean exceedsNaturalStackAlignment(int Align) {
        return this.StackNaturalAlign != 0 && Unsigned.$greater_uint((int)Align, (int)this.StackNaturalAlign);
    }

    public int getStackAlignment() {
        return this.StackNaturalAlign;
    }

    public boolean hasMicrosoftFastStdCallMangling() {
        return this.ManglingMode == ManglingModeT.MM_WinCOFFX86;
    }

    public boolean hasLinkerPrivateGlobalPrefix() {
        return this.ManglingMode == ManglingModeT.MM_MachO;
    }

    public char.ptr getLinkerPrivateGlobalPrefix() {
        if (this.ManglingMode == ManglingModeT.MM_MachO) {
            return NativePointer.$l;
        }
        return NativePointer.$EMPTY;
    }

    public byte getGlobalPrefix() {
        switch (this.ManglingMode) {
            case MM_None: 
            case MM_ELF: 
            case MM_Mips: 
            case MM_WinCOFF: {
                return 0;
            }
            case MM_MachO: 
            case MM_WinCOFFX86: {
                return 95;
            }
        }
        throw new llvm_unreachable("invalid mangling mode");
    }

    public char.ptr getPrivateGlobalPrefix() {
        switch (this.ManglingMode) {
            case MM_None: {
                return NativePointer.$EMPTY;
            }
            case MM_ELF: {
                return NativePointer.$((String)".L");
            }
            case MM_Mips: {
                return NativePointer.$DOLLAR;
            }
            case MM_WinCOFF: 
            case MM_MachO: 
            case MM_WinCOFFX86: {
                return NativePointer.$L;
            }
        }
        throw new llvm_unreachable("invalid mangling mode");
    }

    public static char.ptr getManglingComponent(Triple T2) {
        if (T2.isOSBinFormatMachO()) {
            return NativePointer.$((String)"-m:o");
        }
        if (T2.isOSWindows() && T2.isOSBinFormatCOFF()) {
            return T2.getArch() == Triple.ArchType.x86 ? NativePointer.$((String)"-m:x") : NativePointer.$((String)"-m:w");
        }
        return NativePointer.$((String)"-m:e");
    }

    public boolean fitsInLegalInteger(int Width) {
        Iterator iterator2 = this.LegalIntWidths.iterator();
        while (iterator2.hasNext()) {
            byte LegalIntWidth = (Byte)iterator2.next();
            if (!Unsigned.$lesseq_uint((int)Width, (int)LegalIntWidth)) continue;
            return true;
        }
        return false;
    }

    public int getPointerABIAlignment() {
        return this.getPointerABIAlignment(0);
    }

    public int getPointerABIAlignment(int AS) {
        type.ptr I = (type.ptr)Native.$tryClone(this.findPointerLowerBound$Const(AS));
        if (Native.$eq_ptr((void.ptr)I, (void.ptr)this.Pointers.end$Const()) || ((PointerAlignElem)I.$star()).AddressSpace != AS) {
            I = (type.ptr)Native.$tryClone(this.findPointerLowerBound$Const(0));
            assert (((PointerAlignElem)I.$star()).AddressSpace == 0);
        }
        return ((PointerAlignElem)I.$star()).ABIAlign;
    }

    public int getPointerPrefAlignment() {
        return this.getPointerPrefAlignment(0);
    }

    public int getPointerPrefAlignment(int AS) {
        type.ptr I = (type.ptr)Native.$tryClone(this.findPointerLowerBound$Const(AS));
        if (Native.$eq_ptr((void.ptr)I, (void.ptr)this.Pointers.end$Const()) || ((PointerAlignElem)I.$star()).AddressSpace != AS) {
            I = (type.ptr)Native.$tryClone(this.findPointerLowerBound$Const(0));
            assert (((PointerAlignElem)I.$star()).AddressSpace == 0);
        }
        return ((PointerAlignElem)I.$star()).PrefAlign;
    }

    public int getPointerSize() {
        return this.getPointerSize(0);
    }

    public int getPointerSize(int AS) {
        type.ptr I = (type.ptr)Native.$tryClone(this.findPointerLowerBound$Const(AS));
        if (Native.$eq_ptr((void.ptr)I, (void.ptr)this.Pointers.end$Const()) || ((PointerAlignElem)I.$star()).AddressSpace != AS) {
            I = (type.ptr)Native.$tryClone(this.findPointerLowerBound$Const(0));
            assert (((PointerAlignElem)I.$star()).AddressSpace == 0);
        }
        return ((PointerAlignElem)I.$star()).TypeByteWidth;
    }

    public int getPointerSizeInBits() {
        return this.getPointerSizeInBits(0);
    }

    public int getPointerSizeInBits(int AS) {
        return this.getPointerSize(AS) * 8;
    }

    public int getPointerTypeSizeInBits(Type Ty) {
        assert (Ty.isPtrOrPtrVectorTy()) : "This should only be called with a pointer or pointer vector type";
        if (Ty.isPointerTy()) {
            return Unsigned.$ulong2uint((long)this.getTypeSizeInBits(Ty));
        }
        return Unsigned.$ulong2uint((long)this.getTypeSizeInBits(Ty.getScalarType()));
    }

    public int getPointerTypeSize(Type Ty) {
        return Unsigned.$div_uint((int)this.getPointerTypeSizeInBits(Ty), (int)8);
    }

    public long getTypeSizeInBits(Type Ty) {
        assert (Ty.isSized()) : "Cannot getTypeInfo() on a type that is unsized!";
        switch (Ty.getTypeID()) {
            case LabelTyID: {
                return Unsigned.$uint2ulong((int)this.getPointerSizeInBits(0));
            }
            case PointerTyID: {
                return Unsigned.$uint2ulong((int)this.getPointerSizeInBits(Ty.getPointerAddressSpace()));
            }
            case ArrayTyID: {
                ArrayType ATy = IrRTTI.cast_ArrayType(Ty);
                return ATy.getNumElements() * this.getTypeAllocSizeInBits(ATy.getElementType());
            }
            case StructTyID: {
                return this.getStructLayout(IrRTTI.cast_StructType(Ty)).getSizeInBits();
            }
            case IntegerTyID: {
                return Unsigned.$uint2ulong((int)Ty.getIntegerBitWidth());
            }
            case HalfTyID: {
                return Unsigned.$int2ulong((int)16);
            }
            case FloatTyID: {
                return Unsigned.$int2ulong((int)32);
            }
            case DoubleTyID: 
            case X86_MMXTyID: {
                return Unsigned.$int2ulong((int)64);
            }
            case PPC_FP128TyID: 
            case FP128TyID: {
                return Unsigned.$int2ulong((int)128);
            }
            case X86_FP80TyID: {
                return Unsigned.$int2ulong((int)80);
            }
            case VectorTyID: {
                VectorType VTy = IrRTTI.cast_VectorType(Ty);
                return Unsigned.$uint2ullong((int)VTy.getNumElements()) * this.getTypeSizeInBits(VTy.getElementType());
            }
        }
        throw new llvm_unreachable("DataLayout::getTypeSizeInBits(): Unsupported type");
    }

    public long getTypeStoreSize(Type Ty) {
        return Unsigned.$div_ullong((long)(this.getTypeSizeInBits(Ty) + Unsigned.$int2ullong((int)7)), (long)Unsigned.$int2ullong((int)8));
    }

    public long getTypeStoreSizeInBits(Type Ty) {
        return Unsigned.$int2ullong((int)8) * this.getTypeStoreSize(Ty);
    }

    public long getTypeAllocSize(Type Ty) {
        return llvm.alignTo((long)this.getTypeStoreSize(Ty), (long)Unsigned.$uint2ulong((int)this.getABITypeAlignment(Ty)));
    }

    public long getTypeAllocSizeInBits(Type Ty) {
        return Unsigned.$int2ullong((int)8) * this.getTypeAllocSize(Ty);
    }

    public int getABITypeAlignment(Type Ty) {
        return this.getAlignment(Ty, true);
    }

    public int getABIIntegerTypeAlignment(int BitWidth) {
        return this.getAlignmentInfo((byte)105, BitWidth, true, null);
    }

    public int getPrefTypeAlignment(Type Ty) {
        return this.getAlignment(Ty, false);
    }

    public int getPreferredTypeAlignmentShift(Type Ty) {
        int Align = this.getPrefTypeAlignment(Ty);
        assert ((Align & Align - 1) == 0) : "Alignment is not a power of two!";
        return llvm.Log2_32((int)Align);
    }

    public IntegerType getIntPtrType(LLVMContext C2) {
        return this.getIntPtrType(C2, 0);
    }

    public IntegerType getIntPtrType(LLVMContext C2, int AddressSpace) {
        return IntegerType.get(C2, this.getPointerSizeInBits(AddressSpace));
    }

    public Type getIntPtrType(Type Ty) {
        assert (Ty.isPtrOrPtrVectorTy()) : "Expected a pointer or pointer vector type.";
        int NumBits = this.getPointerTypeSizeInBits(Ty);
        IntegerType IntTy = IntegerType.get(Ty.getContext(), NumBits);
        VectorType VecTy = IrRTTI.dyn_cast_VectorType(Ty);
        if (VecTy != null) {
            return VectorType.get(IntTy, VecTy.getNumElements());
        }
        return IntTy;
    }

    public Type getSmallestLegalIntType(LLVMContext C2) {
        return this.getSmallestLegalIntType(C2, 0);
    }

    public Type getSmallestLegalIntType(LLVMContext C2, int Width) {
        Iterator iterator2 = this.LegalIntWidths.iterator();
        while (iterator2.hasNext()) {
            byte LegalIntWidth = (Byte)iterator2.next();
            if (!Unsigned.$lesseq_uint((int)Width, (int)LegalIntWidth)) continue;
            return Type.getIntNTy(C2, LegalIntWidth);
        }
        return null;
    }

    public Type getLargestLegalIntType(LLVMContext C2) {
        int LargestSize = this.getLargestLegalIntTypeSizeInBits();
        return LargestSize == 0 ? null : Type.getIntNTy(C2, LargestSize);
    }

    public int getLargestLegalIntTypeSizeInBits() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public long getIndexedOffsetInType(Type ElemTy, ArrayRef<Value> Indices) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public StructLayout getStructLayout(StructType Ty) {
        StructLayoutMap STM;
        type.ref<StructLayout> SL;
        if (this.LayoutMap == null) {
            this.LayoutMap = new StructLayoutMap();
        }
        if ((SL = (STM = (StructLayoutMap)this.LayoutMap).$at(Ty)).$deref() != null) {
            return (StructLayout)SL.$deref();
        }
        int NumElts = Ty.getNumElements();
        type.ptr $L = std.malloc((int)(1 + (NumElts - 1) * 1));
        assert ($L.$star() == null) : "JAVA: can not be assigned yet, see code in StructLayout ctor";
        SL.$set((Object)((StructLayout)$L.$star()));
        StructLayout L = (StructLayout)Native.$new_uint_voidPtr((Object)$L, New$Mem -> {
            assert (New$Mem == $L);
            return new StructLayout(SL, $L, Ty, this);
        });
        return L;
    }

    public int getPreferredAlignment(GlobalVariable GV) {
        Type ElemType = GV.getValueType();
        int Alignment = this.getPrefTypeAlignment(ElemType);
        int GVAlignment = GV.getAlignment();
        if (Unsigned.$greatereq_uint((int)GVAlignment, (int)Alignment)) {
            Alignment = GVAlignment;
        } else if (GVAlignment != 0) {
            Alignment = std.max((int)GVAlignment, (int)this.getABITypeAlignment(ElemType));
        }
        if (GV.hasInitializer() && GVAlignment == 0 && Unsigned.$less_uint((int)Alignment, (int)16) && Unsigned.$greater_ulong_ullong((long)this.getTypeSizeInBits(ElemType), (long)Unsigned.$int2ullong((int)128))) {
            Alignment = 16;
        }
        return Alignment;
    }

    public int getPreferredAlignmentLog(GlobalVariable GV) {
        return llvm.Log2_32((int)this.getPreferredAlignment(GV));
    }

    public String toString() {
        return "BigEndian=" + this.BigEndian + ", StackNaturalAlign=" + this.StackNaturalAlign + ", ManglingMode=" + (Object)((Object)this.ManglingMode) + ", LegalIntWidths=" + this.LegalIntWidths + ", Alignments=" + this.Alignments + ", StringRepresentation=" + this.StringRepresentation + ", Pointers=" + this.Pointers + ", LayoutMap=" + NativeTrace.getIdentityStr((Object)this.LayoutMap);
    }

    private static final class ManglingModeT
    extends Enum<ManglingModeT>
    implements Native.NativeUIntEnum {
        public static final /* enum */ ManglingModeT MM_None = new ManglingModeT(0);
        public static final /* enum */ ManglingModeT MM_ELF = new ManglingModeT(MM_None.getValue() + 1);
        public static final /* enum */ ManglingModeT MM_MachO = new ManglingModeT(MM_ELF.getValue() + 1);
        public static final /* enum */ ManglingModeT MM_WinCOFF = new ManglingModeT(MM_MachO.getValue() + 1);
        public static final /* enum */ ManglingModeT MM_WinCOFFX86 = new ManglingModeT(MM_WinCOFF.getValue() + 1);
        public static final /* enum */ ManglingModeT MM_Mips = new ManglingModeT(MM_WinCOFFX86.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ManglingModeT[] $VALUES;

        public static ManglingModeT[] values() {
            return (ManglingModeT[])$VALUES.clone();
        }

        public static ManglingModeT valueOf(String name) {
            return Enum.valueOf(ManglingModeT.class, name);
        }

        public static ManglingModeT valueOf(int val) {
            ManglingModeT out;
            ManglingModeT manglingModeT = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ManglingModeT(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ManglingModeT[]{MM_None, MM_ELF, MM_MachO, MM_WinCOFF, MM_WinCOFFX86, MM_Mips};
        }

        private static final class Values {
            private static final ManglingModeT[] VALUES;
            private static final ManglingModeT[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ManglingModeT kind : ManglingModeT.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ManglingModeT[min < 0 ? 1 - min : 0];
                VALUES = new ManglingModeT[max >= 0 ? 1 + max : 0];
                for (ManglingModeT kind : ManglingModeT.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((ManglingModeT)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((ManglingModeT)kind).value] = kind;
                }
            }
        }
    }
}

