/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitchUInt;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVectorImplUInt;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDString;
import org.llvm.ir.Metadata;
import org.llvm.support.llvm;
import org.llvm.support.simplify_type;

public class DINode
extends MDNode
implements Destructors.ClassWithDestructor {
    protected DINode(LLVMContext C2, int ID2, Metadata.StorageType Storage, int Tag, ArrayRef<Metadata> Ops1) {
        this(C2, ID2, Storage, Tag, Ops1, (ArrayRef<Metadata>)new ArrayRef(llvm.None, true));
    }

    protected DINode(LLVMContext C2, int ID2, Metadata.StorageType Storage, int Tag, ArrayRef<Metadata> Ops1, ArrayRef<Metadata> Ops2) {
        super(C2, ID2, Storage, (ArrayRef<Metadata>)new ArrayRef(Ops1), (ArrayRef<Metadata>)new ArrayRef(Ops2));
        assert (Unsigned.$less_uint((int)Tag, (int)65536));
        this.SubclassData16 = Unsigned.$uint2ushort((int)Tag);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    protected <Ty> Ty getOperandAs(Class<Ty> clazz, int I) {
        return (Ty)llvm.cast_or_null(clazz, (simplify_type)this.getOperand(I));
    }

    protected StringRef getStringOperand(int I) {
        MDString S = this.getOperandAs(MDString.class, I);
        if (S != null) {
            return S.getString();
        }
        return new StringRef();
    }

    protected static MDString getCanonicalMDString(LLVMContext Context, StringRef S) {
        if (S.empty()) {
            return null;
        }
        return MDString.get(Context, new StringRef(S));
    }

    protected void setTag(int Tag) {
        this.SubclassData16 = Unsigned.$uint2ushort((int)Tag);
    }

    public int getTag() {
        return Unsigned.$ushort2uint((char)this.SubclassData16);
    }

    public static int getFlag(StringRef Flag) {
        return new StringSwitchUInt(Flag).Case("DIFlagPrivate", 1).Case("DIFlagProtected", 2).Case("DIFlagPublic", 3).Case("DIFlagFwdDecl", 4).Case("DIFlagAppleBlock", 8).Case("DIFlagBlockByrefStruct", 16).Case("DIFlagVirtual", 32).Case("DIFlagArtificial", 64).Case("DIFlagExplicit", 128).Case("DIFlagPrototyped", 256).Case("DIFlagObjcClassComplete", 512).Case("DIFlagObjectPointer", 1024).Case("DIFlagVector", 2048).Case("DIFlagStaticMember", 4096).Case("DIFlagLValueReference", 8192).Case("DIFlagRValueReference", 16384).Case("DIFlagExternalTypeRef", 32768).Case("DIFlagSingleInheritance", 65536).Case("DIFlagMultipleInheritance", 131072).Case("DIFlagVirtualInheritance", 196608).Case("DIFlagIntroducedVirtual", 262144).Case("DIFlagBitField", 524288).Default(0);
    }

    public static char.ptr getFlagString(int Flag) {
        switch (Flag) {
            default: {
                return NativePointer.$EMPTY;
            }
            case 1: {
                return NativePointer.$((String)"DIFlagPrivate");
            }
            case 2: {
                return NativePointer.$((String)"DIFlagProtected");
            }
            case 3: {
                return NativePointer.$((String)"DIFlagPublic");
            }
            case 4: {
                return NativePointer.$((String)"DIFlagFwdDecl");
            }
            case 8: {
                return NativePointer.$((String)"DIFlagAppleBlock");
            }
            case 16: {
                return NativePointer.$((String)"DIFlagBlockByrefStruct");
            }
            case 32: {
                return NativePointer.$((String)"DIFlagVirtual");
            }
            case 64: {
                return NativePointer.$((String)"DIFlagArtificial");
            }
            case 128: {
                return NativePointer.$((String)"DIFlagExplicit");
            }
            case 256: {
                return NativePointer.$((String)"DIFlagPrototyped");
            }
            case 512: {
                return NativePointer.$((String)"DIFlagObjcClassComplete");
            }
            case 1024: {
                return NativePointer.$((String)"DIFlagObjectPointer");
            }
            case 2048: {
                return NativePointer.$((String)"DIFlagVector");
            }
            case 4096: {
                return NativePointer.$((String)"DIFlagStaticMember");
            }
            case 8192: {
                return NativePointer.$((String)"DIFlagLValueReference");
            }
            case 16384: {
                return NativePointer.$((String)"DIFlagRValueReference");
            }
            case 32768: {
                return NativePointer.$((String)"DIFlagExternalTypeRef");
            }
            case 65536: {
                return NativePointer.$((String)"DIFlagSingleInheritance");
            }
            case 131072: {
                return NativePointer.$((String)"DIFlagMultipleInheritance");
            }
            case 196608: {
                return NativePointer.$((String)"DIFlagVirtualInheritance");
            }
            case 262144: {
                return NativePointer.$((String)"DIFlagIntroducedVirtual");
            }
            case 524288: 
        }
        return NativePointer.$((String)"DIFlagBitField");
    }

    public static int splitFlags(int Flags, SmallVectorImplUInt SplitFlags) {
        int Bit;
        int R;
        int A2 = Flags & 3;
        if (A2 != 0) {
            if (A2 == 1) {
                SplitFlags.push_back(1);
            } else if (A2 == 2) {
                SplitFlags.push_back(2);
            } else {
                SplitFlags.push_back(3);
            }
            Flags &= ~A2;
        }
        if ((R = Flags & 0x30000) != 0) {
            if (R == 65536) {
                SplitFlags.push_back(65536);
            } else if (R == 131072) {
                SplitFlags.push_back(131072);
            } else {
                SplitFlags.push_back(196608);
            }
            Flags &= ~R;
        }
        if ((Bit = Flags & 1) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 2) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 3) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 4) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 8) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x10) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x20) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x40) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x80) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x100) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x200) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x400) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x800) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x1000) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x2000) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x4000) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x8000) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x10000) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x20000) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x30000) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x40000) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        if ((Bit = Flags & 0x80000) != 0) {
            SplitFlags.push_back(Bit);
            Flags &= ~Bit;
        }
        return Flags;
    }

    public static boolean classof(Metadata MD) {
        switch (Metadata.MetadataKind.valueOf(MD.getMetadataID())) {
            default: {
                return false;
            }
            case GenericDINodeKind: 
            case DISubrangeKind: 
            case DIEnumeratorKind: 
            case DIBasicTypeKind: 
            case DIDerivedTypeKind: 
            case DICompositeTypeKind: 
            case DISubroutineTypeKind: 
            case DIFileKind: 
            case DICompileUnitKind: 
            case DISubprogramKind: 
            case DILexicalBlockKind: 
            case DILexicalBlockFileKind: 
            case DINamespaceKind: 
            case DITemplateTypeParameterKind: 
            case DITemplateValueParameterKind: 
            case DIGlobalVariableKind: 
            case DILocalVariableKind: 
            case DIObjCPropertyKind: 
            case DIImportedEntityKind: 
            case DIModuleKind: 
        }
        return true;
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }

    public static final class DIFlags {
        public static final int FlagPrivate = 1;
        public static final int FlagProtected = 2;
        public static final int FlagPublic = 3;
        public static final int FlagFwdDecl = 4;
        public static final int FlagAppleBlock = 8;
        public static final int FlagBlockByrefStruct = 16;
        public static final int FlagVirtual = 32;
        public static final int FlagArtificial = 64;
        public static final int FlagExplicit = 128;
        public static final int FlagPrototyped = 256;
        public static final int FlagObjcClassComplete = 512;
        public static final int FlagObjectPointer = 1024;
        public static final int FlagVector = 2048;
        public static final int FlagStaticMember = 4096;
        public static final int FlagLValueReference = 8192;
        public static final int FlagRValueReference = 16384;
        public static final int FlagExternalTypeRef = 32768;
        public static final int FlagSingleInheritance = 65536;
        public static final int FlagMultipleInheritance = 131072;
        public static final int FlagVirtualInheritance = 196608;
        public static final int FlagIntroducedVirtual = 262144;
        public static final int FlagBitField = 524288;
        public static final int FlagAccessibility = 3;
        public static final int FlagPtrToMemberRep = 196608;
    }
}

