/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.ulong;
import org.clank.support.void;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefULong;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.Metadata;
import org.llvm.ir.impl.IrLlvmStatics;
import org.llvm.ir.impl.MDNodeKeyImplDIExpression;
import org.llvm.support.llvm;

public class DIExpression
extends MDNode
implements Destructors.ClassWithDestructor {
    private std.vectorULong Elements;

    private DIExpression(LLVMContext C2, Metadata.StorageType Storage, ArrayRefULong Elements) {
        super(C2, Metadata.MetadataKind.DIExpressionKind.getValue(), Storage, (ArrayRef<Metadata>)new ArrayRef(llvm.None, true));
        this.Elements = new std.vectorULong((ulong.iterator)Elements.begin(), (ulong.iterator)Elements.end());
    }

    @Override
    public void $destroy() {
        this.Elements.$destroy();
        super.$destroy();
    }

    private static DIExpression getImpl(LLVMContext Context, ArrayRefULong Elements, Metadata.StorageType Storage) {
        return DIExpression.getImpl(Context, Elements, Storage, true);
    }

    private static DIExpression getImpl(LLVMContext Context, ArrayRefULong Elements, Metadata.StorageType Storage, boolean ShouldCreate) {
        if (Storage == Metadata.StorageType.Uniqued) {
            DIExpression N = IrLlvmStatics.getUniqued(Context.pImpl.DIExpressions, new MDNodeKeyImplDIExpression(new ArrayRefULong(Elements)));
            if (N != null) {
                return N;
            }
            if (!ShouldCreate) {
                return null;
            }
        } else assert (ShouldCreate) : "Expected non-uniqued nodes to always be created";
        return DIExpression.storeImpl((DIExpression)MDNode.$new(0, New$Mem -> new DIExpression(Context, Storage, new ArrayRefULong(Elements))), Storage, Context.pImpl.DIExpressions);
    }

    std_ptr.unique_ptr_with_deleter<DIExpression> cloneImpl() {
        return DIExpression.getTemporary(this.getContext(), this.getElements());
    }

    public static DIExpression get(LLVMContext Context, ArrayRefULong Elements) {
        return DIExpression.getImpl(Context, new ArrayRefULong(Elements), Metadata.StorageType.Uniqued);
    }

    public static DIExpression getIfExists(LLVMContext Context, ArrayRefULong Elements) {
        return DIExpression.getImpl(Context, new ArrayRefULong(Elements), Metadata.StorageType.Uniqued, false);
    }

    public static DIExpression getDistinct(LLVMContext Context, ArrayRefULong Elements) {
        return DIExpression.getImpl(Context, new ArrayRefULong(Elements), Metadata.StorageType.Distinct);
    }

    public static std_ptr.unique_ptr_with_deleter<DIExpression> getTemporary(LLVMContext Context, ArrayRefULong Elements) {
        return new std_ptr.unique_ptr_with_deleter((Object)DIExpression.getImpl(Context, new ArrayRefULong(Elements), Metadata.StorageType.Temporary));
    }

    public std_ptr.unique_ptr_with_deleter<DIExpression> clone() {
        return this.cloneImpl();
    }

    public ArrayRefULong getElements() {
        return new ArrayRefULong(this.Elements);
    }

    public int getNumElements() {
        return this.Elements.size();
    }

    public long getElement(int I) {
        assert (Unsigned.$less_uint((int)I, (int)this.Elements.size())) : "Index out of range";
        return this.Elements.$at$Const(I);
    }

    public boolean isBitPiece() {
        assert (this.isValid()) : "Expected valid expression";
        int N = this.getNumElements();
        if (N != 0 && Unsigned.$greatereq_uint((int)N, (int)3)) {
            return this.getElement(N - 3) == Unsigned.$uint2ullong((int)157);
        }
        return false;
    }

    public long getBitPieceOffset() {
        assert (this.isBitPiece()) : "Expected bit piece";
        return this.getElement(this.getNumElements() - 2);
    }

    public long getBitPieceSize() {
        assert (this.isBitPiece()) : "Expected bit piece";
        return this.getElement(this.getNumElements() - 1);
    }

    public ulong.ptr elements_begin() {
        return this.getElements().begin();
    }

    public ulong.ptr elements_end() {
        return this.getElements().end();
    }

    public expr_op_iterator expr_op_begin() {
        return new expr_op_iterator(this.elements_begin());
    }

    public expr_op_iterator expr_op_end() {
        return new expr_op_iterator(this.elements_end());
    }

    public boolean isValid() {
        expr_op_iterator I = this.expr_op_begin();
        expr_op_iterator E = this.expr_op_end();
        while (I.$noteq(E)) {
            if (((ulong.ptr)I.$arrow().get().$add(I.$arrow().getSize())).$greater((Object)E.$arrow().get())) {
                return false;
            }
            switch ((int)I.$arrow().getOp()) {
                default: {
                    return false;
                }
                case 157: {
                    return Native.$eq_ptr((void.ptr)((ulong.ptr)I.$arrow().get().$add(I.$arrow().getSize())), (void.ptr)E.$arrow().get());
                }
                case 6: 
                case 28: 
                case 34: 
            }
            I.$preInc();
        }
        return true;
    }

    public static boolean classof(Metadata MD) {
        return MD.getMetadataID() == Metadata.MetadataKind.DIExpressionKind.getValue();
    }

    @Override
    public String toString() {
        return "Elements=" + this.Elements + super.toString();
    }

    public static class expr_op_iterator
    implements std.iterator<std.input_iterator_tag, ExprOperand>,
    Native.NativeComparable<expr_op_iterator> {
        private ExprOperand Op;

        public expr_op_iterator(ulong.ptr I) {
            this.$iterator();
            this.Op = new ExprOperand(I);
        }

        public ulong.ptr getBase() {
            return this.Op.get();
        }

        public ExprOperand $star() {
            return this.Op;
        }

        public ExprOperand $arrow() {
            return (ExprOperand)Native.$AddrOf((Object)this.Op);
        }

        public expr_op_iterator $preInc() {
            this.increment();
            return this;
        }

        public expr_op_iterator $postInc(int $Prm0) {
            expr_op_iterator T2 = new expr_op_iterator(this);
            this.increment();
            return T2;
        }

        public expr_op_iterator getNext() {
            return new expr_op_iterator(new expr_op_iterator(this).$preInc());
        }

        public boolean $eq(expr_op_iterator X) {
            return Native.$eq_ptr((void.ptr)this.getBase(), (void.ptr)X.getBase());
        }

        public boolean $noteq(expr_op_iterator X) {
            return Native.$noteq_ptr((void.ptr)this.getBase(), (void.ptr)X.getBase());
        }

        private void increment() {
            this.Op.$assignMove(new ExprOperand((ulong.ptr)this.getBase().$add(this.Op.getSize())));
        }

        public expr_op_iterator(expr_op_iterator $Prm0) {
            this.$iterator($Prm0);
            this.Op = new ExprOperand($Prm0.Op);
        }

        public expr_op_iterator(JavaDifferentiators.JD.Move _dparam, expr_op_iterator $Prm0) {
            this.$iterator(JavaDifferentiators.JD.Move.INSTANCE, $Prm0);
            this.Op = new ExprOperand(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Op);
        }

        public String toString() {
            return "Op=" + this.Op + super.toString();
        }
    }

    public static class ExprOperand {
        private ulong.ptr Op;

        public ExprOperand(ulong.ptr Op) {
            this.Op = (ulong.ptr)Native.$tryClone((NativeCloneable)Op);
        }

        public ulong.ptr get() {
            return this.Op;
        }

        public long getOp() {
            return this.Op.$star();
        }

        public long getArg(int I) {
            return this.Op.$at(I + 1);
        }

        public int getNumArgs() {
            return this.getSize() - 1;
        }

        public int getSize() {
            switch ((int)this.getOp()) {
                case 157: {
                    return 3;
                }
                case 28: 
                case 34: {
                    return 2;
                }
            }
            return 1;
        }

        public ExprOperand(ExprOperand $Prm0) {
            this.Op = (ulong.ptr)Native.$tryClone((NativeCloneable)$Prm0.Op);
        }

        public ExprOperand(JavaDifferentiators.JD.Move _dparam, ExprOperand $Prm0) {
            this.Op = (ulong.ptr)Native.$tryClone((NativeCloneable)$Prm0.Op);
        }

        public ExprOperand $assignMove(ExprOperand $Prm0) {
            this.Op = (ulong.ptr)Native.$tryClone((NativeCloneable)$Prm0.Op);
            return this;
        }

        public String toString() {
            return "Op=" + this.Op;
        }
    }
}

