/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.APInt;
import org.llvm.adt.StringRef;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantData;
import org.llvm.ir.ConstantVector;
import org.llvm.ir.IntegerType;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.Type;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.LLVMContextImpl;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm_unreachable;

public final class ConstantInt
extends ConstantData
implements Destructors.ClassWithDestructor {
    private APInt Val;

    @Override
    protected void anchor() {
    }

    protected ConstantInt(ConstantInt $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    private ConstantInt(IntegerType Ty, APInt V) {
        super((Type)Ty, Value.ValueTy.ConstantIntVal);
        this.Val = new APInt(V);
        assert (V.getBitWidth() == Ty.getBitWidth()) : "Invalid constant for type";
    }

    void destroyConstantImpl() {
        throw new llvm_unreachable("You can't ConstantInt->destroyConstantImpl()!");
    }

    public static ConstantInt getTrue(LLVMContext Context) {
        LLVMContextImpl pImpl = Context.pImpl;
        if (pImpl.TheTrueVal == null) {
            pImpl.TheTrueVal = ConstantInt.get(Type.getInt1Ty(Context), Unsigned.$int2ulong((int)1));
        }
        return pImpl.TheTrueVal;
    }

    public static ConstantInt getFalse(LLVMContext Context) {
        LLVMContextImpl pImpl = Context.pImpl;
        if (pImpl.TheFalseVal == null) {
            pImpl.TheFalseVal = ConstantInt.get(Type.getInt1Ty(Context), Unsigned.$int2ulong((int)0));
        }
        return pImpl.TheFalseVal;
    }

    public static Constant getTrue(Type Ty) {
        VectorType VTy = IrRTTI.dyn_cast_VectorType(Ty);
        if (VTy == null) {
            assert (Ty.isIntegerTy(1)) : "True must be i1 or vector of i1.";
            return ConstantInt.getTrue(Ty.getContext());
        }
        assert (VTy.getElementType().isIntegerTy(1)) : "True must be vector of i1 or i1.";
        return ConstantVector.getSplat(VTy.getNumElements(), ConstantInt.getTrue(Ty.getContext()));
    }

    public static Constant getFalse(Type Ty) {
        VectorType VTy = IrRTTI.dyn_cast_VectorType(Ty);
        if (VTy == null) {
            assert (Ty.isIntegerTy(1)) : "False must be i1 or vector of i1.";
            return ConstantInt.getFalse(Ty.getContext());
        }
        assert (VTy.getElementType().isIntegerTy(1)) : "False must be vector of i1 or i1.";
        return ConstantVector.getSplat(VTy.getNumElements(), ConstantInt.getFalse(Ty.getContext()));
    }

    public static Constant get(Type Ty, long V) {
        return ConstantInt.get(Ty, V, false);
    }

    public static Constant get(Type Ty, long V, boolean isSigned) {
        ConstantInt C2 = ConstantInt.get(IrRTTI.cast_IntegerType(Ty.getScalarType()), V, isSigned);
        VectorType VTy = IrRTTI.dyn_cast_VectorType(Ty);
        if (VTy != null) {
            return ConstantVector.getSplat(VTy.getNumElements(), C2);
        }
        return C2;
    }

    public static ConstantInt get(IntegerType Ty, long V) {
        return ConstantInt.get(Ty, V, false);
    }

    public static ConstantInt get(IntegerType Ty, long V, boolean isSigned) {
        return ConstantInt.get(Ty.getContext(), new APInt(JavaDifferentiators.JD$UInt_ULong.INSTANCE, Ty.getBitWidth(), V, isSigned));
    }

    public static ConstantInt getSigned(IntegerType Ty, long V) {
        return ConstantInt.get(Ty, V, true);
    }

    public static Constant getSigned(Type Ty, long V) {
        return ConstantInt.get(Ty, V, true);
    }

    public static ConstantInt get(LLVMContext Context, APInt V) {
        LLVMContextImpl pImpl = Context.pImpl;
        type.ref Slot = pImpl.IntConstants.ref$at((Object)V);
        if (Slot.$deref() == null) {
            IntegerType ITy = IntegerType.get(Context, V.getBitWidth());
            Slot.$set((Object)((ConstantInt)ConstantData.$new_ConstantData(New$Mem -> new ConstantInt(ITy, V))));
        }
        assert (((ConstantInt)Slot.$deref()).getType() == IntegerType.get(Context, V.getBitWidth()));
        return (ConstantInt)Slot.$deref();
    }

    public static ConstantInt get(IntegerType Ty, StringRef Str, byte radix) {
        return ConstantInt.get(Ty.getContext(), new APInt(Ty.getBitWidth(), new StringRef(Str), radix));
    }

    public static Constant get(Type Ty, APInt V) {
        ConstantInt C2 = ConstantInt.get(Ty.getContext(), V);
        assert (C2.getType() == Ty.getScalarType()) : "ConstantInt type doesn't match the type implied by its value!";
        VectorType VTy = IrRTTI.dyn_cast_VectorType(Ty);
        if (VTy != null) {
            return ConstantVector.getSplat(VTy.getNumElements(), C2);
        }
        return C2;
    }

    public APInt getValue() {
        return this.Val;
    }

    public int getBitWidth() {
        return this.Val.getBitWidth();
    }

    public long getZExtValue() {
        return this.Val.getZExtValue();
    }

    public long getSExtValue() {
        return this.Val.getSExtValue();
    }

    public boolean equalsInt(long V) {
        return this.Val.$eq(V);
    }

    @Override
    public IntegerType getType() {
        return IrRTTI.cast_IntegerType(super.getType());
    }

    public static boolean isValueValidForType_Type$P_ulong(Type Ty, long Val) {
        int NumBits = Ty.getIntegerBitWidth();
        if (Ty.isIntegerTy(1)) {
            return Val == Unsigned.$int2ullong((int)0) || Val == Unsigned.$int2ullong((int)1);
        }
        if (Unsigned.$greatereq_uint((int)NumBits, (int)64)) {
            return true;
        }
        long Max = (1L << NumBits) - 1L;
        return Unsigned.$lesseq_ulong((long)Val, (long)Max);
    }

    public static boolean isValueValidForType_Type$P_long(Type Ty, long Val) {
        int NumBits = Ty.getIntegerBitWidth();
        if (Ty.isIntegerTy(1)) {
            return Val == 0L || Val == 1L || Val == -1L;
        }
        if (Unsigned.$greatereq_uint((int)NumBits, (int)64)) {
            return true;
        }
        long Min = -(1L << NumBits - 1);
        long Max = (1L << NumBits - 1) - 1L;
        return Val >= Min && Val <= Max;
    }

    public boolean isNegative() {
        return this.Val.isNegative();
    }

    public boolean isZero() {
        return this.Val.$eq(Unsigned.$int2ulong((int)0));
    }

    public boolean isOne() {
        return this.Val.$eq(Unsigned.$int2ulong((int)1));
    }

    public boolean isMinusOne() {
        return this.Val.isAllOnesValue();
    }

    public boolean isMaxValue(boolean isSigned) {
        if (isSigned) {
            return this.Val.isMaxSignedValue();
        }
        return this.Val.isMaxValue();
    }

    public boolean isMinValue(boolean isSigned) {
        if (isSigned) {
            return this.Val.isMinSignedValue();
        }
        return this.Val.isMinValue();
    }

    public boolean uge(long Num) {
        return Unsigned.$greater_uint((int)this.Val.getActiveBits(), (int)64) || Unsigned.$greatereq_ulong((long)this.Val.getZExtValue(), (long)Num);
    }

    public long getLimitedValue() {
        return this.getLimitedValue(-1L);
    }

    public long getLimitedValue(long Limit) {
        return this.Val.getLimitedValue(Limit);
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.ConstantIntVal.getValue();
    }

    @Override
    public void $destroy() {
        this.Val.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Val=" + this.Val + super.toString();
    }
}

