/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.APFloat;
import org.llvm.adt.APInt;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.SmallPtrSetImpl;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.ir.BlockAddress;
import org.llvm.ir.ConstantAggregate;
import org.llvm.ir.ConstantAggregateZero;
import org.llvm.ir.ConstantDataSequential;
import org.llvm.ir.ConstantDataVector;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.ConstantPointerNull;
import org.llvm.ir.ConstantTokenNone;
import org.llvm.ir.ConstantVector;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.IntegerType;
import org.llvm.ir.PointerType;
import org.llvm.ir.Type;
import org.llvm.ir.UndefValue;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.ConstantsStatics;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.fltSemantics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class Constant
extends User
implements Destructors.ClassWithDestructor {
    protected void $assign(Constant $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected Constant(Constant $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    @Override
    protected void anchor() {
    }

    protected Constant(Type ty, Value.ValueTy vty, type.ptr<Use> Ops, int NumOps) {
        super(ty, vty.getValue(), Ops, NumOps);
    }

    public boolean isNullValue() {
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(this);
        if (CI != null) {
            return CI.isZero();
        }
        ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(this);
        if (CFP != null) {
            return CFP.isZero() && !CFP.isNegative();
        }
        return IrRTTI.isa_ConstantAggregateZero(this) || IrRTTI.isa_ConstantPointerNull(this) || IrRTTI.isa_ConstantTokenNone(this);
    }

    public boolean isOneValue() {
        Constant Splat;
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(this);
        if (CI != null) {
            return CI.isOne();
        }
        ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(this);
        if (CFP != null) {
            return CFP.getValueAPF().bitcastToAPInt().$eq(Unsigned.$int2ulong((int)1));
        }
        Constant CV = IrRTTI.dyn_cast_ConstantVector(this);
        if (CV != null && (Splat = ((ConstantVector)CV).getSplatValue()) != null) {
            return Splat.isOneValue();
        }
        CV = IrRTTI.dyn_cast_ConstantDataVector(this);
        if (CV != null && (Splat = ((ConstantDataVector)CV).getSplatValue()) != null) {
            return Splat.isOneValue();
        }
        return false;
    }

    public boolean isAllOnesValue() {
        Constant Splat;
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(this);
        if (CI != null) {
            return CI.isMinusOne();
        }
        ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(this);
        if (CFP != null) {
            return CFP.getValueAPF().bitcastToAPInt().isAllOnesValue();
        }
        Constant CV = IrRTTI.dyn_cast_ConstantVector(this);
        if (CV != null && (Splat = ((ConstantVector)CV).getSplatValue()) != null) {
            return Splat.isAllOnesValue();
        }
        CV = IrRTTI.dyn_cast_ConstantDataVector(this);
        if (CV != null && (Splat = ((ConstantDataVector)CV).getSplatValue()) != null) {
            return Splat.isAllOnesValue();
        }
        return false;
    }

    public boolean isNegativeZeroValue() {
        ConstantFP SplatCFP;
        ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(this);
        if (CFP != null) {
            return CFP.isZero() && CFP.isNegative();
        }
        Constant CV = IrRTTI.dyn_cast_ConstantDataVector(this);
        if (CV != null && (SplatCFP = IrRTTI.dyn_cast_or_null_ConstantFP(((ConstantDataVector)CV).getSplatValue())) != null && SplatCFP != null && SplatCFP.isZero() && SplatCFP.isNegative()) {
            return true;
        }
        CV = IrRTTI.dyn_cast_ConstantVector(this);
        if (CV != null && (SplatCFP = IrRTTI.dyn_cast_or_null_ConstantFP(((ConstantVector)CV).getSplatValue())) != null && SplatCFP != null && SplatCFP.isZero() && SplatCFP.isNegative()) {
            return true;
        }
        if (this.getType().isFPOrFPVectorTy()) {
            return false;
        }
        return this.isNullValue();
    }

    public boolean isZeroValue() {
        ConstantFP SplatCFP;
        ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(this);
        if (CFP != null) {
            return CFP.isZero();
        }
        Constant CV = IrRTTI.dyn_cast_ConstantDataVector(this);
        if (CV != null && (SplatCFP = IrRTTI.dyn_cast_or_null_ConstantFP(((ConstantDataVector)CV).getSplatValue())) != null && SplatCFP != null && SplatCFP.isZero()) {
            return true;
        }
        CV = IrRTTI.dyn_cast_ConstantVector(this);
        if (CV != null && (SplatCFP = IrRTTI.dyn_cast_or_null_ConstantFP(((ConstantVector)CV).getSplatValue())) != null && SplatCFP != null && SplatCFP.isZero()) {
            return true;
        }
        return this.isNullValue();
    }

    public boolean isNotMinSignedValue() {
        Constant Splat;
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(this);
        if (CI != null) {
            return !CI.isMinValue(true);
        }
        ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(this);
        if (CFP != null) {
            return !CFP.getValueAPF().bitcastToAPInt().isMinSignedValue();
        }
        Constant CV = IrRTTI.dyn_cast_ConstantVector(this);
        if (CV != null && (Splat = ((ConstantVector)CV).getSplatValue()) != null) {
            return Splat.isNotMinSignedValue();
        }
        CV = IrRTTI.dyn_cast_ConstantDataVector(this);
        if (CV != null && (Splat = ((ConstantDataVector)CV).getSplatValue()) != null) {
            return Splat.isNotMinSignedValue();
        }
        return false;
    }

    public boolean isMinSignedValue() {
        Constant Splat;
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(this);
        if (CI != null) {
            return CI.isMinValue(true);
        }
        ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(this);
        if (CFP != null) {
            return CFP.getValueAPF().bitcastToAPInt().isMinSignedValue();
        }
        Constant CV = IrRTTI.dyn_cast_ConstantVector(this);
        if (CV != null && (Splat = ((ConstantVector)CV).getSplatValue()) != null) {
            return Splat.isMinSignedValue();
        }
        CV = IrRTTI.dyn_cast_ConstantDataVector(this);
        if (CV != null && (Splat = ((ConstantDataVector)CV).getSplatValue()) != null) {
            return Splat.isMinSignedValue();
        }
        return false;
    }

    public boolean canTrap() {
        SmallPtrSet NonTrappingOps = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 4);
        return ConstantsStatics.canTrapImpl(this, (SmallPtrSetImpl<ConstantExpr>)NonTrappingOps);
    }

    public boolean isThreadDependent() {
        NativeCallback.BoolPredicate DLLImportPredicate = GV -> GV.isThreadLocal();
        return ConstantsStatics.ConstHasGlobalValuePredicate(this, (NativeCallback.BoolPredicate<GlobalValue>)DLLImportPredicate);
    }

    public boolean isDLLImportDependent() {
        NativeCallback.BoolPredicate DLLImportPredicate = GV -> GV.hasDLLImportStorageClass();
        return ConstantsStatics.ConstHasGlobalValuePredicate(this, (NativeCallback.BoolPredicate<GlobalValue>)DLLImportPredicate);
    }

    public boolean isConstantUsed() {
        for (User U : this.users$Const()) {
            Constant UC = IrRTTI.dyn_cast_Constant(U);
            if (UC == null || IrRTTI.isa_GlobalValue(UC)) {
                return true;
            }
            if (!UC.isConstantUsed()) continue;
            return true;
        }
        return false;
    }

    public boolean needsRelocation() {
        if (IrRTTI.isa_GlobalValue(this)) {
            return true;
        }
        BlockAddress BA = IrRTTI.dyn_cast_BlockAddress(this);
        if (BA != null) {
            return BA.getFunction().needsRelocation();
        }
        ConstantExpr CE = IrRTTI.dyn_cast_ConstantExpr(this);
        if (CE != null && CE.getOpcode() == 13) {
            ConstantExpr LHS = IrRTTI.dyn_cast_ConstantExpr(CE.getOperand_Constant(0));
            ConstantExpr RHS = IrRTTI.dyn_cast_ConstantExpr(CE.getOperand_Constant(1));
            if (LHS != null && RHS != null && LHS.getOpcode() == 45 && RHS.getOpcode() == 45 && IrRTTI.isa_BlockAddress(LHS.getOperand_Constant(0)) && IrRTTI.isa_BlockAddress(RHS.getOperand_Constant(0)) && IrRTTI.cast_BlockAddress(LHS.getOperand_Constant(0)).getFunction() == IrRTTI.cast_BlockAddress(RHS.getOperand_Constant(0)).getFunction()) {
                return false;
            }
        }
        boolean Result2 = false;
        int e = this.getNumOperands();
        for (int i = 0; i != e; ++i) {
            Result2 |= IrRTTI.cast_Constant(this.getOperand(i)).needsRelocation();
        }
        return Result2;
    }

    public Constant getAggregateElement(int Elt) {
        ConstantAggregate CC = IrRTTI.dyn_cast_ConstantAggregate(this);
        if (CC != null) {
            return Unsigned.$less_uint((int)Elt, (int)CC.getNumOperands()) ? CC.getOperand(Elt) : null;
        }
        ConstantAggregateZero CAZ = IrRTTI.dyn_cast_ConstantAggregateZero(this);
        if (CAZ != null) {
            return Unsigned.$less_uint((int)Elt, (int)CAZ.getNumElements()) ? CAZ.getElementValue(Elt) : null;
        }
        UndefValue UV = IrRTTI.dyn_cast_UndefValue(this);
        if (UV != null) {
            return Unsigned.$less_uint((int)Elt, (int)UV.getNumElements()) ? UV.getElementValue(Elt) : null;
        }
        ConstantDataSequential CDS = IrRTTI.dyn_cast_ConstantDataSequential(this);
        if (CDS != null) {
            return Unsigned.$less_uint((int)Elt, (int)CDS.getNumElements()) ? CDS.getElementAsConstant(Elt) : null;
        }
        return null;
    }

    public Constant getAggregateElement(Constant Elt) {
        assert (IrRTTI.isa_IntegerType(Elt.getType())) : "Index must be an integer";
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(Elt);
        if (CI != null) {
            return this.getAggregateElement(Unsigned.$ulong2uint((long)CI.getZExtValue()));
        }
        return null;
    }

    public Constant getSplatValue() {
        assert (super.getType().isVectorTy()) : "Only valid for vectors!";
        if (IrRTTI.isa_ConstantAggregateZero(this)) {
            return Constant.getNullValue(super.getType().getVectorElementType());
        }
        Constant CV = IrRTTI.dyn_cast_ConstantDataVector(this);
        if (CV != null) {
            return ((ConstantDataVector)CV).getSplatValue();
        }
        CV = IrRTTI.dyn_cast_ConstantVector(this);
        if (CV != null) {
            return ((ConstantVector)CV).getSplatValue();
        }
        return null;
    }

    public APInt getUniqueInteger() {
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(this);
        if (CI != null) {
            return CI.getValue();
        }
        assert (this.getSplatValue() != null) : "Doesn't contain a unique integer!";
        Constant C2 = this.getAggregateElement(0);
        assert (C2 != null && IrRTTI.isa_ConstantInt(C2)) : "Not a vector of numbers!";
        return IrRTTI.cast_ConstantInt(C2).getValue();
    }

    public void destroyConstant() {
        switch (Value.ValueTy.valueOf(this.getValueID())) {
            default: {
                throw new llvm_unreachable("Not a constant!");
            }
            case FunctionVal: {
                IrRTTI.cast_Function(this).destroyConstantImpl();
                break;
            }
            case GlobalAliasVal: {
                IrRTTI.cast_GlobalAlias(this).destroyConstantImpl();
                break;
            }
            case GlobalIFuncVal: {
                IrRTTI.cast_GlobalIFunc(this).destroyConstantImpl();
                break;
            }
            case GlobalVariableVal: {
                IrRTTI.cast_GlobalVariable(this).destroyConstantImpl();
                break;
            }
            case BlockAddressVal: {
                IrRTTI.cast_BlockAddress(this).destroyConstantImpl();
                break;
            }
            case ConstantExprVal: {
                IrRTTI.cast_ConstantExpr(this).destroyConstantImpl();
                break;
            }
            case ConstantArrayVal: {
                IrRTTI.cast_ConstantArray(this).destroyConstantImpl();
                break;
            }
            case ConstantStructVal: {
                IrRTTI.cast_ConstantStruct(this).destroyConstantImpl();
                break;
            }
            case ConstantVectorVal: {
                IrRTTI.cast_ConstantVector(this).destroyConstantImpl();
                break;
            }
            case UndefValueVal: {
                IrRTTI.cast_UndefValue(this).destroyConstantImpl();
                break;
            }
            case ConstantAggregateZeroVal: {
                IrRTTI.cast_ConstantAggregateZero(this).destroyConstantImpl();
                break;
            }
            case ConstantDataArrayVal: {
                IrRTTI.cast_ConstantDataArray(this).destroyConstantImpl();
                break;
            }
            case ConstantDataVectorVal: {
                IrRTTI.cast_ConstantDataVector(this).destroyConstantImpl();
                break;
            }
            case ConstantIntVal: {
                IrRTTI.cast_ConstantInt(this).destroyConstantImpl();
                break;
            }
            case ConstantFPVal: {
                IrRTTI.cast_ConstantFP(this).destroyConstantImpl();
                break;
            }
            case ConstantPointerNullVal: {
                IrRTTI.cast_ConstantPointerNull(this).destroyConstantImpl();
                break;
            }
            case ConstantTokenNoneVal: {
                IrRTTI.cast_ConstantTokenNone(this).destroyConstantImpl();
            }
        }
        while (!this.use_empty()) {
            User V = this.user_back$Value();
            if (!IrRTTI.isa_Constant(V)) {
                IrLlvmGlobals.$out_raw_ostream_Value$C(IrLlvmGlobals.$out_raw_ostream_Value$C(llvm.dbgs().$out("While deleting: "), this).$out("\n\nUse still stuck around after Def is destroyed: "), (Value)Native.$Deref((Object)V)).$out("\n\n");
            }
            assert (IrRTTI.isa_Constant(V)) : "References remain to Constant being destroyed";
            IrRTTI.cast_Constant(V).destroyConstant();
            assert (this.use_empty() || this.user_back$Value() != V) : "Constant not removed!";
        }
        Destructors.$destroy((Destructors.ClassWithDestructor)this);
    }

    public static boolean classof(Value V) {
        return Unsigned.$greatereq_uint((int)V.getValueID(), (int)Value.ValueTy.ConstantFirstVal.getValue()) && Unsigned.$lesseq_uint((int)V.getValueID(), (int)Value.ValueTy.ConstantLastVal.getValue());
    }

    public void handleOperandChange(Value From, Value To) {
        Value Replacement = null;
        switch (Value.ValueTy.valueOf(this.getValueID())) {
            default: {
                throw new llvm_unreachable("Not a constant!");
            }
            case FunctionVal: {
                Replacement = IrRTTI.cast_Function(this).handleOperandChangeImpl(From, To);
                break;
            }
            case GlobalAliasVal: {
                Replacement = IrRTTI.cast_GlobalAlias(this).handleOperandChangeImpl(From, To);
                break;
            }
            case GlobalIFuncVal: {
                Replacement = IrRTTI.cast_GlobalIFunc(this).handleOperandChangeImpl(From, To);
                break;
            }
            case GlobalVariableVal: {
                Replacement = IrRTTI.cast_GlobalVariable(this).handleOperandChangeImpl(From, To);
                break;
            }
            case BlockAddressVal: {
                Replacement = IrRTTI.cast_BlockAddress(this).handleOperandChangeImpl(From, To);
                break;
            }
            case ConstantExprVal: {
                Replacement = IrRTTI.cast_ConstantExpr(this).handleOperandChangeImpl(From, To);
                break;
            }
            case ConstantArrayVal: {
                Replacement = IrRTTI.cast_ConstantArray(this).handleOperandChangeImpl(From, To);
                break;
            }
            case ConstantStructVal: {
                Replacement = IrRTTI.cast_ConstantStruct(this).handleOperandChangeImpl(From, To);
                break;
            }
            case ConstantVectorVal: {
                Replacement = IrRTTI.cast_ConstantVector(this).handleOperandChangeImpl(From, To);
                break;
            }
            case UndefValueVal: {
                Replacement = IrRTTI.cast_UndefValue(this).handleOperandChangeImpl(From, To);
                break;
            }
            case ConstantAggregateZeroVal: {
                Replacement = IrRTTI.cast_ConstantAggregateZero(this).handleOperandChangeImpl(From, To);
                break;
            }
            case ConstantDataArrayVal: {
                Replacement = IrRTTI.cast_ConstantDataArray(this).handleOperandChangeImpl(From, To);
                break;
            }
            case ConstantDataVectorVal: {
                Replacement = IrRTTI.cast_ConstantDataVector(this).handleOperandChangeImpl(From, To);
                break;
            }
            case ConstantIntVal: {
                Replacement = IrRTTI.cast_ConstantInt(this).handleOperandChangeImpl(From, To);
                break;
            }
            case ConstantFPVal: {
                Replacement = IrRTTI.cast_ConstantFP(this).handleOperandChangeImpl(From, To);
                break;
            }
            case ConstantPointerNullVal: {
                Replacement = IrRTTI.cast_ConstantPointerNull(this).handleOperandChangeImpl(From, To);
                break;
            }
            case ConstantTokenNoneVal: {
                Replacement = IrRTTI.cast_ConstantTokenNone(this).handleOperandChangeImpl(From, To);
            }
        }
        if (Replacement == null) {
            return;
        }
        assert (Replacement != this) : "I didn't contain From!";
        this.replaceAllUsesWith(Replacement);
        this.destroyConstant();
    }

    public static Constant getNullValue(Type Ty) {
        switch (Ty.getTypeID()) {
            case IntegerTyID: {
                return ConstantInt.get(Ty, Unsigned.$int2ulong((int)0));
            }
            case HalfTyID: {
                return ConstantFP.get(Ty.getContext(), APFloat.getZero((fltSemantics)APFloat.IEEEhalf));
            }
            case FloatTyID: {
                return ConstantFP.get(Ty.getContext(), APFloat.getZero((fltSemantics)APFloat.IEEEsingle));
            }
            case DoubleTyID: {
                return ConstantFP.get(Ty.getContext(), APFloat.getZero((fltSemantics)APFloat.IEEEdouble));
            }
            case X86_FP80TyID: {
                return ConstantFP.get(Ty.getContext(), APFloat.getZero((fltSemantics)APFloat.x87DoubleExtended));
            }
            case FP128TyID: {
                return ConstantFP.get(Ty.getContext(), APFloat.getZero((fltSemantics)APFloat.IEEEquad));
            }
            case PPC_FP128TyID: {
                return ConstantFP.get(Ty.getContext(), new APFloat(APFloat.PPCDoubleDouble, APInt.getNullValue((int)128)));
            }
            case PointerTyID: {
                return ConstantPointerNull.get(IrRTTI.cast_PointerType(Ty));
            }
            case StructTyID: 
            case ArrayTyID: 
            case VectorTyID: {
                return ConstantAggregateZero.get(Ty);
            }
            case TokenTyID: {
                return ConstantTokenNone.get(Ty.getContext());
            }
        }
        throw new llvm_unreachable("Cannot create a null constant of that type!");
    }

    public static Constant getAllOnesValue(Type Ty) {
        IntegerType ITy = IrRTTI.dyn_cast_IntegerType(Ty);
        if (ITy != null) {
            return ConstantInt.get(Ty.getContext(), APInt.getAllOnesValue((int)ITy.getBitWidth()));
        }
        if (Ty.isFloatingPointTy()) {
            APFloat FL = APFloat.getAllOnesValue((int)Ty.getPrimitiveSizeInBits(), (!Ty.isPPC_FP128Ty() ? 1 : 0) != 0);
            return ConstantFP.get(Ty.getContext(), FL);
        }
        VectorType VTy = IrRTTI.cast_VectorType(Ty);
        return ConstantVector.getSplat(VTy.getNumElements(), Constant.getAllOnesValue(VTy.getElementType()));
    }

    public static Constant getIntegerValue(Type Ty, APInt V) {
        VectorType VTy;
        Type ScalarTy = Ty.getScalarType();
        Constant C2 = ConstantInt.get(Ty.getContext(), V);
        PointerType PTy = IrRTTI.dyn_cast_PointerType(ScalarTy);
        if (PTy != null) {
            C2 = ConstantExpr.getIntToPtr(C2, PTy);
        }
        if ((VTy = IrRTTI.dyn_cast_VectorType(Ty)) != null) {
            C2 = ConstantVector.getSplat(VTy.getNumElements(), C2);
        }
        return C2;
    }

    public void removeDeadConstantUsers() {
        Value.user_iterator_impl<User> I = this.user_begin$Const();
        Value.user_iterator_impl<User> E = this.user_end$Const();
        Value.user_iterator_impl<User> LastNonDeadUser = new Value.user_iterator_impl<User>(E);
        while (I.$noteq(E)) {
            Constant User2 = IrRTTI.dyn_cast_Constant((Value)I.$star());
            if (User2 == null) {
                LastNonDeadUser.$assign(I);
                I.$preInc();
                continue;
            }
            if (!ConstantsStatics.removeDeadUsersOfConstant(User2)) {
                LastNonDeadUser.$assign(I);
                I.$preInc();
                continue;
            }
            if (LastNonDeadUser.$eq(E)) {
                I.$assignMove(this.user_begin$Const());
                if (!I.$eq(E)) continue;
                break;
            }
            I.$assign(LastNonDeadUser);
            I.$preInc();
        }
    }

    @Override
    public Constant stripPointerCasts() {
        return IrRTTI.cast_Constant(super.stripPointerCasts());
    }

    @Override
    public Constant stripPointerCasts$Const() {
        return this.stripPointerCasts();
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    protected Constant() {
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

