/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.Twine;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.FCmpInst;
import org.llvm.ir.ICmpInst;
import org.llvm.ir.Instruction;
import org.llvm.ir.OperandTraitsCmpInst;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.java.IRJavaDifferentiators;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm_unreachable;

public class CmpInst
extends Instruction
implements Destructors.ClassWithDestructor {
    protected static Object $new_CmpInst(int $Prm0, int $Prm1) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected CmpInst() {
        throw new UnsupportedOperationException("Deleted");
    }

    protected CmpInst(IRJavaDifferentiators.JD.Type.P_OtherOps_Predicate_Value.P_Twine.C_Instruction.P _dparam, Type ty, int op, Predicate predicate, Value LHS, Value RHS) {
        this(_dparam, ty, op, predicate, LHS, RHS, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    protected CmpInst(IRJavaDifferentiators.JD.Type.P_OtherOps_Predicate_Value.P_Twine.C_Instruction.P _dparam, Type ty, int op, Predicate predicate, Value LHS, Value RHS, Twine Name) {
        this(_dparam, ty, op, predicate, LHS, RHS, Name, (Instruction)null);
    }

    protected CmpInst(IRJavaDifferentiators.JD.Type.P_OtherOps_Predicate_Value.P_Twine.C_Instruction.P _dparam, Type ty, int op, Predicate predicate, Value LHS, Value RHS, Twine Name, Instruction InsertBefore) {
        super(ty, op, OperandTraitsCmpInst.op_begin(User.$BEING_CREATED()), OperandTraitsCmpInst.operands$FixedNumOperandTraits(User.$BEING_CREATED()), InsertBefore);
        this.Op(0).$assign(LHS);
        this.Op(1).$assign(RHS);
        this.setPredicate(predicate);
        this.setName(Name);
    }

    protected CmpInst(IRJavaDifferentiators.JD.Type.P_OtherOps_Predicate_Value.P_Twine.C_BasicBlock.P _dparam, Type ty, int op, Predicate predicate, Value LHS, Value RHS, Twine Name, BasicBlock InsertAtEnd) {
        super(ty, op, OperandTraitsCmpInst.op_begin(User.$BEING_CREATED()), OperandTraitsCmpInst.operands$FixedNumOperandTraits(User.$BEING_CREATED()), InsertAtEnd);
        this.Op(0).$assign(LHS);
        this.Op(1).$assign(RHS);
        this.setPredicate(predicate);
        this.setName(Name);
    }

    @Override
    protected void anchor() {
    }

    public static <T extends CmpInst> T $new_CmpInst(NativeCallback.New.ConstructorCallback<T> $Ctor) {
        return (T)((CmpInst)User.$new_FixedUses(2, $Ctor));
    }

    public static CmpInst Create(int Op, Predicate predicate, Value S1, Value S2) {
        return CmpInst.Create(Op, predicate, S1, S2, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static CmpInst Create(int Op, Predicate predicate, Value S1, Value S2, Twine Name) {
        return CmpInst.Create(Op, predicate, S1, S2, Name, (Instruction)null);
    }

    public static CmpInst Create(int Op, Predicate predicate, Value S1, Value S2, Twine Name, Instruction InsertBefore) {
        if (Op == 51) {
            if (InsertBefore != null) {
                return CmpInst.$new_CmpInst(New$Mem -> new ICmpInst(InsertBefore, predicate, S1, S2, Name));
            }
            return CmpInst.$new_CmpInst(New$Mem -> new ICmpInst(predicate, S1, S2, Name));
        }
        if (InsertBefore != null) {
            return CmpInst.$new_CmpInst(New$Mem -> new FCmpInst(InsertBefore, predicate, S1, S2, Name));
        }
        return CmpInst.$new_CmpInst(New$Mem -> new FCmpInst(predicate, S1, S2, Name));
    }

    public static CmpInst Create(int Op, Predicate predicate, Value S1, Value S2, Twine Name, BasicBlock InsertAtEnd) {
        if (Op == 51) {
            return CmpInst.$new_CmpInst(New$Mem -> new ICmpInst((BasicBlock)Native.$Deref((Object)InsertAtEnd), predicate, S1, S2, Name));
        }
        return CmpInst.$new_CmpInst(New$Mem -> new FCmpInst((BasicBlock)Native.$Deref((Object)InsertAtEnd), predicate, S1, S2, Name));
    }

    @Override
    public int getOpcode() {
        return super.getOpcode();
    }

    public Predicate getPredicate() {
        return Predicate.valueOf(this.getSubclassDataFromInstruction());
    }

    public void setPredicate(Predicate P2) {
        this.setInstructionSubclassData(P2.getValue());
    }

    public static boolean isFPPredicate(Predicate P2) {
        return P2.getValue() >= Predicate.FIRST_FCMP_PREDICATE.getValue() && P2.getValue() <= Predicate.LAST_FCMP_PREDICATE.getValue();
    }

    public static boolean isIntPredicate(Predicate P2) {
        return P2.getValue() >= Predicate.FIRST_ICMP_PREDICATE.getValue() && P2.getValue() <= Predicate.LAST_ICMP_PREDICATE.getValue();
    }

    public boolean isFPPredicate() {
        return CmpInst.isFPPredicate(this.getPredicate());
    }

    public boolean isIntPredicate() {
        return CmpInst.isIntPredicate(this.getPredicate());
    }

    public Predicate getInversePredicate() {
        return CmpInst.getInversePredicate(this.getPredicate());
    }

    public static Predicate getInversePredicate(Predicate pred) {
        switch (pred) {
            default: {
                throw new llvm_unreachable("Unknown cmp predicate!");
            }
            case ICMP_EQ: {
                return Predicate.ICMP_NE;
            }
            case ICMP_NE: {
                return Predicate.ICMP_EQ;
            }
            case ICMP_UGT: {
                return Predicate.ICMP_ULE;
            }
            case ICMP_ULT: {
                return Predicate.ICMP_UGE;
            }
            case ICMP_UGE: {
                return Predicate.ICMP_ULT;
            }
            case ICMP_ULE: {
                return Predicate.ICMP_UGT;
            }
            case ICMP_SGT: {
                return Predicate.ICMP_SLE;
            }
            case ICMP_SLT: {
                return Predicate.ICMP_SGE;
            }
            case ICMP_SGE: {
                return Predicate.ICMP_SLT;
            }
            case ICMP_SLE: {
                return Predicate.ICMP_SGT;
            }
            case FCMP_OEQ: {
                return Predicate.FCMP_UNE;
            }
            case FCMP_ONE: {
                return Predicate.FCMP_UEQ;
            }
            case FCMP_OGT: {
                return Predicate.FCMP_ULE;
            }
            case FCMP_OLT: {
                return Predicate.FCMP_UGE;
            }
            case FCMP_OGE: {
                return Predicate.FCMP_ULT;
            }
            case FCMP_OLE: {
                return Predicate.FCMP_UGT;
            }
            case FCMP_UEQ: {
                return Predicate.FCMP_ONE;
            }
            case FCMP_UNE: {
                return Predicate.FCMP_OEQ;
            }
            case FCMP_UGT: {
                return Predicate.FCMP_OLE;
            }
            case FCMP_ULT: {
                return Predicate.FCMP_OGE;
            }
            case FCMP_UGE: {
                return Predicate.FCMP_OLT;
            }
            case FCMP_ULE: {
                return Predicate.FCMP_OGT;
            }
            case FCMP_ORD: {
                return Predicate.FCMP_UNO;
            }
            case FCMP_UNO: {
                return Predicate.FCMP_ORD;
            }
            case FCMP_TRUE: {
                return Predicate.FCMP_FALSE;
            }
            case FCMP_FALSE: 
        }
        return Predicate.FCMP_TRUE;
    }

    public Predicate getSwappedPredicate() {
        return CmpInst.getSwappedPredicate(this.getPredicate());
    }

    public static Predicate getSwappedPredicate(Predicate pred) {
        switch (pred) {
            default: {
                throw new llvm_unreachable("Unknown cmp predicate!");
            }
            case ICMP_EQ: 
            case ICMP_NE: {
                return pred;
            }
            case ICMP_SGT: {
                return Predicate.ICMP_SLT;
            }
            case ICMP_SLT: {
                return Predicate.ICMP_SGT;
            }
            case ICMP_SGE: {
                return Predicate.ICMP_SLE;
            }
            case ICMP_SLE: {
                return Predicate.ICMP_SGE;
            }
            case ICMP_UGT: {
                return Predicate.ICMP_ULT;
            }
            case ICMP_ULT: {
                return Predicate.ICMP_UGT;
            }
            case ICMP_UGE: {
                return Predicate.ICMP_ULE;
            }
            case ICMP_ULE: {
                return Predicate.ICMP_UGE;
            }
            case FCMP_OEQ: 
            case FCMP_ONE: 
            case FCMP_UEQ: 
            case FCMP_UNE: 
            case FCMP_ORD: 
            case FCMP_UNO: 
            case FCMP_TRUE: 
            case FCMP_FALSE: {
                return pred;
            }
            case FCMP_OGT: {
                return Predicate.FCMP_OLT;
            }
            case FCMP_OLT: {
                return Predicate.FCMP_OGT;
            }
            case FCMP_OGE: {
                return Predicate.FCMP_OLE;
            }
            case FCMP_OLE: {
                return Predicate.FCMP_OGE;
            }
            case FCMP_UGT: {
                return Predicate.FCMP_ULT;
            }
            case FCMP_ULT: {
                return Predicate.FCMP_UGT;
            }
            case FCMP_UGE: {
                return Predicate.FCMP_ULE;
            }
            case FCMP_ULE: 
        }
        return Predicate.FCMP_UGE;
    }

    @Override
    public Value getOperand(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsCmpInst.operands$FixedNumOperandTraits(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Value(((Use)OperandTraitsCmpInst.op_begin(this).$at(i_nocapture)).get());
    }

    @Override
    public void setOperand(int i_nocapture, Value Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsCmpInst.operands$FixedNumOperandTraits(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsCmpInst.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsCmpInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsCmpInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsCmpInst.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsCmpInst.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsCmpInst.operands$FixedNumOperandTraits(this);
    }

    public void swapOperands() {
        ICmpInst IC = IrRTTI.dyn_cast_ICmpInst(this);
        if (IC != null) {
            IC.swapOperands();
        } else {
            IrRTTI.cast_FCmpInst(this).swapOperands();
        }
    }

    @Override
    public boolean isCommutative() {
        ICmpInst IC = IrRTTI.dyn_cast_ICmpInst(this);
        if (IC != null) {
            return IC.isCommutative();
        }
        return IrRTTI.cast_FCmpInst(this).isCommutative();
    }

    public boolean isEquality() {
        ICmpInst IC = IrRTTI.dyn_cast_ICmpInst(this);
        if (IC != null) {
            return IC.isEquality();
        }
        return IrRTTI.cast_FCmpInst(this).isEquality();
    }

    public boolean isSigned() {
        return CmpInst.isSigned(this.getPredicate());
    }

    public boolean isUnsigned() {
        return CmpInst.isUnsigned(this.getPredicate());
    }

    public static Predicate getSignedPredicate(Predicate pred) {
        assert (CmpInst.isUnsigned(pred)) : "Call only with signed predicates!";
        switch (pred) {
            default: {
                throw new llvm_unreachable("Unknown predicate!");
            }
            case ICMP_ULT: {
                return Predicate.ICMP_SLT;
            }
            case ICMP_ULE: {
                return Predicate.ICMP_SLE;
            }
            case ICMP_UGT: {
                return Predicate.ICMP_SGT;
            }
            case ICMP_UGE: 
        }
        return Predicate.ICMP_SGE;
    }

    public Predicate getSignedPredicate() {
        return CmpInst.getSignedPredicate(this.getPredicate());
    }

    public boolean isTrueWhenEqual() {
        return CmpInst.isTrueWhenEqual(this.getPredicate());
    }

    public boolean isFalseWhenEqual() {
        return CmpInst.isFalseWhenEqual(this.getPredicate());
    }

    public boolean isImpliedTrueByMatchingCmp(Predicate Pred2) {
        return CmpInst.isImpliedTrueByMatchingCmp(this.getPredicate(), Pred2);
    }

    public boolean isImpliedFalseByMatchingCmp(Predicate Pred2) {
        return CmpInst.isImpliedFalseByMatchingCmp(this.getPredicate(), Pred2);
    }

    public static boolean isUnsigned(Predicate predicate) {
        switch (predicate) {
            default: {
                return false;
            }
            case ICMP_UGT: 
            case ICMP_ULT: 
            case ICMP_UGE: 
            case ICMP_ULE: 
        }
        return true;
    }

    public static boolean isSigned(Predicate predicate) {
        switch (predicate) {
            default: {
                return false;
            }
            case ICMP_SGT: 
            case ICMP_SLT: 
            case ICMP_SGE: 
            case ICMP_SLE: 
        }
        return true;
    }

    public static boolean isOrdered(Predicate predicate) {
        switch (predicate) {
            default: {
                return false;
            }
            case FCMP_OEQ: 
            case FCMP_ONE: 
            case FCMP_OGT: 
            case FCMP_OLT: 
            case FCMP_OGE: 
            case FCMP_OLE: 
            case FCMP_ORD: 
        }
        return true;
    }

    public static boolean isUnordered(Predicate predicate) {
        switch (predicate) {
            default: {
                return false;
            }
            case FCMP_UEQ: 
            case FCMP_UNE: 
            case FCMP_UGT: 
            case FCMP_ULT: 
            case FCMP_UGE: 
            case FCMP_ULE: 
            case FCMP_UNO: 
        }
        return true;
    }

    public static boolean isTrueWhenEqual(Predicate predicate) {
        switch (predicate) {
            default: {
                return false;
            }
            case ICMP_EQ: 
            case ICMP_UGE: 
            case ICMP_ULE: 
            case ICMP_SGE: 
            case ICMP_SLE: 
            case FCMP_UEQ: 
            case FCMP_UGE: 
            case FCMP_ULE: 
            case FCMP_TRUE: 
        }
        return true;
    }

    public static boolean isFalseWhenEqual(Predicate predicate) {
        switch (predicate) {
            case ICMP_NE: 
            case ICMP_UGT: 
            case ICMP_ULT: 
            case ICMP_SGT: 
            case ICMP_SLT: 
            case FCMP_ONE: 
            case FCMP_OGT: 
            case FCMP_OLT: 
            case FCMP_FALSE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isImpliedTrueByMatchingCmp(Predicate Pred1, Predicate Pred2) {
        if (Pred1 == Pred2) {
            return true;
        }
        switch (Pred1) {
            default: {
                break;
            }
            case ICMP_EQ: {
                return Pred2 == Predicate.ICMP_UGE || Pred2 == Predicate.ICMP_ULE || Pred2 == Predicate.ICMP_SGE || Pred2 == Predicate.ICMP_SLE;
            }
            case ICMP_UGT: {
                return Pred2 == Predicate.ICMP_NE || Pred2 == Predicate.ICMP_UGE;
            }
            case ICMP_ULT: {
                return Pred2 == Predicate.ICMP_NE || Pred2 == Predicate.ICMP_ULE;
            }
            case ICMP_SGT: {
                return Pred2 == Predicate.ICMP_NE || Pred2 == Predicate.ICMP_SGE;
            }
            case ICMP_SLT: {
                return Pred2 == Predicate.ICMP_NE || Pred2 == Predicate.ICMP_SLE;
            }
        }
        return false;
    }

    public static boolean isImpliedFalseByMatchingCmp(Predicate Pred1, Predicate Pred2) {
        return CmpInst.isImpliedTrueByMatchingCmp(Pred1, CmpInst.getInversePredicate(Pred2));
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 51 || I.getOpcode() == 52;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && CmpInst.classof(IrRTTI.cast_Instruction(V));
    }

    public static Type makeCmpResultType(Type opnd_type) {
        VectorType vt = IrRTTI.dyn_cast_VectorType(opnd_type);
        if (vt != null) {
            return VectorType.get(Type.getInt1Ty(opnd_type.getContext()), vt.getNumElements());
        }
        return Type.getInt1Ty(opnd_type.getContext());
    }

    private void setValueSubclassData_CmpInst(char D2) {
        super.setValueSubclassData(D2);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }

    public static final class Predicate
    extends Enum<Predicate>
    implements Native.NativeUShortEnum {
        public static final /* enum */ Predicate FCMP_FALSE = new Predicate(0);
        public static final /* enum */ Predicate FCMP_OEQ = new Predicate(1);
        public static final /* enum */ Predicate FCMP_OGT = new Predicate(2);
        public static final /* enum */ Predicate FCMP_OGE = new Predicate(3);
        public static final /* enum */ Predicate FCMP_OLT = new Predicate(4);
        public static final /* enum */ Predicate FCMP_OLE = new Predicate(5);
        public static final /* enum */ Predicate FCMP_ONE = new Predicate(6);
        public static final /* enum */ Predicate FCMP_ORD = new Predicate(7);
        public static final /* enum */ Predicate FCMP_UNO = new Predicate(8);
        public static final /* enum */ Predicate FCMP_UEQ = new Predicate(9);
        public static final /* enum */ Predicate FCMP_UGT = new Predicate(10);
        public static final /* enum */ Predicate FCMP_UGE = new Predicate(11);
        public static final /* enum */ Predicate FCMP_ULT = new Predicate(12);
        public static final /* enum */ Predicate FCMP_ULE = new Predicate(13);
        public static final /* enum */ Predicate FCMP_UNE = new Predicate(14);
        public static final /* enum */ Predicate FCMP_TRUE = new Predicate(15);
        public static final /* enum */ Predicate FIRST_FCMP_PREDICATE = new Predicate(FCMP_FALSE.getValue());
        public static final /* enum */ Predicate LAST_FCMP_PREDICATE = new Predicate(FCMP_TRUE.getValue());
        public static final /* enum */ Predicate BAD_FCMP_PREDICATE = new Predicate(FCMP_TRUE.getValue() + '\u0001');
        public static final /* enum */ Predicate ICMP_EQ = new Predicate(32);
        public static final /* enum */ Predicate ICMP_NE = new Predicate(33);
        public static final /* enum */ Predicate ICMP_UGT = new Predicate(34);
        public static final /* enum */ Predicate ICMP_UGE = new Predicate(35);
        public static final /* enum */ Predicate ICMP_ULT = new Predicate(36);
        public static final /* enum */ Predicate ICMP_ULE = new Predicate(37);
        public static final /* enum */ Predicate ICMP_SGT = new Predicate(38);
        public static final /* enum */ Predicate ICMP_SGE = new Predicate(39);
        public static final /* enum */ Predicate ICMP_SLT = new Predicate(40);
        public static final /* enum */ Predicate ICMP_SLE = new Predicate(41);
        public static final /* enum */ Predicate FIRST_ICMP_PREDICATE = new Predicate(ICMP_EQ.getValue());
        public static final /* enum */ Predicate LAST_ICMP_PREDICATE = new Predicate(ICMP_SLE.getValue());
        public static final /* enum */ Predicate BAD_ICMP_PREDICATE = new Predicate(ICMP_SLE.getValue() + '\u0001');
        private final char value;
        private static final /* synthetic */ Predicate[] $VALUES;

        public static Predicate[] values() {
            return (Predicate[])$VALUES.clone();
        }

        public static Predicate valueOf(String name) {
            return Enum.valueOf(Predicate.class, name);
        }

        public static Predicate valueOf(int val) {
            Predicate out;
            Predicate predicate = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Predicate(int val) {
            this.value = Unsigned.$uint2ushort((int)val);
        }

        public final char getValue() {
            return this.value;
        }

        static {
            $VALUES = new Predicate[]{FCMP_FALSE, FCMP_OEQ, FCMP_OGT, FCMP_OGE, FCMP_OLT, FCMP_OLE, FCMP_ONE, FCMP_ORD, FCMP_UNO, FCMP_UEQ, FCMP_UGT, FCMP_UGE, FCMP_ULT, FCMP_ULE, FCMP_UNE, FCMP_TRUE, FIRST_FCMP_PREDICATE, LAST_FCMP_PREDICATE, BAD_FCMP_PREDICATE, ICMP_EQ, ICMP_NE, ICMP_UGT, ICMP_UGE, ICMP_ULT, ICMP_ULE, ICMP_SGT, ICMP_SGE, ICMP_SLT, ICMP_SLE, FIRST_ICMP_PREDICATE, LAST_ICMP_PREDICATE, BAD_ICMP_PREDICATE};
        }

        private static final class Values {
            private static final Predicate[] VALUES;
            private static final Predicate[] _VALUES;

            private Values() {
            }

            static {
                char max = '\u0000';
                char min = '\u0000';
                for (Predicate kind : Predicate.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Predicate[min < '\u0000' ? 1 - min : 0];
                VALUES = new Predicate[max >= '\u0000' ? '\u0001' + max : 0];
                for (Predicate kind : Predicate.values()) {
                    if (kind.value < '\u0000') {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((Predicate)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((Predicate)kind).value] = kind;
                }
            }
        }
    }
}

