/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Casts;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.FoldingSetImpl;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.impl.AttributeImpl;
import org.llvm.ir.impl.AttributesStatics;
import org.llvm.ir.impl.EnumAttributeImpl;
import org.llvm.ir.impl.IntAttributeImpl;
import org.llvm.ir.impl.LLVMContextImpl;
import org.llvm.ir.impl.StringAttributeImpl;
import org.llvm.ir.java.IRFunctionPointers;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class Attribute
implements Native.ComparableLower,
Native.NativeComparable<Attribute>,
Native.NativePOD<Attribute>,
NativeMoveable<Attribute> {
    private AttributeImpl pImpl;

    private Attribute(AttributeImpl A2) {
        this.pImpl = A2;
    }

    public Attribute() {
        this.pImpl = null;
    }

    public static Attribute get(LLVMContext Context, AttrKind Kind2) {
        return Attribute.get(Context, Kind2, Unsigned.$int2ulong((int)0));
    }

    public static Attribute get(LLVMContext Context, AttrKind Kind2, long Val) {
        type.ref InsertPoint2;
        AttributeImpl PA;
        LLVMContextImpl pImpl = Context.pImpl;
        FoldingSetNodeID ID2 = new FoldingSetNodeID();
        ID2.AddInteger_int(Kind2.getValue());
        if (Val != 0L) {
            ID2.AddInteger_ullong(Val);
        }
        if ((PA = (AttributeImpl)pImpl.AttrsSet.FindNodeOrInsertPos(ID2, InsertPoint2 = NativePointer.create_type$ref())) == null) {
            PA = Val == 0L ? new EnumAttributeImpl(Kind2) : new IntAttributeImpl(Kind2, Val);
            pImpl.AttrsSet.InsertNode((FoldingSetImpl.Node)PA, (type.ptr)InsertPoint2.$deref());
        }
        return new Attribute(PA);
    }

    public static Attribute get(LLVMContext Context, StringRef Kind2) {
        return Attribute.get(Context, Kind2, new StringRef());
    }

    public static Attribute get(LLVMContext Context, StringRef Kind2, StringRef Val) {
        type.ref InsertPoint2;
        AttributeImpl PA;
        LLVMContextImpl pImpl = Context.pImpl;
        FoldingSetNodeID ID2 = new FoldingSetNodeID();
        ID2.AddString(new StringRef(Kind2));
        if (!Val.empty()) {
            ID2.AddString(new StringRef(Val));
        }
        if ((PA = (AttributeImpl)pImpl.AttrsSet.FindNodeOrInsertPos(ID2, InsertPoint2 = NativePointer.create_type$ref())) == null) {
            PA = new StringAttributeImpl(new StringRef(Kind2), new StringRef(Val));
            pImpl.AttrsSet.InsertNode((FoldingSetImpl.Node)PA, (type.ptr)InsertPoint2.$deref());
        }
        return new Attribute(PA);
    }

    public static Attribute getWithAlignment(LLVMContext Context, long Align) {
        assert (llvm.isPowerOf2_32((int)Unsigned.$ulong2uint((long)Align))) : "Alignment must be a power of two.";
        assert (Unsigned.$lesseq_ulong_ullong((long)Align, (long)Unsigned.$int2ullong((int)0x40000000))) : "Alignment too large.";
        return Attribute.get(Context, AttrKind.Alignment, Align);
    }

    public static Attribute getWithStackAlignment(LLVMContext Context, long Align) {
        assert (llvm.isPowerOf2_32((int)Unsigned.$ulong2uint((long)Align))) : "Alignment must be a power of two.";
        assert (Unsigned.$lesseq_ulong_ullong((long)Align, (long)Unsigned.$int2ullong((int)256))) : "Alignment too large.";
        return Attribute.get(Context, AttrKind.StackAlignment, Align);
    }

    public static Attribute getWithDereferenceableBytes(LLVMContext Context, long Bytes) {
        assert (Bytes != 0L) : "Bytes must be non-zero.";
        return Attribute.get(Context, AttrKind.Dereferenceable, Bytes);
    }

    public static Attribute getWithDereferenceableOrNullBytes(LLVMContext Context, long Bytes) {
        assert (Bytes != 0L) : "Bytes must be non-zero.";
        return Attribute.get(Context, AttrKind.DereferenceableOrNull, Bytes);
    }

    public static Attribute getWithAllocSizeArgs(LLVMContext Context, int ElemSizeArg, ADTAliases.OptionalUInt NumElemsArg) {
        assert (ElemSizeArg != 0 || !NumElemsArg.$bool() || NumElemsArg.$star() != 0) : "Invalid allocsize arguments -- given allocsize(0, 0)";
        return Attribute.get(Context, AttrKind.AllocSize, AttributesStatics.packAllocSizeArgs(ElemSizeArg, NumElemsArg));
    }

    public boolean isEnumAttribute() {
        return this.pImpl != null && this.pImpl.isEnumAttribute();
    }

    public boolean isIntAttribute() {
        return this.pImpl != null && this.pImpl.isIntAttribute();
    }

    public boolean isStringAttribute() {
        return this.pImpl != null && this.pImpl.isStringAttribute();
    }

    public boolean hasAttribute(AttrKind Kind2) {
        return this.pImpl != null && this.pImpl.hasAttribute(Kind2) || this.pImpl == null && Kind2 == AttrKind.None;
    }

    public boolean hasAttribute(StringRef Kind2) {
        if (!this.isStringAttribute()) {
            return false;
        }
        return this.pImpl != null && this.pImpl.hasAttribute(new StringRef(Kind2));
    }

    public AttrKind getKindAsEnum() {
        if (this.pImpl == null) {
            return AttrKind.None;
        }
        assert (this.isEnumAttribute() || this.isIntAttribute()) : "Invalid attribute type to get the kind as an enum!";
        return this.pImpl.getKindAsEnum();
    }

    public long getValueAsInt() {
        if (this.pImpl == null) {
            return Unsigned.$int2ulong((int)0);
        }
        assert (this.isIntAttribute()) : "Expected the attribute to be an integer attribute!";
        return this.pImpl.getValueAsInt();
    }

    public StringRef getKindAsString() {
        if (this.pImpl == null) {
            return new StringRef();
        }
        assert (this.isStringAttribute()) : "Invalid attribute type to get the kind as a string!";
        return this.pImpl.getKindAsString();
    }

    public StringRef getValueAsString() {
        if (this.pImpl == null) {
            return new StringRef();
        }
        assert (this.isStringAttribute()) : "Invalid attribute type to get the value as a string!";
        return this.pImpl.getValueAsString();
    }

    public int getAlignment() {
        assert (this.hasAttribute(AttrKind.Alignment)) : "Trying to get alignment from non-alignment attribute!";
        return Unsigned.$ulong2uint((long)this.pImpl.getValueAsInt());
    }

    public int getStackAlignment() {
        assert (this.hasAttribute(AttrKind.StackAlignment)) : "Trying to get alignment from non-alignment attribute!";
        return Unsigned.$ulong2uint((long)this.pImpl.getValueAsInt());
    }

    public long getDereferenceableBytes() {
        assert (this.hasAttribute(AttrKind.Dereferenceable)) : "Trying to get dereferenceable bytes from non-dereferenceable attribute!";
        return this.pImpl.getValueAsInt();
    }

    public long getDereferenceableOrNullBytes() {
        assert (this.hasAttribute(AttrKind.DereferenceableOrNull)) : "Trying to get dereferenceable bytes from non-dereferenceable attribute!";
        return this.pImpl.getValueAsInt();
    }

    public std_pair.pairUIntType<ADTAliases.OptionalUInt> getAllocSizeArgs() {
        assert (this.hasAttribute(AttrKind.AllocSize)) : "Trying to get allocsize args from non-allocsize attribute";
        return AttributesStatics.unpackAllocSizeArgs(this.pImpl.getValueAsInt());
    }

    public std.string getAsString() {
        return this.getAsString(false);
    }

    public std.string getAsString(boolean InAttrGrp) {
        if (this.pImpl == null) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, NativePointer.$EMPTY);
        }
        if (this.hasAttribute(AttrKind.SanitizeAddress)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"sanitize_address");
        }
        if (this.hasAttribute(AttrKind.AlwaysInline)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"alwaysinline");
        }
        if (this.hasAttribute(AttrKind.ArgMemOnly)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"argmemonly");
        }
        if (this.hasAttribute(AttrKind.Builtin)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"builtin");
        }
        if (this.hasAttribute(AttrKind.ByVal)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"byval");
        }
        if (this.hasAttribute(AttrKind.Convergent)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"convergent");
        }
        if (this.hasAttribute(AttrKind.SwiftError)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"swifterror");
        }
        if (this.hasAttribute(AttrKind.SwiftSelf)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"swiftself");
        }
        if (this.hasAttribute(AttrKind.InaccessibleMemOnly)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"inaccessiblememonly");
        }
        if (this.hasAttribute(AttrKind.InaccessibleMemOrArgMemOnly)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"inaccessiblemem_or_argmemonly");
        }
        if (this.hasAttribute(AttrKind.InAlloca)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"inalloca");
        }
        if (this.hasAttribute(AttrKind.InlineHint)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"inlinehint");
        }
        if (this.hasAttribute(AttrKind.InReg)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"inreg");
        }
        if (this.hasAttribute(AttrKind.JumpTable)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"jumptable");
        }
        if (this.hasAttribute(AttrKind.MinSize)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"minsize");
        }
        if (this.hasAttribute(AttrKind.Naked)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"naked");
        }
        if (this.hasAttribute(AttrKind.Nest)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"nest");
        }
        if (this.hasAttribute(AttrKind.NoAlias)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"noalias");
        }
        if (this.hasAttribute(AttrKind.NoBuiltin)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"nobuiltin");
        }
        if (this.hasAttribute(AttrKind.NoCapture)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"nocapture");
        }
        if (this.hasAttribute(AttrKind.NoDuplicate)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"noduplicate");
        }
        if (this.hasAttribute(AttrKind.NoImplicitFloat)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"noimplicitfloat");
        }
        if (this.hasAttribute(AttrKind.NoInline)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"noinline");
        }
        if (this.hasAttribute(AttrKind.NonLazyBind)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"nonlazybind");
        }
        if (this.hasAttribute(AttrKind.NonNull)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, NativePointer.$nonnull);
        }
        if (this.hasAttribute(AttrKind.NoRedZone)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"noredzone");
        }
        if (this.hasAttribute(AttrKind.NoReturn)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"noreturn");
        }
        if (this.hasAttribute(AttrKind.NoRecurse)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"norecurse");
        }
        if (this.hasAttribute(AttrKind.NoUnwind)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"nounwind");
        }
        if (this.hasAttribute(AttrKind.OptimizeNone)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"optnone");
        }
        if (this.hasAttribute(AttrKind.OptimizeForSize)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"optsize");
        }
        if (this.hasAttribute(AttrKind.ReadNone)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"readnone");
        }
        if (this.hasAttribute(AttrKind.ReadOnly)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"readonly");
        }
        if (this.hasAttribute(AttrKind.WriteOnly)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"writeonly");
        }
        if (this.hasAttribute(AttrKind.Returned)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"returned");
        }
        if (this.hasAttribute(AttrKind.ReturnsTwice)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"returns_twice");
        }
        if (this.hasAttribute(AttrKind.SExt)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"signext");
        }
        if (this.hasAttribute(AttrKind.StackProtect)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"ssp");
        }
        if (this.hasAttribute(AttrKind.StackProtectReq)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"sspreq");
        }
        if (this.hasAttribute(AttrKind.StackProtectStrong)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"sspstrong");
        }
        if (this.hasAttribute(AttrKind.SafeStack)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"safestack");
        }
        if (this.hasAttribute(AttrKind.StructRet)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"sret");
        }
        if (this.hasAttribute(AttrKind.SanitizeThread)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"sanitize_thread");
        }
        if (this.hasAttribute(AttrKind.SanitizeMemory)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"sanitize_memory");
        }
        if (this.hasAttribute(AttrKind.UWTable)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"uwtable");
        }
        if (this.hasAttribute(AttrKind.ZExt)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"zeroext");
        }
        if (this.hasAttribute(AttrKind.Cold)) {
            return new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"cold");
        }
        if (this.hasAttribute(AttrKind.Alignment)) {
            std.string Result2 = new std.string();
            Result2.$addassign_T$C$P((CharSequence)"align");
            Result2.$addassign_T$C$P(InAttrGrp ? NativePointer.$EQ : NativePointer.$SPACE);
            Result2.$addassign(llvm.utostr((long)this.getValueAsInt()));
            return Result2;
        }
        IRFunctionPointers.ConstChar2StdString AttrWithBytesToString = Name -> {
            std.string Result2 = new std.string();
            Result2.$addassign_T$C$P(Name);
            if (InAttrGrp) {
                Result2.$addassign_T$C$P((CharSequence)"=");
                Result2.$addassign(llvm.utostr((long)this.getValueAsInt()));
            } else {
                Result2.$addassign_T$C$P((CharSequence)"(");
                Result2.$addassign(llvm.utostr((long)this.getValueAsInt()));
                Result2.$addassign_T$C$P((CharSequence)")");
            }
            return Result2;
        };
        if (this.hasAttribute(AttrKind.StackAlignment)) {
            return AttrWithBytesToString.$call(NativePointer.$((String)"alignstack"));
        }
        if (this.hasAttribute(AttrKind.Dereferenceable)) {
            return AttrWithBytesToString.$call(NativePointer.$((String)"dereferenceable"));
        }
        if (this.hasAttribute(AttrKind.DereferenceableOrNull)) {
            return AttrWithBytesToString.$call(NativePointer.$((String)"dereferenceable_or_null"));
        }
        if (this.hasAttribute(AttrKind.AllocSize)) {
            std_pair.pairUIntType<ADTAliases.OptionalUInt> tmp = this.getAllocSizeArgs();
            int ElemSize = tmp.first;
            ADTAliases.OptionalUInt NumElems = (ADTAliases.OptionalUInt)tmp.second;
            std.string Result3 = new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"allocsize(");
            Result3.$addassign(llvm.utostr((long)Unsigned.$uint2ulong((int)ElemSize)));
            if (NumElems.hasValue()) {
                Result3.$addassign_T((byte)44);
                Result3.$addassign(llvm.utostr((long)Unsigned.$uint2ulong((int)NumElems.$star())));
            }
            Result3.$addassign_T((byte)41);
            return Result3;
        }
        if (this.isStringAttribute()) {
            std.string Result4 = new std.string();
            Result4.$addassign(llvm.$add_Twine$C((Twine)llvm.$add_Twine$C((Twine)new Twine(JavaDifferentiators.JD$Char.INSTANCE, 34), (Twine)new Twine(this.getKindAsString())), (Twine)new Twine(JavaDifferentiators.JD$Char.INSTANCE, 34)).str());
            StringRef Val = this.pImpl.getValueAsString();
            if (Val.empty()) {
                return Result4;
            }
            Result4.$addassign(llvm.$add_Twine$C((Twine)llvm.$add_char$ptr$C_StringRef$C((String)"=\"", (StringRef)Val), (Twine)new Twine(JavaDifferentiators.JD$Char.INSTANCE, 34)).str());
            return Result4;
        }
        throw new llvm_unreachable("Unknown attribute");
    }

    public boolean $eq(Attribute A2) {
        return this.pImpl == A2.pImpl;
    }

    public boolean $noteq(Attribute A2) {
        return this.pImpl != A2.pImpl;
    }

    public boolean $less(Attribute A2) {
        if (this.pImpl == null && A2.pImpl == null) {
            return false;
        }
        if (this.pImpl == null) {
            return true;
        }
        if (A2.pImpl == null) {
            return false;
        }
        return this.pImpl.$less(A2.pImpl);
    }

    public void Profile(FoldingSetNodeID ID2) {
        ID2.AddPointer((Object)this.pImpl);
    }

    public Object getRawPointer() {
        return this.pImpl;
    }

    public static Attribute fromRawPointer(Object RawPtr) {
        return new Attribute((AttributeImpl)((Object)Casts.reinterpret_cast(AttributeImpl.class, (Object)RawPtr)));
    }

    public Attribute(Attribute $Prm0) {
        this.pImpl = $Prm0.pImpl;
    }

    public Attribute(JavaDifferentiators.JD.Move _dparam, Attribute $Prm0) {
        this.pImpl = $Prm0.pImpl;
    }

    public Attribute $assign(Attribute $Prm0) {
        this.pImpl = $Prm0.pImpl;
        return this;
    }

    public Attribute $assignMove(Attribute $Prm0) {
        this.pImpl = $Prm0.pImpl;
        return this;
    }

    public boolean $less(Object obj) {
        return this.$less((Attribute)obj);
    }

    public Attribute clone() {
        return new Attribute(this);
    }

    public Attribute move() {
        return new Attribute(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public String toString() {
        return "pImpl=" + (Object)((Object)this.pImpl);
    }

    public static final class AttrKind
    extends Enum<AttrKind>
    implements Native.NativeUIntEnum {
        public static final /* enum */ AttrKind None = new AttrKind(0);
        public static final /* enum */ AttrKind Alignment = new AttrKind(None.getValue() + 1);
        public static final /* enum */ AttrKind AllocSize = new AttrKind(Alignment.getValue() + 1);
        public static final /* enum */ AttrKind AlwaysInline = new AttrKind(AllocSize.getValue() + 1);
        public static final /* enum */ AttrKind ArgMemOnly = new AttrKind(AlwaysInline.getValue() + 1);
        public static final /* enum */ AttrKind Builtin = new AttrKind(ArgMemOnly.getValue() + 1);
        public static final /* enum */ AttrKind ByVal = new AttrKind(Builtin.getValue() + 1);
        public static final /* enum */ AttrKind Cold = new AttrKind(ByVal.getValue() + 1);
        public static final /* enum */ AttrKind Convergent = new AttrKind(Cold.getValue() + 1);
        public static final /* enum */ AttrKind Dereferenceable = new AttrKind(Convergent.getValue() + 1);
        public static final /* enum */ AttrKind DereferenceableOrNull = new AttrKind(Dereferenceable.getValue() + 1);
        public static final /* enum */ AttrKind InAlloca = new AttrKind(DereferenceableOrNull.getValue() + 1);
        public static final /* enum */ AttrKind InReg = new AttrKind(InAlloca.getValue() + 1);
        public static final /* enum */ AttrKind InaccessibleMemOnly = new AttrKind(InReg.getValue() + 1);
        public static final /* enum */ AttrKind InaccessibleMemOrArgMemOnly = new AttrKind(InaccessibleMemOnly.getValue() + 1);
        public static final /* enum */ AttrKind InlineHint = new AttrKind(InaccessibleMemOrArgMemOnly.getValue() + 1);
        public static final /* enum */ AttrKind JumpTable = new AttrKind(InlineHint.getValue() + 1);
        public static final /* enum */ AttrKind MinSize = new AttrKind(JumpTable.getValue() + 1);
        public static final /* enum */ AttrKind Naked = new AttrKind(MinSize.getValue() + 1);
        public static final /* enum */ AttrKind Nest = new AttrKind(Naked.getValue() + 1);
        public static final /* enum */ AttrKind NoAlias = new AttrKind(Nest.getValue() + 1);
        public static final /* enum */ AttrKind NoBuiltin = new AttrKind(NoAlias.getValue() + 1);
        public static final /* enum */ AttrKind NoCapture = new AttrKind(NoBuiltin.getValue() + 1);
        public static final /* enum */ AttrKind NoDuplicate = new AttrKind(NoCapture.getValue() + 1);
        public static final /* enum */ AttrKind NoImplicitFloat = new AttrKind(NoDuplicate.getValue() + 1);
        public static final /* enum */ AttrKind NoInline = new AttrKind(NoImplicitFloat.getValue() + 1);
        public static final /* enum */ AttrKind NoRecurse = new AttrKind(NoInline.getValue() + 1);
        public static final /* enum */ AttrKind NoRedZone = new AttrKind(NoRecurse.getValue() + 1);
        public static final /* enum */ AttrKind NoReturn = new AttrKind(NoRedZone.getValue() + 1);
        public static final /* enum */ AttrKind NoUnwind = new AttrKind(NoReturn.getValue() + 1);
        public static final /* enum */ AttrKind NonLazyBind = new AttrKind(NoUnwind.getValue() + 1);
        public static final /* enum */ AttrKind NonNull = new AttrKind(NonLazyBind.getValue() + 1);
        public static final /* enum */ AttrKind OptimizeForSize = new AttrKind(NonNull.getValue() + 1);
        public static final /* enum */ AttrKind OptimizeNone = new AttrKind(OptimizeForSize.getValue() + 1);
        public static final /* enum */ AttrKind ReadNone = new AttrKind(OptimizeNone.getValue() + 1);
        public static final /* enum */ AttrKind ReadOnly = new AttrKind(ReadNone.getValue() + 1);
        public static final /* enum */ AttrKind Returned = new AttrKind(ReadOnly.getValue() + 1);
        public static final /* enum */ AttrKind ReturnsTwice = new AttrKind(Returned.getValue() + 1);
        public static final /* enum */ AttrKind SExt = new AttrKind(ReturnsTwice.getValue() + 1);
        public static final /* enum */ AttrKind SafeStack = new AttrKind(SExt.getValue() + 1);
        public static final /* enum */ AttrKind SanitizeAddress = new AttrKind(SafeStack.getValue() + 1);
        public static final /* enum */ AttrKind SanitizeMemory = new AttrKind(SanitizeAddress.getValue() + 1);
        public static final /* enum */ AttrKind SanitizeThread = new AttrKind(SanitizeMemory.getValue() + 1);
        public static final /* enum */ AttrKind StackAlignment = new AttrKind(SanitizeThread.getValue() + 1);
        public static final /* enum */ AttrKind StackProtect = new AttrKind(StackAlignment.getValue() + 1);
        public static final /* enum */ AttrKind StackProtectReq = new AttrKind(StackProtect.getValue() + 1);
        public static final /* enum */ AttrKind StackProtectStrong = new AttrKind(StackProtectReq.getValue() + 1);
        public static final /* enum */ AttrKind StructRet = new AttrKind(StackProtectStrong.getValue() + 1);
        public static final /* enum */ AttrKind SwiftError = new AttrKind(StructRet.getValue() + 1);
        public static final /* enum */ AttrKind SwiftSelf = new AttrKind(SwiftError.getValue() + 1);
        public static final /* enum */ AttrKind UWTable = new AttrKind(SwiftSelf.getValue() + 1);
        public static final /* enum */ AttrKind WriteOnly = new AttrKind(UWTable.getValue() + 1);
        public static final /* enum */ AttrKind ZExt = new AttrKind(WriteOnly.getValue() + 1);
        public static final /* enum */ AttrKind EndAttrKinds = new AttrKind(ZExt.getValue() + 1);
        private final int value;
        private static final /* synthetic */ AttrKind[] $VALUES;

        public static AttrKind[] values() {
            return (AttrKind[])$VALUES.clone();
        }

        public static AttrKind valueOf(String name) {
            return Enum.valueOf(AttrKind.class, name);
        }

        public static AttrKind valueOf(int val) {
            AttrKind out;
            AttrKind attrKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private AttrKind(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new AttrKind[]{None, Alignment, AllocSize, AlwaysInline, ArgMemOnly, Builtin, ByVal, Cold, Convergent, Dereferenceable, DereferenceableOrNull, InAlloca, InReg, InaccessibleMemOnly, InaccessibleMemOrArgMemOnly, InlineHint, JumpTable, MinSize, Naked, Nest, NoAlias, NoBuiltin, NoCapture, NoDuplicate, NoImplicitFloat, NoInline, NoRecurse, NoRedZone, NoReturn, NoUnwind, NonLazyBind, NonNull, OptimizeForSize, OptimizeNone, ReadNone, ReadOnly, Returned, ReturnsTwice, SExt, SafeStack, SanitizeAddress, SanitizeMemory, SanitizeThread, StackAlignment, StackProtect, StackProtectReq, StackProtectStrong, StructRet, SwiftError, SwiftSelf, UWTable, WriteOnly, ZExt, EndAttrKinds};
        }

        private static final class Values {
            private static final AttrKind[] VALUES;
            private static final AttrKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (AttrKind kind : AttrKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new AttrKind[min < 0 ? 1 - min : 0];
                VALUES = new AttrKind[max >= 0 ? 1 + max : 0];
                for (AttrKind kind : AttrKind.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((AttrKind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((AttrKind)kind).value] = kind;
                }
            }
        }
    }
}

