/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.psi.css.impl.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.css.impl.CssElementTypes;
import fleet.com.intellij.psi.css.impl.parsing.CssParser2;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NotNull;

public final class CssBlockSkipper {
    private CssBlockSkipper() {
    }

    public static boolean skipDeclarationBlockAndCollapse(@NotNull CssParser2 parser, @NotNull ILazyParseableElementType blockElementType) {
        if (parser.getTokenType() != CssElementTypes.CSS_LBRACE) {
            return false;
        }
        boolean isInMixin = false;
        int blockLevel = 0;
        PsiBuilder.Marker declarationBlock = parser.createCompositeElement();
        PsiBuilder.Marker lastLBraceOrSemicolon = parser.createCompositeElement();
        while (!parser.isDone()) {
            IElementType currentToken = parser.getTokenType();
            if (CssBlockSkipper.shouldSkipAtRule(blockElementType, currentToken)) {
                parser.advanceUntil(CssElementTypes.CSS_LBRACE);
                CssBlockSkipper.skipDeclarationBlockAndCollapse(parser, CssElementTypes.CSS_DECLARATION_BLOCK);
                continue;
            }
            if (currentToken == CssElementTypes.CSS_EXPRESSION) {
                parser.parseExpression();
                continue;
            }
            if (currentToken == CssElementTypes.CSS_LBRACE) {
                if (blockLevel == 0 || parser.supportsNestedBlocks() || isInMixin) {
                    lastLBraceOrSemicolon.drop();
                    parser.addSingleToken();
                    lastLBraceOrSemicolon = parser.createCompositeElement();
                    ++blockLevel;
                    continue;
                }
                lastLBraceOrSemicolon.rollbackTo();
                lastLBraceOrSemicolon = null;
                break;
            }
            if (currentToken == CssElementTypes.CSS_RBRACE) {
                parser.addSingleToken();
                if (--blockLevel == 0) break;
                isInMixin = false;
                continue;
            }
            if (currentToken == CssElementTypes.CSS_SEMICOLON) {
                lastLBraceOrSemicolon.drop();
                parser.addSingleToken();
                lastLBraceOrSemicolon = parser.createCompositeElement();
                continue;
            }
            if (blockLevel > 0 && currentToken == CssElementTypes.CSS_IDENT && StringUtil.notNullize((String)parser.getTokenText()).startsWith("--")) {
                isInMixin = parser.lookAhead(1) == CssElementTypes.CSS_COLON && parser.lookAhead(2) == CssElementTypes.CSS_LBRACE;
            }
            parser.addSingleToken();
        }
        if (lastLBraceOrSemicolon != null) {
            lastLBraceOrSemicolon.drop();
        }
        declarationBlock.collapse((IElementType)blockElementType);
        declarationBlock.setCustomEdgeTokenBinders(parser.getCommentsBeforeBinder(), null);
        return true;
    }

    private static boolean shouldSkipAtRule(ILazyParseableElementType blockElementType, IElementType currentToken) {
        return blockElementType == CssElementTypes.CSS_PAGE_BLOCK && CssBlockSkipper.pageOrAtRule(currentToken);
    }

    private static boolean pageOrAtRule(IElementType currentToken) {
        return currentToken == CssElementTypes.CSS_PAGE_MARGIN_SYM || currentToken == CssElementTypes.CSS_ATKEYWORD;
    }
}

