/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.bootstrap;

import fleet.dock.bootstrap.Dock;
import fleet.dock.bootstrap.DockKind;
import fleet.dock.bootstrap.DockModuleLayersStorage;
import fleet.dock.bootstrap.DockStartupStatistics;
import fleet.dock.bootstrap.FleetBootstrapProperties;
import fleet.dock.bootstrap.FleetDistributionLayout;
import fleet.dock.bootstrap.UserHome;
import fleet.util.modules.FleetModuleFinderLogger;
import fleet.util.modules.JavaModules;
import fleet.util.modules.ModuleInfo;
import fleet.util.modules.ModuleLayers;
import fleet.util.os.Os;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class FleetBootstrap {
    public static void main(String ... args) {
        long bootstrapStartTimeMs = System.currentTimeMillis();
        StdoutModuleFinderLogger moduleFinderLogger = new StdoutModuleFinderLogger();
        FleetBootstrap.loadSystemProperties();
        FleetDistributionLayout distributionLayout = FleetDistributionLayout.create();
        Path bootstrapDirectory = distributionLayout.bootstrapDirectory();
        List<ModuleInfo> dockApiModulePath = FleetBootstrap.readModulePathFromFile(bootstrapDirectory.resolve("fleet.dock.api.module.path.txt"), distributionLayout.bundledCodeCacheDirectory());
        List<ModuleInfo> dockImplModulePath = FleetBootstrap.readModulePathFromFile(bootstrapDirectory.resolve("fleet.dock.impl.module.path.txt"), distributionLayout.bundledCodeCacheDirectory());
        FleetBootstrap.configureJna(distributionLayout);
        FleetBootstrap.configureJni(distributionLayout);
        DockKind dockKind = FleetBootstrap.getDockKind(args);
        try {
            if ("Server".equals(dockKind.type())) {
                ModuleLayer apiModuleLayer = ModuleLayers.moduleLayer(Collections.emptyList(), dockApiModulePath, (FleetModuleFinderLogger)moduleFinderLogger);
                ModuleLayer implModuleLayer = ModuleLayers.moduleLayer(Collections.singletonList(apiModuleLayer), dockImplModulePath, (FleetModuleFinderLogger)moduleFinderLogger);
                JavaModules.openAndExportModules((ModuleLayer)implModuleLayer, Files.readAllLines(bootstrapDirectory.resolve("exports.txt"), StandardCharsets.UTF_8));
                DockModuleLayersStorage dockModuleLayersStorage = new DockModuleLayersStorage(apiModuleLayer, moduleFinderLogger);
                FleetBootstrap.runDock(apiModuleLayer, implModuleLayer, dockKind, bootstrapStartTimeMs, distributionLayout, dockModuleLayersStorage, args);
            } else if ("Desktop".equals(dockKind.type())) {
                ModuleLayer apiModuleLayer = FleetBootstrap.buildDesktopApiModuleLayer(bootstrapDirectory, distributionLayout, dockApiModulePath, moduleFinderLogger);
                ModuleLayer desktopModuleLayer = FleetBootstrap.buildDesktopModuleLayer(bootstrapDirectory, distributionLayout, dockImplModulePath, apiModuleLayer, moduleFinderLogger);
                JavaModules.openAndExportModules((ModuleLayer)desktopModuleLayer, Files.readAllLines(bootstrapDirectory.resolve("desktopExports.txt"), StandardCharsets.UTF_8));
                DockModuleLayersStorage dockModuleLayersStorage = new DockModuleLayersStorage(apiModuleLayer, moduleFinderLogger);
                FleetBootstrap.runDock(apiModuleLayer, desktopModuleLayer, dockKind, bootstrapStartTimeMs, distributionLayout, dockModuleLayersStorage, args);
            } else {
                System.err.println("Unsupported dock kind: " + dockKind);
            }
        }
        catch (Throwable t) {
            new Throwable("Failed to run Fleet Dock", t).printStackTrace();
            System.exit(1);
        }
    }

    private static ModuleLayer buildDesktopModuleLayer(Path bootstrapDirectory, FleetDistributionLayout distributionLayout, List<ModuleInfo> dockImplModulePath, ModuleLayer apiModuleLayer, FleetModuleFinderLogger moduleFinderLogger) {
        List<ModuleInfo> dockDesktopModulePath = FleetBootstrap.readModulePathFromFile(bootstrapDirectory.resolve("fleet.dock.desktop.module.path.txt"), distributionLayout.bundledCodeCacheDirectory());
        ArrayList<ModuleInfo> desktopLayerModulePath = new ArrayList<ModuleInfo>(dockDesktopModulePath);
        desktopLayerModulePath.addAll(dockImplModulePath);
        ModuleLayer desktopModuleLayer = ModuleLayers.moduleLayer(Collections.singletonList(apiModuleLayer), desktopLayerModulePath, (FleetModuleFinderLogger)moduleFinderLogger);
        return desktopModuleLayer;
    }

    private static ModuleLayer buildDesktopApiModuleLayer(Path bootstrapDirectory, FleetDistributionLayout distributionLayout, List<ModuleInfo> dockApiModulePath, FleetModuleFinderLogger moduleFinderLogger) {
        List<ModuleInfo> windowManagementApiModulePath = FleetBootstrap.readModulePathFromFile(bootstrapDirectory.resolve("fleet.noria.windowManagement.api.module.path.txt"), distributionLayout.bundledCodeCacheDirectory());
        ArrayList<ModuleInfo> apiLayerModulePath = new ArrayList<ModuleInfo>(dockApiModulePath);
        apiLayerModulePath.addAll(windowManagementApiModulePath);
        return ModuleLayers.moduleLayer(Collections.emptyList(), apiLayerModulePath, (FleetModuleFinderLogger)moduleFinderLogger);
    }

    @NotNull
    private static DockKind getDockKind(String[] args) {
        for (String arg : args) {
            if (!"--workspaceOnly".equals(arg)) continue;
            return new DockKind("Server");
        }
        return new DockKind("Desktop");
    }

    private static void configureJna(FleetDistributionLayout distributionLayout) {
        Path jnaLibraryFile = distributionLayout.jnaLibraryFile();
        if (jnaLibraryFile != null) {
            System.setProperty("jna.nosys", "true");
            System.setProperty("jna.noclasspath", "true");
            System.setProperty("jna.nounpack", "true");
            System.setProperty("jna.boot.library.path", jnaLibraryFile.getParent().toString());
        }
    }

    private static void configureJni(FleetDistributionLayout distributionLayout) {
        System.setProperty("jni.library.path", distributionLayout.librariesDirectory().toString());
    }

    @NotNull
    private static Dock findDock(DockKind dockKind, ModuleLayer implModuleLayer) {
        ServiceLoader<Dock> docks = ServiceLoader.load(implModuleLayer, Dock.class);
        for (Dock dock : docks) {
            if (!dockKind.equals(dock.getDockKind())) continue;
            Dock dock2 = dock;
            if (dock2 == null) {
                FleetBootstrap.$$$reportNull$$$0(0);
            }
            return dock2;
        }
        throw new RuntimeException("Dock with kind: " + dockKind + " not found among `" + docks);
    }

    private static void runDock(ModuleLayer apiModuleLayer, ModuleLayer implModuleLayer, DockKind dockKind, Long bootstrapStartTimeMs, FleetDistributionLayout distributionLayout, DockModuleLayersStorage dockModuleLayersStorage, String[] args) {
        Dock dock = FleetBootstrap.findDock(dockKind, implModuleLayer);
        long jvmStartTimeMs = ManagementFactory.getRuntimeMXBean().getStartTime();
        long bootstrapEndTimeMs = System.currentTimeMillis();
        String dockVersion = System.getProperty("fleet.dock.version", "SNAPSHOT");
        dock.main(apiModuleLayer, dockVersion, distributionLayout, new DockStartupStatistics(jvmStartTimeMs, bootstrapStartTimeMs, bootstrapEndTimeMs), dockModuleLayersStorage, args);
    }

    private static List<ModuleInfo> readModulePathFromFile(Path file, Path bundledCodeCacheDirectory) {
        try {
            List<String> lines = Files.readAllLines(file, StandardCharsets.UTF_8);
            int size = lines.size();
            int resultCapacity = size / 2 + size % 2 == 0 ? 0 : 1;
            ArrayList<ModuleInfo> result = new ArrayList<ModuleInfo>(resultCapacity);
            for (int i = 0; i < size; i += 2) {
                if (i >= size - 1) continue;
                Path moduleFile = Path.of(lines.get(i), new String[0]);
                moduleFile = moduleFile.isAbsolute() ? moduleFile : bundledCodeCacheDirectory.resolve(moduleFile);
                String moduleDescriptor = lines.get(i + 1);
                if ("null".equals(moduleDescriptor)) {
                    result.add((ModuleInfo)new ModuleInfo.Path(moduleFile.toString()));
                    continue;
                }
                result.add((ModuleInfo)new ModuleInfo.WithDescriptor(ModuleLayers.deserializeModuleDescriptor((String)moduleDescriptor), moduleFile.toString()));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadSystemProperties() {
        final Properties properties = System.getProperties();
        if (Os.INSTANCE.isMac()) {
            properties.setProperty("skiko.renderApi", "METAL");
            properties.setProperty("apple.awt.captureNextAppWinKey", "false");
        }
        Path userHome = UserHome.getUserHome();
        ArrayList<Path> files = new ArrayList<Path>();
        files.add(userHome.resolve("fleet.properties"));
        files.add(FleetBootstrap.defaultConfigDirectoryPath(userHome).resolve("fleet.properties"));
        String fromProperty = FleetBootstrapProperties.fleetProperty("fleet.properties.file");
        if (fromProperty != null) {
            files.add(Path.of(fromProperty, new String[0]).normalize());
        }
        Properties loader = new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                if (key instanceof String && value instanceof String) {
                    properties.setProperty((String)key, (String)value);
                }
                return null;
            }
        };
        for (Path file : files) {
            try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), StandardCharsets.UTF_8));){
                loader.load(reader2);
            }
            catch (AccessDeniedException | NoSuchFileException reader2) {
            }
            catch (Throwable t) {
                System.out.println("Couldn't read `${file.pathString}`");
                t.printStackTrace();
            }
        }
    }

    public static Path defaultConfigDirectoryPath(@NotNull Path userHome) {
        if (userHome == null) {
            FleetBootstrap.$$$reportNull$$$0(1);
        }
        return FleetBootstrap.platformPath(userHome, "Application Support", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
    }

    public static Path platformPath(@NotNull Path userHome, @NotNull String macDir, @NotNull String winVar, @NotNull String winSub, @NotNull String xdgVar, @NotNull String xdgDfl, @NotNull String xdgSub) {
        if (userHome == null) {
            FleetBootstrap.$$$reportNull$$$0(2);
        }
        if (macDir == null) {
            FleetBootstrap.$$$reportNull$$$0(3);
        }
        if (winVar == null) {
            FleetBootstrap.$$$reportNull$$$0(4);
        }
        if (winSub == null) {
            FleetBootstrap.$$$reportNull$$$0(5);
        }
        if (xdgVar == null) {
            FleetBootstrap.$$$reportNull$$$0(6);
        }
        if (xdgDfl == null) {
            FleetBootstrap.$$$reportNull$$$0(7);
        }
        if (xdgSub == null) {
            FleetBootstrap.$$$reportNull$$$0(8);
        }
        Path path = switch (Os.INSTANCE.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case Os.Type.MacOS -> FleetBootstrap.macPlatformPath(userHome, macDir);
            case Os.Type.Windows -> FleetBootstrap.windowsPlatformPath(userHome, winVar, winSub);
            case Os.Type.Linux -> FleetBootstrap.linuxPlatformPath(userHome, xdgVar, xdgDfl, xdgSub);
            case Os.Type.Unknown -> throw new RuntimeException("Unknown OS");
        };
        return path.toAbsolutePath().normalize();
    }

    private static Path macPlatformPath(Path userHome, String macDir) {
        return userHome.resolve("Library").resolve(macDir).resolve("JetBrains").resolve("Fleet");
    }

    private static Path windowsPlatformPath(Path userHome, String winVar, String winSub) {
        Path appData;
        String appDataFromEnv = System.getenv(winVar);
        if (appDataFromEnv != null && !appDataFromEnv.trim().isEmpty()) {
            appData = Path.of(appDataFromEnv, new String[0]);
        } else {
            String appDataSubDir = winVar.startsWith("LOCAL") ? "Local" : "Roaming";
            appData = userHome.resolve("AppData").resolve(appDataSubDir);
        }
        return appData.resolve("JetBrains").resolve("Fleet").resolve(winSub);
    }

    private static Path linuxPlatformPath(Path userHome, String xdgVar, String xdgDfl, String xdgSub) {
        String appDataFromEnv = System.getenv(xdgVar);
        Path appData = appDataFromEnv != null && !appDataFromEnv.trim().isEmpty() ? Path.of(appDataFromEnv, new String[0]) : userHome.resolve(xdgDfl);
        return appData.resolve("JetBrains/Fleet").resolve(xdgSub);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fleet/dock/bootstrap/FleetBootstrap";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userHome";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "winVar";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "winSub";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xdgVar";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xdgDfl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xdgSub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findDock";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fleet/dock/bootstrap/FleetBootstrap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "defaultConfigDirectoryPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "platformPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    private static class StdoutModuleFinderLogger
    implements FleetModuleFinderLogger {
        private StdoutModuleFinderLogger() {
        }

        public void warn(@NotNull Supplier<String> message) {
            if (message == null) {
                StdoutModuleFinderLogger.$$$reportNull$$$0(0);
            }
            System.out.println(message.get());
        }

        public void error(Throwable t, @NotNull Supplier<String> message) {
            if (message == null) {
                StdoutModuleFinderLogger.$$$reportNull$$$0(1);
            }
            new Throwable(message.get(), t).printStackTrace();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "message";
            objectArray2[1] = "fleet/dock/bootstrap/FleetBootstrap$StdoutModuleFinderLogger";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warn";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

