/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeDeclaration {
    @NotNull
    private static final TokenSet TYPE_DECLARATION_DELIMITERS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opBIT_OR, PhpTokenTypes.opBIT_AND});
    @NotNull
    private static final TokenSet PIPE_DELIMITER = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opBIT_OR});

    public static IElementType parseType(PhpPsiBuilder builder, @NotNull IElementType typeDeclarationToken) {
        PsiBuilder.Marker typeDeclaration = builder.mark();
        boolean isNullableType = builder.compare(PhpTokenTypes.opQUEST);
        int numberOfClassReferences = TypeDeclaration.parseClassReferences(builder);
        if (numberOfClassReferences == 0) {
            if (isNullableType) {
                typeDeclaration.done(typeDeclarationToken);
                builder.error(PhpParserErrors.expected(PhpBundle.message("type", new Object[0])));
                return PhpTokenTypes.opQUEST;
            }
            typeDeclaration.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
        if (numberOfClassReferences > 0 && (builder.compareAndEat(PhpTokenTypes.opBIT_OR) || TypeDeclaration.tryEatBitAndNotFollowedByVarOrVararg(builder, typeDeclarationToken))) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("type", new Object[0])));
        }
        typeDeclaration.done(typeDeclarationToken);
        return typeDeclarationToken;
    }

    private static int parseClassReferences(PhpPsiBuilder builder) {
        builder.compareAndEat(PhpTokenTypes.opQUEST);
        IElementType firstType = TypeDeclaration.parseUnionTypeElement(builder);
        TokenSet delimiter = firstType == PhpElementTypes.EMPTY_INPUT ? PIPE_DELIMITER : TYPE_DECLARATION_DELIMITERS;
        return ListParsingHelper.parseDelimitedExpressionWithLeadExpr(builder, firstType, b -> {
            b.compareAndEat(PhpTokenTypes.opQUEST);
            return TypeDeclaration.parseUnionTypeElement(b);
        }, delimiter, false, false);
    }

    private static IElementType parseUnionTypeElement(PhpPsiBuilder builder) {
        if (builder.compare(PhpTokenTypes.chLPAREN)) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            if (TypeDeclaration.parseClassReferences(builder) == 0) {
                builder.error(PhpParserErrors.expected(PhpBundle.message("type", new Object[0])));
            }
            builder.match(PhpTokenTypes.chRPAREN);
            mark.done(PhpElementTypes.CLASS_REFERENCES_GROUP);
            return PhpElementTypes.CLASS_REFERENCES_GROUP;
        }
        return TypeDeclaration.parseSimpleType(builder);
    }

    private static boolean tryEatBitAndNotFollowedByVarOrVararg(PhpPsiBuilder builder, @NotNull IElementType typeDeclarationToken) {
        return (typeDeclarationToken != PhpElementTypes.PARAMETER_TYPE || builder.lookAhead() != PhpTokenTypes.opVARIADIC && builder.lookAhead() != PhpTokenTypes.VARIABLE) && builder.compareAndEat(PhpTokenTypes.opBIT_AND);
    }

    public static IElementType parseSimpleType(PhpPsiBuilder builder) {
        IElementType classReference;
        if (builder.compare(PhpTokenTypes.kwARRAY) || builder.compare(PhpTokenTypes.kwCALLABLE)) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done(PhpElementTypes.CLASS_REFERENCE);
            classReference = PhpElementTypes.CLASS_REFERENCE;
        } else {
            classReference = ClassReference.parse(builder);
        }
        TypeDeclaration.parseBrackets(builder);
        return classReference;
    }

    private static void parseBrackets(@NotNull PhpPsiBuilder builder) {
        PsiBuilder.Marker mark;
        while (true) {
            mark = builder.mark();
            if (!builder.compareAndEat(PhpTokenTypes.chLBRACKET)) break;
            if (!builder.compareAndEat(PhpTokenTypes.chRBRACKET)) {
                mark.precede().error(PhpParserErrors.unexpected(PhpTokenTypes.chLBRACKET));
            }
            mark.drop();
        }
        mark.drop();
    }

    public static boolean isTypeDeclaration(@Nullable IElementType elementType) {
        return elementType == PhpElementTypes.PARAMETER_TYPE || elementType == PhpElementTypes.RETURN_TYPE || elementType == PhpElementTypes.FIELD_TYPE;
    }
}

