/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocStubElementTypes;
import fleet.com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocTagParserRegistry;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.ParserPart;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.parsing.Namespace;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class PhpDocTagParser
implements PhpDocElementTypes {
    public static final TokenSet TYPE_SEP = TokenSet.create((IElementType[])new IElementType[]{DOC_PIPE, DOC_AMPERSAND});
    private static final ParserPart ADVANCED_CLOSURE_PARAMETER = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            PsiBuilder.Marker param = builder.mark();
            builder.compareAndEat(PhpDocTokenTypes.DOC_VARIABLE);
            if (PhpDocTagParser.parseTypes(builder)) {
                param.done(PhpDocStubElementTypes.phpDocParam);
                return PhpDocStubElementTypes.phpDocParam;
            }
            param.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
    };

    public void parse(PhpPsiBuilder builder, boolean inside, boolean inlineTag) {
        PsiBuilder.Marker tag = builder.mark();
        builder.match(DOC_TAG_NAME);
        this.parseContents(builder);
        if (inlineTag || !inside) {
            PhpDocTagParser.parseValue(builder, inlineTag);
        }
        tag.done(this.getElementType());
    }

    public IElementType getElementType() {
        return phpDocTag;
    }

    protected boolean parseContents(PhpPsiBuilder builder) {
        PsiBuilder.Marker content = builder.mark();
        if (builder.compareAndEat(DOC_LPAREN)) {
            while (!(builder.compare(DOC_RPAREN) || builder.compare(DOC_COMMENT_LEADING_ASTERISK) || builder.compare(DOC_COMMENT_END) || builder.eof())) {
                if (builder.compare(DOC_TAG_NAME)) {
                    this.parse(builder, true, false);
                    continue;
                }
                if (builder.compare(DOC_STRING)) {
                    PsiBuilder.Marker mark = builder.mark();
                    builder.match(DOC_STRING);
                    mark.done((IElementType)phpDocString);
                    continue;
                }
                builder.advanceLexer();
            }
            builder.compareAndEat(DOC_RPAREN);
            content.done((IElementType)phpDocAttributeList);
        } else {
            content.drop();
        }
        return true;
    }

    public static boolean parseTypes(PhpPsiBuilder builder) {
        return PhpDocTagParser.parseTypes(builder, false);
    }

    public static boolean parseTypes(PhpPsiBuilder builder, boolean remapTextPipe) {
        boolean atLeastOneTypeParsed = false;
        while (builder.compare(DOC_IDENTIFIER) || builder.compare(DOC_NAMESPACE) || builder.compare(DOC_VARIABLE) && "$this".equals(builder.getTokenText()) || builder.compare(DOC_HASH) || builder.compare(DOC_TEXT) || builder.compare(DOC_QUESTION_MARK) || builder.compare(DOC_LAB)) {
            if (builder.getTokenType() == DOC_TEXT) {
                String tokenText = builder.getTokenText();
                if (tokenText == null || !tokenText.equals("?")) break;
                builder.remapCurrentTokenWithDocQuestion();
                builder.advanceLexer();
            } else if (builder.getTokenType() == DOC_QUESTION_MARK) {
                builder.advanceLexer();
            } else {
                PsiBuilder.Marker closure = builder.mark();
                if (PhpDocTagParser.tryParseAdvancedCallable(builder)) {
                    atLeastOneTypeParsed = true;
                    closure.done((IElementType)phpDocType);
                    continue;
                }
                closure.rollbackTo();
            }
            PsiBuilder.Marker type = builder.mark();
            builder.compareAndEat(DOC_HASH);
            Namespace.parseReference(builder);
            if (!builder.compareAndEat(DOC_IDENTIFIER) && "$this".equals(builder.getTokenText())) {
                builder.advanceLexer();
            }
            if (!PhpDocTagParser.parseGenericArray(builder, DOC_LAB, DOC_RAB, PhpDocTagParser::parseTypes)) {
                PhpDocTagParser.parseGenericArray(builder, DOC_LBRACE, DOC_RBRACE, b -> {
                    PhpDocTagParser.parseKey(builder);
                    return PhpDocTagParser.parseTypes(builder, true);
                });
            }
            PsiBuilder.Marker array = builder.mark();
            while (builder.compareAndEat(DOC_LBRACKET) && builder.compareAndEat(DOC_RBRACKET)) {
                array.drop();
                array = builder.mark();
            }
            array.rollbackTo();
            atLeastOneTypeParsed = true;
            type.done((IElementType)phpDocType);
            if (remapTextPipe && builder.compare(DOC_TEXT) && "|".equals(builder.getTokenText())) {
                builder.remapCurrentTokenWithDocPipe();
            }
            if (!(builder.compare(DOC_LPAREN) | !builder.compareAndEat(TYPE_SEP))) continue;
            break;
        }
        return atLeastOneTypeParsed;
    }

    private static void parseKey(PhpPsiBuilder builder) {
        String text;
        PsiBuilder.Marker mark = builder.mark();
        if (builder.compareAndEat(DOC_IDENTIFIER) || builder.compareAndEat(DOC_STRING)) {
            if (!PhpDocTagParser.compareAndEatTextWithValue(builder, "?:")) {
                PhpDocTagParser.compareAndEatTextWithValue(builder, "?");
                if (!PhpDocTagParser.compareAndEatTextWithValue(builder, ":")) {
                    mark.rollbackTo();
                    return;
                }
            }
        } else if (builder.compare(DOC_TEXT) && (text = builder.getTokenText()) != null) {
            if (PhpDocTagParser.isNumberEndingWith(text, "?")) {
                builder.advanceLexer();
                PhpDocTagParser.compareAndEatTextWithValue(builder, ":");
            } else if (PhpDocTagParser.isNumberEndingWith(text, "?:")) {
                builder.advanceLexer();
            }
        }
        mark.drop();
    }

    private static boolean isNumberEndingWith(String text, String suffix) {
        return StringUtil.endsWith((CharSequence)text, (CharSequence)suffix) && PhpDocTagParser.isNotNegativeNumber(text.substring(0, text.length() - suffix.length()));
    }

    private static boolean parseGenericArray(PhpPsiBuilder builder, IElementType openParens, IElementType closedParens, Function<PhpPsiBuilder, Boolean> typeParser) {
        if (builder.rawLookup(0) != DOC_WHITESPACE && builder.compare(openParens)) {
            PsiBuilder.Marker param = builder.mark();
            builder.advanceLexer();
            while (typeParser.apply(builder).booleanValue() && builder.compareAndEat(DOC_COMMA)) {
            }
            builder.compareAndEat(closedParens);
            param.done((IElementType)phpDocAttributeList);
            return true;
        }
        return false;
    }

    private static boolean compareAndEatTextWithValue(PhpPsiBuilder builder, String text) {
        if (builder.compare(DOC_TEXT) && text.equals(builder.getTokenText())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    private static boolean tryParseAdvancedCallable(PhpPsiBuilder builder) {
        builder.advanceLexer();
        if (!builder.compareAndEat(PhpDocTokenTypes.DOC_LPAREN)) {
            return false;
        }
        ListParsingHelper.parseDelimitedExpressionWithLeadExpr(builder, ADVANCED_CLOSURE_PARAMETER.parse(builder), ADVANCED_CLOSURE_PARAMETER, PhpDocTokenTypes.DOC_COMMA, false, true);
        if (!builder.compareAndEat(PhpDocTokenTypes.DOC_RPAREN)) {
            return false;
        }
        if (builder.getTokenType() == DOC_TEXT && ":".equals(builder.getTokenText())) {
            builder.advanceLexer();
            return PhpDocTagParser.parseTypes(builder);
        }
        return false;
    }

    protected static boolean parseVar(PhpPsiBuilder builder) {
        PsiBuilder.Marker tag = builder.mark();
        builder.compareAndEat(DOC_AMPERSAND);
        if (builder.compare(DOC_TEXT) && "...".equals(builder.getTokenText())) {
            builder.advanceLexer();
        }
        if (builder.compareAndEat(DOC_VARIABLE)) {
            if (builder.compare(DOC_UNLIMITED)) {
                builder.advanceLexer();
            }
            tag.done((IElementType)phpDocVariable);
            return true;
        }
        tag.rollbackTo();
        return false;
    }

    protected static boolean parseId(PhpPsiBuilder builder) {
        PsiBuilder.Marker tag = builder.mark();
        if (builder.compareAndEat(DOC_IDENTIFIER) && !builder.compare(DOC_NAMESPACE) && !builder.compare(DOC_PIPE)) {
            tag.done((IElementType)phpDocVariable);
            return true;
        }
        tag.rollbackTo();
        return false;
    }

    protected static boolean parseProperty(PhpPsiBuilder builder) {
        if (builder.compare(DOC_LPAREN)) {
            PsiBuilder.Marker paren = builder.mark();
            builder.advanceLexer();
            while (!(builder.compare(DOC_RPAREN) || builder.compare(DOC_LEADING_ASTERISK) || builder.compare(DOC_COMMENT_END) || builder.compare(DOC_VARIABLE) || builder.eof())) {
                builder.advanceLexer();
            }
            if (builder.compare(DOC_RPAREN)) {
                builder.advanceLexer();
                paren.drop();
            } else {
                paren.rollbackTo();
            }
        }
        PsiBuilder.Marker tag = builder.mark();
        if ((builder.compareAndEat(DOC_VARIABLE) || builder.compareAndEat(DOC_IDENTIFIER)) && !builder.compare(DOC_NAMESPACE) && !builder.compare(DOC_PIPE)) {
            tag.done(phpDocProperty);
            return true;
        }
        tag.rollbackTo();
        return false;
    }

    private static void parseValue(PhpPsiBuilder builder, boolean inlineTag) {
        PsiBuilder.Marker value = builder.mark();
        boolean lbrace = false;
        while (!(builder.compare(DOC_TAG_VALUE_END) || builder.eof() || inlineTag && builder.compare(DOC_RBRACE))) {
            if (lbrace && builder.compare(DOC_TAG_NAME)) {
                PhpDocTagParserRegistry.parse(builder, true);
                continue;
            }
            lbrace = builder.compare(DOC_LBRACE);
            builder.advanceLexer();
        }
        value.done((IElementType)phpDocTagValue);
    }

    public Collection<String> getTagNames() {
        return Collections.emptyList();
    }

    @Contract(value="null -> false")
    public static boolean isNotNegativeNumber(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (PhpDocTagParser.isDecimalDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }
}

