/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support.aliases;

import java.io.PrintWriter;
import org.clank.support.AbstractArrayPointerType;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char$ptr$array;
import org.clank.support.aliases.float$ptr;
import org.clank.support.aliases.float$ref;
import org.clank.support.void$ptr;

public final class float$ptr$array
extends AbstractArrayPointerType<float$ptr>
implements float$ptr {
    float[] array;
    private static long nonConstInstances = 0L;
    private static long constPtrInstances = 0L;
    private static long constContentInstances = 0L;
    private static long fullyConstInstances = 0L;

    protected float$ptr$array(float$ptr$array other, boolean makeConstPtr, boolean makeConstContent) {
        super(other, makeConstPtr, float$ptr$array.adjustImmutableContent(makeConstContent, other.array));
        this.array = other.array;
        float$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    public float$ptr$array() {
        this(null, 0, false, false);
    }

    public float$ptr$array(float[] arr) {
        this(arr, 0, false, false);
    }

    public float$ptr$array(float[] arr, int idx) {
        this(arr, idx, false, false);
    }

    public float$ptr$array(float[] arr, boolean makeConstPtr) {
        this(arr, 0, makeConstPtr, false);
    }

    public float$ptr$array(float[] arr, int idx, boolean makeConstPtr) {
        this(arr, idx, makeConstPtr, false);
    }

    public float$ptr$array(float[] arr, int idx, boolean makeConstPtr, boolean makeConstContent) {
        super(makeConstPtr, float$ptr$array.adjustImmutableContent(makeConstContent, arr));
        this.array = arr;
        assert (idx >= 0) : "can not be negative " + idx;
        this.index = idx;
        float$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    private static boolean adjustImmutableContent(boolean curConstValue, Object arrayToCheck) {
        if ($assertionsDisabled || !(curConstValue |= !NativeTrace.getArrayName(arrayToCheck).isEmpty())) {
            // empty if block
        }
        return curConstValue;
    }

    @Override
    public boolean $isNull() {
        return this.array == null;
    }

    @Override
    public float $star() {
        return this.array[this.index];
    }

    @Override
    public float $set(float value) {
        return this.$set(0, value);
    }

    @Override
    public float $at(int index) {
        return this.array[this.index + index];
    }

    @Override
    public int $sub(float$ptr other) {
        assert (other instanceof float$ptr$array) : "unexpected object " + other;
        return this.index - ((float$ptr$array)other).index;
    }

    @Override
    public float$ptr$array $add(int amount) {
        float$ptr$array cloned = new float$ptr$array(this, false, this._isConstContent());
        cloned.index += amount;
        return cloned;
    }

    @Override
    public float$ptr$array $sub(int amount) {
        float$ptr$array cloned = new float$ptr$array(this, false, this._isConstContent());
        cloned.index -= amount;
        return cloned;
    }

    @Override
    public float $set(int index, float value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        float f = value;
        this.array[this.index + index] = f;
        return f;
    }

    @Override
    public float $set$addassign(int index, float value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        float f = this.array[n] + value;
        this.array[n] = f;
        return f;
    }

    @Override
    public float $set$minusassign(int index, float value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        float f = this.array[n] - value;
        this.array[n] = f;
        return f;
    }

    @Override
    public float $set$starassign(int index, float value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        float f = this.array[n] * value;
        this.array[n] = f;
        return f;
    }

    @Override
    public float $set$slashassign(int index, float value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        float f = this.array[n] / value;
        this.array[n] = f;
        return f;
    }

    @Override
    public float $set$postInc(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        float f = this.array[n];
        this.array[n] = f + 1.0f;
        return f;
    }

    @Override
    public float $set$postDec(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        float f = this.array[n];
        this.array[n] = f - 1.0f;
        return f;
    }

    @Override
    public float $set$preInc(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        float f = this.array[n] + 1.0f;
        this.array[n] = f;
        return f;
    }

    @Override
    public float $set$preDec(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        float f = this.array[n] - 1.0f;
        this.array[n] = f;
        return f;
    }

    @Override
    public float$ptr $assign(float$ptr value) {
        assert (!this._isConstPtr()) : "Cannot modify const object!";
        if (value instanceof float$ptr$array) {
            float$ptr$array val = (float$ptr$array)value;
            this.array = val.array;
            this.index = val.index;
            if (val._isConstContent()) {
                super.$toConstContent();
            }
            return this;
        }
        throw new IllegalArgumentException("Different pointer types: expected '" + this.getClass().getName() + "', but found '" + (value != null ? value.getClass() : "null") + "'");
    }

    @Override
    public boolean isComparableTo(void$ptr other) {
        return other instanceof float$ptr$array && ((float$ptr$array)other).array == this.array;
    }

    @Override
    public boolean $less(Object obj) {
        if (obj instanceof float$ptr$array) {
            float$ptr$array other = (float$ptr$array)obj;
            return other.array == this.array && this.index - other.index < 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $lesseq(Object obj) {
        if (obj instanceof float$ptr$array) {
            float$ptr$array other = (float$ptr$array)obj;
            return other.array == this.array && this.index - other.index <= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greater(Object obj) {
        if (obj instanceof float$ptr$array) {
            float$ptr$array other = (float$ptr$array)obj;
            return other.array == this.array && this.index - other.index > 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greatereq(Object obj) {
        if (obj instanceof float$ptr$array) {
            float$ptr$array other = (float$ptr$array)obj;
            return other.array == this.array && this.index - other.index >= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $eq(Object p) {
        if (p instanceof float$ptr$array) {
            float$ptr$array other = (float$ptr$array)p;
            return other.array == this.array && this.index == other.index;
        }
        return false;
    }

    @Override
    public boolean $noteq(Object p) {
        return !this.$eq(p);
    }

    @Override
    public float$ref star$ref() {
        return new float$ref(){
            float$ptr$array localPtr;
            {
                this.localPtr = float$ptr$array.this;
            }

            @Override
            public float $deref() {
                return this.localPtr.$star();
            }

            @Override
            public float $set(float value) {
                return this.localPtr.$set(value);
            }

            @Override
            public float$ptr deref$ptr() {
                if (this.localPtr == float$ptr$array.this) {
                    this.localPtr = this.localPtr.clone();
                }
                return this.localPtr;
            }
        };
    }

    @Override
    public int $hashcode() {
        return System.identityHashCode(this.array) ^ this.index;
    }

    @Override
    public float$ptr$array clone() {
        return new float$ptr$array(this, false, this._isConstContent());
    }

    @Override
    public float$ptr$array const_clone() {
        return super._isConstPtr() ? this : new float$ptr$array(this, true, this._isConstContent());
    }

    public String toString() {
        String arrName = NativeTrace.getArrayName(this.array);
        if (this.array == null || this.array.length == 0) {
            return arrName + "<EMPTY>";
        }
        StringBuilder sb = new StringBuilder(arrName + "\n" + char$ptr$array.class.getSimpleName() + "{range=[" + this.index + "-" + this.array.length + "]\n");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.array.length + 1)) + "d";
        for (int i = this.index; i < this.array.length; ++i) {
            float b = this.array[i];
            sb.append(i == this.index ? "*[" : " [").append(String.format(fmt, i)).append("]");
            sb.append(b).append("\n");
            if (i - this.index <= 256) continue;
            sb.append("....");
            break;
        }
        sb.append("}").append(float$ptr$array.class.getSimpleName()).append("\n");
        return sb.toString();
    }

    public static void trackInstance(boolean constPtr, boolean constContent) {
        if (NativeTrace.STATISTICS) {
            if (constPtr && constContent) {
                ++fullyConstInstances;
            } else if (constPtr) {
                ++constPtrInstances;
            } else if (constContent) {
                ++constContentInstances;
            } else {
                ++nonConstInstances;
            }
        }
    }

    public static void clearStatistics() {
        fullyConstInstances = 0L;
        constPtrInstances = 0L;
        constContentInstances = 0L;
        nonConstInstances = 0L;
    }

    public static long printStatistics(PrintWriter out) {
        long totalInstances = nonConstInstances + fullyConstInstances + constPtrInstances + constContentInstances;
        out.printf("%30s created all:\t%s%n", float$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(totalInstances));
        out.printf("%32s non const:\t%s%n", float$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(nonConstInstances));
        out.printf("%32s const ptr:\t%s%n", float$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constPtrInstances));
        out.printf("%28s const content:\t%s%n", float$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constContentInstances));
        out.printf("%20s const ptr and content:\t%s%n", float$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(fullyConstInstances));
        return totalInstances;
    }

    @Override
    public final float[] $array() {
        return this.array;
    }
}

