/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support.aliases;

import java.io.PrintWriter;
import org.clank.support.AbstractArrayPointerType;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char$ptr$array;
import org.clank.support.aliases.double$ptr;
import org.clank.support.aliases.double$ref;
import org.clank.support.void$ptr;

public final class double$ptr$array
extends AbstractArrayPointerType<double$ptr>
implements double$ptr {
    double[] array;
    private static long nonConstInstances = 0L;
    private static long constPtrInstances = 0L;
    private static long constContentInstances = 0L;
    private static long fullyConstInstances = 0L;

    protected double$ptr$array(double$ptr$array other, boolean makeConstPtr, boolean makeConstContent) {
        super(other, makeConstPtr, double$ptr$array.adjustImmutableContent(makeConstContent, other.array));
        this.array = other.array;
        double$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    public double$ptr$array() {
        this(null, 0, false, false);
    }

    public double$ptr$array(double[] arr) {
        this(arr, 0, false, false);
    }

    public double$ptr$array(double[] arr, int idx) {
        this(arr, idx, false, false);
    }

    public double$ptr$array(double[] arr, boolean makeConstPtr) {
        this(arr, 0, makeConstPtr, false);
    }

    public double$ptr$array(double[] arr, int idx, boolean makeConstPtr) {
        this(arr, idx, makeConstPtr, false);
    }

    public double$ptr$array(double[] arr, int idx, boolean makeConstPtr, boolean makeConstContent) {
        super(makeConstPtr, double$ptr$array.adjustImmutableContent(makeConstContent, arr));
        this.array = arr;
        assert (idx >= 0) : "can not be negative " + idx;
        this.index = idx;
        double$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    private static boolean adjustImmutableContent(boolean curConstValue, Object arrayToCheck) {
        if ($assertionsDisabled || !(curConstValue |= !NativeTrace.getArrayName(arrayToCheck).isEmpty())) {
            // empty if block
        }
        return curConstValue;
    }

    @Override
    public boolean $isNull() {
        return this.array == null;
    }

    @Override
    public double $star() {
        return this.array[this.index];
    }

    @Override
    public double $set(double value) {
        return this.$set(0, value);
    }

    @Override
    public double $at(int index) {
        return this.array[this.index + index];
    }

    @Override
    public int $sub(double$ptr other) {
        assert (other instanceof double$ptr$array) : "unexpected object " + other;
        return this.index - ((double$ptr$array)other).index;
    }

    @Override
    public double$ptr$array $add(int amount) {
        double$ptr$array cloned = new double$ptr$array(this, false, this._isConstContent());
        cloned.index += amount;
        return cloned;
    }

    @Override
    public double$ptr$array $sub(int amount) {
        double$ptr$array cloned = new double$ptr$array(this, false, this._isConstContent());
        cloned.index -= amount;
        return cloned;
    }

    @Override
    public double $set(int index, double value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        double d = value;
        this.array[this.index + index] = d;
        return d;
    }

    @Override
    public double $set$addassign(int index, double value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        double d = this.array[n] + value;
        this.array[n] = d;
        return d;
    }

    @Override
    public double $set$minusassign(int index, double value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        double d = this.array[n] - value;
        this.array[n] = d;
        return d;
    }

    @Override
    public double $set$starassign(int index, double value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        double d = this.array[n] * value;
        this.array[n] = d;
        return d;
    }

    @Override
    public double $set$slashassign(int index, double value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        double d = this.array[n] / value;
        this.array[n] = d;
        return d;
    }

    @Override
    public double $set$postInc(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        double d = this.array[n];
        this.array[n] = d + 1.0;
        return d;
    }

    @Override
    public double $set$postDec(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        double d = this.array[n];
        this.array[n] = d - 1.0;
        return d;
    }

    @Override
    public double $set$preInc(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        double d = this.array[n] + 1.0;
        this.array[n] = d;
        return d;
    }

    @Override
    public double $set$preDec(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        double d = this.array[n] - 1.0;
        this.array[n] = d;
        return d;
    }

    @Override
    public double$ptr $assign(double$ptr value) {
        assert (!this._isConstPtr()) : "Cannot modify const object!";
        if (value instanceof double$ptr$array) {
            double$ptr$array val = (double$ptr$array)value;
            this.array = val.array;
            this.index = val.index;
            if (val._isConstContent()) {
                super.$toConstContent();
            }
            return this;
        }
        throw new IllegalArgumentException("Different pointer types: expected '" + this.getClass().getName() + "', but found '" + (value != null ? value.getClass() : "null") + "'");
    }

    @Override
    public boolean isComparableTo(void$ptr other) {
        return other instanceof double$ptr$array && ((double$ptr$array)other).array == this.array;
    }

    @Override
    public boolean $less(Object obj) {
        if (obj instanceof double$ptr$array) {
            double$ptr$array other = (double$ptr$array)obj;
            return other.array == this.array && this.index - other.index < 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $lesseq(Object obj) {
        if (obj instanceof double$ptr$array) {
            double$ptr$array other = (double$ptr$array)obj;
            return other.array == this.array && this.index - other.index <= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greater(Object obj) {
        if (obj instanceof double$ptr$array) {
            double$ptr$array other = (double$ptr$array)obj;
            return other.array == this.array && this.index - other.index > 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greatereq(Object obj) {
        if (obj instanceof double$ptr$array) {
            double$ptr$array other = (double$ptr$array)obj;
            return other.array == this.array && this.index - other.index >= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $eq(Object p) {
        if (p instanceof double$ptr$array) {
            double$ptr$array other = (double$ptr$array)p;
            return other.array == this.array && this.index == other.index;
        }
        return false;
    }

    @Override
    public boolean $noteq(Object p) {
        return !this.$eq(p);
    }

    @Override
    public double$ref star$ref() {
        return new double$ref(){
            double$ptr$array localPtr;
            {
                this.localPtr = double$ptr$array.this;
            }

            @Override
            public double $deref() {
                return this.localPtr.$star();
            }

            @Override
            public double $set(double value) {
                return this.localPtr.$set(value);
            }

            @Override
            public double$ptr deref$ptr() {
                if (this.localPtr == double$ptr$array.this) {
                    this.localPtr = this.localPtr.clone();
                }
                return this.localPtr;
            }
        };
    }

    @Override
    public int $hashcode() {
        return System.identityHashCode(this.array) ^ this.index;
    }

    @Override
    public double$ptr$array clone() {
        return new double$ptr$array(this, false, this._isConstContent());
    }

    @Override
    public double$ptr$array const_clone() {
        return super._isConstPtr() ? this : new double$ptr$array(this, true, this._isConstContent());
    }

    public String toString() {
        String arrName = NativeTrace.getArrayName(this.array);
        if (this.array == null || this.array.length == 0) {
            return arrName + "<EMPTY>";
        }
        StringBuilder sb = new StringBuilder(arrName + "\n" + char$ptr$array.class.getSimpleName() + "{range=[" + this.index + "-" + this.array.length + "]\n");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.array.length + 1)) + "d";
        for (int i = this.index; i < this.array.length; ++i) {
            double b = this.array[i];
            sb.append(i == this.index ? "*[" : " [").append(String.format(fmt, i)).append("]");
            sb.append(b).append("\n");
            if (i - this.index <= 256) continue;
            sb.append("....");
            break;
        }
        sb.append("}").append(double$ptr$array.class.getSimpleName()).append("\n");
        return sb.toString();
    }

    public static void trackInstance(boolean constPtr, boolean constContent) {
        if (NativeTrace.STATISTICS) {
            if (constPtr && constContent) {
                ++fullyConstInstances;
            } else if (constPtr) {
                ++constPtrInstances;
            } else if (constContent) {
                ++constContentInstances;
            } else {
                ++nonConstInstances;
            }
        }
    }

    public static void clearStatistics() {
        fullyConstInstances = 0L;
        constPtrInstances = 0L;
        constContentInstances = 0L;
        nonConstInstances = 0L;
    }

    public static long printStatistics(PrintWriter out) {
        long totalInstances = nonConstInstances + fullyConstInstances + constPtrInstances + constContentInstances;
        out.printf("%30s created all:\t%s%n", double$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(totalInstances));
        out.printf("%32s non const:\t%s%n", double$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(nonConstInstances));
        out.printf("%32s const ptr:\t%s%n", double$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constPtrInstances));
        out.printf("%28s const content:\t%s%n", double$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constContentInstances));
        out.printf("%20s const ptr and content:\t%s%n", double$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(fullyConstInstances));
        return totalInstances;
    }

    @Override
    public final double[] $array() {
        return this.array;
    }
}

