/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.StackElementArray;
import org.clank.support.aliases.char$ptr;

public final class NativeTrace {
    private static final Logger LOG;
    private static boolean releaseMode;
    private static volatile Throwable firstException;
    private static volatile Throwable firstCleanupException;
    private static final int STACK_THREASHOLD;
    public static final boolean USE_PTH_DRIVER_IN_TEST;
    private static final boolean STANDALONE;
    public static final File STAT_OUT_FOLDER;
    public static final String STAT_OUT_FOLDER_RPOP = "clank.statistics.out.folder";
    public static final String CLANG_MODE_PROP = "clank.as.clang";
    public static final boolean CLANG_MODE;
    private static final boolean CHECK_FILES;
    private static final boolean TRUE_CASE_SENSITIVE_SYSTEM;
    public static final int TO_STRING_LIMIT = 256;
    public static final boolean OPTIMIZE_DENSE_MAP_INFO;
    public static final String REUSE_JAVA_CLEANER_PROP = "org.clank.reuse.java.cleaner";
    public static final boolean REUSE_JAVA_CLEANER;
    public static final boolean STATISTICS;
    public static final boolean TRACE_IO;
    public static final boolean TRACE_BUILT_IN;
    public static final boolean TRACE_MEMORY;
    public static final String TRACE_FILE_INFO_EXIT_PROP = "org.clank.trace.file.level";
    public static final int TRACE_FILE_INFO_EXIT;
    public static final String SERVICE_STATISTICS_RPOP = "clank.service.statistics";
    public static final boolean SERVICE_STATISTICS;
    public static final String CLANK_VERBOSE_PROP = "org.clank.verbose";
    public static final boolean VERBOSE_MODE;
    public static final boolean UNIT_TEST_MODE;
    public static boolean UNIT_TEST_REDIRECTED_STREAMS;
    public static final String CHECK_STD_ACCESS_DESTROYED_PROP = "clank.check.access.destroyed";
    public static final boolean CHECK_STD_PTR_ACCESS_DESTROYED;
    public static final boolean ALWAYS_USE_NB_FS;
    public static final String CHECK_ALLOCATOR_PROP = "clank.check.allocator";
    public static final boolean CHECK_ALLOCATOR;
    private static final ConcurrentHashMap<String, Boolean> tracedNotImplemented;
    private static final ConcurrentHashMap<CharSequence, AtomicInteger> restrictLog;
    private static final Set<StackElementArray> toStringStacks;
    private static int DEFAULT_STACK_FRAMES_NUM;
    private static int DEFAULT_STACK_FRAMES_PRINT_NUM;
    private static final Map<byte[], String> constByteArraysStorage;
    private static final Map<char[], String> constCharArraysStorage;
    private static final Map<short[], String> constShortArraysStorage;
    private static final Map<int[], String> constIntArraysStorage;
    private static final Map<long[], String> constLongArraysStorage;
    private static final Map<boolean[], String> constBooleanArraysStorage;
    private static final Map<float[], String> constFloatArraysStorage;
    private static final Map<double[], String> constDoubleArraysStorage;
    private static final Map<?, String> constObjectArraysStorage;

    private static boolean initStandalone() {
        if ("true".equals(System.getProperty("cnd.command.line.utility"))) {
            return true;
        }
        if (NativeTrace.getBoolean("java.awt.headless", false)) {
            return true;
        }
        return !NativeTrace.class.getClassLoader().getClass().getName().startsWith("org.netbeans.");
    }

    public static void dumpStatisticValue(PrintWriter out, String valueName, long value) {
        out.println(String.format("==== %32s: %20s", valueName, NativeTrace.formatNumber(value)));
        out.flush();
        NativeTrace.dumpStatisticValue(valueName, value);
    }

    public static void dumpStatisticValue(String valueName, long value) {
        if (STAT_OUT_FOLDER != null) {
            File out = new File(STAT_OUT_FOLDER, valueName);
            try (FileWriter fw = new FileWriter(out);){
                fw.write("YVALUE=" + String.format("%d", value) + "\n");
            }
            catch (IOException ex) {
                NativeTrace.severe(ex);
            }
        }
    }

    public static boolean isCheckingFile(CharSequence path) {
        String toString;
        return CHECK_FILES && ((toString = path.toString()).endsWith("module.h") || toString.endsWith("cpu.h") || toString.endsWith("memory.h"));
    }

    public static boolean isCheckingFile(char$ptr path) {
        if (CHECK_FILES) {
            return NativeTrace.isCheckingFile(Casts.toJavaString(path));
        }
        return false;
    }

    public static boolean getBoolean(String systemPropertyName, boolean defaultValue) {
        String text = System.getProperty(systemPropertyName);
        if (text != null) {
            defaultValue = Boolean.parseBoolean(text);
        }
        return defaultValue;
    }

    public static boolean isStandalone() {
        return STANDALONE;
    }

    public static boolean isUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.unittest");
    }

    public static boolean NDEBUG() {
        return !NativeTrace.isDebugMode();
    }

    public static boolean isReleaseMode() {
        return releaseMode;
    }

    public static boolean isDebugMode() {
        return !NativeTrace.isReleaseMode();
    }

    public static boolean isSystemCaseSensitive() {
        return TRUE_CASE_SENSITIVE_SYSTEM;
    }

    public static final void trace(String message, boolean traceFlag) {
        if (traceFlag) {
            System.err.println(message);
        }
    }

    public static final void traceNotImplemented(String message) {
        if (NativeTrace.isDebugMode() && !CLANG_MODE && tracedNotImplemented.putIfAbsent(message, Boolean.TRUE) == null) {
            System.err.println(message + " not yet implemented");
        }
    }

    private NativeTrace() {
        throw new AssertionError((Object)"Not instantiable");
    }

    public static String getIdentityStr(Object obj) {
        return obj == null ? "<null>" : "#" + System.identityHashCode(obj) + ":" + obj.getClass().getSimpleName();
    }

    public static boolean hasWideChars(CharSequence text) {
        return NativeTrace.findFirstWideCharInText(text) >= 0;
    }

    public static int findFirstWideCharInText(CharSequence text) {
        if (text == null) {
            return -1;
        }
        int out = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            assert (c >= '\u0000') : " " + c;
            if (c <= '\u00ff') continue;
            return i;
        }
        return out;
    }

    public static String formatNumber(long num) {
        return NativeTrace.formatNumber(num, -1);
    }

    public static String formatNumber(long num, int digits) {
        String fmt = "%,";
        if (digits > 0) {
            fmt = fmt + digits;
        }
        fmt = fmt + "d";
        return String.format(fmt, num);
    }

    public static void assertTrue(boolean value) {
        if (!value && NativeTrace.isDebugMode()) {
            NativeTrace.severe("Assertion error");
        }
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null && NativeTrace.isDebugMode()) {
            NativeTrace.severe(message);
        }
    }

    public static void assertUnconditional(String message) {
        if (NativeTrace.isDebugMode()) {
            NativeTrace.severe(message);
        }
    }

    public static void assertNotNull(Object object, CharSequence prefix, Object message) {
        if (object == null && NativeTrace.isDebugMode()) {
            NativeTrace.severe(prefix.toString() + message);
        }
    }

    public static void assertNotNullInConsole(Object object, String message) {
        if (object == null && NativeTrace.isDebugMode()) {
            NativeTrace.info(message);
        }
    }

    public static void assertNull(Object object, String message) {
        if (object != null && NativeTrace.isDebugMode()) {
            NativeTrace.severe(message);
        }
    }

    public static int getNumberCndWorkerThreads() {
        int threadCount = Math.min(4, Runtime.getRuntime().availableProcessors() - 2);
        if (System.getProperty("cnd.modelimpl.parser.threads") != null) {
            threadCount = Integer.getInteger("cnd.modelimpl.parser.threads");
        }
        return Math.max(threadCount, 1);
    }

    public static int getConcurrencyLevel() {
        return NativeTrace.getNumberCndWorkerThreads();
    }

    public static void assertFalse(boolean value) {
        if (value && NativeTrace.isDebugMode()) {
            NativeTrace.severe("Assertion error");
        }
    }

    public static void assertFalse(boolean value, String message) {
        NativeTrace.assertTrue(!value, message);
    }

    public static void assertTrue(boolean value, String message) {
        if (NativeTrace.isDebugMode() && !value) {
            NativeTrace.severe(message);
        }
    }

    private static String addThreadName(String msg) {
        return msg + "\n@[" + Thread.currentThread().getName() + "]";
    }

    public static <T extends Throwable> T registerReason(T th) {
        if (firstException == null) {
            firstException = th;
        }
        return th;
    }

    public static void assertTrue(boolean value, String prefix, Object message) {
        if (NativeTrace.isDebugMode() && !value) {
            NativeTrace.printStackTraceOnce(NativeTrace.registerReason(new Exception(NativeTrace.addThreadName(prefix + message))));
        }
    }

    public static void severe(Exception exception) {
        LOG.log(Level.SEVERE, exception.getMessage(), NativeTrace.registerReason(exception));
    }

    private static void severe(String message) {
        LOG.log(Level.SEVERE, message, NativeTrace.registerReason(new Exception(NativeTrace.addThreadName(message))));
    }

    private static void info(String message) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, message, NativeTrace.registerReason(new Exception(NativeTrace.addThreadName(message))));
        }
    }

    public static void assertTrueInConsole(boolean value, String message) {
        if (NativeTrace.isDebugMode() && !value && LOG.isLoggable(Level.INFO)) {
            StackTraceElement[] stackTrace;
            Exception exception = new Exception(NativeTrace.addThreadName(message));
            Level level = Level.INFO;
            for (StackTraceElement element : stackTrace = exception.getStackTrace()) {
                int i;
                AtomicInteger counter;
                String className = element.getClassName();
                if (className.contains(".NativeTrace")) continue;
                int lineNumber = element.getLineNumber();
                String key = className + "-" + lineNumber;
                AtomicInteger old = restrictLog.putIfAbsent(key, counter = new AtomicInteger());
                if (old != null) {
                    counter = old;
                }
                if ((i = counter.incrementAndGet()) <= STACK_THREASHOLD) break;
                level = Level.FINE;
                break;
            }
            LOG.log(level, message, NativeTrace.registerReason(exception));
        }
    }

    private static boolean pathsEqual(CharSequence path1, CharSequence path2) {
        if (path1 == null) {
            return path2 == null;
        }
        if (path2 == null) {
            return false;
        }
        if (path1 == path2) {
            return true;
        }
        int len = path1.length();
        if (len == path2.length()) {
            for (int i = len - 1; i >= 0; --i) {
                char c1 = path1.charAt(i);
                char c2 = path2.charAt(i);
                if (!(c1 == '/' || c1 == '\\' ? c2 != '/' && c2 != '\\' : c1 != c2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void assertPathsEqualInConsole(CharSequence path1, CharSequence path2, String format, Object ... args) {
        if (NativeTrace.isDebugMode() && !NativeTrace.pathsEqual(path1, path2)) {
            String text = MessageFormat.format(format, args);
            NativeTrace.assertTrueInConsole(false, text);
        }
    }

    public static void assertTrueInConsole(boolean value, String prefix, Object message) {
        if (NativeTrace.isDebugMode() && !value && LOG.isLoggable(Level.INFO)) {
            NativeTrace.assertTrueInConsole(value, prefix + message);
        }
    }

    public static Logger getLogger() {
        return LOG;
    }

    public static void printStackTraceOnce(Throwable exception, int stackCompareSize) {
        NativeTrace.printStackTraceOnce(exception, Level.INFO, true, stackCompareSize);
    }

    public static void printStackTraceOnce(Throwable exception) {
        NativeTrace.printStackTraceOnce(exception, Level.INFO, true);
    }

    public static void printStackTraceAlways(Throwable exception) {
        NativeTrace.printStackTraceOnce(exception, Level.INFO, false);
    }

    public static Throwable getFirstException() {
        return firstException;
    }

    public static Throwable getFirstCleanupException() {
        return firstCleanupException;
    }

    public static Throwable registerCleanupException(Throwable ex) {
        if (firstCleanupException == null) {
            firstCleanupException = ex;
        }
        return ex;
    }

    public static void clearFirstException() {
        firstException = null;
        firstCleanupException = null;
        if (toStringStacks != null) {
            toStringStacks.clear();
        }
    }

    public static void printStackTraceOnce(Throwable cause, Level level, boolean once, int stackCompareSize) {
        if (NativeTrace.isDebugMode() && (!once || StackElementArray.addStackIfNew(cause.getStackTrace(), toStringStacks, stackCompareSize))) {
            LOG.log(level, cause.getMessage(), NativeTrace.registerReason(cause));
        }
    }

    public static void printStackTraceOnce(Throwable cause, Level level, boolean once) {
        NativeTrace.printStackTraceOnce(cause, level, once, DEFAULT_STACK_FRAMES_NUM);
    }

    public static void printDebuggingStackFrames(Throwable cause) {
        NativeTrace.printDebuggingStackFrames(cause, 0, DEFAULT_STACK_FRAMES_PRINT_NUM, Level.INFO);
    }

    public static void printDebuggingStackFrames(String msg) {
        NativeTrace.printDebuggingStackFrames(new Exception(msg), DEFAULT_STACK_FRAMES_PRINT_NUM + 1, 1, Level.INFO);
    }

    public static void printDebuggingStackFrames(String msg, int framesDepth) {
        NativeTrace.printDebuggingStackFrames(new Exception(msg), framesDepth, 1, Level.INFO);
    }

    public static void printDebuggingStackFrames(Throwable cause, int fromIndex, int numFrames, Level level) {
        if (cause != null && LOG.isLoggable(level)) {
            StringBuilder msg = new StringBuilder(cause.getMessage());
            StackTraceElement[] stackTrace = cause.getStackTrace();
            if (stackTrace != null) {
                int maxFrame = Math.min(fromIndex + numFrames, stackTrace.length);
                if (fromIndex > 1) {
                    msg.append("\n").append("[skip ").append(fromIndex).append(" frames]....");
                }
                for (int i = fromIndex; i < maxFrame; ++i) {
                    StackTraceElement element = stackTrace[i];
                    String line = "at " + element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")";
                    msg.append("\n").append(line);
                }
            }
            LOG.log(level, msg.toString());
        }
    }

    private static <T> Map<T, String> arrToStorage(T array2) {
        assert (array2 != null);
        Class<?> arrClass = array2.getClass();
        assert (arrClass.isArray()) : "must be array " + arrClass;
        Map<Object, String> ArraysStorage = null;
        ArraysStorage = arrClass == byte[].class ? constByteArraysStorage : (arrClass == char[].class ? constCharArraysStorage : (arrClass == short[].class ? constShortArraysStorage : (arrClass == int[].class ? constIntArraysStorage : (arrClass == long[].class ? constLongArraysStorage : (arrClass == boolean[].class ? constBooleanArraysStorage : (arrClass == float[].class ? constFloatArraysStorage : (arrClass == double[].class ? constDoubleArraysStorage : constObjectArraysStorage)))))));
        return ArraysStorage;
    }

    public static <T> boolean unregisterArrayWithImmutableContent(T array2, String name) {
        if (!NativeTrace.isDebugMode()) {
            throw new IllegalStateException("Must be called from assert statement");
        }
        assert (name.length() > 0);
        assert (array2 != null) : "must not register null array [" + name + "]";
        Map<T, String> ArraysStorage = NativeTrace.arrToStorage(array2);
        String prev = ArraysStorage.remove(array2);
        assert (name.contentEquals(prev)) : "was not registered before [" + name + "]";
        return true;
    }

    public static <T> boolean registerArrayWithImmutableContent(T array2, String name) {
        if (!NativeTrace.isDebugMode()) {
            throw new IllegalStateException("Must be called from assert statement");
        }
        assert (name.length() > 0);
        assert (array2 != null) : "must not register null array [" + name + "]";
        Map<T, String> ArraysStorage = NativeTrace.arrToStorage(array2);
        String prev = ArraysStorage.put(array2, name);
        assert (prev == null) : "already registered as " + prev;
        return true;
    }

    public static <T> String getArrayName(T array2) {
        String name;
        String string2 = name = array2 == null ? null : NativeTrace.arrToStorage(array2).get(array2);
        if (name == null) {
            name = "";
        } else {
            if (!NativeTrace.isDebugMode()) {
                throw new IllegalStateException("How name was registered in non-debug mode?");
            }
            name = "CONST-ARRAY[" + name + "]";
        }
        return name;
    }

    public static <T> boolean assertArrayHasMutableContent(T array2, Object owner) {
        if (!NativeTrace.isDebugMode()) {
            throw new IllegalStateException("Must be called from assert statement");
        }
        String name = NativeTrace.getArrayName(array2);
        assert (name.isEmpty()) : "const array " + name + "must not be modified" + (array2 != owner ? " by " + NativeTrace.getIdentityStr(owner) : "");
        return name.isEmpty();
    }

    public static boolean assertDefaultValue(Object defaultValue) {
        if (!NativeTrace.isDebugMode()) {
            throw new IllegalStateException("Must be called from assert statement");
        }
        Object clone = null;
        assert (defaultValue == null || defaultValue instanceof Enum || defaultValue instanceof Supplier || (clone = Native.$tryClone(defaultValue)) != defaultValue) : "non cloneable class (forgot implement NativePOD?) for defaultValue " + defaultValue.getClass();
        Destructors.$destroy(clone);
        return true;
    }

    static {
        boolean caseSenstive;
        LOG = Logger.getLogger("cnd.logger");
        STACK_THREASHOLD = Integer.valueOf(System.getProperty("cnd.utils.same.stacks", "3"));
        USE_PTH_DRIVER_IN_TEST = Boolean.valueOf(System.getProperty("use.pth.driver.in.test", "false"));
        String text = System.getProperty("cnd.release.mode");
        if (text == null) {
            releaseMode = true;
            if (!$assertionsDisabled) {
                releaseMode = false;
                if (false) {
                    throw new AssertionError();
                }
            }
        } else {
            releaseMode = Boolean.parseBoolean(text);
        }
        STANDALONE = NativeTrace.initStandalone();
        String folder = System.getProperty(STAT_OUT_FOLDER_RPOP);
        File out = null;
        if (folder != null) {
            out = new File(folder).getAbsoluteFile();
            System.err.print("Dump statistics:" + out.getPath());
            if (!out.exists()) {
                System.err.println("- DOES NOT EXIST, NO DUMP");
                out = null;
            } else {
                System.err.println("");
            }
        }
        STAT_OUT_FOLDER = out;
        CLANG_MODE = Boolean.valueOf(System.getProperty(CLANG_MODE_PROP, "false"));
        CHECK_FILES = Boolean.valueOf(System.getProperty("cnd.tracing.files", "false"));
        try {
            File tmpFile = File.createTempFile("CaseSensitiveFile", ".check");
            String absPath = tmpFile.getAbsolutePath();
            absPath = absPath.toUpperCase();
            caseSenstive = !new File(absPath).exists();
            tmpFile.delete();
        }
        catch (IOException ex) {
            caseSenstive = true;
        }
        TRUE_CASE_SENSITIVE_SYSTEM = caseSenstive;
        OPTIMIZE_DENSE_MAP_INFO = Boolean.valueOf(System.getProperty("org.clank.optimize.densemap.info", "true"));
        REUSE_JAVA_CLEANER = Boolean.valueOf(System.getProperty(REUSE_JAVA_CLEANER_PROP, "false"));
        STATISTICS = Boolean.valueOf(System.getProperty("org.clank.statistics", STAT_OUT_FOLDER == null ? "false" : "true"));
        TRACE_IO = Boolean.valueOf(System.getProperty("org.clank.trace_io", "false"));
        TRACE_BUILT_IN = Boolean.valueOf(System.getProperty("org.clank.trace_builtin", "false"));
        TRACE_MEMORY = Boolean.valueOf(System.getProperty("org.clank.trace_memory", "false"));
        TRACE_FILE_INFO_EXIT = Integer.valueOf(System.getProperty(TRACE_FILE_INFO_EXIT_PROP, "0"));
        SERVICE_STATISTICS = Boolean.valueOf(System.getProperty(SERVICE_STATISTICS_RPOP, STAT_OUT_FOLDER == null ? "false" : "true"));
        VERBOSE_MODE = Boolean.valueOf(System.getProperty(CLANK_VERBOSE_PROP, "false"));
        UNIT_TEST_MODE = Boolean.getBoolean("cnd.mode.unittest");
        UNIT_TEST_REDIRECTED_STREAMS = false;
        ALWAYS_USE_NB_FS = Boolean.valueOf(System.getProperty("apt.always.use.filesystem", "false"));
        boolean checkStdPtrAccess = false;
        if (System.getProperty(CHECK_STD_ACCESS_DESTROYED_PROP) != null) {
            checkStdPtrAccess = Boolean.getBoolean(CHECK_STD_ACCESS_DESTROYED_PROP);
        } else if (UNIT_TEST_MODE) {
            checkStdPtrAccess = true;
        }
        CHECK_STD_PTR_ACCESS_DESTROYED = checkStdPtrAccess;
        boolean check = false;
        if (System.getProperty(CHECK_ALLOCATOR_PROP) != null) {
            check = Boolean.getBoolean(CHECK_ALLOCATOR_PROP);
        } else if (UNIT_TEST_MODE) {
            check = CHECK_STD_PTR_ACCESS_DESTROYED;
        }
        CHECK_ALLOCATOR = check;
        tracedNotImplemented = new ConcurrentHashMap();
        restrictLog = new ConcurrentHashMap();
        toStringStacks = NativeTrace.isDebugMode() ? StackElementArray.createSet() : null;
        DEFAULT_STACK_FRAMES_NUM = 6;
        DEFAULT_STACK_FRAMES_PRINT_NUM = 10;
        constByteArraysStorage = Collections.synchronizedMap(new IdentityHashMap());
        constCharArraysStorage = Collections.synchronizedMap(new IdentityHashMap());
        constShortArraysStorage = Collections.synchronizedMap(new IdentityHashMap());
        constIntArraysStorage = Collections.synchronizedMap(new IdentityHashMap());
        constLongArraysStorage = Collections.synchronizedMap(new IdentityHashMap());
        constBooleanArraysStorage = Collections.synchronizedMap(new IdentityHashMap());
        constFloatArraysStorage = Collections.synchronizedMap(new IdentityHashMap());
        constDoubleArraysStorage = Collections.synchronizedMap(new IdentityHashMap());
        constObjectArraysStorage = Collections.synchronizedMap(new IdentityHashMap());
    }
}

