/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Sequence;
import org.clank.support.aliases.JavaIteratorShort;
import org.clank.support.aliases.NativeContainerShort;
import org.clank.support.aliases.short$iterator;
import org.clank.support.aliases.short$ptr;
import org.clank.support.aliases.short$ref;

public abstract class StdVectorShort
extends NativeTrace.CreateDestroy.Tracker
implements Native.NativePOD<std.vectorShort>,
NativeMoveable<std.vectorShort>,
Native.NativeComparable<std.vectorShort>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<Short>,
Sequence<short$ref>,
NativeContainerShort,
Destructors.ClassWithDestructor {
    protected final short defaultValue;
    protected short[] array;
    private static final short[] EMPTY = NativePointer.new$short(0);
    protected int end;

    protected StdVectorShort(short defaultValue) {
        this.array = EMPTY;
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected StdVectorShort(int initialSize, short defaultValue) {
        this(initialSize, defaultValue, defaultValue);
    }

    protected StdVectorShort(int initialSize, short initialValue, short defaultValue) {
        this(defaultValue);
        this.assignWithSupplier(initialSize, initialValue);
    }

    protected StdVectorShort(short[] array2, int length, short defaultValue) {
        this.array = array2;
        this.end = length;
        this.defaultValue = defaultValue;
    }

    protected StdVectorShort(short$iterator<?> iter, int length, short defaultValue) {
        this(iter, (short$iterator)iter.$add(length), defaultValue);
    }

    protected StdVectorShort(short$iterator<?> begin, short$iterator<?> end, short defaultValue) {
        this(defaultValue);
        this.append(begin, end);
    }

    protected StdVectorShort(std.vectorShort other) {
        this(other.defaultValue);
        assert (other.checkAlive());
        this.append(other.begin(), other.end());
    }

    protected StdVectorShort(JavaDifferentiators.JD.Move _dparam, std.vectorShort other) {
        this(other.defaultValue);
        this.$assignMove(other);
    }

    @Override
    public std.vectorShort $assign(std.vectorShort other) {
        assert (other.checkAlive());
        if (this == other) {
            return (std.vectorShort)this;
        }
        assert (this.checkAlive());
        this.clear();
        this.array = EMPTY;
        this.append(other.begin(), other.end());
        return (std.vectorShort)this;
    }

    @Override
    public std.vectorShort $assignMove(std.vectorShort other) {
        assert (other.checkAlive());
        if (this == other) {
            return (std.vectorShort)this;
        }
        assert (this.checkAlive());
        this.clear();
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
        return (std.vectorShort)this;
    }

    public boolean shrink_to_fit() {
        return false;
    }

    public void clear() {
        assert (this.checkAlive());
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    @Override
    public void resize(int newSize) {
        this.resize(newSize, this.defaultValue);
    }

    public void resize(int newSize, short defaultValue) {
        assert (this.checkAlive());
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
            }
            for (int i = this.end; i < newSize; ++i) {
                assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
                this.array[i] = Native.$tryClone(defaultValue);
            }
        }
        this.setEnd(newSize);
    }

    public void reserve(int N) {
        assert (this.checkAlive());
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public void assign(int NumElts, short Elt) {
        assert (this.checkAlive());
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    private void assignWithSupplier(int NumElts, short Supplier2) {
        assert (this.checkAlive());
        assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.array[i] = Supplier2;
        }
    }

    public void assign$T(short$iterator<?> __first, short$iterator<?> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public void swap(StdVectorShort RHS) {
        assert (RHS.checkAlive());
        assert (this.checkAlive());
        short[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(short elem) {
        assert (this.checkAlive());
        return this.find(elem, 0);
    }

    public final int find(short elem, int from) {
        assert (this.checkAlive());
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq(this.array[i], elem, isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(short elem) {
        assert (this.checkAlive());
        return this.find(elem) != std.string.npos;
    }

    public final void remove_if(NativeCallback.ShortBoolPredicate predicate) {
        assert (this.checkAlive());
        if (this.empty()) {
            return;
        }
        for (int i = 0; i < this.end; ++i) {
            if (!predicate.$call(this.array[i])) continue;
            boolean res = this.erase_at(i);
            assert (res);
            --i;
        }
    }

    public final boolean erase(short elem) {
        assert (this.checkAlive());
        int index = this.find(elem);
        return this.erase_at(index);
    }

    private final boolean erase_at(int index) {
        if (index == std.string.npos) {
            return false;
        }
        assert (this.checkIndex(index));
        this.destroy_range(index, index + 1);
        if (index < this.end - 1) {
            std.copy(this.array, index + 1, this.end - index - 1, this.array, index);
        }
        this.$set(this.end - 1, this.$getDefaultVal());
        --this.end;
        return true;
    }

    public iterator erase(iterator I) {
        assert (this.checkAlive());
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.move(I.$add(1), this.end(), I, this.isDataPointerLike());
        this.pop_back();
        return N;
    }

    public iterator erase(iterator S, iterator E) {
        assert (this.checkAlive());
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = std.move(E, this.end(), S, this.isDataPointerLike());
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public iterator insert(iterator I, short Elt) {
        assert (this.checkAlive());
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward(I, this.end().$sub(1), this.end(), this.isDataPointerLike());
        I.star$ref().$set(Native.$tryAssign(I.$star(), Elt, this.isDataPointerLike()));
        return I;
    }

    public iterator insert_T$RR(iterator I, short Elt) {
        assert (this.checkAlive());
        if (I.$eq(this.end())) {
            this.push_back_T$RR(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward(I, this.end().$sub(1), this.end(), this.isDataPointerLike());
        I.star$ref().$set(Native.$tryMove(I.$star(), Elt, this.isDataPointerLike()));
        return I;
    }

    public iterator insert(iterator I, int NumToInsert, short Elt) {
        assert (this.checkAlive());
        assert (NumToInsert >= 0);
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd, this.isDataPointerLike());
            std.fill_n(I, NumToInsert, Elt);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub(I);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten), this.isDataPointerLike());
        std.fill_n(I, NumOverwritten, Elt);
        std.fill_n(OldEnd, NumToInsert - NumOverwritten, Elt);
        return I;
    }

    public final iterator insert$T(iterator I, short$iterator<?> From, short$iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public iterator insert(iterator I, short$iterator<?> From, short$iterator<?> To) {
        int NumOverwritten;
        assert (this.checkAlive());
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (NumToInsert == 0) {
            return I;
        }
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd, this.isDataPointerLike());
            std.copy(From, To, I, this.isDataPointerLike());
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten), this.isDataPointerLike());
        From = Native.$tryClone(From);
        iterator J = Native.$Clone(I);
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set(From.$star());
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, OldEnd, this.isDataPointerLike());
        return I;
    }

    public void append(short$iterator<?> in_start, short$iterator<?> in_end) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        short$iterator<?> iter = Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            ++this.end;
            this.$set(this.end - 1, iter.$star());
            iter.$preInc();
        }
    }

    public void append(int NumInputs, short Elt) {
        assert (this.checkAlive());
        assert (NumInputs >= 0);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            ++this.end;
            this.$set(this.end - 1, Elt);
        }
    }

    @Override
    public boolean $eq(std.vectorShort RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        if (this.size() != RHS.size()) {
            return false;
        }
        return std.equal(this.begin(), this.end(), RHS.begin());
    }

    @Override
    public boolean $noteq(std.vectorShort RHS) {
        return !this.$eq(RHS);
    }

    @Override
    public boolean $less(Object obj) {
        assert (this.checkAlive());
        assert (((StdVectorShort)obj).checkAlive());
        return std.lexicographical_compare(this.begin(), this.end(), ((StdVectorShort)obj).begin(), ((StdVectorShort)obj).end());
    }

    @Override
    public boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((std.vectorShort)obj);
    }

    @Override
    public short$ref ref$at(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return NativePointer.create_short$ref(this.array, idx);
    }

    public short $at(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return this.array[idx];
    }

    public short $at$Const(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return this.array[idx];
    }

    public short $set(int idx, short value) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
        this.array[idx] = value;
        return value;
    }

    protected final short $set$move(int idx, short value) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        assert (NativeTrace.assertArrayHasMutableContent(this.array, this));
        this.array[idx] = value;
        return value;
    }

    public boolean empty() {
        assert (this.checkAlive());
        return this.size() == 0;
    }

    @Override
    public void $destroy() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
        this.set$destroyed();
    }

    @Override
    public final void push_back_T$C$R(short val) {
        assert (this.checkAlive());
        this.push_back(val);
    }

    @Override
    public final void push_back_T$RR(short val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow(2 * this.capacity() + 1);
        }
        ++this.end;
        this.$set$move(this.end - 1, val);
    }

    @Override
    public void push_back(short val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow(2 * this.capacity() + 1);
        }
        ++this.end;
        this.$set(this.end - 1, val);
    }

    public final void emplace_back(short val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        int index = this.size();
        this.array[index] = val;
        this.setEnd(index + 1);
    }

    public final void emplace_back() {
        assert (this.checkAlive());
        this.push_back(this.$getDefaultVal());
    }

    public void pop_back() {
        assert (this.checkAlive());
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public short pop_back_val() {
        assert (this.checkAlive());
        short val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator begin() {
        assert (this.checkAlive());
        return new iterator(this, 0, false);
    }

    public final iterator cbegin() {
        return this.begin$Const();
    }

    public final iterator begin$Const() {
        assert (this.checkAlive());
        return this.begin();
    }

    public final iterator end() {
        assert (this.checkAlive());
        return new iterator(this, this.end, false);
    }

    public final iterator cend() {
        return this.end$Const();
    }

    public final iterator end$Const() {
        assert (this.checkAlive());
        return this.end();
    }

    public std.reverse_iteratorShort rbegin() {
        assert (this.checkAlive());
        return new std.reverse_iteratorShort(this.end());
    }

    public final std.reverse_iteratorShort rbegin$Const() {
        assert (this.checkAlive());
        return this.rbegin();
    }

    public std.reverse_iteratorShort rend() {
        assert (this.checkAlive());
        return new std.reverse_iteratorShort(this.begin());
    }

    public final std.reverse_iteratorShort rend$Const() {
        assert (this.checkAlive());
        return this.rend();
    }

    public short$ptr data() {
        assert (this.checkAlive());
        return NativePointer.create_short$ptr(this.array);
    }

    public short front() {
        assert (this.checkAlive());
        assert (this.checkIndex(0));
        return this.array[0];
    }

    public final short front$Const() {
        assert (this.checkAlive());
        return this.front();
    }

    public short back() {
        assert (this.checkAlive());
        assert (this.checkIndex(this.end - 1));
        return this.array[this.end - 1];
    }

    public final short back$Const() {
        assert (this.checkAlive());
        return this.back();
    }

    public short$ref ref$front() {
        return new short$ref(){
            private final short stored;
            private final int index = 0;
            {
                assert (StdVectorShort.this.checkAlive());
                assert (StdVectorShort.this.checkIndex(0));
                this.stored = StdVectorShort.this.array[0];
                this.index = 0;
            }

            @Override
            public short $deref() {
                assert (StdVectorShort.this.checkAlive());
                assert (StdVectorShort.this.checkIndex(0));
                return this.stored;
            }

            @Override
            public short $set(short value) {
                assert (StdVectorShort.this.checkAlive());
                assert (StdVectorShort.this.checkIndex(0));
                assert (NativeTrace.assertArrayHasMutableContent(StdVectorShort.this.array, this));
                StdVectorShort.this.array[0] = value;
                return value;
            }

            @Override
            public short$ptr deref$ptr() {
                assert (StdVectorShort.this.checkAlive());
                assert (StdVectorShort.this.checkIndex(0));
                return (short$ptr)StdVectorShort.this.data().$add(0);
            }
        };
    }

    public short$ref ref$back() {
        return new short$ref(){
            private final short stored;
            private final int index;
            {
                assert (StdVectorShort.this.checkAlive());
                assert (StdVectorShort.this.checkIndex(StdVectorShort.this.end - 1));
                this.stored = StdVectorShort.this.array[StdVectorShort.this.end - 1];
                this.index = StdVectorShort.this.end - 1;
            }

            @Override
            public short $deref() {
                assert (StdVectorShort.this.checkAlive());
                assert (StdVectorShort.this.checkIndex(this.index));
                return this.stored;
            }

            @Override
            public short $set(short value) {
                assert (StdVectorShort.this.checkAlive());
                assert (StdVectorShort.this.checkIndex(this.index));
                assert (NativeTrace.assertArrayHasMutableContent(StdVectorShort.this.array, this));
                StdVectorShort.this.array[this.index] = value;
                return value;
            }

            @Override
            public short$ptr deref$ptr() {
                assert (StdVectorShort.this.checkAlive());
                assert (StdVectorShort.this.checkIndex(this.index));
                return (short$ptr)StdVectorShort.this.data().$add(this.index);
            }
        };
    }

    @Override
    public int size() {
        assert (this.checkAlive());
        return this.end;
    }

    public int max_size() {
        assert (this.checkAlive());
        return Integer.MAX_VALUE;
    }

    public int capacity() {
        assert (this.checkAlive());
        return this.array.length;
    }

    @Override
    public int $sizeof() {
        int oneElemSize = NativeType.sizeof(this.defaultValue);
        for (short elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof(elem);
            break;
        }
        return this.capacity() * oneElemSize;
    }

    public short$ptr ptr$at(int idx) {
        assert (this.checkAlive());
        assert (this.checkIndex(idx));
        return NativePointer.create_short$ptr(this.array, idx);
    }

    @Override
    public std.vectorShort clone() {
        assert (this.checkAlive());
        std.vectorShort out = new std.vectorShort((std.vectorShort)this);
        assert (this.getClass() == out.getClass()) : "forgot to override clone in " + out.getClass();
        return out;
    }

    @Override
    public std.vectorShort move() {
        assert (this.checkAlive());
        std.vectorShort out = new std.vectorShort(JavaDifferentiators.JD.Move.INSTANCE, (std.vectorShort)this);
        assert (this.getClass() == out.getClass()) : "forgot to override move in " + out.getClass();
        return out;
    }

    public void set_size(int N) {
        assert (this.checkAlive());
        assert (N >= 0);
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    protected void grow(int newSize) {
        this.array = NativePointer.copyOf$short(this.array, newSize);
    }

    private void grow() {
        this.grow(this.capacity() > 0 ? this.capacity() * 2 : 1);
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<Short> iterator() {
        assert (this.checkAlive());
        return new JavaIteratorShort(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        String arrName = NativeTrace.getArrayName(this.array);
        if (this.end == 0) {
            return arrName + (super.is$destroyed() ? "DESTROYED " : "") + "<EMPTY>";
        }
        StringBuilder out = new StringBuilder(arrName);
        if (super.is$destroyed()) {
            out.append("DESTROYED");
        }
        out.append("\n").append(this.getClass().getSimpleName()).append("{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            short element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}").append(this.getClass().getSimpleName()).append("}\n");
        return out.toString();
    }

    private short $getDefaultVal() {
        return this.defaultValue;
    }

    protected final boolean checkIndex(int index) {
        assert (index < this.end) : "invalid index " + index + " when size is " + this.end;
        return true;
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }

    public static final class iterator
    implements short$iterator<iterator>,
    Native.assignable<iterator>,
    NativeMoveable<iterator>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final StdVectorShort delegate;
        private int index;

        public iterator(StdVectorShort delegate, int index, boolean makeConst) {
            assert (delegate.checkAlive());
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator(iterator other) {
            assert (other.delegate.checkAlive());
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        public iterator(JavaDifferentiators.JD.Move _dparam, iterator other) {
            assert (other.delegate.checkAlive());
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        @Override
        public iterator $assign(iterator other) {
            assert (this.delegate.checkAlive());
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        @Override
        public iterator $assignMove(iterator other) {
            assert (this.delegate.checkAlive());
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        @Override
        public short $arrow() {
            assert (this.delegate.checkAlive());
            return this.$at(0);
        }

        @Override
        public short $star() {
            assert (this.delegate.checkAlive());
            return this.$at(0);
        }

        @Override
        public short$ref star$ref() {
            assert (this.delegate.checkAlive());
            return this.ref$at(0);
        }

        @Override
        public int $sub(iterator iter) {
            assert (this.delegate.checkAlive());
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        @Override
        public iterator $preInc() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            ++this.index;
            return this;
        }

        @Override
        public iterator $preDec() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            --this.index;
            return this;
        }

        @Override
        public iterator $postInc() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        @Override
        public iterator $postDec() {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        @Override
        public iterator $inc(int amount) {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            this.index += amount;
            return this;
        }

        @Override
        public iterator $dec(int amount) {
            assert (this.delegate.checkAlive());
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        @Override
        public iterator $add(int amount) {
            assert (this.delegate.checkAlive());
            return new iterator(this.delegate, this.index + amount, false);
        }

        @Override
        public iterator $sub(int amount) {
            assert (this.delegate.checkAlive());
            return new iterator(this.delegate, this.index - amount, false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate.checkAlive());
            assert (((iterator)other).delegate.checkAlive());
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate.checkAlive());
            assert (((iterator)other).delegate.checkAlive());
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        @Override
        public iterator move() {
            assert (this.delegate.checkAlive());
            return new iterator(JavaDifferentiators.JD.Move.INSTANCE, this);
        }

        @Override
        public iterator clone() {
            assert (this.delegate.checkAlive());
            return new iterator(this.delegate, this.index, false);
        }

        @Override
        public iterator const_clone() {
            assert (this.delegate.checkAlive());
            return new iterator(this.delegate, this.index, true);
        }

        @Override
        public boolean $less(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        @Override
        public boolean $lesseq(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        @Override
        public boolean $greater(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        @Override
        public boolean $greatereq(Object obj) {
            assert (this.delegate.checkAlive());
            assert (((iterator)obj).delegate.checkAlive());
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public short $at(int index) {
            assert (this.delegate.checkAlive());
            return this.delegate.$at(this.index + index);
        }

        public short$ref ref$at(int index) {
            assert (this.delegate.checkAlive());
            return this.delegate.ref$at(this.index + index);
        }

        public short$ptr toPointer() {
            assert (this.delegate.checkAlive());
            return NativePointer.create_short$ptr(this.delegate.array, this.index);
        }

        public int $index() {
            assert (this.delegate.checkAlive());
            assert (this.delegate.checkIndex(this.index));
            return this.index;
        }

        public String toString() {
            return "[" + (this.delegate.is$destroyed() ? "DESTROYED " : "") + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

