/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.clank.java.std;
import org.clank.java.std_map;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.int$ptr;
import org.clank.support.aliases.int$ref;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public abstract class StdMapTypeInt<KeyT>
extends NativeTrace.CreateDestroy.Tracker
implements Native.NativePOD<std_map.mapTypeInt<KeyT>>,
Iterable<std_pair.pairTypeInt<KeyT>>,
Destructors.ClassWithDestructor {
    protected int defaultValue;
    protected TreeMap<KeyT, std_pair.pairTypeInt<KeyT>> treeMap;

    protected StdMapTypeInt(int defaultValue) {
        this(null, defaultValue);
    }

    protected StdMapTypeInt(Comparator<KeyT> comparator, int defaultValue) {
        if (comparator == null) {
            comparator = Native::$compare_type;
        }
        this.treeMap = new TreeMap(comparator);
        this.defaultValue = defaultValue;
    }

    protected StdMapTypeInt(std_map.mapTypeInt<KeyT> other) {
        this(other.treeMap.comparator(), other.defaultValue);
        this.$assign(other);
    }

    protected StdMapTypeInt(JavaDifferentiators.JD.Move _dparam, std_map.mapTypeInt<KeyT> other) {
        this(other.treeMap.comparator(), other.defaultValue);
        this.$assign(other);
        other.$destroy();
        other.treeMap = null;
    }

    public Comparator<? super KeyT> keyComparator() {
        return this.treeMap.comparator();
    }

    @Override
    public std_map.mapTypeInt<KeyT> $assign(std_map.mapTypeInt<KeyT> other) {
        assert (other.checkAlive());
        assert (this.checkAlive());
        this.clear();
        for (Map.Entry entry : other.treeMap.entrySet()) {
            this.treeMap.put(this.$cloneKeyIfNeed(entry.getKey()), Native.$Clone((std_pair.pairTypeInt)entry.getValue()));
        }
        return (std_map.mapTypeInt)this;
    }

    public void swap(std_map.mapTypeInt<KeyT> other) {
        assert (other.checkAlive());
        assert (this.checkAlive());
        TreeMap<KeyT, std_pair.pairTypeInt<KeyT>> tmpMap = this.treeMap;
        this.treeMap = other.treeMap;
        other.treeMap = tmpMap;
        int tmpDefVal = this.defaultValue;
        this.defaultValue = other.defaultValue;
        other.defaultValue = tmpDefVal;
    }

    public int $at_T$C$R(KeyT key) {
        assert (this.checkAlive());
        return this.$at(key);
    }

    public int $at_T$RR(KeyT key) {
        assert (this.checkAlive());
        return this.$at(key);
    }

    public int $at(KeyT key) {
        assert (this.checkAlive());
        std_pair.pairTypeInt<KeyT> out = this.treeMap.get(key);
        if (out == null) {
            out = std.make_pair_T_int(this.$cloneKeyIfNeed(key), this.$cloneValIfNeed(this.defaultValue));
            this.treeMap.put(this.$cloneKeyIfNeed(key), out);
        }
        return out.second;
    }

    public void $set(KeyT key, int val) {
        assert (this.checkAlive());
        this.treeMap.put(this.$cloneKeyIfNeed(key), std.make_pair_T_int(this.$cloneKeyIfNeed(key), this.$cloneValIfNeed(val)));
    }

    public int$ref ref$at(final KeyT key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            this.treeMap.put(this.$cloneKeyIfNeed(key), std.make_pair_T_int(this.$cloneKeyIfNeed(key), this.$cloneValIfNeed(this.defaultValue)));
        }
        return new int$ref(){

            @Override
            public int $deref() {
                assert (StdMapTypeInt.this.checkAlive());
                return StdMapTypeInt.this.treeMap.get((Object)key).second;
            }

            @Override
            public int $set(int value) {
                assert (StdMapTypeInt.this.checkAlive());
                StdMapTypeInt.this.treeMap.get((Object)key).second = Native.$tryAssign(StdMapTypeInt.this.treeMap.get((Object)key).second, value, StdMapTypeInt.this.isDataPointerLike());
                return value;
            }

            @Override
            public int$ptr deref$ptr() {
                assert (StdMapTypeInt.this.checkAlive());
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public int size() {
        assert (this.checkAlive());
        return this.treeMap.size();
    }

    public boolean empty() {
        assert (this.checkAlive());
        return this.treeMap.isEmpty();
    }

    public void clear() {
        assert (this.checkAlive());
        if (!this.isKeyPointerLike() || !this.isDataPointerLike()) {
            for (Map.Entry<KeyT, std_pair.pairTypeInt<KeyT>> entry : this.treeMap.entrySet()) {
                if (!this.isKeyPointerLike()) {
                    Native.destroy(entry.getKey());
                }
                Native.destroy(entry.getValue());
            }
        }
        this.treeMap.clear();
    }

    public std_pair.pairTypeBool<iterator<KeyT>> insert$T$RR(std_pair.pairTypeInt<KeyT> val) {
        assert (this.checkAlive());
        Object Key = this.$cloneKeyIfNeed(val.first);
        boolean newElement = !this.treeMap.containsKey(Key);
        this.treeMap.put(Key, Native.$Move(val));
        return std.make_pair_Ptr_bool(this.find(Key), newElement);
    }

    public final std_pair.pairTypeBool<iterator<KeyT>> insert$T(std_pair.pairTypeInt<KeyT> val) {
        assert (this.checkAlive());
        return this.insert(val);
    }

    public std_pair.pairTypeBool<iterator<KeyT>> insert(std_pair.pairTypeInt<KeyT> val) {
        assert (this.checkAlive());
        boolean newElement = !this.treeMap.containsKey(val.first);
        this.treeMap.put(this.$cloneKeyIfNeed(val.first), Native.$Clone(val));
        return std.make_pair_Ptr_bool(this.find(val.first), newElement);
    }

    public void insert(type$iterator<?, std_pair.pairTypeInt<KeyT>> I, type$iterator<?, std_pair.pairTypeInt<KeyT>> E) {
        assert (this.checkAlive());
        while (Native.$noteq_iter(I, E)) {
            std_pair.pairTypeInt<KeyT> val = I.$star();
            this.treeMap.put(this.$cloneKeyIfNeed(val.first), Native.$Clone(val));
            I.$preInc();
        }
    }

    public void erase(iterator<KeyT> position) {
        assert (this.checkAlive());
        Native.destroy((Destructors.ClassWithDestructor)position.$star());
        ((iterator)position).erase();
    }

    public boolean erase(KeyT key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            return false;
        }
        Map.Entry<KeyT, std_pair.pairTypeInt<KeyT>> entry = this.treeMap.ceilingEntry(key);
        if (!this.isKeyPointerLike()) {
            Native.destroy(entry.getKey());
        }
        Native.destroy(entry.getValue());
        this.treeMap.remove(key);
        return true;
    }

    public iterator<KeyT> lower_bound(KeyT key) {
        assert (this.checkAlive());
        KeyT lowerBoundKey = this.treeMap.ceilingKey(key);
        return lowerBoundKey != null ? this.find(lowerBoundKey) : this.end();
    }

    public iterator<KeyT> upper_bound(KeyT key) {
        assert (this.checkAlive());
        KeyT upperBoundKey = this.treeMap.higherKey(key);
        return upperBoundKey != null ? this.find(upperBoundKey) : this.end();
    }

    public iterator<KeyT> begin$Const() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, this.treeMap.firstEntry(), this.defaultValue, true);
    }

    public iterator<KeyT> end$Const() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, null, this.defaultValue, true);
    }

    public iterator<KeyT> begin() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, this.treeMap.firstEntry(), this.defaultValue, false);
    }

    public iterator<KeyT> end() {
        assert (this.checkAlive());
        return new iterator(this.treeMap, null, this.defaultValue, false);
    }

    @Override
    public Iterator<std_pair.pairTypeInt<KeyT>> iterator() {
        assert (this.checkAlive());
        return new JavaIterator<std_pair.pairTypeInt<KeyT>>(this.begin(), this.end());
    }

    public boolean count(KeyT key) {
        assert (this.checkAlive());
        return this.treeMap.containsKey(key);
    }

    public boolean replaceValueReference(KeyT key, int val) {
        assert (this.checkAlive());
        std_pair.pairTypeInt<KeyT> entry = this.treeMap.get(key);
        assert (entry != null) : "must be called only for existing entry " + key + " => " + val;
        entry.second = val;
        return true;
    }

    public final iterator<KeyT> find$Const(KeyT key) {
        assert (this.checkAlive());
        return this.find(key);
    }

    public iterator<KeyT> find(KeyT key) {
        assert (this.checkAlive());
        if (!this.treeMap.containsKey(key)) {
            return this.end();
        }
        return new iterator(this.treeMap, this.treeMap.ceilingEntry(key), this.defaultValue, false);
    }

    @Override
    public boolean $eq(std_map.mapTypeInt<KeyT> other) {
        if (this.size() != other.size()) {
            return false;
        }
        return std.equal(this.begin(), this.end(), other.begin(), false);
    }

    @Override
    public std_map.mapTypeInt<KeyT> clone() {
        assert (this.checkAlive());
        std_map.mapTypeInt out = new std_map.mapTypeInt((std_map.mapTypeInt)this);
        assert (this.getClass() == out.getClass()) : "forgot to override clone in " + out.getClass();
        return out;
    }

    @Override
    public void $destroy() {
        assert (this.checkAlive());
        this.clear();
        super.set$destroyed();
    }

    private boolean isKeyPointerLike() {
        return false;
    }

    private KeyT $cloneKeyIfNeed(KeyT Key) {
        return this.isKeyPointerLike() ? Key : Native.$tryClone(Key);
    }

    private boolean isDataPointerLike() {
        return false;
    }

    private int $cloneValIfNeed(int Val) {
        return this.isDataPointerLike() ? Val : Native.$tryClone(Val);
    }

    public String toString() {
        return "StdMapTypeInt " + (super.is$destroyed() ? "DESTROYED" : "") + "{" + this.treeMap + "}";
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }

    public static class iterator<KeyT>
    implements type$iterator<iterator<KeyT>, std_pair.pairTypeInt<KeyT>> {
        private final int defaultValue;
        private final TreeMap<KeyT, std_pair.pairTypeInt<KeyT>> map;
        private final boolean _const;
        private Map.Entry<KeyT, std_pair.pairTypeInt<KeyT>> currentEntry;

        public iterator(iterator<KeyT> other) {
            this.defaultValue = Native.$tryClone(other.defaultValue);
            this.map = Native.$tryClone(other.map);
            this.currentEntry = Native.$tryClone(other.currentEntry);
            this._const = other._const;
        }

        public iterator(JavaDifferentiators.JD.Move _dparam, iterator<KeyT> other) {
            this.defaultValue = other.defaultValue;
            this.map = other.map;
            this.currentEntry = other.currentEntry;
            this._const = other._const;
        }

        private iterator(TreeMap<KeyT, std_pair.pairTypeInt<KeyT>> map, Map.Entry<KeyT, std_pair.pairTypeInt<KeyT>> curr, int defaultValue, boolean asConst) {
            this.defaultValue = defaultValue;
            this.map = map;
            this.currentEntry = curr;
            this._const = asConst;
        }

        private KeyT getKey() {
            return this.currentEntry.getKey();
        }

        private void erase() {
            this.map.remove(this.currentEntry.getKey());
        }

        @Override
        public std_pair.pairTypeInt<KeyT> $arrow() {
            return this.currentEntry.getValue();
        }

        @Override
        public std_pair.pairTypeInt<KeyT> $star() {
            return this.currentEntry.getValue();
        }

        @Override
        public type$ref<std_pair.pairTypeInt<KeyT>> star$ref() {
            return new type$ref<std_pair.pairTypeInt<KeyT>>(){
                private final Map.Entry<KeyT, std_pair.pairTypeInt<KeyT>> localEntry;
                {
                    this.localEntry = currentEntry;
                }

                @Override
                public std_pair.pairTypeInt<KeyT> $deref() {
                    return this.localEntry.getValue();
                }

                @Override
                public std_pair.pairTypeInt<KeyT> $set(std_pair.pairTypeInt<KeyT> value) {
                    assert (map.comparator().compare(value.first, this.localEntry.getKey()) == 0) : "Trying to change key of entry via iterator!";
                    this.localEntry.getValue().second = Native.$tryAssign(this.localEntry.getValue().second, value.second, this.isDataPointerLike());
                    return value;
                }

                @Override
                public type$ptr<std_pair.pairTypeInt<KeyT>> deref$ptr() {
                    throw new UnsupportedOperationException("Not supported.");
                }
            };
        }

        @Override
        public iterator<KeyT> $preInc() {
            this.currentEntry = this.map.higherEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<KeyT> $postInc() {
            iterator cloned = Native.$Clone(this);
            this.$preInc();
            return cloned;
        }

        @Override
        public iterator<KeyT> clone() {
            return new iterator<KeyT>(this.map, this.currentEntry, this.defaultValue, false);
        }

        @Override
        public iterator<KeyT> const_clone() {
            return new iterator<KeyT>(this.map, this.currentEntry, this.defaultValue, true);
        }

        public boolean $eq(Object other) {
            if (other instanceof iterator) {
                iterator otherIter = (iterator)other;
                if (otherIter.map == this.map) {
                    if (otherIter.currentEntry == null) {
                        return this.currentEntry == null;
                    }
                    if (this.currentEntry == null) {
                        return otherIter.currentEntry == null;
                    }
                    return Native.$eq(otherIter.currentEntry.getKey(), this.currentEntry.getKey());
                }
            }
            return false;
        }

        public boolean $noteq(Object other) {
            return !this.$eq(other);
        }

        @Override
        public int $sub(iterator<KeyT> iter) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT> $preDec() {
            this.currentEntry = this.currentEntry == null ? this.map.lastEntry() : this.map.lowerEntry(this.currentEntry.getKey());
            return this;
        }

        @Override
        public iterator<KeyT> $postDec() {
            iterator cloned = Native.$Clone(this);
            this.$preDec();
            return cloned;
        }

        @Override
        public iterator<KeyT> $inc(int amount) {
            if (amount == 0) {
                return this;
            }
            if (amount > 0) {
                do {
                    this.$preInc();
                } while (--amount > 0);
                return this;
            }
            return this.$dec(-amount);
        }

        @Override
        public iterator<KeyT> $dec(int amount) {
            if (amount == 0) {
                return this;
            }
            if (amount > 0) {
                do {
                    this.$preDec();
                } while (--amount > 0);
                return this;
            }
            return this.$inc(-amount);
        }

        @Override
        public iterator<KeyT> $add(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public iterator<KeyT> $sub(int amount) {
            throw new UnsupportedOperationException("Not supported.");
        }

        private boolean isDataPointerLike() {
            return false;
        }
    }
}

