/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.JavaIterator;

public abstract class StdTuple
implements NativeCloneable<std.tuple>,
Native.NativeComparable<std.tuple>,
Native.assignable<std.tuple>,
Iterable<Object> {
    private boolean isDataPointerLike;
    private Object[] elements;

    public StdTuple(StdTuple other) {
        this.isDataPointerLike = other.isDataPointerLike;
        this.elements = other.elements;
    }

    public StdTuple(Object ... elements) {
        this(false, elements);
    }

    public StdTuple(boolean isDataPointerLike, Object ... elements) {
        this.isDataPointerLike = isDataPointerLike;
        this.elements = elements;
    }

    @Override
    public std.tuple clone() {
        return new std.tuple(this.isDataPointerLike, this.elements);
    }

    @Override
    public std.tuple $assign(std.tuple value) {
        if (this == value) {
            return value;
        }
        this.isDataPointerLike = value.isDataPointerLike;
        if (this.elements.length == value.elements.length) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i] = Native.$tryAssign(this.elements[i], value.elements[i], this.isDataPointerLike);
            }
        }
        throw new AssertionError((Object)"Tuples of different sizes (and types) are not assignable!");
    }

    @Override
    public boolean $noteq(std.tuple other) {
        return !this.$eq(other);
    }

    @Override
    public boolean $eq(std.tuple other) {
        if (this.isDataPointerLike != other.isDataPointerLike) {
            return false;
        }
        if (this.elements.length == other.elements.length) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (Native.$eq(this.elements[i], other.elements[i], this.isDataPointerLike)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object $getAt(int idx) {
        return this.elements[idx];
    }

    public Object[] $get() {
        Object[] res = new Object[this.elements.length];
        System.arraycopy(this.elements, 0, res, 0, this.elements.length);
        return res;
    }

    @Override
    public Iterator<Object> iterator() {
        return new JavaIterator<Object>(NativePointer.create_type$ptr(this.elements), NativePointer.create_type$ptr(this.elements, this.elements == null ? 0 : this.elements.length));
    }
}

