/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl;

import java.security.InvalidParameterException;
import org.clank.java.std;
import org.clank.java.stdimpl.StdBaseBitset;
import org.clank.support.Native;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.ushort$ref;

public class StdBitset
extends StdBaseBitset
implements Native.NativeComparable<std.bitset> {
    private final int _Nb;

    public boolean $at$Const(int value) {
        return this.test(value);
    }

    public boolean $at(int value) {
        return this.test(value);
    }

    protected StdBitset(StdBitset $Prm0) {
        super($Prm0);
        this._Nb = $Prm0._Nb;
    }

    protected StdBitset(int _Nb) {
        super(StdBitset._GLIBCXX_BITSET_WORDS(_Nb));
        this._Nb = _Nb;
    }

    protected StdBitset(int _Nb, char __val) {
        super(StdBitset._GLIBCXX_BITSET_WORDS(_Nb), __val);
        this._Nb = _Nb;
    }

    protected StdBitset(int _Nb, std.string __s) {
        this(_Nb, __s, 0);
    }

    protected StdBitset(int _Nb, std.string __s, int __position) {
        super(StdBitset._GLIBCXX_BITSET_WORDS(_Nb));
        this._Nb = _Nb;
        if (__position > __s.size()) {
            throw new RuntimeException("bitset::bitset initial position not valid");
        }
        this._M_copy_from_string(__s, __position, std.string.npos, '0', '1');
    }

    public std.bitset set() {
        this._M_do_set();
        this._M_do_sanitize();
        return (std.bitset)this;
    }

    public std.bitset set(byte __position) {
        return this.set(__position & 0xFF, true);
    }

    public std.bitset set(byte __position, boolean __val) {
        return this.set(__position & 0xFF, __val);
    }

    public std.bitset set(int __position) {
        return this.set(__position, true);
    }

    public std.bitset set(int __position, boolean __val) {
        assert (__position >= 0) : "must be unsigned " + __position;
        if (__position >= this._Nb) {
            throw new RuntimeException("Overflow!");
        }
        return this._Unchecked_set(__position, __val ? 1 : 0);
    }

    public std.bitset reset() {
        this._M_do_reset();
        return (std.bitset)this;
    }

    public std.bitset reset(byte __position) {
        return this.reset(__position & 0xFF);
    }

    public std.bitset reset(int __position) {
        assert (__position >= 0) : "must be unsigned " + __position;
        if (__position >= this._Nb) {
            throw new RuntimeException("Overflow!");
        }
        return this._Unchecked_reset(__position);
    }

    public std.bitset flip() {
        this._M_do_flip();
        this._M_do_sanitize();
        return (std.bitset)this;
    }

    public std.bitset flip(byte __position) {
        return this.flip(__position & 0xFF);
    }

    public std.bitset flip(int __position) {
        assert (__position >= 0) : "must be unsigned " + __position;
        if (__position >= this._Nb) {
            throw new RuntimeException("Overflow!");
        }
        return this._Unchecked_flip(__position);
    }

    public int count() {
        return this._M_do_count();
    }

    public int size() {
        return this._Nb;
    }

    @Override
    public boolean $eq(std.bitset other) {
        return this._M_is_equal(other);
    }

    @Override
    public boolean $noteq(std.bitset other) {
        return !this._M_is_equal(other);
    }

    public void $andassign(std.bitset other) {
        this._M_do_and(other);
    }

    public void $orassign(std.bitset other) {
        this._M_do_or(other);
    }

    public static std.bitset $bitand_bitset$_Nb$C(std.bitset b1, std.bitset b2) {
        std.bitset res = new std.bitset(b1.size());
        res._M_do_or(b1);
        res._M_do_and(b2);
        return res;
    }

    public std.bitset $bitnot() {
        std.bitset res = new std.bitset(this._Nb);
        res._M_do_or(this);
        return res;
    }

    public boolean test(byte __position) {
        return this.test(__position & 0xFF);
    }

    public boolean test(int __position) {
        assert (__position >= 0) : "must be unsigned " + __position;
        if (__position >= this._Nb) {
            throw new RuntimeException("Overflow!");
        }
        return this._Unchecked_test(__position);
    }

    public boolean all() {
        return this._M_are_all(this._Nb);
    }

    public boolean any() {
        return this._M_is_any();
    }

    public boolean none() {
        return !this._M_is_any();
    }

    public String toString() {
        std.string tmp = new std.string();
        this._M_copy_to_string(tmp, '0', '1');
        return tmp.toJavaString();
    }

    protected std.bitset _Unchecked_set(int __pos) {
        this._M_getword$ref(__pos).$set((char)(this._M_getword(__pos) | StdBaseBitset._S_maskbit(__pos)));
        return (std.bitset)this;
    }

    protected std.bitset _Unchecked_set(int __pos, int __val) {
        if (__val != 0) {
            this._M_getword$ref(__pos).$set((char)(this._M_getword(__pos) | StdBaseBitset._S_maskbit(__pos)));
        } else {
            this._M_getword$ref(__pos).$set((char)(this._M_getword(__pos) & ~StdBaseBitset._S_maskbit(__pos)));
        }
        return (std.bitset)this;
    }

    protected std.bitset _Unchecked_reset(int __pos) {
        this._M_getword$ref(__pos).$set((char)(this._M_getword(__pos) & ~StdBaseBitset._S_maskbit(__pos)));
        return (std.bitset)this;
    }

    protected std.bitset _Unchecked_flip(int __pos) {
        this._M_getword$ref(__pos).$set((char)(this._M_getword(__pos) ^ StdBaseBitset._S_maskbit(__pos)));
        return (std.bitset)this;
    }

    protected boolean _Unchecked_test(int __pos) {
        return (this._M_getword(__pos) & StdBaseBitset._S_maskbit(__pos)) != 0;
    }

    private void _M_do_sanitize() {
        _Sanitize __sanitize_type = new _Sanitize(this._Nb % 16);
        __sanitize_type._S_do_sanitize(this._M_hiword$ref());
    }

    private void _M_copy_from_string(std.string __s, int __pos, int __n, char __zero, char __one) {
        this._M_copy_from_string(__s, __pos, __n, (byte)__zero, (byte)__one);
    }

    private void _M_copy_from_string(std.string __s, int __pos, int __n, byte __zero, byte __one) {
        this._M_copy_from_ptr(__s.data(), __s.size(), __pos, __n, __zero, __one);
    }

    private void _M_copy_from_ptr(char$ptr __s, int __len, int __pos, int __n, char __zero, char __one) {
        this._M_copy_from_ptr(__s, __len, __pos, __n, (byte)__zero, (byte)__one);
    }

    private void _M_copy_from_ptr(char$ptr __s, int __len, int __pos, int __n, byte __zero, byte __one) {
        int __nbits;
        this.reset();
        for (int __i = __nbits = std.min(this._Nb, std.min(__n, __len - __pos)); __i > 0; --__i) {
            byte __c = __s.$at(__pos + __nbits - __i);
            if (Native.$eq(__c, __zero)) continue;
            if (Native.$eq(__c, __one)) {
                this._Unchecked_set(__i - 1);
                continue;
            }
            throw new InvalidParameterException("Not 'one' or 'zero' character found!");
        }
    }

    private void _M_copy_to_string(std.string __s, char __zero, char __one) {
        this._M_copy_to_string(__s, (byte)__zero, (byte)__one);
    }

    private void _M_copy_to_string(std.string __s, byte __zero, byte __one) {
        __s.assign(this._Nb, __zero);
        for (int __i = this._Nb; __i > 0; --__i) {
            if (!this._Unchecked_test(__i - 1)) continue;
            __s.$set(this._Nb - __i, __one);
        }
    }

    private static int _GLIBCXX_BITSET_WORDS(int __n) {
        return __n / 16 + (__n % 16 == 0 ? 0 : 1);
    }

    private static class _Sanitize {
        private final int _Extrabits;

        public _Sanitize(int _Extrabits) {
            this._Extrabits = _Extrabits;
        }

        public void _S_do_sanitize(ushort$ref __val) {
            __val.$set((char)(__val.$deref() & ~(-1 << this._Extrabits)));
        }
    }
}

