/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativeSwappable;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.NativeContainer;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ref;
import org.clank.support.type$ptr$inout;

public interface std_list {

    public static class list<E>
    implements Iterable<E>,
    Destructors.ClassWithDestructor,
    NativeCloneable<list<E>>,
    NativeMoveable<list<E>>,
    NativeContainer<E>,
    NativeSwappable,
    Native.NativeComparable<list<E>> {
        private final Supplier<E> defaultValue;
        private transient int size = 0;
        private transient Node<E> first;
        private transient Node<E> last;

        public list() {
            this(std.getSupplier(null));
        }

        public list(E defaultValue) {
            this(std.getSupplier(defaultValue));
        }

        public list(Supplier<E> defaultValue) {
            this.defaultValue = defaultValue;
        }

        public list(int __n, E __value, Supplier<E> defaultValue) {
            this(defaultValue);
            while (--__n >= 0) {
                super.linkLast(super.$cloneIfNeeded(__value));
            }
        }

        public list(list<E> __x) {
            this(__x.defaultValue);
            for (E elem : __x) {
                super.linkLast(super.$cloneIfNeeded(elem));
            }
        }

        public list(JavaDifferentiators.JD.Move _dparam, list<E> other) {
            this(other.defaultValue);
            this.swap(other);
        }

        public list(type$iterator<?, E> __first, type$iterator<?, E> __last, Supplier<E> defaultValue) {
            this(defaultValue);
            type$iterator<?, E> B = Native.$tryClone(__first);
            type$iterator<?, E> E = __last;
            while (B.$noteq(E)) {
                super.linkLast(super.$cloneIfNeeded(B.$star()));
                B.$preInc();
            }
        }

        public list<E> $assign(list<E> other) {
            this.clear();
            this.insert$T(this.end(), other.begin(), other.end());
            return this;
        }

        public final list<E> $assignMove(list<E> other) {
            this.clear();
            this.swap(other);
            return this;
        }

        @Override
        public void push_back(E val) {
            this.linkLast(Native.$tryClone(val));
        }

        @Override
        public void push_back_T$C$R(E val) {
            this.linkLast(Native.$tryClone(val));
        }

        @Override
        public void push_back_T$RR(E val) {
            this.linkLast(Native.$tryMove(val));
        }

        public void push_front_T$RR(E val) {
            this.linkFirst(Native.$tryMove(val));
        }

        public void remove_if(NativeCallback.BoolPredicate<E> predicate) {
            Node<E> cur = this.first;
            while (cur != null) {
                Node next = cur.next;
                if (predicate.$call(cur.item)) {
                    this.$destroyIfNeeded(this.unlink(cur));
                }
                cur = next;
            }
        }

        public E front() {
            return this.getFirst();
        }

        public E front$Const() {
            return this.getFirst();
        }

        public E back() {
            return this.getLast();
        }

        public E back$Const() {
            return this.getLast();
        }

        public void emplace_back() {
            this.push_back(this.$getDefaultVal());
        }

        public void emplace_back(E val) {
            this.linkLast(val);
        }

        public void pop_back() {
            this.$destroyIfNeeded(this.removeLast());
        }

        public void pop_front() {
            this.$destroyIfNeeded(this.removeFirst());
        }

        public iterator<E> erase(iterator<E> __position) {
            assert (((iterator)__position).lst == this);
            abstract_iterator next = ((iterator)__position.clone()).$preInc();
            this.$destroyIfNeeded(this.unlink(((iterator)__position).current));
            return next;
        }

        public iterator<E> erase(iterator<E> __first, iterator<E> __last) {
            while (__first.$noteq(__last)) {
                __first = this.erase(__first);
            }
            return __last;
        }

        public void insert$T(iterator<E> position, type$iterator<?, E> begin, type$iterator<?, E> end) {
            assert (((iterator)position).lst == this);
            type$iterator<?, E> cur = Native.$Clone(begin);
            while (cur.$noteq(end)) {
                E toInsert = this.$cloneIfNeeded(cur.$star());
                if (((iterator)position).current == null) {
                    this.linkLast(toInsert);
                } else {
                    this.linkBefore(toInsert, ((iterator)position).current);
                }
                cur.$preInc();
            }
        }

        public iterator<E> insert__List_const_iterator$_Tp_T$C$R(iterator<E> position, E val) {
            assert (((iterator)position).lst == this);
            E toInsert = this.$cloneIfNeeded(val);
            if (((iterator)position).current == null) {
                this.linkLast(toInsert);
            } else {
                this.linkBefore(toInsert, ((iterator)position).current);
            }
            return position;
        }

        public iterator<E> insert__List_const_iterator$_Tp_T$RR(iterator<E> position, E val) {
            assert (((iterator)position).lst == this);
            E toInsert = this.$moveIfNeeded(val);
            if (((iterator)position).current == null) {
                this.linkLast(toInsert);
            } else {
                this.linkBefore(toInsert, ((iterator)position).current);
            }
            return position;
        }

        public iterator<E> begin() {
            return new iterator(this, this.first);
        }

        public iterator<E> end() {
            return new iterator(this, null);
        }

        public iterator<E> begin$Const() {
            return new iterator(this, this.first);
        }

        public iterator<E> end$Const() {
            return new iterator(this, null);
        }

        public std.reverse_iterator<E> rbegin() {
            return new std.reverse_iterator(this.end());
        }

        public std.reverse_iterator<E> rend() {
            return new std.reverse_iterator(this.begin());
        }

        public boolean empty() {
            return this.size() == 0;
        }

        public void sort(std.Compare<E> compare) {
            std.sort(this.begin(), this.end(), compare);
        }

        public void sort$T(std.Compare<E> compare) {
            std.sort(this.begin(), this.end(), compare);
        }

        @Override
        public boolean $eq(list<E> other) {
            if (this.size() != other.size()) {
                return false;
            }
            if (this.$isPointerLike() != super.$isPointerLike()) {
                return false;
            }
            return std.equal(this.begin(), this.end(), other.begin(), this.$isPointerLike());
        }

        @Override
        public boolean $noteq(list<E> other) {
            return !this.$eq(other);
        }

        @Override
        public void swap(NativeSwappable RHS) {
            list other = (list)RHS;
            assert (this.$isPointerLike() == other.$isPointerLike());
            Node<E> tmp = this.first;
            this.first = other.first;
            other.first = tmp;
            tmp = this.last;
            this.last = other.last;
            other.last = tmp;
            int tmpSize = this.size;
            this.size = other.size;
            other.size = tmpSize;
        }

        public int size() {
            return this.size;
        }

        public void clear() {
            if (!this.$isPointerLike()) {
                for (E elem : this) {
                    Destructors.$destroy(elem);
                }
            }
            Node<E> x = this.first;
            while (x != null) {
                Node next = x.next;
                x.item = null;
                x.next = null;
                x.prev = null;
                x = next;
            }
            this.last = null;
            this.first = null;
            this.size = 0;
        }

        @Override
        public list<E> move() {
            list<E> out = new list<E>(JavaDifferentiators.JD.Move.INSTANCE, this);
            assert (this.getClass() == out.getClass()) : "forgot to override move in " + out.getClass();
            return out;
        }

        @Override
        public void $destroy() {
            if (!this.$isPointerLike()) {
                for (E elem : this) {
                    Destructors.$destroy(elem);
                }
            }
        }

        @Override
        public list<E> clone() {
            return new list<E>(this);
        }

        @Override
        public Iterator<E> iterator() {
            return new JavaIterator(this.begin(), this.end());
        }

        public void emplace_back(Object ... args) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void emplace_front(Object ... args) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private static <T> void $printRest(StringBuilder sb, Node<T> node) {
            boolean printComma = false;
            while (node != null) {
                if (printComma) {
                    sb.append(", ");
                }
                sb.append(node.item);
                printComma = true;
                node = node.next;
            }
        }

        private E $getDefaultVal() {
            if (this.defaultValue != null) {
                E res = this.defaultValue.get();
                assert (res != null) : "If stored type is pointer then pass null as a supplier! Nonnull supplier must provide nonull values.";
                return res;
            }
            return null;
        }

        private boolean $isPointerLike() {
            return this.defaultValue == null;
        }

        private E $cloneIfNeeded(E value) {
            return !this.$isPointerLike() ? Native.$tryClone(value) : value;
        }

        private E $moveIfNeeded(E value) {
            return !this.$isPointerLike() ? Native.$tryMove(value) : value;
        }

        private void $destroyIfNeeded(E value) {
            if (!this.$isPointerLike()) {
                Destructors.$destroy(value);
            }
        }

        private void linkFirst(E e) {
            Node<E> f = this.first;
            Node<E> newNode = new Node<E>(null, e, f);
            this.first = newNode;
            if (f == null) {
                this.last = newNode;
            } else {
                f.prev = newNode;
            }
            ++this.size;
        }

        private void linkLast(E e) {
            Node<E> l = this.last;
            Node<E> newNode = new Node<E>(l, e, null);
            this.last = newNode;
            if (l == null) {
                this.first = newNode;
            } else {
                l.next = newNode;
            }
            ++this.size;
        }

        private void linkBefore(E e, Node<E> succ) {
            Node pred = succ.prev;
            Node newNode = new Node(pred, e, succ);
            succ.prev = newNode;
            if (pred == null) {
                this.first = newNode;
            } else {
                pred.next = newNode;
            }
            ++this.size;
        }

        private E unlinkFirst(Node<E> f) {
            Object element = f.item;
            Node next = f.next;
            f.item = null;
            f.next = null;
            this.first = next;
            if (next == null) {
                this.last = null;
            } else {
                next.prev = null;
            }
            --this.size;
            return element;
        }

        private E unlinkLast(Node<E> l) {
            Object element = l.item;
            Node prev = l.prev;
            l.item = null;
            l.prev = null;
            this.last = prev;
            if (prev == null) {
                this.first = null;
            } else {
                prev.next = null;
            }
            --this.size;
            return element;
        }

        private E unlink(Node<E> x) {
            Object element = x.item;
            Node next = x.next;
            Node prev = x.prev;
            if (prev == null) {
                this.first = next;
            } else {
                prev.next = next;
                x.prev = null;
            }
            if (next == null) {
                this.last = prev;
            } else {
                next.prev = prev;
                x.next = null;
            }
            x.item = null;
            --this.size;
            return element;
        }

        private E getFirst() {
            Node<E> f = this.first;
            if (f == null) {
                throw new NoSuchElementException();
            }
            return f.item;
        }

        private E getLast() {
            Node<E> l = this.last;
            if (l == null) {
                throw new NoSuchElementException();
            }
            return l.item;
        }

        private E removeFirst() {
            Node<E> f = this.first;
            if (f == null) {
                throw new NoSuchElementException();
            }
            return this.unlinkFirst(f);
        }

        private E removeLast() {
            Node<E> l = this.last;
            if (l == null) {
                throw new NoSuchElementException();
            }
            return this.unlinkLast(l);
        }

        private void addFirst(E e) {
            this.linkFirst(e);
        }

        private void addLast(E e) {
            this.linkLast(e);
        }

        private boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        private int indexOf(Object o) {
            int index = 0;
            if (o == null) {
                Node<E> x = this.first;
                while (x != null) {
                    if (x.item == null) {
                        return index;
                    }
                    ++index;
                    x = x.next;
                }
            } else {
                Node<E> x = this.first;
                while (x != null) {
                    if (o.equals(x.item)) {
                        return index;
                    }
                    ++index;
                    x = x.next;
                }
            }
            return -1;
        }

        private boolean add(E e) {
            this.linkLast(e);
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (!this.empty()) {
                list.$printRest(sb, this.first);
            } else {
                sb.append("<EMPTY>");
            }
            return sb.toString();
        }

        private static class Node<E> {
            E item;
            Node<E> next;
            Node<E> prev;

            Node(Node<E> prev, E element, Node<E> next) {
                this.item = element;
                this.next = next;
                this.prev = prev;
            }
        }

        public static class iterator<T>
        implements type$iterator<iterator<T>, T>,
        NativeSwappable {
            private list<T> lst;
            private Node<T> current;

            public iterator() {
                this.lst = null;
                this.current = null;
            }

            public iterator(iterator<T> other) {
                this.lst = other.lst;
                this.current = other.current;
            }

            public iterator(JavaDifferentiators.JD.Move _dparam, iterator<T> other) {
                this.lst = other.lst;
                this.current = other.current;
            }

            private iterator(list<T> lst, Node<T> node) {
                this.lst = lst;
                this.current = node;
            }

            public iterator<T> $assign(iterator<T> other) {
                this.lst = other.lst;
                this.current = other.current;
                return this;
            }

            public iterator<T> $assignMove(iterator<T> other) {
                this.lst = other.lst;
                this.current = other.current;
                return this;
            }

            @Override
            public T $arrow() {
                return (T)this.current.item;
            }

            @Override
            public T $star() {
                return (T)this.current.item;
            }

            @Override
            public type$ref<T> star$ref() {
                return new type$ptr$inout<T>(){
                    final Node<T> node;
                    {
                        this.node = current;
                    }

                    @Override
                    protected T $star$impl() {
                        return this.node.item;
                    }

                    @Override
                    protected T $set$impl(T value) {
                        this.node.item = Native.$tryAssign(this.node.item, value, lst.$isPointerLike());
                        return this.node.item;
                    }
                };
            }

            public boolean $noteq(Object other) {
                return !this.$eq(other);
            }

            public boolean $eq(Object other) {
                iterator otherIter = (iterator)other;
                return this.lst == otherIter.lst && this.current == otherIter.current;
            }

            @Override
            public int $sub(iterator<T> iter) {
                return std.distance(iter, this, JavaDifferentiators.JD.FAKE.TRAILING);
            }

            @Override
            public iterator<T> $preInc() {
                this.current = this.current == null ? ((list)this.lst).first : this.current.next;
                return this;
            }

            @Override
            public iterator<T> $preDec() {
                this.current = this.current == ((list)this.lst).first ? null : (this.current == null ? ((list)this.lst).last : this.current.prev);
                return this;
            }

            @Override
            public iterator<T> $postInc() {
                Object cloned = this.clone();
                this.$preInc();
                return cloned;
            }

            @Override
            public iterator<T> $postDec() {
                Object cloned = this.clone();
                this.$preDec();
                return cloned;
            }

            @Override
            public iterator<T> clone() {
                return new iterator<T>(this);
            }

            @Override
            public iterator<T> const_clone() {
                return this.clone();
            }

            @Override
            public iterator<T> $inc(int amount) {
                if (amount > 0) {
                    while (amount-- > 0) {
                        this.$preInc();
                    }
                } else if (amount < 0) {
                    this.$dec(-amount);
                }
                return this;
            }

            @Override
            public iterator<T> $dec(int amount) {
                if (amount > 0) {
                    while (amount-- > 0) {
                        this.$preDec();
                    }
                } else if (amount < 0) {
                    this.$inc(-amount);
                }
                return this;
            }

            @Override
            public iterator<T> $add(int amount) {
                Object cloned = this.clone();
                return ((iterator)cloned).$inc(amount);
            }

            @Override
            public iterator<T> $sub(int amount) {
                Object cloned = this.clone();
                return ((iterator)cloned).$dec(amount);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("[").append(this.$index()).append("]: ");
                if (this.current != null) {
                    list.$printRest(sb, this.current);
                } else {
                    sb.append("<END>");
                }
                return sb.toString();
            }

            public int $index() {
                if (this.current == null) {
                    return this.lst.size();
                }
                int index = 0;
                Node inList = ((list)this.lst).first;
                while (inList != null && inList != this.current) {
                    ++index;
                    inList = inList.next;
                }
                return index;
            }

            @Override
            public void swap(NativeSwappable RHS) {
                iterator other = (iterator)RHS;
                assert (this.lst == other.lst) : "only iterators created on the same list can be swapped";
                Object tmp = this.current.item;
                this.current.item = other.current.item;
                other.current.item = tmp;
            }
        }
    }
}

