/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UnknownFormatConversionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clank.java.io_defines;
import org.clank.java.io_ioctl;
import org.clank.java.io_limits;
import org.clank.java.mman_defines;
import org.clank.java.std;
import org.clank.java.std_defines;
import org.clank.java.std_time;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char$iterator;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.char$ptr$array;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type$ptr;
import org.clank.support.void$ptr;

public class io
extends io_ioctl
implements std_defines,
io_defines,
mman_defines,
io_limits {
    private static final Path ROOT_PATH = Paths.get("/", new String[0]);
    private static final ThreadLocal<AtomicInteger> errnoVal = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };
    public static final istream cin = new StreamIn(System.in);
    public static final ostream cout = new StreamOut(System.out);
    public static final ostream cerr = new StreamOut(System.err);
    public static final FILE stdin = new FILE(0);
    public static final FILE stdout = new FILE(1);
    public static final FILE stderr = new FILE(2);
    public static final NativeCallback.Void2String endl = () -> "\n";
    public static final int S_IFMT = 61440;
    public static final int S_IAMB = 511;
    public static final int S_IFIFO = 4096;
    public static final int S_IFCHR = 8192;
    public static final int S_IFDIR = 16384;
    public static final int S_IFNAM = 20480;
    public static final int S_INSEM = 1;
    public static final int S_INSHD = 2;
    public static final int S_IFBLK = 24576;
    public static final int S_IFREG = 32768;
    public static final int S_IFLNK = 40960;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFDOOR = 53248;
    public static final int S_IFPORT = 57344;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    public static final int S_IREAD = 256;
    public static final int S_IWRITE = 128;
    public static final int S_IEXEC = 64;
    public static final int S_ENFMT = 1024;
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    private static final ThreadLocal<AtomicReference<String>> CWD = new ThreadLocal<AtomicReference<String>>(){

        @Override
        protected AtomicReference<String> initialValue() {
            String out = System.getProperty("user.dir");
            if (out == null) {
                out = System.getenv("PWD");
            }
            return new AtomicReference<String>(out);
        }
    };
    public static char$ptr[] __environ = null;
    public static char$ptr[] environ = null;
    private static final int RW_MASK = 3;
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_SEARCH = 0x200000;
    public static final int O_EXEC = 0x400000;
    public static final int O_NDELAY = 4;
    public static final int O_APPEND = 8;
    public static final int O_SYNC = 16;
    public static final int O_DSYNC = 64;
    public static final int O_RSYNC = 32768;
    public static final int O_NONBLOCK = 128;
    public static final int O_LARGEFILE = 8192;
    public static final int O_CREAT = 256;
    public static final int O_TRUNC = 512;
    public static final int O_EXCL = 1024;
    public static final int O_NOCTTY = 2048;
    public static final int O_XATTR = 16384;
    public static final int O_NOFOLLOW = 131072;
    public static final int O_NOLINKS = 262144;
    public static final int O_CLOEXEC = 0x800000;
    public static final int O_DIRECTORY = 0x1000000;
    public static final int O_TTY_INIT = 0x2000000;
    private static final List<OpenedFile> openedFiles = new ArrayList<OpenedFile>(3);
    private static final String R_OPEN_MODE = "r";
    private static final String RW_OPEN_MODE = "rw";
    public static final int R_OK = 4;
    public static final int W_OK = 2;
    public static final int X_OK = 1;
    public static final int F_OK = 0;
    public static final char$ptr MAP_FAILED;
    private static final int _UTSNAME_LENGTH = 65;
    private static final int _UTSNAME_DOMAIN_LENGTH = 65;
    private static final int _UTSNAME_SYSNAME_LENGTH = 65;
    private static final int _UTSNAME_NODENAME_LENGTH = 65;
    private static final int _UTSNAME_RELEASE_LENGTH = 65;
    private static final int _UTSNAME_VERSION_LENGTH = 65;
    private static final int _UTSNAME_MACHINE_LENGTH = 65;
    public static final String UNKNOWN = "unknown";

    protected io() {
    }

    public static String Cpp2JavaFormatString(String cpp) {
        String java = cpp;
        return java;
    }

    public static Object[] prepareArgsForPrintf(Object ... objects) {
        int i = 0;
        for (Object obj : objects) {
            if (obj instanceof char$ptr) {
                objects[i] = Casts.toJavaString((char$ptr)obj);
            }
            ++i;
        }
        return objects;
    }

    public static int errno() {
        return errnoVal.get().get();
    }

    public static int setErrno(int errno) {
        errnoVal.get().set(errno);
        return errno;
    }

    public static basic_ostream $out_os_char$ptr$C(basic_ostream out, char$ptr o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_char$ptr$C(basic_ostream out, String o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_byte(basic_ostream out, byte o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_char(basic_ostream out, char o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_int(basic_ostream out, int o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_long(basic_ostream out, long o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_ulong(basic_ostream out, long o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_string$C(basic_ostream out, std.string o) {
        return out.$out_os_str(o);
    }

    public static int fprintf(FILE fOut, char$ptr format, Object ... args) {
        return io.fprintf(fOut, (CharSequence)Native.$toString(format), args);
    }

    public static int fprintf(FILE fOut, CharSequence format, Object ... args) {
        StringWriter sw = new StringWriter();
        String Fmt = io.Cpp2JavaFormatString(format.toString());
        try (PrintWriter writer = new PrintWriter(sw);){
            writer.printf(Fmt, io.prepareArgsForPrintf(args));
        }
        catch (UnknownFormatConversionException e) {
            NativeTrace.registerReason(e);
            NativeTrace.traceNotImplemented("This format string is not supported: " + Fmt);
        }
        String toWrite = sw.toString();
        OpenedFile F = io.getOpenedFileImpl(fOut.$FD);
        try {
            F.writeBytes(toWrite);
        }
        catch (IOException ex) {
            NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
            return -1;
        }
        return toWrite.length();
    }

    public static int fprintf(ostream stderr, CharSequence format, Object ... args) {
        return io.fprintf(stderr, format.toString(), args);
    }

    public static int fprintf(ostream stderr, String format, Object ... args) {
        stderr.$out(format, args);
        return 1;
    }

    public static int printf(char$ptr format, Object ... args) {
        return io.printf(Casts.toJavaString(format), args);
    }

    public static int printf(String format, Object ... args) {
        cout.$out(format, args);
        return 1;
    }

    public static int vfprintf(FILE __s, char$ptr __format, type$ptr __arg) {
        return io.vfprintf(__s, Casts.toJavaString(__format), __arg);
    }

    public static int vfprintf(FILE __s, String __format, type$ptr __arg) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int vprintf(char$ptr __format, type$ptr __arg) {
        return io.vprintf(Casts.toJavaString(__format), __arg);
    }

    public static int vprintf(String __format, type$ptr __arg) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int vsprintf(char$ptr __s, char$ptr __format, type$ptr __arg) {
        return io.vsprintf(__s, Casts.toJavaString(__format), __arg);
    }

    public static int vsprintf(char$ptr __s, String __format, type$ptr __arg) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int snprintf(char$ptr s, int n, char$ptr format, Object ... objects) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printer = new PrintStream(out);
        String Fmt = io.Cpp2JavaFormatString(Casts.toJavaString(format));
        try {
            printer.printf(Fmt, io.prepareArgsForPrintf(objects));
        }
        catch (UnknownFormatConversionException e) {
            NativeTrace.registerReason(e);
            NativeTrace.traceNotImplemented("This format string is not supported: " + Fmt);
        }
        printer.flush();
        printer.close();
        byte[] res = out.toByteArray();
        for (int i = 0; i < res.length && i < n; ++i) {
            s.$set(res[i]);
            s.$preInc();
        }
        return Math.min(res.length, n);
    }

    public static int snprintf(byte[] s, int n, char$ptr format, Object ... objects) {
        return io.snprintf(NativePointer.create_char$ptr(s), n, format, objects);
    }

    public static basic_ostream $out_os_T(basic_ostream out, byte o) {
        return out.$out(o);
    }

    public static int putchar(int __c) {
        cout.$out(Unsigned.$int2ushort(__c));
        return __c;
    }

    public static int puts(char$ptr __s) {
        cout.$out(() -> Casts.toJavaString(__s));
        cout.$out('\n');
        return 1;
    }

    public static basic_ostream $out_os_T(basic_ostream out, char o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_T(basic_ostream out, int o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_T(basic_ostream out, long o) {
        return out.$out(o);
    }

    public static <T> basic_ostream $out_os_T(basic_ostream out, T o) {
        return out.$out(o);
    }

    public static basic_ostream $out_os_str(basic_ostream out, std.string o) {
        return out.$out_os_str(o);
    }

    public static int getline(basic_istream in, std.string to) {
        return in.getline(to);
    }

    public static int getline_is_string(basic_istream in, std.string to) {
        return in.getline(to);
    }

    public static char$ptr realpath(char$ptr name, byte[] buf) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate open request to custom FS impl?";
        if (name == null) {
            io.setErrno(22);
            return null;
        }
        String fileName = Native.$toString(name);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("realpath requested for:" + fileName, NativeTrace.TRACE_IO);
        }
        Path filePath = io.resolvePathByFileName(fileName);
        io.setErrno(0);
        try {
            Path realPath = filePath.toRealPath(new LinkOption[0]);
            char$ptr realPathPtr = NativePointer.create_char$ptr_utf8(realPath.toString());
            std.memcpy(buf, 0, realPathPtr.$array(), 0, std.strlen(realPathPtr));
            return NativePointer.create_char$ptr(buf);
        }
        catch (Throwable e) {
            io.setErrno(5);
            return null;
        }
    }

    private static Path resolvePathByFileName(String fileName) {
        if (fileName.startsWith("\\") || fileName.startsWith("/") || fileName.length() > 1 && fileName.charAt(1) == ':') {
            return ROOT_PATH.resolve(fileName);
        }
        return Paths.get(CWD.get().get(), fileName);
    }

    public static int readlink(char$ptr name, byte[] buf) {
        throw new UnsupportedOperationException();
    }

    public static long write(int fildes, char$ptr buf, int bufIdxFrom, int __nbytes) {
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("write requested for " + fildes, NativeTrace.TRACE_IO);
        }
        return io.pwrite(fildes, buf, bufIdxFrom, __nbytes, Long.MIN_VALUE);
    }

    public static long pwrite(int fildes, char$ptr __buf, int bufIdxFrom, int __nbytes, long __offset) {
        int offset;
        byte[] buffer;
        if (__buf instanceof char$ptr$array) {
            buffer = __buf.$array();
            offset = bufIdxFrom;
        } else {
            offset = 0;
            buffer = NativePointer.new$char(__nbytes, new byte[0]);
            char$ptr first = __buf;
            int i = 0;
            int j = bufIdxFrom;
            while (i < __nbytes) {
                buffer[i] = first.$at(j);
                ++i;
                ++j;
            }
        }
        return io.pwrite(fildes, buffer, offset, __nbytes, __offset);
    }

    public static long write(int fildes, byte[] buffer, int bufOffset, int __nbytes) {
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("write byte[] requested for " + fildes, NativeTrace.TRACE_IO);
        }
        return io.pwrite(fildes, buffer, bufOffset, __nbytes, Long.MIN_VALUE);
    }

    public static long write(int __fd, char$ptr __buf, int __n) {
        return io.write(__fd, __buf, 0, __n);
    }

    public static long pwrite(int fildes, byte[] buffer, int bufOffset, int __nbytes, long __file_offset) {
        OpenedFile openedFile = io.getOpenedFileImpl(fildes);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("pwrite requested " + __nbytes + " bytes " + (__file_offset != Long.MIN_VALUE ? "from " + __file_offset : "from the last") + " position for " + fildes + ":" + openedFile, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (openedFile == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "pread not opened {0}", fildes);
            io.setErrno(9);
            return -1L;
        }
        if (__nbytes == 0) {
            return 0L;
        }
        long savedPosition = 0L;
        if (__file_offset != Long.MIN_VALUE) {
            try {
                savedPosition = openedFile.position();
                openedFile.seek(__file_offset);
            }
            catch (IOException ex) {
                NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
                io.setErrno(79);
                return -1L;
            }
        }
        long written = __nbytes;
        try {
            openedFile.write(buffer, bufOffset, __nbytes);
        }
        catch (IOException ex) {
            NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
            return -1L;
        }
        if (__file_offset != Long.MIN_VALUE) {
            try {
                openedFile.seek(savedPosition);
            }
            catch (IOException ex) {
                NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
                io.setErrno(79);
                return -1L;
            }
        }
        return written;
    }

    public static long lseek(int fildes, long offset, int whence) {
        OpenedFile openedFile = io.getOpenedFileImpl(fildes);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("lseek to position " + offset + " for " + fildes + ":" + openedFile, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (openedFile == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "lseek not opened {0}", fildes);
            io.setErrno(9);
            return -1L;
        }
        if (offset < 0L || offset == Long.MIN_VALUE) {
            io.setErrno(22);
            return -1L;
        }
        if (openedFile.file == null) {
            assert (fildes <= 2);
            if (offset != 0L) {
                io.setErrno(79);
                return -1L;
            }
            return whence == 1 ? -1L : 0L;
        }
        long savedPosition = 0L;
        try {
            savedPosition = openedFile.position();
            openedFile.seek(offset);
        }
        catch (IOException ex) {
            NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
            try {
                openedFile.seek(savedPosition);
            }
            catch (IOException ex1) {
                Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex1);
            }
            io.setErrno(79);
            return -1L;
        }
        return offset;
    }

    public static long read(int __fd, char$iterator buf, int __nbytes) {
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("read requested for " + __fd, NativeTrace.TRACE_IO);
        }
        return io.pread(__fd, buf, __nbytes, Long.MIN_VALUE);
    }

    public static long pread(int __fd, char$iterator<?> __buf, int __nbytes, long __offset) {
        long read;
        block6: {
            boolean createdOwnBuffer;
            int buf$index;
            byte[] buffer;
            if (__buf instanceof char$ptr$array) {
                buffer = ((char$ptr$array)__buf).$array();
                buf$index = ((char$ptr$array)__buf).$index();
                createdOwnBuffer = false;
            } else {
                buffer = NativePointer.new$char(__nbytes, new byte[0]);
                buf$index = 0;
                createdOwnBuffer = true;
            }
            read = io.pread(__fd, buffer, buf$index, __nbytes, __offset);
            if (!createdOwnBuffer || read <= 0L) break block6;
            if (__buf instanceof char$ptr) {
                int i = 0;
                while ((long)i < read) {
                    ((char$ptr)__buf).$set(i, buffer[i]);
                    ++i;
                }
            } else {
                char$iterator<?> first = Native.$tryClone(__buf);
                int i = 0;
                while ((long)i < read) {
                    first.star$ref().$set(buffer[i]);
                    first.$preInc();
                    ++i;
                }
            }
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long pread(int __fd, byte[] buffer, int __bufOffset, int __nbytes, long __offset) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate read request to custome FS impl?";
        OpenedFile openedFile = io.getOpenedFileImpl(__fd);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("pread requested " + __nbytes + " bytes " + (__offset != Long.MIN_VALUE ? "from " + __offset : "from the last") + " position for " + __fd + ":" + openedFile, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (openedFile == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "pread not opened {0}", __fd);
            io.setErrno(9);
            return -1L;
        }
        if (__nbytes == 0) {
            return 0L;
        }
        OpenedFile openedFile2 = openedFile;
        synchronized (openedFile2) {
            int read;
            if (openedFile.file != null) {
                int read2;
                long savedPosition = 0L;
                if (__offset != Long.MIN_VALUE) {
                    try {
                        savedPosition = openedFile.position();
                        openedFile.seek(__offset);
                    }
                    catch (IOException ex) {
                        NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
                        io.setErrno(79);
                        return -1L;
                    }
                }
                try {
                    read2 = openedFile.file.read(buffer, __bufOffset, __nbytes);
                }
                catch (IOException ex) {
                    NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
                    return -1L;
                }
                if (__offset != Long.MIN_VALUE) {
                    try {
                        openedFile.seek(savedPosition);
                    }
                    catch (IOException ex) {
                        NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
                        io.setErrno(79);
                        return -1L;
                    }
                }
                return read2 != -1 ? (long)read2 : 0L;
            }
            try {
                read = openedFile.inputStream.read(buffer, __bufOffset, __nbytes);
                if (read == -1) {
                    read = 0;
                }
            }
            catch (IOException ex) {
                NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
                return -1L;
            }
            return read;
        }
    }

    public static int pipe(int[] __pipedes) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int pipe(int.ptr __pipedes) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void perror(char$ptr __s) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void perror(String __s) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int waitpid(int __pid, int.ptr __stat_loc, int __options) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fork() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int execvp(char$ptr __file, char$ptr[] __argv) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void _exit(int __status) {
        System.exit(__status);
    }

    public static int futimens(int FD, std_time.timespec[] out) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static boolean S_ISFIFO(long mode) {
        return (mode & 0xF000L) == 4096L;
    }

    public static boolean S_ISCHR(long mode) {
        return (mode & 0xF000L) == 8192L;
    }

    public static boolean S_ISDIR(long mode) {
        return (mode & 0xF000L) == 16384L;
    }

    public static boolean S_ISBLK(long mode) {
        return (mode & 0xF000L) == 24576L;
    }

    public static boolean S_ISREG(long mode) {
        return (mode & 0xF000L) == 32768L;
    }

    public static boolean S_ISLNK(long mode) {
        return (mode & 0xF000L) == 40960L;
    }

    public static boolean S_ISSOCK(long mode) {
        return (mode & 0xF000L) == 49152L;
    }

    public static boolean S_ISDOOR(long mode) {
        return (mode & 0xF000L) == 53248L;
    }

    public static boolean S_ISPORT(long mode) {
        return (mode & 0xF000L) == 57344L;
    }

    private static int toUnixPermImpl(PosixFilePermission p) {
        switch (p) {
            case OWNER_READ: {
                return 256;
            }
            case OWNER_WRITE: {
                return 128;
            }
            case OWNER_EXECUTE: {
                return 64;
            }
            case GROUP_READ: {
                return 32;
            }
            case GROUP_WRITE: {
                return 16;
            }
            case GROUP_EXECUTE: {
                return 8;
            }
            case OTHERS_READ: {
                return 4;
            }
            case OTHERS_WRITE: {
                return 2;
            }
            case OTHERS_EXECUTE: {
                return 1;
            }
        }
        throw new AssertionError((Object)p.name());
    }

    public static int isatty(int __fd) {
        io.setErrno(0);
        if (__fd <= 2) {
            if (NativeTrace.UNIT_TEST_MODE) {
                return NativeTrace.UNIT_TEST_REDIRECTED_STREAMS ? 1 : 0;
            }
            return System.console() != null ? 1 : 0;
        }
        return 0;
    }

    public static int stat(char$ptr file, stat out) {
        return io.stat(Native.$toString(file), out);
    }

    public static int stat(String fileName, stat out) {
        return io.statImpl(fileName, out, new LinkOption[0]);
    }

    public static int lstat(char$ptr file, stat out) {
        return io.lstat(Native.$toString(file), out);
    }

    public static int lstat(String fileName, stat out) {
        return io.statImpl(fileName, out, LinkOption.NOFOLLOW_LINKS);
    }

    private static int statImpl(String fileName, stat out, LinkOption ... options) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate stat request to custome FS impl?";
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("stat requested for:" + fileName, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        Path path = io.resolvePathByFileName(fileName);
        if (Files.exists(path, options)) {
            try {
                BasicFileAttributes basicAttrs = null;
                basicAttrs = Files.readAttributes(path, BasicFileAttributes.class, options);
                if (basicAttrs.isDirectory()) {
                    out.st_mode |= 0x4000;
                }
                if (basicAttrs.isRegularFile()) {
                    out.st_mode |= 0x8000;
                }
                if (basicAttrs.isSymbolicLink()) {
                    out.st_mode |= 0xA000;
                }
                out.st_size = basicAttrs.size();
                FileTime lastModifiedTime = basicAttrs.lastModifiedTime();
                out.st_mtim.tv_nsec = lastModifiedTime.to(TimeUnit.NANOSECONDS);
                out.st_mtim.tv_sec = lastModifiedTime.to(TimeUnit.SECONDS);
                boolean unixSupported = false;
                for (FileStore fileStore : path.getFileSystem().getFileStores()) {
                    if (fileStore.supportsFileAttributeView(PosixFileAttributeView.class)) {
                        Set<PosixFilePermission> perms = Files.getPosixFilePermissions(path, options);
                        for (PosixFilePermission perm : perms) {
                            out.st_mode |= io.toUnixPermImpl(perm);
                        }
                    }
                    if (!fileStore.supportsFileAttributeView("unix")) continue;
                    Map<String, Object> unixAttrs = Files.readAttributes(path, "unix:ino,dev,gid,uid", options);
                    out.st_ino = ((Number)unixAttrs.get("ino")).longValue();
                    out.st_dev = ((Number)unixAttrs.get("dev")).longValue();
                    out.st_gid = ((Number)unixAttrs.get("gid")).intValue();
                    out.st_uid = ((Number)unixAttrs.get("uid")).intValue();
                    unixSupported = true;
                    break;
                }
                if (!unixSupported) {
                    Object fileKey = basicAttrs.fileKey();
                    out.st_ino = fileKey == null ? (long)path.hashCode() : (long)fileKey.hashCode();
                    out.st_dev = 0L;
                    out.st_gid = 0;
                    out.st_uid = 0;
                }
            }
            catch (IOException ex) {
                NativeTrace.printStackTraceOnce(ex, Level.WARNING, true);
            }
            return 0;
        }
        io.setErrno(2);
        return -1;
    }

    public static int fstat(int fildes, stat out) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate fstat request to custome FS impl?";
        String openedFileNameImpl = io.getOpenedFileNameImpl(fildes);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("fstat requested for " + fildes + ":" + openedFileNameImpl, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (openedFileNameImpl == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "closing not opened {0}", fildes);
            io.setErrno(9);
            return -1;
        }
        if (fildes <= 2) {
            boolean tty = io.isatty(fildes) != 0;
            out.st_mode = tty ? 8192 : 32768;
            int n = out.st_blksize = tty ? 0 : BLOCK_SIZE;
            if (fildes != 0 && !tty) {
                out.st_mode |= 0x1A4;
            }
            return 0;
        }
        out.st_blocks = 1L;
        out.st_blksize = BLOCK_SIZE;
        return io.stat(openedFileNameImpl, out);
    }

    public static int mkdir(char$iterator<?> __file, int mode) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate mkdir request to custome FS impl?";
        io.setErrno(0);
        try {
            String fileName = Native.$toString(__file);
            if (NativeTrace.TRACE_IO) {
                NativeTrace.trace("mkdir requested for:" + fileName, NativeTrace.TRACE_IO);
            }
            Path filePath = io.resolvePathByFileName(fileName);
            Files.createDirectories(filePath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException ex) {
            io.setErrno(17);
            return -1;
        }
        catch (IOException ex) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, null, ex);
            io.setErrno(13);
            return -1;
        }
        return 0;
    }

    public static DIR opendir(char$iterator<?> file) {
        io.setErrno(0);
        NativeTrace.traceNotImplemented("io.opendir");
        return null;
    }

    public static int closedir(DIR dir) {
        io.setErrno(0);
        NativeTrace.traceNotImplemented("io.closedir");
        return io.errno();
    }

    public static dirent readdir(DIR dir) {
        io.setErrno(0);
        NativeTrace.traceNotImplemented("io.readdir");
        return null;
    }

    public static int remove(char$iterator<?> __file) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate open request to custome FS impl?";
        String fileName = Native.$toString(__file);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("open requested for:" + fileName, NativeTrace.TRACE_IO);
        }
        Path filePath = io.resolvePathByFileName(fileName);
        io.setErrno(0);
        try {
            boolean existed = Files.deleteIfExists(filePath);
            if (!existed) {
                io.setErrno(2);
                return -1;
            }
        }
        catch (IOException ex) {
            io.setErrno(5);
            return -1;
        }
        return 0;
    }

    public static int link(char$iterator<?> __existingfile, char$iterator<?> __link) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int symlink(char$iterator<?> __existingfile, char$iterator<?> __link) {
        String linkName = Native.$toString(__link);
        String fileName = Native.$toString(__existingfile);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("symlink requested for:" + fileName, NativeTrace.TRACE_IO);
        }
        Path linkPath = io.resolvePathByFileName(linkName);
        Path filePath = io.resolvePathByFileName(fileName);
        io.setErrno(0);
        try {
            Files.createSymbolicLink(linkPath, filePath, new FileAttribute[0]);
            return 0;
        }
        catch (UnsupportedOperationException ex) {
            io.setErrno(5);
            System.out.println("This OS doesn't support creating Sym links");
            return -1;
        }
        catch (SecurityException ex) {
            io.setErrno(13);
            return -1;
        }
        catch (FileAlreadyExistsException ex) {
            io.setErrno(17);
            return -1;
        }
        catch (IOException ex) {
            io.setErrno(5);
            return -1;
        }
    }

    public static int rename(char$iterator<?> __from, char$iterator<?> __to) {
        String from = Native.$toString(__from);
        String to = Native.$toString(__to);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("rename requested [" + from + "] => [" + to + "]", NativeTrace.TRACE_IO);
        }
        Path fromPath = io.resolvePathByFileName(from);
        Path toPath = io.resolvePathByFileName(to);
        io.setErrno(0);
        try {
            Files.move(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            io.setErrno(5);
            return -1;
        }
        return 0;
    }

    public static int truncate(char$iterator<?> __file, long size) {
        int fId = io.open(__file, 257, new int[0]);
        if (fId >= 0) {
            OpenedFile OF = io.getOpenedFileImpl(fId);
            try {
                OF.file.setLength(size);
            }
            catch (IOException ex) {
                io.setErrno(5);
                return -1;
            }
            io.close(fId);
            return 0;
        }
        io.setErrno(13);
        return -1;
    }

    public static char$ptr getcwd(char$ptr buf, int bufSize) {
        io.setErrno(0);
        String curDir = CWD.get().get();
        char$ptr first = Native.$tryClone(buf);
        for (int i = 0; i < Math.min(bufSize, curDir.length()); ++i) {
            first.star$ref().$set((byte)curDir.charAt(i));
            first.$preInc();
        }
        return buf;
    }

    public static String getCWD() {
        return CWD.get().get();
    }

    public static int chdir(char$ptr path) {
        return io.chdir(Casts.toJavaString(path));
    }

    public static int chdir(String path) {
        io.setErrno(0);
        CWD.get().set(path);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int close(int FileDescriptor2) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate close request to custome FS impl?";
        io.setErrno(0);
        OpenedFile openedFile = io.getOpenedFileImpl(FileDescriptor2);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("closing " + FileDescriptor2 + ":" + openedFile, NativeTrace.TRACE_IO);
        }
        if (openedFile == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "closing not opened {0}", FileDescriptor2);
            io.setErrno(9);
            return -1;
        }
        if (FileDescriptor2 <= 2) {
            if (FileDescriptor2 == 2) {
                Logger.getLogger(io.class.getName()).log(Level.SEVERE, "closing standard stream {0}", FileDescriptor2);
                io.setErrno(9);
                return -1;
            }
            return 0;
        }
        List<OpenedFile> list2 = openedFiles;
        synchronized (list2) {
            openedFiles.set(FileDescriptor2, null);
        }
        try {
            openedFile.close();
        }
        catch (IOException ex) {
            NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
            io.setErrno(5);
            return -1;
        }
        return 0;
    }

    public static int open(char$iterator<?> __file, int __oflag, int ... additional_args) {
        boolean create;
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate open request to custome FS impl?";
        String fileName = Native.$toString(__file);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("open requested for:" + fileName, NativeTrace.TRACE_IO);
        }
        Path filePath = io.resolvePathByFileName(fileName);
        io.setErrno(0);
        boolean read = (__oflag & 3) == 0 || (__oflag & 3) == 2 || (__oflag & 0x400) == 1024;
        boolean truncate = (__oflag & 0x100) == 256 || (__oflag & 0x200) == 512;
        boolean append = (__oflag & 8) == 8;
        boolean write = (__oflag & 3) == 1 || (__oflag & 3) == 2 || append || truncate;
        boolean bl = create = (__oflag & 0x100) == 256;
        if (create || Files.exists(filePath, new LinkOption[0])) {
            if (!create && read && !Files.isReadable(filePath)) {
                io.setErrno(13);
                return -1;
            }
            if (!create && write && !Files.isWritable(filePath)) {
                io.setErrno(13);
                return -1;
            }
            String mode = io.convertToJavaFileOpenMode(__oflag);
            try {
                int fId = io.openFileDescriptorImpl(fileName, mode, truncate);
                if (append && fId >= 0) {
                    io.fseek(new FILE(fId), 0L, 2);
                }
                return fId;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(io.class.getName()).log(Level.FINEST, null, ex);
                io.setErrno(2);
                return -1;
            }
            catch (IOException ex) {
                Logger.getLogger(io.class.getName()).log(Level.INFO, null, ex);
                io.setErrno(13);
                return -1;
            }
        }
        io.setErrno(2);
        return -1;
    }

    public static int unlink(char$iterator<?> __file) {
        try {
            io.setErrno(0);
            String fileName = Native.$toString(__file);
            if (NativeTrace.TRACE_IO) {
                NativeTrace.trace("unlink requested for:" + fileName, NativeTrace.TRACE_IO);
            }
            Path filePath = io.resolvePathByFileName(fileName);
            Files.delete(filePath);
            return 0;
        }
        catch (IOException ex) {
            NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
            io.setErrno(30);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OpenedFile getOpenedFileImpl(void$ptr MMap) {
        List<OpenedFile> list2 = openedFiles;
        synchronized (list2) {
            for (OpenedFile file : openedFiles) {
                if (file == null || !file.isPtrOwner(MMap)) continue;
                return file;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OpenedFile getOpenedFileImpl(int FileDescriptor2) {
        List<OpenedFile> list2 = openedFiles;
        synchronized (list2) {
            return FileDescriptor2 < openedFiles.size() ? openedFiles.get(FileDescriptor2) : null;
        }
    }

    private static String getOpenedFileNameImpl(int FileDescriptor2) {
        OpenedFile file = io.getOpenedFileImpl(FileDescriptor2);
        return file == null ? null : file.name;
    }

    private static String convertToJavaFileOpenMode(int __oflag) {
        boolean write;
        boolean read = (__oflag & 3) == 0 || (__oflag & 3) == 2 || (__oflag & 0x400) == 1024;
        boolean bl = write = (__oflag & 3) == 1 || (__oflag & 3) == 2 || (__oflag & 0x100) == 256 || (__oflag & 0x200) == 512;
        assert (read || write);
        return write ? RW_OPEN_MODE : R_OPEN_MODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int openFileDescriptorImpl(String name, String mode, boolean truncate) throws FileNotFoundException, IOException {
        RandomAccessFile file;
        block8: {
            file = new RandomAccessFile(name, mode);
            if (truncate) {
                try {
                    file.getChannel().truncate(0L);
                }
                catch (IOException e) {
                    if ("/dev/null".contentEquals(name)) break block8;
                    throw e;
                }
            }
        }
        List<OpenedFile> list2 = openedFiles;
        synchronized (list2) {
            int index = -1;
            for (int i = 0; i < openedFiles.size(); ++i) {
                if (openedFiles.get(i) != null) continue;
                index = i;
                break;
            }
            if (index == -1) {
                index = openedFiles.size();
                openedFiles.add(null);
            }
            openedFiles.set(index, new OpenedFile(name, file));
            return index;
        }
    }

    public static FILE fopen(char$iterator<?> __file, CharSequence mode) {
        String fileName = Native.$toString(__file);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("fopen requested for:" + fileName, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        String modeString = mode.toString();
        boolean exists = new File(fileName).exists();
        if (modeString.startsWith(R_OPEN_MODE)) {
            if (exists) {
                boolean openForRW = modeString.startsWith("r+") || modeString.startsWith("rb+");
                int fId = io.open(__file, openForRW ? 2 : 0, new int[0]);
                if (fId >= 0) {
                    return new FILE(fId);
                }
                return null;
            }
            io.setErrno(2);
            return null;
        }
        if (modeString.startsWith("w")) {
            if (modeString.startsWith("w+") || modeString.startsWith("wb+")) {
                int fId = io.open(__file, 770, 416);
                if (fId >= 0) {
                    return new FILE(fId);
                }
                return null;
            }
            int fId = io.open(__file, 769, 416);
            if (fId >= 0) {
                return new FILE(fId);
            }
            return null;
        }
        if (modeString.startsWith("a")) {
            if (modeString.startsWith("a+") || modeString.startsWith("ab+")) {
                int fId = io.open(__file, 776, 416);
                if (fId >= 0) {
                    return new FILE(fId);
                }
                return null;
            }
            int fId = io.open(__file, 778, 416);
            if (fId >= 0) {
                return new FILE(fId);
            }
            return null;
        }
        io.setErrno(22);
        return null;
    }

    public static int access(char$iterator<?> __file, long mode) {
        String fileName = Native.$toString(__file);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("access requested for:" + fileName, NativeTrace.TRACE_IO);
        }
        Path path = io.resolvePathByFileName(fileName);
        io.setErrno(0);
        if (mode > 7L) {
            io.setErrno(22);
            return -1;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            io.setErrno(2);
            return -1;
        }
        if (mode == 0L) {
            return 0;
        }
        if ((mode & 4L) == 4L && !Files.isReadable(path)) {
            io.setErrno(13);
            return -1;
        }
        if ((mode & 2L) == 2L && !Files.isWritable(path)) {
            io.setErrno(13);
            return -1;
        }
        if ((mode & 1L) == 1L && !Files.isExecutable(path)) {
            io.setErrno(13);
            return -1;
        }
        return 0;
    }

    public static int ferror(FILE F) {
        return io.errno();
    }

    public static int feof(FILE F) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fclose(FILE F) {
        if (F != null && F.$FD >= 0) {
            return io.close(F.$FD);
        }
        return 0;
    }

    public static int ftruncate(int FD, long size) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fseek(FILE __stream, long __off, int __whence) {
        assert (__whence == 0 || __whence == 2 || __whence == 1);
        if (__stream.$FD >= 0) {
            io.setErrno(0);
            OpenedFile OF = io.getOpenedFileImpl(__stream.$FD);
            try {
                long whence;
                switch (__whence) {
                    case 0: {
                        whence = 0L;
                        break;
                    }
                    case 2: {
                        whence = OF.length();
                        break;
                    }
                    case 1: {
                        whence = OF.position();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Not reachable!");
                    }
                }
                OF.seek(whence + __off);
            }
            catch (IOException ex) {
                Logger.getLogger(io.class.getName()).log(Level.INFO, null, ex);
                io.setErrno(13);
                return -1;
            }
            return 0;
        }
        io.setErrno(22);
        return -1;
    }

    public static long ftell(FILE __stream) {
        if (__stream.$FD >= 0) {
            io.setErrno(0);
            OpenedFile OF = io.getOpenedFileImpl(__stream.$FD);
            try {
                return OF.position();
            }
            catch (IOException ex) {
                Logger.getLogger(io.class.getName()).log(Level.INFO, null, ex);
                io.setErrno(13);
                return -1L;
            }
        }
        io.setErrno(22);
        return -1L;
    }

    public static int fputs(char$ptr __s, FILE __stream) {
        if (__stream.$FD >= 0) {
            if (io.fwrite(__s, 1, std.strlen(__s), __stream) < 0) {
                return -1;
            }
            return 0;
        }
        io.setErrno(9);
        return -1;
    }

    public static int fread(char$ptr buf, int elem_size, int count, FILE F) {
        if (F.$FD >= 0) {
            io.setErrno(0);
            OpenedFile OF = io.getOpenedFileImpl(F.$FD);
            if (OF == null) {
                Logger.getLogger(io.class.getName()).log(Level.SEVERE, "fread not opened {0}", F.$FD);
                io.setErrno(9);
                return 0;
            }
            long bytesRead = io.read(F.$FD, buf, elem_size * count);
            if (bytesRead >= 0L) {
                return Unsigned.$long2uint(bytesRead / (long)elem_size);
            }
            return 0;
        }
        io.setErrno(9);
        return 0;
    }

    public static int fread(void$ptr buf, int elem_size, int count, FILE F) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fread(char$ptr buf, int elem_size, int count, istream F) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fread(void$ptr buf, int elem_size, int count, istream F) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fwrite(char$ptr __ptr, int __size, int __n, FILE __s) {
        if (__s.$FD >= 0) {
            io.setErrno(0);
            OpenedFile OF = io.getOpenedFileImpl(__s.$FD);
            if (OF == null) {
                Logger.getLogger(io.class.getName()).log(Level.SEVERE, "fwrite not opened {0}", __s.$FD);
                io.setErrno(9);
                return 0;
            }
            long bytesWritten = io.write(__s.$FD, __ptr, 0, __size * __n);
            if (bytesWritten >= 0L) {
                return Unsigned.$long2uint(bytesWritten / (long)__size);
            }
            return 0;
        }
        io.setErrno(9);
        return 0;
    }

    public static int fwrite(void$ptr __ptr, int __size, int __n, FILE __s) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fwrite(char$ptr __ptr, int __size, int __n, ostream __s) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fwrite(void$ptr __ptr, int __size, int __n, ostream __s) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fflush(FILE __stream) {
        if (__stream != null && __stream.$FD >= 0) {
            OpenedFile OF = io.getOpenedFileImpl(__stream.$FD);
            if (OF.file == null && OF.outStream instanceof JavaPrintStreamWrapper) {
                try {
                    ((JavaPrintStreamWrapper)OF.outStream).getDelegate().flush();
                }
                catch (IOException ex) {
                    NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
                    return -1;
                }
            }
            return 0;
        }
        return -1;
    }

    public static int fflush(ostream __stream) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void setbuf(FILE __stream, char$ptr __buf) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int setvbuf(FILE __stream, char$ptr __buf, int __modes, int __n) {
        assert (__buf == null) : "Non-null buffer is not supported yet!";
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("setvbuf requested for " + __stream.$FD, NativeTrace.TRACE_IO);
        }
        return 0;
    }

    public static int fileno(FILE __stream) {
        return __stream.$FD;
    }

    public static char$ptr fgets(char$ptr __s, int __n, FILE __stream) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static char$ptr mmap(void$ptr start, long length, int prot, int flags, int FD, long offset) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate mmap-open request to custome FS impl?";
        OpenedFile openedFile = io.getOpenedFileImpl(FD);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("fstat requested for " + FD + ":" + openedFile, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (start != null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "invalid addr {0}:{1}", new Object[]{FD, start});
            io.setErrno(22);
            return MAP_FAILED;
        }
        if (offset != 0L) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "invalid offset {0}:{1}", new Object[]{FD, offset});
            io.setErrno(22);
            return MAP_FAILED;
        }
        assert (start == null) : "non null is not portable";
        if (openedFile == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "closing not opened {0}", FD);
            io.setErrno(9);
            return MAP_FAILED;
        }
        if (openedFile.file == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "closing {0}:{1}", new Object[]{FD, openedFile});
            io.setErrno(9);
            return MAP_FAILED;
        }
        FileChannel.MapMode mode = io.toMapMode(prot, flags);
        if (mode == null) {
            Logger.getLogger(io.class.getName()).log(Level.SEVERE, "no write or read flags {0}:{1}", new Object[]{FD, Integer.toHexString(flags)});
            io.setErrno(22);
            return MAP_FAILED;
        }
        try {
            return openedFile.mmap(mode, offset, length);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(io.class.getName()).log(Level.WARNING, "file {0} not found, probably removed", new Object[]{openedFile.toString()});
            io.setErrno(22);
            return MAP_FAILED;
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("cannot extend file to required size")) {
                Logger.getLogger(io.class.getName()).log(Level.WARNING, "file {0} size doesn't match, probably updated externally", new Object[]{openedFile.toString()});
            } else {
                Logger.getLogger(io.class.getName()).log(Level.WARNING, "" + openedFile, ex);
            }
            io.setErrno(22);
            return MAP_FAILED;
        }
    }

    public static int munmap(void$ptr start, long length) {
        assert (!NativeTrace.ALWAYS_USE_NB_FS) : "forgot to delegate munmap request to custome FS impl?";
        OpenedFile openedFile = io.getOpenedFileImpl(start);
        if (NativeTrace.TRACE_IO) {
            NativeTrace.trace("munmap requested " + openedFile, NativeTrace.TRACE_IO);
        }
        io.setErrno(0);
        if (openedFile == null) {
            io.setErrno(22);
            return -1;
        }
        openedFile.munmap(start, length);
        return 0;
    }

    private static FileChannel.MapMode toMapMode(int protection, int flags) {
        FileChannel.MapMode mode = null;
        if ((protection & 2) == 2) {
            if ((protection & 1) == 1) {
                return FileChannel.MapMode.READ_WRITE;
            }
            if ((flags & 2) == 2) {
                return FileChannel.MapMode.PRIVATE;
            }
        } else if ((protection & 1) == 1) {
            return FileChannel.MapMode.READ_ONLY;
        }
        return mode;
    }

    public static int uname(utsname out) {
        io.setErrno(0);
        std.memcpy(out.sysname, System.getProperty("os.name", UNKNOWN));
        std.memcpy(out.version, System.getProperty("os.version", UNKNOWN));
        std.memcpy(out.machine, System.getProperty("os.arch", UNKNOWN));
        std.memcpy(out.nodename, Hostname.hostName);
        std.memcpy(out.release, System.getProperty("os.arch", UNKNOWN) + "-" + System.getProperty("os.name", UNKNOWN) + "-" + System.getProperty("os.version", UNKNOWN));
        return io.errno();
    }

    public static int dladdr(Object addr, Dl_info out) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int dup2(int oldfd, int newfd) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long pathconf(char$ptr __path, int __name) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long fpathconf(int __fd, int __name) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static long sysconf(int __name) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int confstr(int __name, char$ptr __buf, int __len) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static int fcntl(int __fd, int __cmd, Object ... Args) {
        if (__fd >= 0) {
            io.setErrno(0);
            OpenedFile OF = io.getOpenedFileImpl(__fd);
            switch (__cmd) {
                case 1: {
                    return OF.getFlags();
                }
                case 2: {
                    OF.setFlags((Integer)Args[0]);
                    return 0;
                }
            }
            io.setErrno(22);
            return -1;
        }
        io.setErrno(9);
        return -1;
    }

    static {
        openedFiles.add(0, new OpenedFile("stdin", FileDescriptor.in));
        openedFiles.add(1, new OpenedFile("stdout", FileDescriptor.out));
        openedFiles.add(2, new OpenedFile("stderr", FileDescriptor.err));
        if (NativeTrace.VERBOSE_MODE) {
            System.err.printf("STDOUT is a TTY? %s\n", io.isatty(1) != 0);
        }
        assert (openedFiles.size() == 3);
        MAP_FAILED = Native.$toConst(NativePointer.create_char$ptr((byte[])null));
    }

    public static final class Dl_info {
        public char$ptr dli_fname;
        public void$ptr dli_fbase;
        public char$ptr dli_sname;
        public void$ptr dli_saddr;
    }

    private static final class Hostname {
        private static final String hostName = Hostname.get();

        private Hostname() {
        }

        private static String get() {
            String hostName = null;
            if (hostName == null) {
                hostName = System.getProperty("HOSTNAME");
            }
            if (hostName == null) {
                hostName = System.getenv("HOSTNAME");
            }
            if (hostName == null) {
                try {
                    Process uname = Runtime.getRuntime().exec("uname -n");
                    BufferedReader input = new BufferedReader(new InputStreamReader(uname.getInputStream()));
                    hostName = input.readLine();
                    int ret = uname.waitFor();
                    if (ret != 0) {
                        hostName = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (hostName == null) {
                try {
                    hostName = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return hostName == null ? io.UNKNOWN : hostName;
        }
    }

    public static final class utsname {
        public byte[] sysname = NativePointer.new$char(65, new byte[0]);
        public byte[] nodename = NativePointer.new$char(65, new byte[0]);
        public byte[] release = NativePointer.new$char(65, new byte[0]);
        public byte[] version = NativePointer.new$char(65, new byte[0]);
        public byte[] machine = NativePointer.new$char(65, new byte[0]);
        public byte[] domainname = NativePointer.new$char(65, new byte[0]);
    }

    private static final class JavaPrintStreamWrapper
    implements DataOutput {
        private final boolean SystemOut;

        public JavaPrintStreamWrapper(FileDescriptor outFD) {
            assert (outFD == FileDescriptor.out || outFD == FileDescriptor.err);
            this.SystemOut = outFD == FileDescriptor.out;
        }

        private OutputStream getDelegate() {
            return this.SystemOut ? System.out : System.err;
        }

        @Override
        public void write(int b) throws IOException {
            this.getDelegate().write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.getDelegate().write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.getDelegate().write(b, off, len);
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeByte(int v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeShort(int v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeChar(int v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeInt(int v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeLong(long v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeFloat(float v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeDouble(double v) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeBytes(String s) throws IOException {
            byte[] buffer = new byte[s.length()];
            for (int i = 0; i < s.length(); ++i) {
                buffer[i] = Unsigned.$ushort2uchar(s.charAt(i));
            }
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void writeChars(String s) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void writeUTF(String s) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class JavaInputStreamWrapper
    extends InputStream {
        public JavaInputStreamWrapper(FileDescriptor inFD) {
            assert (inFD == FileDescriptor.in);
        }

        private InputStream getDelegate() {
            return System.in;
        }

        @Override
        public int read() throws IOException {
            return this.getDelegate().read();
        }
    }

    private static final class OpenedFile {
        private final String name;
        private final RandomAccessFile file;
        private final InputStream inputStream;
        private final DataOutput outStream;
        private FileChannel channel = null;
        private boolean closed = false;
        private final char$ptr charPtr = NativePointer.create_char$null$ptr();
        private MappedByteBuffer BBuffer = null;
        private int flags;
        private static Method DIRECT_BUFFER_CLEANER_METHOD = null;
        private static Method DIRECT_BUFFER_CLEANER_CLEAN_METHOD = null;

        public OpenedFile(String name, RandomAccessFile file) {
            this.name = name;
            this.file = file;
            this.outStream = file;
            this.inputStream = null;
        }

        public OpenedFile(String name, FileDescriptor inOutFD) {
            this.name = name;
            this.file = null;
            if (inOutFD == FileDescriptor.out || inOutFD == FileDescriptor.err) {
                this.inputStream = null;
                this.outStream = new JavaPrintStreamWrapper(inOutFD);
            } else {
                this.inputStream = new JavaInputStreamWrapper(inOutFD);
                this.outStream = null;
            }
        }

        private int setFlags(int flags) {
            this.flags = flags;
            return this.flags;
        }

        private int getFlags() {
            return this.flags;
        }

        public String toString() {
            return "OpenedFile{name=" + this.name + ", file=" + this.file + '}';
        }

        public int close() throws IOException {
            if (this.closed) {
                throw new IllegalStateException("already closed " + this.name);
            }
            this.closed = true;
            if (this.channel != null) {
                this.channel.close();
            }
            this.file.close();
            return 0;
        }

        private void write(byte[] buffer, int off, int len) throws IOException {
            this.outStream.write(buffer, off, len);
        }

        private void writeBytes(String bytes) throws IOException {
            this.outStream.writeBytes(bytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char$ptr mmap(FileChannel.MapMode mode, long pos, long size) throws IOException {
            assert (this.charPtr.$isNull()) : "already in use";
            assert (this.BBuffer == null) : "already in use";
            assert (this.channel == null) : "channel already in use";
            MappedByteBuffer out = null;
            try {
                this.channel = this.file.getChannel();
                out = this.channel.map(mode, pos, size);
                byte[] dst = NativePointer.new$char(Unsigned.$long2uint(pos + size + 1L), new byte[0]);
                out.get(dst, Unsigned.$long2uint(pos), Unsigned.$long2uint(size));
                this.charPtr.$assign(NativePointer.create_char$ptr(dst, Unsigned.$long2uint(pos)));
                char$ptr char$ptr = this.charPtr;
                return char$ptr;
            }
            finally {
                String cleanerClassName = "";
                try {
                    out.clear();
                    if (out.isDirect()) {
                        Object cleaner;
                        Method cleanerMethod;
                        if (DIRECT_BUFFER_CLEANER_CLEAN_METHOD == null && (cleanerMethod = out.getClass().getMethod("cleaner", new Class[0])) != null) {
                            Method cleanMethod;
                            cleanerMethod.setAccessible(true);
                            Object cleaner2 = cleanerMethod.invoke((Object)out, new Object[0]);
                            if (cleaner2 != null && (cleanMethod = cleaner2.getClass().getMethod("clean", new Class[0])) != null) {
                                cleanMethod.setAccessible(true);
                                DIRECT_BUFFER_CLEANER_METHOD = cleanerMethod;
                                DIRECT_BUFFER_CLEANER_CLEAN_METHOD = cleanMethod;
                            }
                        }
                        if (DIRECT_BUFFER_CLEANER_CLEAN_METHOD != null && (cleaner = DIRECT_BUFFER_CLEANER_METHOD.invoke((Object)out, new Object[0])) != null) {
                            DIRECT_BUFFER_CLEANER_CLEAN_METHOD.invoke(cleaner, new Object[0]);
                        }
                    }
                }
                catch (Throwable e) {
                    if (!cleanerClassName.isEmpty()) {
                        NativeTrace.printDebuggingStackFrames("Class " + cleanerClassName + " doesn't have 'clean' method for Buf:" + NativeTrace.getIdentityStr(out));
                    }
                    NativeTrace.printStackTraceOnce(e);
                }
            }
        }

        public boolean isPtrOwner(void$ptr MMapPtr) {
            assert (MMapPtr != this.charPtr || !this.charPtr.$isNull()) : "null can not be mapped";
            return MMapPtr == this.charPtr || this.charPtr.$eq(MMapPtr);
        }

        public boolean munmap(void$ptr MMapPtr, long length) {
            this.BBuffer = null;
            NativePointer.clear_char$ptr(this.charPtr);
            return true;
        }

        private long position() throws IOException {
            return this.file.getFilePointer();
        }

        private void seek(long __file_offset) throws IOException {
            this.file.seek(__file_offset);
        }

        private long length() throws IOException {
            return this.file.length();
        }
    }

    public static final class stat {
        public long st_dev;
        public long[] st_pad1 = NativePointer.new$long(3);
        public long st_ino;
        public int st_mode;
        public long st_nlink;
        public int st_uid;
        public int st_gid;
        public long st_rdev;
        public long[] st_pad2 = NativePointer.new$long(2);
        public long st_size;
        public long st_pad3;
        public std_time.timespec st_atim = new std_time.timespec();
        public std_time.timespec st_mtim = new std_time.timespec();
        public std_time.timespec st_ctim = new std_time.timespec();
        public int st_blksize;
        public long st_blocks;
        public byte[] st_fstype = NativePointer.new$char(16, new byte[0]);
        public long[] st_pad4 = NativePointer.new$long(8);
    }

    public static class dirent {
        public long d_ino;
        public long d_off;
        public int d_reclen;
        public byte[] d_name = NativePointer.new$char(1, new byte[0]);

        public String toString() {
            return "dirent{d_ino=" + this.d_ino + ", d_off=" + this.d_off + ", d_reclen=" + this.d_reclen + ", d_name=" + new String(this.d_name) + '}';
        }
    }

    public static class DIR {
        public int d_fd;
        public int d_loc;
        public int d_size;
        public char$ptr d_buf;

        public String toString() {
            return "DIR{d_fd=" + this.d_fd + ", d_loc=" + this.d_loc + ", d_size=" + this.d_size + ", d_buf=" + this.d_buf + '}';
        }
    }

    public static class FILE {
        public int _cnt;
        public char$ptr _ptr;
        public char$ptr _base;
        public short _flag;
        public short _magic;
        public byte __orientation;
        public boolean __ionolock;
        public boolean __seekable;
        public boolean __extendedfd;
        public boolean __xf_nocheck;
        public char __filler;
        private int $FD;

        public FILE() {
        }

        private FILE(int FD) {
            this.$FD = FD;
        }
    }

    private static class StreamOut
    implements ostream {
        private final PrintStream out;

        public StreamOut(PrintStream out) {
            this.out = out;
        }

        @Override
        public basic_ostream $out(String format, Object ... args) {
            this.out.printf(io.Cpp2JavaFormatString(format), io.prepareArgsForPrintf(args));
            return this;
        }

        @Override
        public basic_ostream $out(NativeCallback.Void2String o) {
            this.out.print(o.$call());
            return this;
        }

        @Override
        public <T> basic_ostream $out(T o) {
            this.out.print(o);
            return this;
        }

        @Override
        public basic_ostream $out(char$ptr str) {
            this.out.print(str);
            return this;
        }

        @Override
        public basic_ostream $out(char$ptr str, int Len) {
            throw new UnsupportedOperationException("Please implement it!");
        }

        @Override
        public basic_ostream $out_os_str(std.string str) {
            this.out.print(str.c_str());
            return this;
        }

        @Override
        public basic_ostream $out(byte o) {
            this.out.print(o);
            return this;
        }

        @Override
        public basic_ostream $out(char o) {
            this.out.print(o);
            return this;
        }

        @Override
        public basic_ostream $out(int o) {
            this.out.print(o);
            return this;
        }

        @Override
        public basic_ostream $out_int(int o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(long o) {
            this.out.print(o);
            return this;
        }

        @Override
        public basic_ostream $out(double o) {
            this.out.print(o);
            return this;
        }

        @Override
        public basic_ostream write(char$ptr data, int size) {
            throw new UnsupportedOperationException("Please implement it!");
        }

        @Override
        public void $destroy() {
            this.out.close();
        }
    }

    private static class StreamIn
    implements istream {
        private final InputStream in;

        public StreamIn(InputStream in) {
            this.in = in;
        }

        @Override
        public boolean eof() {
            return false;
        }

        @Override
        public boolean fail() {
            return false;
        }

        @Override
        public int getline(std.string to) {
            StringBuilder out = new StringBuilder();
            try {
                int ch;
                while ((ch = this.in.read()) != -1 && ch != 10) {
                    out.append((char)ch);
                }
            }
            catch (IOException ex) {
                NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
            }
            to.$assign(out.toString());
            return out.length() == 0 ? -1 : out.length();
        }

        @Override
        public void $destroy() {
            try {
                this.in.close();
            }
            catch (IOException ex) {
                NativeTrace.printStackTraceOnce(ex, Level.SEVERE, false);
            }
        }
    }

    public static interface iostream
    extends istream,
    ostream {
    }

    public static class ostringstream
    implements basic_ostream {
        @Override
        public <T> basic_ostream $out(T o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(NativeCallback.Void2String o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(byte o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(char o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(int o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out_int(int o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(long o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(double o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(char$ptr str) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(char$ptr str, int Len) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out_os_str(std.string str) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(String format, Object ... args) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream write(char$ptr data, int size) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public std.string str() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void $destroy() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static interface ostream
    extends basic_ostream {
    }

    public static interface basic_ostream
    extends Destructors.ClassWithDestructor {
        public <T> basic_ostream $out(T var1);

        public basic_ostream $out(NativeCallback.Void2String var1);

        public basic_ostream $out(byte var1);

        public basic_ostream $out(char var1);

        public basic_ostream $out(int var1);

        public basic_ostream $out_int(int var1);

        public basic_ostream $out(long var1);

        public basic_ostream $out(double var1);

        public basic_ostream $out(char$ptr var1);

        public basic_ostream $out(char$ptr var1, int var2);

        public basic_ostream $out_os_str(std.string var1);

        public basic_ostream $out(String var1, Object ... var2);

        public basic_ostream write(char$ptr var1, int var2);
    }

    public static interface istream
    extends basic_istream {
    }

    public static class basic_stringstream
    implements basic_ostream {
        @Override
        public <T> basic_ostream $out(T o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(NativeCallback.Void2String o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(byte o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(char o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(int o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out_int(int o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(long o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(double o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(char$ptr str) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(char$ptr str, int Len) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out_os_str(std.string str) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream $out(String format, Object ... args) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public basic_ostream write(char$ptr data, int size) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String str() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void $destroy() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static interface basic_istream
    extends basic_ios,
    Destructors.ClassWithDestructor {
        public boolean eof();

        public boolean fail();

        public int getline(std.string var1);
    }

    public static interface basic_ios {
        default public boolean good() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class basic_ifstream
    implements basic_istream,
    Destructors.ClassWithDestructor {
        public basic_ifstream(char$ptr filePath) {
        }

        @Override
        public boolean eof() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean fail() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getline(std.string to) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean is_open() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void $destroy() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

