/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core;

import java.io.IOException;
import org.ec4j.core.PropertyTypeRegistry;
import org.ec4j.core.Resource;
import org.ec4j.core.model.EditorConfig;
import org.ec4j.core.model.Version;
import org.ec4j.core.parser.EditorConfigModelHandler;
import org.ec4j.core.parser.EditorConfigParser;
import org.ec4j.core.parser.ErrorHandler;

public class EditorConfigLoader {
    private final ErrorHandler errorHandler;
    private final EditorConfigModelHandler handler;
    private final EditorConfigParser parser = EditorConfigParser.default_();

    public static EditorConfigLoader default_() {
        return new EditorConfigLoader(new EditorConfigModelHandler(PropertyTypeRegistry.default_(), Version.CURRENT), ErrorHandler.THROW_SYNTAX_ERRORS_IGNORE_OTHERS);
    }

    public static EditorConfigLoader of(Version version) {
        return EditorConfigLoader.of(version, PropertyTypeRegistry.default_());
    }

    public static EditorConfigLoader of(Version version, PropertyTypeRegistry registry) {
        return EditorConfigLoader.of(version, registry, ErrorHandler.THROW_SYNTAX_ERRORS_IGNORE_OTHERS);
    }

    public static EditorConfigLoader of(Version version, PropertyTypeRegistry registry, ErrorHandler errorHandler) {
        return new EditorConfigLoader(new EditorConfigModelHandler(registry, version), errorHandler);
    }

    public EditorConfigLoader(EditorConfigModelHandler handler, ErrorHandler errorHandler) {
        this.handler = handler;
        this.errorHandler = errorHandler;
    }

    public EditorConfig load(Resource configFile) throws IOException {
        try {
            this.parser.parse(configFile, this.handler, this.errorHandler);
            EditorConfig result = this.handler.getEditorConfig();
            return result;
        }
        catch (IOException e) {
            throw new IOException("Could not load " + configFile.getPath(), e);
        }
    }
}

