/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.fus.impl;

import fleet.dock.connectors.fus.FusApiKind;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"SESSION_ID_CREATION_FORMAT", "", "generateSessionId", "getCurrentHourInUTC", "calendar", "Ljava/util/Calendar;", "getOrGenerateSaltFromPrefs", "", "recorderId", "getPrefs", "Lkotlin/Pair;", "Ljava/util/prefs/Preferences;", "getSaltFromPrefs", "shortedUUID", "fleet.reporting.fus.impl"})
public final class SaltGenerationKt {
    @NotNull
    private static final String SESSION_ID_CREATION_FORMAT = "yyyy-MM-dd HH";

    @Nullable
    public static final byte[] getSaltFromPrefs(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Pair<Preferences, String> pair = SaltGenerationKt.getPrefs(recorderId);
        Preferences prefs = (Preferences)pair.component1();
        String saltKey = (String)pair.component2();
        return prefs.getByteArray(saltKey, null);
    }

    @NotNull
    public static final byte[] getOrGenerateSaltFromPrefs(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Pair<Preferences, String> pair = SaltGenerationKt.getPrefs(recorderId);
        Preferences prefs = (Preferences)pair.component1();
        String saltKey = (String)pair.component2();
        byte[] salt = prefs.getByteArray(saltKey, null);
        if (salt == null) {
            salt = new byte[32];
            new SecureRandom().nextBytes(salt);
            prefs.putByteArray(saltKey, salt);
        }
        return salt;
    }

    private static final Pair<Preferences, String> getPrefs(String recorderId) {
        Object object;
        Preferences prefs = Preferences.userRoot().node("jetbrains");
        if (Intrinsics.areEqual((Object)FusApiKind.Main.getRecorderId(), (Object)recorderId)) {
            object = "feature_usage_event_log_salt";
        } else {
            String string = recorderId.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            object = string + "_event_log_salt";
        }
        String saltKey = object;
        return new Pair((Object)prefs, (Object)saltKey);
    }

    @NotNull
    public static final String generateSessionId() {
        String presentableHour = SaltGenerationKt.getCurrentHourInUTC$default(null, 1, null);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return presentableHour + "_" + SaltGenerationKt.shortedUUID(string);
    }

    private static final String getCurrentHourInUTC(Calendar calendar) {
        calendar.set(1, RangesKt.coerceIn((int)calendar.get(1), (int)2000, (int)2099));
        SimpleDateFormat format = new SimpleDateFormat(SESSION_ID_CREATION_FORMAT, Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        String string = format.format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    static /* synthetic */ String getCurrentHourInUTC$default(Calendar calendar, int n, Object object) {
        if ((n & 1) != 0) {
            Calendar calendar2 = Calendar.getInstance(Locale.ENGLISH);
            Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"getInstance(...)");
            calendar = calendar2;
        }
        return SaltGenerationKt.getCurrentHourInUTC(calendar);
    }

    @NotNull
    public static final String shortedUUID(@NotNull String $this$shortedUUID) {
        Intrinsics.checkNotNullParameter((Object)$this$shortedUUID, (String)"<this>");
        int start = StringsKt.lastIndexOf$default((CharSequence)$this$shortedUUID, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (start > 0 && start + 1 < $this$shortedUUID.length()) {
            String string = $this$shortedUUID.substring(start + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return $this$shortedUUID;
    }
}

