/*
 * Decompiled with CFR 0.152.
 */
package fleet.rpc.relay.jwt;

import fleet.rpc.relay.jwt.JWK;
import fleet.rpc.relay.jwt.JWKThumbprintSerializer;
import fleet.rpc.relay.jwt.JWTKt;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=JWKThumbprintSerializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lfleet/rpc/relay/jwt/JWKThumbprint;", "", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "fleet.rpc.relay"})
public final class JWKThumbprint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;

    public JWKThumbprint(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final JWKThumbprint copy(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new JWKThumbprint(value);
    }

    public static /* synthetic */ JWKThumbprint copy$default(JWKThumbprint jWKThumbprint, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = jWKThumbprint.value;
        }
        return jWKThumbprint.copy(string);
    }

    @NotNull
    public String toString() {
        return "JWKThumbprint(value=" + this.value + ")";
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JWKThumbprint)) {
            return false;
        }
        JWKThumbprint jWKThumbprint = (JWKThumbprint)other;
        return Intrinsics.areEqual((Object)this.value, (Object)jWKThumbprint.value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u00c6\u0001\u00a8\u0006\t"}, d2={"Lfleet/rpc/relay/jwt/JWKThumbprint$Companion;", "", "()V", "calculate", "Lfleet/rpc/relay/jwt/JWKThumbprint;", "jwk", "Lfleet/rpc/relay/jwt/JWK;", "serializer", "Lkotlinx/serialization/KSerializer;", "fleet.rpc.relay"})
    @SourceDebugExtension(value={"SMAP\nJWT.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JWT.kt\nfleet/rpc/relay/jwt/JWKThumbprint$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JWKThumbprint calculate(@NotNull JWK jwk) {
            Intrinsics.checkNotNullParameter((Object)jwk, (String)"jwk");
            if (!Intrinsics.areEqual((Object)jwk.getKty(), (Object)"RSA")) {
                boolean $i$a$-require-JWKThumbprint$Companion$calculate$22 = false;
                String $i$a$-require-JWKThumbprint$Companion$calculate$22 = "Only RSA key type is supported";
                throw new IllegalArgumentException($i$a$-require-JWKThumbprint$Companion$calculate$22.toString());
            }
            String stringRepresenation = "\"e\":\"" + jwk.getExponent() + "\",\"kty\":\"RSA\",\"n\":\"" + jwk.getModulus() + "\"";
            byte[] byArray = stringRepresenation.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] bytes = byArray;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(bytes);
            Intrinsics.checkNotNull((Object)hash);
            return new JWKThumbprint(JWTKt.access$jwtBase64Encode(hash));
        }

        @NotNull
        public final KSerializer<JWKThumbprint> serializer() {
            return (KSerializer)new JWKThumbprintSerializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

