/*
 * Decompiled with CFR 0.152.
 */
package fleet.rpc.relay;

import fleet.rpc.client.ClientId;
import fleet.rpc.relay.RelaySessionSerializer;
import fleet.util.UID;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=RelaySessionSerializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lfleet/rpc/relay/RelaySession;", "", "clientId", "Lfleet/rpc/client/ClientId;", "session", "Lfleet/util/UID;", "(Lfleet/rpc/client/ClientId;Lfleet/util/UID;)V", "getClientId", "()Lfleet/rpc/client/ClientId;", "getSession", "()Lfleet/util/UID;", "component1", "component2", "copy", "encode", "", "equals", "", "other", "hashCode", "", "toString", "Companion", "fleet.rpc.relay"})
public final class RelaySession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientId clientId;
    @NotNull
    private final UID session;
    @NotNull
    public static final String SEPARATOR = "_";

    public RelaySession(@NotNull ClientId clientId, @NotNull UID session) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.clientId = clientId;
        this.session = session;
    }

    @NotNull
    public final ClientId getClientId() {
        return this.clientId;
    }

    @NotNull
    public final UID getSession() {
        return this.session;
    }

    @NotNull
    public final String encode() {
        return this.clientId.getUid().getId() + SEPARATOR + this.session.getId();
    }

    @NotNull
    public final ClientId component1() {
        return this.clientId;
    }

    @NotNull
    public final UID component2() {
        return this.session;
    }

    @NotNull
    public final RelaySession copy(@NotNull ClientId clientId, @NotNull UID session) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new RelaySession(clientId, session);
    }

    public static /* synthetic */ RelaySession copy$default(RelaySession relaySession, ClientId clientId, UID uID, int n, Object object) {
        if ((n & 1) != 0) {
            clientId = relaySession.clientId;
        }
        if ((n & 2) != 0) {
            uID = relaySession.session;
        }
        return relaySession.copy(clientId, uID);
    }

    @NotNull
    public String toString() {
        return "RelaySession(clientId=" + this.clientId + ", session=" + this.session + ")";
    }

    public int hashCode() {
        int result2 = this.clientId.hashCode();
        result2 = result2 * 31 + this.session.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RelaySession)) {
            return false;
        }
        RelaySession relaySession = (RelaySession)other;
        if (!Intrinsics.areEqual((Object)this.clientId, (Object)relaySession.clientId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.session, (Object)relaySession.session);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u00c6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lfleet/rpc/relay/RelaySession$Companion;", "", "()V", "SEPARATOR", "", "decode", "Lfleet/rpc/relay/RelaySession;", "string", "serializer", "Lkotlinx/serialization/KSerializer;", "fleet.rpc.relay"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RelaySession decode(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            String[] stringArray = new String[]{RelaySession.SEPARATOR};
            List components = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (!(components.size() == 2)) {
                boolean bl = false;
                String string2 = "Wrong components count in network address string [" + string + "]";
                throw new IllegalStateException(string2.toString());
            }
            return new RelaySession(new ClientId(UID.Companion.fromString((String)components.get(0))), UID.Companion.fromString((String)components.get(1)));
        }

        @NotNull
        public final KSerializer<RelaySession> serializer() {
            return (KSerializer)new RelaySessionSerializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

