UDP Tracker Protocol
====================

This description of the UDP tracker protocol is adapted from
[this page](https://libtorrent.org/udp_tracker_protocol.html) by Arvid Norberg.

A tracker with the protocol "udp://" in its URI is should be contacted with
this protocol.

All values are sent in network byte order (big-endian).

If no response to a request is received within 15 seconds, resend the request.
If no reply has been received after 60 seconds, stop retrying.

Transaction IDs sent in request messages are returned in response messages.

Connection ID returned by tracker in connect response message should be sent
by client in later requests. The initial connection ID sent in connect requests
shoudl be `0x41727101980` in network byte order.

Action values in requests and responses should be taken from the `Actions`
table.

When a message is followed by a structure labeled _repeating:_, the rest of the
message is zero or more of that structure.

Fields with type `[T; N]` are `N` instances of values of type `T` with no extra
padding.

Fields with type `[T; NAME]` are `NAME` instances of values of type `T` with no
extra padding, where `NAME` is an integer field of the same message.

Files with type `[T]` are zero or more instances of values of type `T` with no
extra padding, which make up any trailing bytes of the message.


Actions
-------

| name     | value |
|----------|-------|
| connect  | 0     |
| announce | 1     |
| scrape   | 2     |
| error    | 3     |

Events
------

| name      | value |
|-----------|-------|
| none      | 0     |
| completed | 1     |
| started   | 2     |
| stopped   | 3     |

Error
------

| type | name           | description                               |
|------|----------------|-------------------------------------------|
| i32  | action         |                                           |
| i32  | transaction_id |                                           |
| [i8] | error_string   | rest of packet is string describing error |

Connect
-------

### Request

| type | name           |
|------|----------------|
| i64  | connection_id  |
| i32  | action         |
| i32  | transaction_id |

### Response

| type | name           |
|------|----------------|
| i32  | action         |
| i32  | transaction_id |
| i64  | connection_id  |

Announce
--------

### Request

| type     | name           | description                                                  |
|----------|----------------|--------------------------------------------------------------|
| i64      | connection_id  |                                                              |
| i32      | action         |                                                              |
| i32      | transaction_id |                                                              |
| [i8; 20] | info_hash      | torrent infohash                                             |
| [i8; 20] | peer_id        | peer ID                                                      |
| i64      | downloaded     | bytes downloaded this session                                |
| i64      | left           | bytes left to download                                       |
| i64      | uploaded       | bytes uploaded this session                                  |
| i32      | event          | from `Events` table                                          |
| u32      | ip             | 0 to use sender of this UDP packet                           |
| u32      | key            | randomly generated by client, unknown function.              |
| i32      | num_want       | maximum number of peers to send in reply, use -1 for default |
| u16      | port           | listening port                                               |
| u16      | extensions     |                                                              |

### Response

| type | name           | description                                                 |
|------|----------------|-------------------------------------------------------------|
| i32  | action         |                                                             |
| i32  | transaction_id |                                                             |
| i32  | interval       | seconds to wait announcing again                            |
| i32  | leechers       | number of peers in swarm that have not finished downloading |
| i32  | seeders        | number of peers in swarm that have finished downloading     |

_repeating:_

| type | name | description         |
|------|------|---------------------|
| i32  | ip   | peer IP             |
| i16  | port | peer listening port |

Scrape
------

### Request

| type | name           |
|------|----------------|
| i64  | connection_id  |
| i32  | action         |
| i32  | transaction_id |

_repeating:_

| type     | name      |
|----------|-----------|
| [i8; 20] | info_hash |

### Response

| type | name           |
|------|----------------|
| i32  | action         |
| i32  | transaction_id |

_repeating:_

| type | name       | description                                  |
|------|------------|----------------------------------------------|
| i32  | complete   | peers in swarm that have finished downloding |
| i32  | downloaded | times torrent has been downloaded            |
| i32  | incomplete | peers that have not finished downloading     |

Extensions
----------

The extensions field is a bitmask. The following bits are assigned:

| name           | bit |
|----------------|-----|
| authentication | 1   |
| request string | 2   |

If multiple bits are present in the extension field, the extension bodies are
appended to the packet in the order of least significant bit first. For
instance, if both bit 1 and 2 are set, the extension represented by bit 1 comes
first, followed by the extension represented by bit 2.

### Authentication

The packet will have authentication information appended to it.

`passwd_hash` is the first eight bytes of `sha1(packet || sha1(password))`,
where `packet` is the bytes of the packet, less the final 8 bytes that are
`passwd_hash`.

| type                   | name            |
|------------------------|-----------------|
| i8                     | username_length |
| [i8; `username_length` | username        |
| [u8; 8]                | passwd_hash     |

### Request String

The request string extension is meant to allow torrent creators pass along
cookies back to the tracker. This can be useful for authenticating that a
torrent is allowed to be tracked by a tracker for instance. It could also be
used to authenticate users by generating torrents with unique tokens in the
tracker URL for each user. The extension body has the following format:

| type                   | name           |
|------------------------|----------------|
| i8                     | request_length |
| [i8; `request_length`] | request_string |

`request_string` is the string that comes after the hostname and port in the
UDP tracker URL. Typically this starts with "/announce" The bittorrent client
is not expected to append query string arguments for stats reporting, like
"uploaded" and "downloaded" since this is already reported in the UDP tracker
protocol. However, the client is free to add arguments as extensions.|

Credits
-------

Protocol designed by Olaf van der Spek and extended by Arvid Norberg
