import type {Connection} from "@volar/language-server"
import type {createServer} from "@volar/language-server/node"
import {URI} from "vscode-uri"
import type {GetElementTypeArguments, GetSymbolTypeArguments, GetTypePropertiesArguments} from "tsc-ide-plugin/protocol"
import {getElementTypeVolarServer, getSymbolTypeVolarServer, getTypePropertiesVolarServer} from "./get-element-type-volar-server"

export function addIjServerPlugin(ts: typeof import("tsc-ide-plugin/tsserverlibrary.shim"), connection: Connection, server: ReturnType<typeof createServer>) {
  async function getService(uri: string) {
    return (await server.project.getLanguageService(URI.parse(uri)));
  }

  connection.onRequest('$/ij/getElementType', async (params: GetElementTypeArguments) => {
    const languageService = await getService(params.file);
    if (languageService) {
      return getElementTypeVolarServer(ts, languageService.context, params.file, params);
    }
  });
  connection.onRequest('$/ij/getSymbolType', async (params: GetSymbolTypeArguments) => {
    const languageService = await getService(params.originalRequestUri);
    if (languageService) {
      return getSymbolTypeVolarServer(ts, languageService.context, params.originalRequestUri, params);
    }
  });
  connection.onRequest('$/ij/getTypeProperties', async (params: GetTypePropertiesArguments) => {
    const languageService = await getService(params.originalRequestUri);
    if (languageService) {
      return getTypePropertiesVolarServer(ts, languageService.context, params.originalRequestUri, params);
    }
  });
}