import React from 'react';
import { ERROR_TEXT } from '../../constants';
var renderErrors = function (errors) {
    if (!errors) {
        return null;
    }
    return errors
        .map(function (singleError, index) {
        if (!singleError || !singleError.title || !singleError.location) {
            return null;
        }
        return (React.createElement("div", { key: index, className: "flex" },
            React.createElement("span", null, "".concat(singleError.location.startLine, ".")),
            React.createElement("code", { className: "whitespace-pre-wrap break-all ml-2" }, singleError.title)));
    })
        .filter(Boolean);
};
export var Error = function (_a) {
    var error = _a.error;
    if (!error) {
        return null;
    }
    var title = error.title, validationErrors = error.validationErrors;
    return (React.createElement("div", { className: "panel-item" },
        React.createElement("div", { className: "panel-item--center p-8" },
            React.createElement("section", { className: "shadow rounded bg-gray-200 border-red-500 border-l-8" },
                React.createElement("h2", { className: "p-2" }, title ? "".concat(ERROR_TEXT, ": ").concat(title) : ERROR_TEXT),
                validationErrors && validationErrors.length ? (React.createElement("div", { className: "bg-gray-800 text-white text-xs p-2" },
                    React.createElement("pre", null, renderErrors(validationErrors)))) : null)),
        React.createElement("div", { className: "panel-item--right" })));
};
//# sourceMappingURL=Error.js.map