// Copyright 2016-2021 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.goide;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.testFramework.TestModeFlags;
import org.jetbrains.annotations.NotNull;

public final class GoOsManager {
  public static final Key<OS> TESTING_OS = Key.create("GO_TESTING_OS");
  public static final Key<String> TESTING_ARCH = Key.create("GO_TESTING_ARCH");

  public enum OS {
    LINUX, WINDOWS, MAC
  }

  public static boolean isWindows() {
    return isOs(OS.WINDOWS, SystemInfo.isWindows);
  }

  public static boolean isLinux() {
    return isOs(OS.LINUX, SystemInfo.isLinux);
  }

  public static boolean isMac() {
    return isOs(OS.MAC, SystemInfo.isMac);
  }

  private static boolean isOs(@NotNull OS expected, boolean defaultValue) {
    if (ApplicationManager.getApplication().isUnitTestMode()) {
      OS os = TestModeFlags.get(TESTING_OS);
      if (os != null) {
        return os == expected;
      }
    }
    return defaultValue;
  }
}
