"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryHandleTsServerCommand = exports.initCommandNamesForSessionProvider = exports.registerProtocolHandlers = void 0;
const get_element_type_ts_server_1 = require("./get-element-type-ts-server");
const customHandlers = {
    "ideGetElementType": get_element_type_ts_server_1.getElementTypeTsServer,
    "ideGetSymbolType": get_element_type_ts_server_1.getSymbolTypeTsServer,
    "ideGetTypeProperties": get_element_type_ts_server_1.getTypePropertiesTsServer,
    "ideCloseSafely": closeSafelyTsServer,
    "ideEnsureFileAndProjectOpenedCommand": ensureFileAndProjectOpenedTsServer,
};
/** This method is used to register handlers for TS 5+ */
function registerProtocolHandlers(session, ts, projectService) {
    for (let command in customHandlers) {
        session.addProtocolHandler(command, (request) => {
            try {
                return customHandlers[command](ts, projectService, request) || emptyDoneResponse();
            }
            catch (e) {
                if (e.isOperationCancelledError) {
                    return cancelledResponse();
                }
                else {
                    throw e;
                }
            }
        });
    }
}
exports.registerProtocolHandlers = registerProtocolHandlers;
/** This method is used by the old session provider logic for TS <5 **/
function initCommandNamesForSessionProvider(TypeScriptCommandNames) {
    for (let command in customHandlers) {
        TypeScriptCommandNames[command] = command;
    }
}
exports.initCommandNamesForSessionProvider = initCommandNamesForSessionProvider;
/** This method is used by the old session provider logic for TS <5  **/
function tryHandleTsServerCommand(ts_impl, projectService, request) {
    var _a;
    return (_a = customHandlers[request.command]) === null || _a === void 0 ? void 0 : _a.call(customHandlers, ts_impl, projectService, request);
}
exports.tryHandleTsServerCommand = tryHandleTsServerCommand;
function closeSafelyTsServer(_ts, projectService, request) {
    const requestArguments = request.arguments;
    projectService.ideProjectService.closeClientFileSafely(requestArguments.file);
    return notRequiredResponse();
}
function ensureFileAndProjectOpenedTsServer(ts, projectService, request) {
    const requestArguments = request.arguments;
    // Ensure that there is a project opened for the file
    projectService.ideProjectService.getProjectAndSourceFile(requestArguments.file, requestArguments.projectFileName);
    return notRequiredResponse();
}
function notRequiredResponse() {
    return {
        responseRequired: false
    };
}
function emptyDoneResponse() {
    return {
        responseRequired: true,
        response: null
    };
}
function cancelledResponse() {
    return {
        responseRequired: true,
        response: {
            cancelled: true
        }
    };
}
//# sourceMappingURL=ide-commands.js.map