"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTypePropertiesTsServer = exports.getSymbolTypeTsServer = exports.getElementTypeTsServer = exports.decorateLanguageService = void 0;
const ide_get_element_type_1 = require("./ide-get-element-type");
const decoratedLanguageServices = new WeakSet();
function decorateLanguageService(languageService) {
    if (decoratedLanguageServices.has(languageService)) {
        return;
    }
    decoratedLanguageServices.add(languageService);
    languageService.webStormGetElementType = (ts, fileName, startOffset, endOffset, forceReturnType, cancellationToken, reverseMapper) => {
        // see getQuickInfoAtPosition
        let program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        const sourceFile = program.getSourceFile(fileName);
        if (!sourceFile) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getElementTypeByOffsets)(ts, languageService.ideProjectId, program, sourceFile, startOffset, endOffset, forceReturnType, cancellationToken, reverseMapper);
    };
    languageService.webStormGetSymbolType = (ts, symbolId, cancellationToken, reverseMapper) => {
        let program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getSymbolType)(ts, program, symbolId, cancellationToken, reverseMapper);
    };
    languageService.webStormGetTypeProperties = (ts, typeId, cancellationToken, reverseMapper) => {
        let program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getTypeProperties)(ts, program, typeId, cancellationToken, reverseMapper);
    };
}
exports.decorateLanguageService = decorateLanguageService;
function getElementTypeTsServer(ts, projectService, request) {
    const requestArguments = request.arguments;
    let fileName = ts.server.toNormalizedPath(requestArguments.file);
    let { project, sourceFile } = projectService.ideProjectService.getProjectAndSourceFile(requestArguments.file, requestArguments.projectFileName);
    if (!project || !sourceFile)
        return undefined;
    let range = requestArguments.range;
    let startOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.start.line, range.start.character);
    let endOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.end.line, range.end.character);
    return project.getLanguageService().webStormGetElementType(ts, fileName, startOffset, endOffset, requestArguments.forceReturnType, projectService.cancellationToken);
}
exports.getElementTypeTsServer = getElementTypeTsServer;
function getSymbolTypeTsServer(ts, projectService, request) {
    const requestArguments = request.arguments;
    const languageService = findLanguageService(projectService, requestArguments.ideProjectId, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormGetSymbolType(ts, requestArguments.symbolId, projectService.cancellationToken);
}
exports.getSymbolTypeTsServer = getSymbolTypeTsServer;
function getTypePropertiesTsServer(ts, projectService, request) {
    const requestArguments = request.arguments;
    const languageService = findLanguageService(projectService, requestArguments.ideProjectId, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormGetTypeProperties(ts, requestArguments.typeId, projectService.cancellationToken);
}
exports.getTypePropertiesTsServer = getTypePropertiesTsServer;
function findLanguageService(projectService, ideProjectId, ideTypeCheckerId) {
    for (let [, project] of projectService.configuredProjects) {
        if (project.ideProjectId === ideProjectId) {
            return getLanguageService(project);
        }
    }
    for (let inferredProject of projectService.inferredProjects) {
        if (inferredProject.ideProjectId === ideProjectId) {
            return getLanguageService(inferredProject);
        }
    }
    for (let externalProject of projectService.externalProjects) {
        if (externalProject.ideProjectId === ideProjectId) {
            return getLanguageService(externalProject);
        }
    }
    function getLanguageService(project) {
        var _a, _b, _c, _d;
        let program = project.getLanguageService().getProgram();
        if (((_b = (_a = program === null || program === void 0 ? void 0 : program.getTypeChecker()) === null || _a === void 0 ? void 0 : _a.webStormCacheInfo) === null || _b === void 0 ? void 0 : _b.ideTypeCheckerId) == ideTypeCheckerId) {
            return project.getLanguageService();
        }
        console.error(`findLanguageService - failed to find language service for ideProjectId ${ideProjectId} - wrong typeCheckerId. Cached: ${(_d = (_c = program === null || program === void 0 ? void 0 : program.getTypeChecker()) === null || _c === void 0 ? void 0 : _c.webStormCacheInfo) === null || _d === void 0 ? void 0 : _d.ideTypeCheckerId}, requested: ${ideTypeCheckerId}`);
    }
    console.error(`findLanguageService - failed to find language service for ideProjectId ${ideProjectId}`);
}
//# sourceMappingURL=get-element-type-ts-server.js.map