/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter.settings;

import com.goide.GoLanguage;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.i18n.GoBundle;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NonNls
    private static final String DEFAULT_CODE_SAMPLE = "package main\n\nimport \"fmt\"\n\nfunc main() {\n\tfmt.Println(\"Hello\")\n}";

    @NotNull
    public Language getLanguage() {
        Language language = GoLanguage.INSTANCE;
        if (language == null) {
            GoLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return language;
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            GoLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return DEFAULT_CODE_SAMPLE;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            GoLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        return new GoCodeStyleSettings(settings);
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            GoLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (indentOptions == null) {
            GoLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        indentOptions.INDENT_SIZE = 4;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        indentOptions.TAB_SIZE = 4;
        indentOptions.USE_TAB_CHARACTER = true;
        commonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = false;
        commonSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
        commonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            GoLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (settingsType == null) {
            GoLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "CALL_PARAMETERS_WRAP", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE"});
            consumer.renameStandardOption("CALL_PARAMETERS_WRAP", GoBundle.message("go.settings.formatter.wrap.call.arguments", new Object[0]));
            String compLitGroupName = GoBundle.message("go.settings.formatter.wrap.comp.lit", new Object[0]);
            consumer.showCustomOption(GoCodeStyleSettings.class, "WRAP_COMP_LIT", compLitGroupName, null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(GoCodeStyleSettings.class, "WRAP_COMP_LIT_NEWLINE_AFTER_LBRACE", ApplicationBundle.message((String)"wrapping.new.line.after.lbrace", (Object[])new Object[0]), compLitGroupName, new Object[0]);
            consumer.showCustomOption(GoCodeStyleSettings.class, "WRAP_COMP_LIT_NEWLINE_BEFORE_RBRACE", ApplicationBundle.message((String)"wrapping.rbrace.on.new.line", (Object[])new Object[0]), compLitGroupName, new Object[0]);
            String funcParamGroupName = GoBundle.message("go.settings.formatter.wrap.func.params", new Object[0]);
            consumer.showCustomOption(GoCodeStyleSettings.class, "WRAP_FUNC_PARAMS", funcParamGroupName, null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(GoCodeStyleSettings.class, "WRAP_FUNC_PARAMS_NEWLINE_AFTER_LPAREN", ApplicationBundle.message((String)"wrapping.new.line.after.lpar", (Object[])new Object[0]), funcParamGroupName, new Object[0]);
            consumer.showCustomOption(GoCodeStyleSettings.class, "WRAP_FUNC_PARAMS_NEWLINE_BEFORE_RPAREN", ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0]), funcParamGroupName, new Object[0]);
            String funcResultGroupName = GoBundle.message("go.settings.formatter.wrap.func.result", new Object[0]);
            consumer.showCustomOption(GoCodeStyleSettings.class, "WRAP_FUNC_RESULT", funcResultGroupName, null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(GoCodeStyleSettings.class, "WRAP_FUNC_RESULT_NEWLINE_AFTER_LPAREN", ApplicationBundle.message((String)"wrapping.new.line.after.lpar", (Object[])new Object[0]), funcResultGroupName, new Object[0]);
            consumer.showCustomOption(GoCodeStyleSettings.class, "WRAP_FUNC_RESULT_NEWLINE_BEFORE_RPAREN", ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0]), funcResultGroupName, new Object[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/settings/GoLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/settings/GoLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCustomSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

