/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.wait;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class Wait {
    public static boolean poll(Duration interval, Duration timeout, Supplier<Boolean> condition) {
        return Wait.poll(interval, interval, timeout, condition);
    }

    public static boolean poll(Duration initialDelay, Duration interval, Duration timeout, Supplier<Boolean> condition) {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        AtomicBoolean result2 = new AtomicBoolean(false);
        long dueDate = System.currentTimeMillis() + timeout.toMillis();
        ScheduledFuture<?> future = executorService.scheduleAtFixedRate(() -> {
            try {
                result2.set((Boolean)condition.get());
            }
            catch (Exception e) {
                result2.set(false);
            }
        }, initialDelay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        try {
            while (System.currentTimeMillis() < dueDate) {
                if (!result2.get()) continue;
                future.cancel(true);
                return true;
            }
        }
        catch (Exception e) {
            return result2.get();
        }
        future.cancel(true);
        return result2.get();
    }
}

