/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1CustomResourceConversion;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionNames;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionVersion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CustomResourceDefinitionSpec describes how a user wants their resource to appear")
public class V1CustomResourceDefinitionSpec {
    public static final String SERIALIZED_NAME_CONVERSION = "conversion";
    @SerializedName(value="conversion")
    private V1CustomResourceConversion conversion;
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group;
    public static final String SERIALIZED_NAME_NAMES = "names";
    @SerializedName(value="names")
    private V1CustomResourceDefinitionNames names;
    public static final String SERIALIZED_NAME_PRESERVE_UNKNOWN_FIELDS = "preserveUnknownFields";
    @SerializedName(value="preserveUnknownFields")
    private Boolean preserveUnknownFields;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private String scope;
    public static final String SERIALIZED_NAME_VERSIONS = "versions";
    @SerializedName(value="versions")
    private List<V1CustomResourceDefinitionVersion> versions = new ArrayList<V1CustomResourceDefinitionVersion>();

    public V1CustomResourceDefinitionSpec conversion(V1CustomResourceConversion conversion) {
        this.conversion = conversion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1CustomResourceConversion getConversion() {
        return this.conversion;
    }

    public void setConversion(V1CustomResourceConversion conversion) {
        this.conversion = conversion;
    }

    public V1CustomResourceDefinitionSpec group(String group2) {
        this.group = group2;
        return this;
    }

    @ApiModelProperty(required=true, value="group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group2) {
        this.group = group2;
    }

    public V1CustomResourceDefinitionSpec names(V1CustomResourceDefinitionNames names) {
        this.names = names;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1CustomResourceDefinitionNames getNames() {
        return this.names;
    }

    public void setNames(V1CustomResourceDefinitionNames names) {
        this.names = names;
    }

    public V1CustomResourceDefinitionSpec preserveUnknownFields(Boolean preserveUnknownFields) {
        this.preserveUnknownFields = preserveUnknownFields;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting `x-preserve-unknown-fields` to true in `spec.versions[*].schema.openAPIV3Schema`. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning for details.")
    public Boolean getPreserveUnknownFields() {
        return this.preserveUnknownFields;
    }

    public void setPreserveUnknownFields(Boolean preserveUnknownFields) {
        this.preserveUnknownFields = preserveUnknownFields;
    }

    public V1CustomResourceDefinitionSpec scope(String scope2) {
        this.scope = scope2;
        return this;
    }

    @ApiModelProperty(required=true, value="scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`.")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope2) {
        this.scope = scope2;
    }

    public V1CustomResourceDefinitionSpec versions(List<V1CustomResourceDefinitionVersion> versions) {
        this.versions = versions;
        return this;
    }

    public V1CustomResourceDefinitionSpec addVersionsItem(V1CustomResourceDefinitionVersion versionsItem) {
        this.versions.add(versionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="versions is the list of all API versions of the defined custom resource. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is \"kube-like\", it will sort above non \"kube-like\" version strings, which are ordered lexicographically. \"Kube-like\" versions start with a \"v\", then are followed by a number (the major version), then optionally the string \"alpha\" or \"beta\" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.")
    public List<V1CustomResourceDefinitionVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<V1CustomResourceDefinitionVersion> versions) {
        this.versions = versions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceDefinitionSpec v1CustomResourceDefinitionSpec = (V1CustomResourceDefinitionSpec)o;
        return Objects.equals(this.conversion, v1CustomResourceDefinitionSpec.conversion) && Objects.equals(this.group, v1CustomResourceDefinitionSpec.group) && Objects.equals(this.names, v1CustomResourceDefinitionSpec.names) && Objects.equals(this.preserveUnknownFields, v1CustomResourceDefinitionSpec.preserveUnknownFields) && Objects.equals(this.scope, v1CustomResourceDefinitionSpec.scope) && Objects.equals(this.versions, v1CustomResourceDefinitionSpec.versions);
    }

    public int hashCode() {
        return Objects.hash(this.conversion, this.group, this.names, this.preserveUnknownFields, this.scope, this.versions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CustomResourceDefinitionSpec {\n");
        sb.append("    conversion: ").append(this.toIndentedString(this.conversion)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    preserveUnknownFields: ").append(this.toIndentedString(this.preserveUnknownFields)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

