/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions.logs;

import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.logs.KubernetesContextLogsManager;
import com.intellij.kubernetes.view.KubernetesContainerObject;
import com.intellij.kubernetes.view.KubernetesPodServiceViewDescriptorKt;
import com.intellij.kubernetes.view.ui.actions.logs.LogContainerNodeLeafDescriptor;
import com.intellij.kubernetes.view.ui.actions.logs.LogGroupNodeDescriptor;
import com.intellij.kubernetes.view.ui.actions.logs.LogNodeDescriptor;
import com.intellij.ui.ColoredTreeCellRenderer;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/logs/LogPodNodeDescriptor;", "Lcom/intellij/kubernetes/view/ui/actions/logs/LogGroupNodeDescriptor;", "pod", "Lio/kubernetes/client/openapi/models/V1Pod;", "logManager", "Lcom/intellij/kubernetes/logs/KubernetesContextLogsManager;", "<init>", "(Lio/kubernetes/client/openapi/models/V1Pod;Lcom/intellij/kubernetes/logs/KubernetesContextLogsManager;)V", "getPod", "()Lio/kubernetes/client/openapi/models/V1Pod;", "text", "", "getText", "()Ljava/lang/String;", "containers", "", "Lcom/intellij/kubernetes/view/KubernetesContainerObject;", "getContainers", "()Ljava/util/List;", "children", "Lcom/intellij/kubernetes/view/ui/actions/logs/LogNodeDescriptor;", "getChildren", "setTextPresentationForTextRenderer", "", "textRenderer", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogSourcesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogSourcesTree.kt\ncom/intellij/kubernetes/view/ui/actions/logs/LogPodNodeDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,451:1\n1557#2:452\n1628#2,3:453\n*S KotlinDebug\n*F\n+ 1 KubernetesLogSourcesTree.kt\ncom/intellij/kubernetes/view/ui/actions/logs/LogPodNodeDescriptor\n*L\n392#1:452\n392#1:453,3\n*E\n"})
final class LogPodNodeDescriptor
extends LogGroupNodeDescriptor {
    @NotNull
    private final V1Pod pod;
    @NotNull
    private final List<LogNodeDescriptor> children;

    /*
     * WARNING - void declaration
     */
    public LogPodNodeDescriptor(@NotNull V1Pod pod, @NotNull KubernetesContextLogsManager logManager) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)pod, (String)"pod");
        Intrinsics.checkNotNullParameter((Object)logManager, (String)"logManager");
        V1ObjectMeta v1ObjectMeta = pod.getMetadata();
        Intrinsics.checkNotNull((Object)v1ObjectMeta);
        String string = v1ObjectMeta.getName();
        Intrinsics.checkNotNull((Object)string);
        super(string, CollectionsKt.emptyList(), logManager);
        this.pod = pod;
        Iterable iterable = this.getContainers();
        LogPodNodeDescriptor logPodNodeDescriptor = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KubernetesContainerObject kubernetesContainerObject = (KubernetesContainerObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LogContainerNodeLeafDescriptor((KubernetesContainerObject)it, logManager));
        }
        logPodNodeDescriptor.children = (List)destination$iv$iv;
    }

    @NotNull
    public final V1Pod getPod() {
        return this.pod;
    }

    @Override
    @NotNull
    public String getText() {
        V1ObjectMeta v1ObjectMeta = this.pod.getMetadata();
        Intrinsics.checkNotNull((Object)v1ObjectMeta);
        String string = v1ObjectMeta.getName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final List<KubernetesContainerObject> getContainers() {
        List<KubernetesContainerObject> basicContainers = KubernetesPodServiceViewDescriptorKt.getPodBasicContainers(this.pod);
        List<KubernetesContainerObject> initContainers = KubernetesPodServiceViewDescriptorKt.getPodInitContainers(this.pod);
        List<KubernetesContainerObject> ephemeralContainer = KubernetesPodServiceViewDescriptorKt.getPodEphemeralContainers(this.pod);
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)initContainers, (Iterable)basicContainers), (Iterable)ephemeralContainer);
    }

    @Override
    @NotNull
    public List<LogNodeDescriptor> getChildren() {
        return this.children;
    }

    @Override
    public void setTextPresentationForTextRenderer(@NotNull ColoredTreeCellRenderer textRenderer) {
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        super.setTextPresentationForTextRenderer(textRenderer);
        textRenderer.setIcon(KubernetesIcons.Pod);
    }
}

