/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.KubernetesContextServiceViewContributorKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareToggleAction;
import com.intellij.kubernetes.view.ui.actions.KubernetesSetCurrentContextAction$Group$updateChildren$;
import com.intellij.kubernetes.view.vfs.UtilsKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesSetCurrentContextAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesModelBasedDumbAwareToggleAction;", "currentContext", "Lcom/intellij/kubernetes/api/Context;", "<init>", "(Lcom/intellij/kubernetes/api/Context;)V", "getApiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "", "isSelected", "", "setSelected", "state", "Group", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesSetCurrentContextAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSetCurrentContextAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesSetCurrentContextAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1557#2:112\n1628#2,3:113\n1782#2,4:116\n*S KotlinDebug\n*F\n+ 1 KubernetesSetCurrentContextAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesSetCurrentContextAction\n*L\n33#1:112\n33#1:113,3\n34#1:116,4\n*E\n"})
public final class KubernetesSetCurrentContextAction
extends KubernetesModelBasedDumbAwareToggleAction {
    @NotNull
    private final Context currentContext;

    public KubernetesSetCurrentContextAction(@NotNull Context currentContext) {
        Intrinsics.checkNotNullParameter((Object)currentContext, (String)"currentContext");
        this.currentContext = currentContext;
    }

    @Override
    @Nullable
    protected KubernetesApiModel getApiModel(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        return KubernetesApiProvider.Companion.getInstance(project).findModel(this.currentContext);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(@NotNull AnActionEvent e) {
        Supplier<String> supplier;
        String currentContextNameWithPath;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        String currentContextName = this.currentContext.getName();
        KubernetesApiModel apiModel2 = this.getApiModel(e);
        if (apiModel2 != null) {
            int n;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.toList((Iterable)apiModel2.getApiProvider$intellij_clouds_kubernetes().getExistingContexts());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Context context = (Context)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            List contextNames = (List)destination$iv$iv;
            Iterable $this$count$iv = contextNames;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)currentContextName) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n > 1) {
                List otherPaths = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)apiModel2.getApiProvider$intellij_clouds_kubernetes().getExistingContexts()), arg_0 -> KubernetesSetCurrentContextAction.update$lambda$2(this, arg_0)), KubernetesSetCurrentContextAction::update$lambda$3));
                String url = KubernetesContextServiceViewContributorKt.preparePathToShow(otherPaths, this.currentContext.getKubeConfigUrl());
                v2 = currentContextName + " " + url;
            } else {
                v2 = currentContextName;
            }
        } else {
            v2 = currentContextNameWithPath = currentContextName;
        }
        if (Toggleable.isSelected((Presentation)presentation2)) {
            var8_8 = new Object[]{currentContextNameWithPath};
            supplier = KubernetesBundle.messagePointer("action.Kubernetes.SetCurrentContext.selected.text", var8_8);
        } else {
            var8_8 = new Object[]{currentContextNameWithPath};
            supplier = KubernetesBundle.messagePointer("action.Kubernetes.SetCurrentContext.not.selected.text", var8_8);
        }
        Supplier<String> supplier2 = supplier;
        Intrinsics.checkNotNull(supplier2);
        Supplier<String> text = supplier2;
        presentation2.setText(text);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModel kubernetesApiModel = this.getApiModel(e);
        Intrinsics.checkNotNull((Object)kubernetesApiModel);
        KubernetesApiProvider $this$isSelected_u24lambda_u244 = kubernetesApiModel.getApiProvider$intellij_clouds_kubernetes();
        boolean bl = false;
        return Intrinsics.areEqual((Object)$this$isSelected_u24lambda_u244.getContext(KubernetesProjectSettings.Companion.getInstance($this$isSelected_u24lambda_u244.getProject$intellij_clouds_kubernetes())), (Object)this.currentContext);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesUsageTriggerCollector.KubernetesEventWrapper<String> kubernetesEventWrapper = KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT();
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        kubernetesEventWrapper.log(project, "change-context");
        Context contextToSet = state ? this.currentContext : null;
        KubernetesApiModel kubernetesApiModel = this.getApiModel(e);
        Intrinsics.checkNotNull((Object)kubernetesApiModel);
        KubernetesApiModel apiModel2 = kubernetesApiModel;
        KubernetesApiProvider $this$setSelected_u24lambda_u245 = apiModel2.getApiProvider$intellij_clouds_kubernetes();
        boolean bl = false;
        $this$setSelected_u24lambda_u245.setContext(KubernetesProjectSettings.Companion.getInstance($this$setSelected_u24lambda_u245.getProject$intellij_clouds_kubernetes()), contextToSet);
    }

    private static final boolean update$lambda$2(KubernetesSetCurrentContextAction this$0, Context it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)this$0.currentContext.getName()) && !Intrinsics.areEqual((Object)it.getKubeConfigUrl(), (Object)this$0.currentContext.getKubeConfigUrl());
    }

    private static final String update$lambda$3(Context it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKubeConfigUrl();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesSetCurrentContextAction$Group;", "Lcom/intellij/ide/actions/NonTrivialActionGroup;", "<init>", "()V", "updateChildren", "", "contexts", "Ljava/util/SortedSet;", "Lcom/intellij/kubernetes/api/Context;", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "disable", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesSetCurrentContextAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSetCurrentContextAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesSetCurrentContextAction$Group\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 actionUtils.kt\ncom/intellij/kubernetes/view/ui/actions/ActionUtilsKt\n*L\n1#1,111:1\n477#2:112\n1557#3:113\n1628#3,3:114\n59#4:117\n25#5:118\n*S KotlinDebug\n*F\n+ 1 KubernetesSetCurrentContextAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesSetCurrentContextAction$Group\n*L\n80#1:112\n87#1:113\n87#1:114,3\n94#1:117\n95#1:118\n*E\n"})
    public static final class Group
    extends NonTrivialActionGroup {
        /*
         * WARNING - void declaration
         */
        private final synchronized void updateChildren(SortedSet<Context> contexts2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AnAction[] anActionArray = this.getChildActionsOrStubs();
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildActionsOrStubs(...)");
            Object $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])anActionArray);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Group$updateChildren$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            SortedSet actionContexts = SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)sequence, Group::updateChildren$lambda$0));
            if (Intrinsics.areEqual((Object)actionContexts, contexts2)) {
                return;
            }
            this.removeAll();
            $this$filterIsInstance$iv = contexts2;
            Group group2 = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Context context = (Context)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new KubernetesSetCurrentContextAction((Context)it));
            }
            group2.addAll((List)destination$iv$iv);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            Presentation presentation2 = presentation;
            Project project = e.getProject();
            if (project == null) {
                this.disable(presentation2);
                return;
            }
            Project project2 = project;
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project2;
            boolean $i$f$serviceIfCreated = false;
            KubernetesApiProvider kubernetesApiProvider = (KubernetesApiProvider)((Object)$this$serviceIfCreated$iv.getServiceIfCreated(KubernetesApiProvider.class));
            if (kubernetesApiProvider == null) {
                this.disable(presentation2);
                return;
            }
            KubernetesApiProvider apiProvider = kubernetesApiProvider;
            AnActionEvent $this$virtualFile$iv = e;
            boolean $i$f$getVirtualFile = false;
            VirtualFile virtualFile = (VirtualFile)$this$virtualFile$iv.getData(CommonDataKeys.VIRTUAL_FILE);
            if (virtualFile == null) {
                this.disable(presentation2);
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            presentation2.setEnabledAndVisible(UtilsKt.isKubernetesFile(virtualFile2, project2));
            if (!presentation2.isVisible()) {
                return;
            }
            this.updateChildren(CollectionsKt.toSortedSet((Iterable)apiProvider.getExistingContexts()));
            super.update(e);
        }

        private final void disable(Presentation presentation) {
            presentation.setEnabledAndVisible(false);
        }

        private static final Context updateChildren$lambda$0(KubernetesSetCurrentContextAction it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return it.currentContext;
        }
    }
}

