/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.ui.MomentJSLikeDuration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0005"}, d2={"formatAge", "", "Ljava/time/OffsetDateTime;", "now", "formatISO", "intellij.clouds.kubernetes"})
public final class DateTimeUtilitiesKt {
    @NotNull
    public static final String formatAge(@NotNull OffsetDateTime $this$formatAge, @NotNull OffsetDateTime now) {
        Intrinsics.checkNotNullParameter((Object)$this$formatAge, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        MomentJSLikeDuration duration = new MomentJSLikeDuration($this$formatAge, now);
        if (duration.getNegative()) {
            return "-";
        }
        if (duration.getSeconds() < 45L) {
            String string = KubernetesBundle.message("DateTimeUtilities.formatAge.fewSeconds", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        long minutes = duration.getMinutes();
        if (minutes <= 1L) {
            String string = KubernetesBundle.message("DateTimeUtilities.formatAge.minute", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        if (minutes < 45L) {
            Object[] objectArray = new Object[]{minutes};
            String string = KubernetesBundle.message("DateTimeUtilities.formatAge.minutes", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        long hours = duration.getHours();
        if (hours <= 1L) {
            String string = KubernetesBundle.message("DateTimeUtilities.formatAge.hour", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        if (hours < 22L) {
            Object[] objectArray = new Object[]{hours};
            String string = KubernetesBundle.message("DateTimeUtilities.formatAge.hours", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        long days = duration.getDays();
        if (days <= 1L) {
            String string = KubernetesBundle.message("DateTimeUtilities.formatAge.day", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        if (days < 26L) {
            Object[] objectArray = new Object[]{days};
            String string = KubernetesBundle.message("DateTimeUtilities.formatAge.days", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        int months = duration.getMonths();
        if (months <= 1) {
            String string = KubernetesBundle.message("DateTimeUtilities.formatAge.month", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        if (months < 11) {
            Object[] objectArray = new Object[]{months};
            String string = KubernetesBundle.message("DateTimeUtilities.formatAge.months", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        int years = duration.getYears();
        if (years <= 1) {
            String string = KubernetesBundle.message("DateTimeUtilities.formatAge.year", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        Object[] objectArray = new Object[]{years};
        String string = KubernetesBundle.message("DateTimeUtilities.formatAge.years", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public static /* synthetic */ String formatAge$default(OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2, int n, Object object) {
        if ((n & 1) != 0) {
            offsetDateTime2 = OffsetDateTime.now();
        }
        return DateTimeUtilitiesKt.formatAge(offsetDateTime, offsetDateTime2);
    }

    @NotNull
    public static final String formatISO(@NotNull OffsetDateTime $this$formatISO) {
        Intrinsics.checkNotNullParameter((Object)$this$formatISO, (String)"<this>");
        String string = $this$formatISO.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

