/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view;

import com.intellij.kubernetes.view.KubernetesContainerObject;
import com.intellij.kubernetes.view.KubernetesContainerObjectImpl;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.kubernetes.client.openapi.models.V1ContainerStateTerminated;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1PodStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/view/KubernetesInitContainerObjectImpl;", "Lcom/intellij/kubernetes/view/KubernetesContainerObjectImpl;", "container", "Lio/kubernetes/client/openapi/models/V1Container;", "containerStatus", "Lio/kubernetes/client/openapi/models/V1ContainerStatus;", "parentPod", "Lio/kubernetes/client/openapi/models/V1Pod;", "<init>", "(Lio/kubernetes/client/openapi/models/V1Container;Lio/kubernetes/client/openapi/models/V1ContainerStatus;Lio/kubernetes/client/openapi/models/V1Pod;)V", "getKind", "", "isComplete", "", "Companion", "intellij.clouds.kubernetes"})
public final class KubernetesInitContainerObjectImpl
extends KubernetesContainerObjectImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KubernetesInitContainerObjectImpl(@NotNull V1Container container, @NotNull V1ContainerStatus containerStatus, @NotNull V1Pod parentPod) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)containerStatus, (String)"containerStatus");
        Intrinsics.checkNotNullParameter((Object)parentPod, (String)"parentPod");
        super(container, containerStatus, parentPod);
    }

    @Override
    @Nullable
    public String getKind() {
        return "V1InitContainer";
    }

    public final boolean isComplete() {
        Object object = this.getContainerStatus().getState();
        return Intrinsics.areEqual((Object)(object != null && (object = ((V1ContainerState)object).getTerminated()) != null ? ((V1ContainerStateTerminated)object).getReason() : null), (Object)"Completed");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/view/KubernetesInitContainerObjectImpl$Companion;", "", "<init>", "()V", "createInitContainerObject", "Lcom/intellij/kubernetes/view/KubernetesContainerObject;", "pod", "Lio/kubernetes/client/openapi/models/V1Pod;", "containerName", "", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesContainerServiceViewDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesContainerServiceViewDescriptor.kt\ncom/intellij/kubernetes/view/KubernetesInitContainerObjectImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,321:1\n1#2:322\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KubernetesContainerObject createInitContainerObject(@NotNull V1Pod pod, @NotNull String containerName) {
            V1ContainerStatus containerStatus;
            Object object;
            V1Container container;
            Intrinsics.checkNotNullParameter((Object)pod, (String)"pod");
            Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
            Object object2 = pod.getSpec();
            if (object2 != null && (object2 = ((V1PodSpec)object2).getInitContainers()) != null) {
                Object object3;
                block7: {
                    Iterable iterable = (Iterable)object2;
                    for (Object object4 : iterable) {
                        V1Container it = (V1Container)object4;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)containerName)) continue;
                        object3 = object4;
                        break block7;
                    }
                    object3 = null;
                }
                v2 = (V1Container)object3;
            } else {
                v2 = container = null;
            }
            if ((object = pod.getStatus()) != null && (object = ((V1PodStatus)object).getInitContainerStatuses()) != null) {
                Object v4;
                block8: {
                    Object object4;
                    Iterable iterable = (Iterable)object;
                    object4 = iterable.iterator();
                    while (object4.hasNext()) {
                        Object e = object4.next();
                        V1ContainerStatus it = (V1ContainerStatus)e;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)containerName)) continue;
                        v4 = e;
                        break block8;
                    }
                    v4 = null;
                }
                v5 = v4;
            } else {
                v5 = containerStatus = null;
            }
            if (container != null && containerStatus != null) {
                return new KubernetesInitContainerObjectImpl(container, containerStatus, pod);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

