/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view;

import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.view.KubernetesContainerContent;
import com.intellij.kubernetes.view.KubernetesContainerObject;
import com.intellij.kubernetes.view.KubernetesEphemeralContainerObjectImpl;
import com.intellij.kubernetes.view.KubernetesInitContainerObjectImpl;
import com.intellij.kubernetes.view.KubernetesRefreshable;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.ui.LayeredIcon;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00030\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00030\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lcom/intellij/kubernetes/view/KubernetesContainerServiceViewDescriptor;", "Lcom/intellij/execution/services/SimpleServiceViewDescriptor;", "Lcom/intellij/kubernetes/view/KubernetesRefreshable;", "Lcom/intellij/kubernetes/view/KubernetesContainerObject;", "resourceContainer", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/kubernetes/view/KubernetesContainerObject;Lcom/intellij/kubernetes/api/KubernetesApiModel;Lcom/intellij/openapi/Disposable;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "currentContainer", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "resource", "getResource$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/view/KubernetesContainerObject;", "_presentation", "Lcom/intellij/navigation/ItemPresentation;", "content", "Lcom/intellij/kubernetes/view/KubernetesContainerContent;", "getContent", "()Lcom/intellij/kubernetes/view/KubernetesContainerContent;", "content$delegate", "Lkotlin/Lazy;", "getContentComponent", "Ljavax/swing/JComponent;", "getPresentation", "refresh", "", "newResource", "intellij.clouds.kubernetes"})
public final class KubernetesContainerServiceViewDescriptor
extends SimpleServiceViewDescriptor
implements KubernetesRefreshable<KubernetesContainerObject> {
    @NotNull
    private final KubernetesApiModel apiModel;
    @NotNull
    private final AtomicReference<KubernetesContainerObject> currentContainer;
    @NotNull
    private ItemPresentation _presentation;
    @NotNull
    private final Lazy content$delegate;

    public KubernetesContainerServiceViewDescriptor(@NotNull KubernetesContainerObject resourceContainer, @NotNull KubernetesApiModel apiModel2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)resourceContainer, (String)"resourceContainer");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(resourceContainer.getName(), null);
        this.apiModel = apiModel2;
        this.currentContainer = new AtomicReference<KubernetesContainerObject>(resourceContainer);
        this._presentation = (ItemPresentation)new PresentationData(this.getResource$intellij_clouds_kubernetes().getName(), null, null, null);
        Icon icon = this.getResource$intellij_clouds_kubernetes().getStarted() ? KubernetesIcons.SingleRunningContainer : KubernetesIcons.SingleStoppedContainer;
        Intrinsics.checkNotNull((Object)icon);
        Icon statusIcon = icon;
        Icon finalIcon = this.getResource$intellij_clouds_kubernetes() instanceof KubernetesEphemeralContainerObjectImpl ? (Icon)LayeredIcon.Companion.layeredIcon(() -> KubernetesContainerServiceViewDescriptor._init_$lambda$0(statusIcon)) : statusIcon;
        this._presentation = (ItemPresentation)new PresentationData(this.getResource$intellij_clouds_kubernetes().getName(), null, finalIcon, null);
        this.content$delegate = LazyKt.lazy(() -> KubernetesContainerServiceViewDescriptor.content_delegate$lambda$1(this, parentDisposable));
    }

    @NotNull
    public final KubernetesApiModel getApiModel() {
        return this.apiModel;
    }

    public final KubernetesContainerObject getResource$intellij_clouds_kubernetes() {
        return this.currentContainer.get();
    }

    @NotNull
    public final KubernetesContainerContent getContent() {
        Lazy lazy = this.content$delegate;
        return (KubernetesContainerContent)lazy.getValue();
    }

    @Nullable
    public JComponent getContentComponent() {
        return this.getContent().getComponent();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this._presentation;
    }

    @Override
    public void refresh(@NotNull KubernetesContainerObject newResource) {
        Intrinsics.checkNotNullParameter((Object)newResource, (String)"newResource");
        this.currentContainer.set(newResource);
        Icon icon = newResource.getStarted() ? KubernetesIcons.SingleRunningContainer : KubernetesIcons.SingleStoppedContainer;
        Intrinsics.checkNotNull((Object)icon);
        Icon statusIcon = icon;
        KubernetesContainerObject kubernetesContainerObject = newResource;
        Icon finalIcon = kubernetesContainerObject instanceof KubernetesEphemeralContainerObjectImpl ? (Icon)LayeredIcon.Companion.layeredIcon(() -> KubernetesContainerServiceViewDescriptor.refresh$lambda$2(statusIcon)) : (kubernetesContainerObject instanceof KubernetesInitContainerObjectImpl ? (Icon)LayeredIcon.Companion.layeredIcon(() -> KubernetesContainerServiceViewDescriptor.refresh$lambda$3(statusIcon)) : statusIcon);
        this._presentation = (ItemPresentation)new PresentationData(newResource.getName(), null, finalIcon, null);
        this.getContent().refresh(newResource);
    }

    private static final Icon[] _init_$lambda$0(Icon $statusIcon) {
        Icon[] iconArray = new Icon[]{$statusIcon, AllIcons.Actions.Scratch};
        return iconArray;
    }

    private static final KubernetesContainerContent content_delegate$lambda$1(KubernetesContainerServiceViewDescriptor this$0, Disposable $parentDisposable) {
        KubernetesContainerObject kubernetesContainerObject = this$0.getResource$intellij_clouds_kubernetes();
        Intrinsics.checkNotNullExpressionValue((Object)kubernetesContainerObject, (String)"<get-resource>(...)");
        return new KubernetesContainerContent(kubernetesContainerObject, this$0.apiModel, $parentDisposable);
    }

    private static final Icon[] refresh$lambda$2(Icon $statusIcon) {
        Icon[] iconArray = new Icon[]{$statusIcon, AllIcons.Actions.Scratch};
        return iconArray;
    }

    private static final Icon[] refresh$lambda$3(Icon $statusIcon) {
        Icon[] iconArray = new Icon[]{$statusIcon, AllIcons.Nodes.ProcessMark};
        return iconArray;
    }
}

