/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.HelmDependencyRepository;
import com.intellij.kubernetes.helm.RemoteHelmDependencyRepository;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.actions.HelmUpdateRepositoryAction;
import com.intellij.kubernetes.ui.intentions.HelmDependencyRepositoryIntentionActionBase;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.util.EnumSet;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J#\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/ui/intentions/HelmUpdateRepositoryIntentionAction;", "Lcom/intellij/kubernetes/ui/intentions/HelmDependencyRepositoryIntentionActionBase;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getFamilyName", "", "getText", "isAvailableFor", "", "project", "Lcom/intellij/openapi/project/Project;", "repo", "Lcom/intellij/kubernetes/helm/RemoteHelmDependencyRepository;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.clouds.kubernetes"})
public final class HelmUpdateRepositoryIntentionAction
extends HelmDependencyRepositoryIntentionActionBase {
    @Override
    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = AllIcons.Actions.Refresh;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Refresh");
        return icon;
    }

    @NotNull
    public String getFamilyName() {
        String string = KubernetesBundle.message("HelmUpdateRepositoryAction.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        String string = KubernetesBundle.message("HelmUpdateRepositoryAction.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public boolean isAvailableFor(@NotNull Project project, @NotNull RemoteHelmDependencyRepository repo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        EnumSet<Enum> enumSet = EnumSet.of((Enum)SideEffectGuard.EffectType.INVOKE_LATER);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        return (Boolean)SideEffectGuard.Companion.computeWithAllowedSideEffectsBlocking(enumSet, () -> HelmUpdateRepositoryIntentionAction.isAvailableFor$lambda$0(repo));
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor == null) {
            return;
        }
        YAMLValue yAMLValue = YamlUtilKt.getTypedAncestorOrSelf(element, YAMLValue.class);
        if (yAMLValue == null) {
            return;
        }
        YAMLValue yamlValue = yAMLValue;
        RemoteHelmDependencyRepository remoteHelmDependencyRepository = HelmDependencyRepository.Companion.getRemote(project, YamlUtilKt.getEffectiveText(yamlValue));
        if (remoteHelmDependencyRepository == null) {
            return;
        }
        RemoteHelmDependencyRepository repo = remoteHelmDependencyRepository;
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"ICON_NAVIGATION", null, (DataContext)dataContext2);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        AnActionEvent actionEvent = anActionEvent;
        new HelmUpdateRepositoryAction(repo).actionPerformed(actionEvent);
    }

    private static final boolean isAvailableFor$lambda$0(RemoteHelmDependencyRepository $repo) {
        return $repo.getRemoteRepoDto() != null;
    }
}

