/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.telepresence;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.telepresence.TelepresenceConnectActionKt;
import com.intellij.kubernetes.telepresence.TelepresenceConsoleFilterProviderKt;
import com.intellij.kubernetes.telepresence.TelepresenceCoroutineScopeProvider;
import com.intellij.kubernetes.telepresence.TelepresenceInstallActionKt;
import com.intellij.kubernetes.telepresence.TelepresenceModel;
import com.intellij.kubernetes.telepresence.TelepresenceProblem;
import com.intellij.kubernetes.telepresence.TelepresenceResult;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareActionKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceConnectAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nTelepresenceConnectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelepresenceConnectAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceConnectAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,210:1\n31#2,2:211\n14#3:213\n*S KotlinDebug\n*F\n+ 1 TelepresenceConnectAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceConnectAction\n*L\n57#1:211,2\n32#1:213\n*E\n"})
public final class TelepresenceConnectAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public void update(@NotNull AnActionEvent e) {
        boolean nameSpaceSelected;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModel kubernetesApiModel = KubernetesModelBasedDumbAwareActionKt.getApiModel(e);
        TelepresenceModel telepresenceModel = kubernetesApiModel != null ? kubernetesApiModel.getTelepresenceModel$intellij_clouds_kubernetes() : null;
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setVisible(telepresenceModel != null && TelepresenceModel.Companion.isEnabled());
        KubernetesApiModel kubernetesApiModel2 = KubernetesModelBasedDumbAwareActionKt.getApiModel(e);
        boolean bl = kubernetesApiModel2 != null ? !kubernetesApiModel2.isAllNamespaces() : (nameSpaceSelected = false);
        if (!nameSpaceSelected) {
            presentation2.setText(KubernetesBundle.message("action.Telepresence.ConnectInterception.text.alt", new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModel kubernetesApiModel = KubernetesModelBasedDumbAwareActionKt.getApiModel(e);
        Intrinsics.checkNotNull((Object)kubernetesApiModel);
        KubernetesApiModel apiModel2 = kubernetesApiModel;
        Project project = apiModel2.getProject();
        KubernetesUsageTriggerCollector.INSTANCE.getTELEPRESENCE_ACTION_TRIGGERED_EVENT().log(apiModel2.getProject(), (Object)"telepresence-connect");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<TelepresenceCoroutineScopeProvider> serviceClass$iv = TelepresenceCoroutineScopeProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        CoroutineScope coroutineScope = ((TelepresenceCoroutineScopeProvider)object).getCoroutineScope();
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.current();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(e, apiModel2, project, null){
            int label;
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ KubernetesApiModel $apiModel;
            final /* synthetic */ Project $project;
            {
                this.$e = $e;
                this.$apiModel = $apiModel;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = TelepresenceConnectActionKt.doTelepresenceConnectInteractively(this.$e, this.$apiModel, (Continuation<? super TelepresenceResult<Unit>>)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((result = (TelepresenceResult)v0).isFailure()) {
                            reason = result.getReason();
                            if (Intrinsics.areEqual((Object)reason, (Object)TelepresenceProblem.TelepresenceNotInstalled.INSTANCE)) {
                                TelepresenceInstallActionKt.downloadAndInstallTelepresenceInteractive$default(this.$project, false, 2, null);
                            } else if (Intrinsics.areEqual((Object)reason, (Object)TelepresenceProblem.TelepresenceOutdated.INSTANCE)) {
                                TelepresenceInstallActionKt.downloadAndInstallTelepresenceInteractive(this.$project, true);
                            } else if (Intrinsics.areEqual((Object)reason, (Object)TelepresenceProblem.TrafficManagerNotInstalled.INSTANCE)) {
                                TelepresenceConsoleFilterProviderKt.suggestInstallTrafficManager(this.$apiModel, false);
                            } else if (Intrinsics.areEqual((Object)reason, (Object)TelepresenceProblem.TrafficManagerOutdated.INSTANCE)) {
                                TelepresenceConsoleFilterProviderKt.suggestInstallTrafficManager(this.$apiModel, true);
                            } else if (reason instanceof TelepresenceProblem.ErrorPrintedToConsoleOutput || reason instanceof TelepresenceProblem.ErrorWithPrintableMessage || reason instanceof TelepresenceProblem.ErrorWithoutConsoleOutput) {
                                TelepresenceConnectAction.access$getLOG$cp().warn("Couldn't connect with Telepresence to cluster due to unexpected problem. Reason = " + reason);
                            } else if (Intrinsics.areEqual((Object)reason, (Object)TelepresenceProblem.Cancelled.INSTANCE)) {
                                TelepresenceConnectAction.access$getLOG$cp().debug("Connecting with Telepresence to cluster was cancelled");
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TelepresenceConnectAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceConnectAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

