/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.KubernetesContextLogsManager;
import com.intellij.kubernetes.logs.KubernetesLogFilterModel;
import com.intellij.kubernetes.logs.KubernetesLogFilterSettings;
import com.intellij.kubernetes.logs.KubernetesLogsPatternMatchingAction;
import com.intellij.kubernetes.logs.KubernetesLogsPresentableTextBuildersKt;
import com.intellij.kubernetes.logs.KubernetesTextFilterModel;
import com.intellij.kubernetes.logs.pattern.matching.LogCluster;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0014J\b\u0010$\u001a\u00020\u0018H\u0014J\b\u0010%\u001a\u00020\u0018H\u0014J\u0006\u0010&\u001a\u00020\u0018J\r\u0010'\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b(J\b\u0010)\u001a\u00020\u0018H\u0002J\b\u0010*\u001a\u00020\u0018H\u0002J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u000fH\u0002J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u00060"}, d2={"Lcom/intellij/kubernetes/logs/TextFilterField;", "Lcom/intellij/ui/SearchTextField;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "textFilterModel", "Lcom/intellij/kubernetes/logs/KubernetesTextFilterModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/kubernetes/logs/KubernetesTextFilterModel;Lcom/intellij/openapi/Disposable;)V", "createItemChosenCallback", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "list", "Ljavax/swing/JList;", "onEmptyText", "", "Lorg/jetbrains/annotations/Nls;", "getOnEmptyText", "()Ljava/lang/String;", "tooltipText", "getTooltipText", "getMinimumSize", "Ljava/awt/Dimension;", "applyFilter", "", "addToHistory", "", "onFieldCleared", "patternsPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "patternsTextAdded", "Ljava/util/concurrent/atomic/AtomicReference;", "getPatternsTextAdded", "()Ljava/util/concurrent/atomic/AtomicReference;", "setPatternsTextAdded", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "onFocusGained", "onFocusLost", "clearPatternsText", "updatePatternsSelectedTextToFilterField", "updatePatternsSelectedTextToFilterField$intellij_clouds_kubernetes", "showPatternsPopup", "hideSelectedPatternsPopup", "isSameFilterAs", "otherText", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogFilterTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogFilterTab.kt\ncom/intellij/kubernetes/logs/TextFilterField\n+ 2 Runnable.kt\nkotlinx/coroutines/RunnableKt\n*L\n1#1,643:1\n13#2:644\n*S KotlinDebug\n*F\n+ 1 KubernetesLogFilterTab.kt\ncom/intellij/kubernetes/logs/TextFilterField\n*L\n528#1:644\n*E\n"})
public abstract class TextFilterField
extends SearchTextField
implements UiDataProvider {
    @NotNull
    private final KubernetesTextFilterModel textFilterModel;
    @Nullable
    private JBPopup patternsPopup;
    @NotNull
    private AtomicReference<Boolean> patternsTextAdded;

    public TextFilterField(@NotNull KubernetesTextFilterModel textFilterModel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)textFilterModel, (String)"textFilterModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super("Kubernetes.Log.Filter.History");
        this.textFilterModel = textFilterModel;
        this.setText(this.textFilterModel.getText$intellij_clouds_kubernetes());
        this.getTextEditor().getEmptyText().setText(this.getOnEmptyText());
        TextComponentEmptyText.setupPlaceholderVisibility((JTextComponent)((JTextComponent)this.getTextEditor()));
        this.getTextEditor().addActionListener(arg_0 -> TextFilterField._init_$lambda$1(this, arg_0));
        BuildersKt.launch$default((CoroutineScope)this.textFilterModel.getManager().getCoroutineScope$intellij_clouds_kubernetes(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TextFilterField this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest(this.this$0.textFilterModel.getSettingsFlow(), (Function2)((Function2)new Function2<KubernetesLogFilterSettings, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ TextFilterField this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        String modelText = this.this$0.textFilterModel.getText$intellij_clouds_kubernetes();
                                        if (!this.this$0.isSameFilterAs(modelText)) {
                                            this.this$0.setText(modelText);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(KubernetesLogFilterSettings p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.getTextEditor().setToolTipText(XmlStringUtil.wrapInHtml((CharSequence)this.getTooltipText()));
        Disposer.register((Disposable)parentDisposable, () -> TextFilterField._init_$lambda$2(this));
        this.patternsTextAdded = new AtomicReference<Boolean>(true);
    }

    @Nullable
    protected Runnable createItemChosenCallback(@Nullable JList<?> list2) {
        boolean $i$f$Runnable = false;
        return new Runnable(list2, this){
            final /* synthetic */ JList $list$inlined;
            final /* synthetic */ TextFilterField this$0;
            {
                this.$list$inlined = jList;
                this.this$0 = textFilterField;
            }

            public final void run() {
                boolean bl = false;
                Object value2 = this.$list$inlined != null ? (Object)this.$list$inlined.getSelectedValue() : null;
                KubernetesTextFilterModel kubernetesTextFilterModel = TextFilterField.access$getTextFilterModel$p(this.this$0);
                Object object = value2;
                if (object == null || (object = object.toString()) == null) {
                    object = "";
                }
                kubernetesTextFilterModel.setText$intellij_clouds_kubernetes((String)object);
                TextFilterField.access$createItemChosenCallback$s367062757(this.this$0, this.$list$inlined).run();
            }
        };
    }

    @NotNull
    public abstract String getOnEmptyText();

    @NotNull
    public abstract String getTooltipText();

    @NotNull
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.width = Math.max(size.width, JBUIScale.scale((int)150));
        Intrinsics.checkNotNull((Object)size);
        return size;
    }

    private final void applyFilter(boolean addToHistory) {
        this.textFilterModel.setText$intellij_clouds_kubernetes(this.getText());
        if (addToHistory) {
            this.addCurrentTextToHistory();
        }
    }

    protected void onFieldCleared() {
        this.textFilterModel.setText$intellij_clouds_kubernetes("");
    }

    @NotNull
    public final AtomicReference<Boolean> getPatternsTextAdded() {
        return this.patternsTextAdded;
    }

    public final void setPatternsTextAdded(@NotNull AtomicReference<Boolean> atomicReference) {
        Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
        this.patternsTextAdded = atomicReference;
    }

    protected void onFocusGained() {
        this.showPatternsPopup();
        this.clearPatternsText();
    }

    protected void onFocusLost() {
        if (this.patternsTextAdded.get().booleanValue()) {
            this.clearPatternsText();
        }
        if (!this.isSameFilterAs(this.textFilterModel.getText$intellij_clouds_kubernetes())) {
            this.applyFilter(false);
        }
        this.hideSelectedPatternsPopup();
        this.updatePatternsSelectedTextToFilterField$intellij_clouds_kubernetes();
    }

    public final void clearPatternsText() {
        this.setText(this.textFilterModel.getText$intellij_clouds_kubernetes());
        this.getTextEditor().getHighlighter().removeAllHighlights();
        this.patternsTextAdded.set(false);
    }

    public final void updatePatternsSelectedTextToFilterField$intellij_clouds_kubernetes() {
        String patternsText;
        int patternsCount;
        Object excludedPatterns;
        KubernetesTextFilterModel kubernetesTextFilterModel;
        Object object;
        Object selectedPatterns;
        this.clearPatternsText();
        KubernetesTextFilterModel kubernetesTextFilterModel2 = this.textFilterModel;
        Object object2 = kubernetesTextFilterModel2 instanceof KubernetesLogFilterModel ? (MutableStateFlow<List<LogCluster>>)kubernetesTextFilterModel2 : null;
        if (object2 == null || (object2 = object2.getSelectedPatterns$intellij_clouds_kubernetes()) == null || (object2 = (List)object2.getValue()) == null) {
            object2 = selectedPatterns = CollectionsKt.emptyList();
        }
        if ((object = (kubernetesTextFilterModel = this.textFilterModel) instanceof KubernetesLogFilterModel ? (MutableStateFlow<List<LogCluster>>)kubernetesTextFilterModel : null) == null || (object = object.getExcludedPatterns$intellij_clouds_kubernetes()) == null || (object = (List)object.getValue()) == null) {
            object = excludedPatterns = CollectionsKt.emptyList();
        }
        if ((patternsCount = selectedPatterns.size() + excludedPatterns.size()) == 0) {
            return;
        }
        if (!this.patternsTextAdded.compareAndSet(false, true)) {
            return;
        }
        this.getTextEditor().getHighlighter().removeAllHighlights();
        String basicText = this.textFilterModel.getText$intellij_clouds_kubernetes();
        String string = patternsText = ((CharSequence)basicText).length() == 0 ? patternsCount + " pattern" + (patternsCount > 1 ? "s" : "") + " selected" : "  [+ " + patternsCount + " more pattern" + (patternsCount > 1 ? "s" : "") + "]";
        if (((CharSequence)basicText).length() == 0) {
            // empty if block
        }
        this.setText(basicText + patternsText);
    }

    private final void showPatternsPopup() {
        block5: {
            Object excludedPatterns;
            KubernetesTextFilterModel kubernetesTextFilterModel;
            Object object;
            Object selectedPatterns;
            JBPopup jBPopup = this.patternsPopup;
            if (jBPopup != null) {
                jBPopup.cancel();
            }
            KubernetesTextFilterModel kubernetesTextFilterModel2 = this.textFilterModel;
            Object object2 = kubernetesTextFilterModel2 instanceof KubernetesLogFilterModel ? (MutableStateFlow<List<LogCluster>>)kubernetesTextFilterModel2 : null;
            if (object2 == null || (object2 = object2.getSelectedPatterns$intellij_clouds_kubernetes()) == null || (object2 = (List)object2.getValue()) == null) {
                object2 = selectedPatterns = CollectionsKt.emptyList();
            }
            if ((object = (kubernetesTextFilterModel = this.textFilterModel) instanceof KubernetesLogFilterModel ? (MutableStateFlow<List<LogCluster>>)kubernetesTextFilterModel : null) == null || (object = object.getExcludedPatterns$intellij_clouds_kubernetes()) == null || (object = (List)object.getValue()) == null) {
                object = excludedPatterns = CollectionsKt.emptyList();
            }
            if (selectedPatterns.isEmpty() && excludedPatterns.isEmpty()) {
                return;
            }
            String htmlText = KubernetesLogsPresentableTextBuildersKt.buildPatternsDescriptionHtmlText((List<? extends LogCluster>)selectedPatterns, (List<? extends LogCluster>)excludedPatterns);
            JLabel label = new JLabel(htmlText);
            label.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
            label.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ TextFilterField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    KubernetesContextLogsManager logsManager = TextFilterField.access$getTextFilterModel$p(this.this$0).getManager();
                    KubernetesLogsPatternMatchingAction.Companion.performKubernetesLogsPatternMatchingAction(logsManager);
                }
            });
            JBPopup jBPopup2 = this.patternsPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)label, null).setRequestFocus(false).setFocusable(false).setResizable(false).setMovable(false).setCancelOnClickOutside(true).createPopup();
            boolean bl = jBPopup2 != null ? jBPopup2.isVisible() : false;
            if (bl) {
                return;
            }
            JBPopup jBPopup3 = this.patternsPopup;
            if (jBPopup3 == null) break block5;
            jBPopup3.showUnderneathOf((Component)this.getTextEditor());
        }
    }

    private final void hideSelectedPatternsPopup() {
        JBPopup jBPopup = this.patternsPopup;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        this.patternsPopup = null;
    }

    private final boolean isSameFilterAs(String otherText) {
        String thisText = this.getText();
        CharSequence charSequence = thisText;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return StringsKt.isBlank((CharSequence)otherText);
        }
        return Intrinsics.areEqual((Object)thisText, (Object)otherText);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformCoreDataKeys.HELP_ID;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"HELP_ID");
        sink.set(dataKey, (Object)"kubernetes.logs.filter.text.field");
    }

    private static final void _init_$lambda$1(TextFilterField this$0, ActionEvent it) {
        this$0.applyFilter(true);
    }

    private static final void _init_$lambda$2(TextFilterField this$0) {
        this$0.hidePopup();
    }

    public static final /* synthetic */ Runnable access$createItemChosenCallback$s367062757(TextFilterField $this, JList p0) {
        return super.createItemChosenCallback(p0);
    }
}

