/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.KubernetesContextLogsModelKt;
import com.intellij.kubernetes.logs.KubernetesEventLog;
import com.intellij.kubernetes.logs.KubernetesLogPresentationSettings;
import com.intellij.kubernetes.view.KubernetesContainerObject;
import com.intellij.openapi.diagnostic.Logger;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import java.time.Instant;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001!B#\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\u0011\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010 \u00a8\u0006\""}, d2={"Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "", "timestamp", "Ljava/time/Instant;", "message", "", "sourceContainerObject", "Lcom/intellij/kubernetes/view/KubernetesContainerObject;", "<init>", "(Ljava/time/Instant;Ljava/lang/String;Lcom/intellij/kubernetes/view/KubernetesContainerObject;)V", "getTimestamp", "()Ljava/time/Instant;", "getMessage", "()Ljava/lang/String;", "getSourceContainerObject", "()Lcom/intellij/kubernetes/view/KubernetesContainerObject;", "source", "getSource", "prettyTimestamp", "getPrettyTimestamp", "toString", "options", "Lcom/intellij/kubernetes/logs/KubernetesLogPresentationSettings;", "toString$intellij_clouds_kubernetes", "size", "", "getSize", "()I", "compareTo", "other", "isEvent", "", "()Z", "Companion", "intellij.clouds.kubernetes"})
public class KubernetesContextLog
implements Comparable<KubernetesContextLog> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant timestamp;
    @NotNull
    private final String message;
    @Nullable
    private final KubernetesContainerObject sourceContainerObject;
    @NotNull
    private final String prettyTimestamp;
    private final boolean isEvent;
    @NotNull
    private static final Comparator<KubernetesContextLog> comparator;

    public KubernetesContextLog(@NotNull Instant timestamp, @NotNull String message2, @Nullable KubernetesContainerObject sourceContainerObject) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.timestamp = timestamp;
        this.message = message2;
        this.sourceContainerObject = sourceContainerObject;
        this.prettyTimestamp = KubernetesContextLogsModelKt.prettyFormatInstant(this.timestamp);
    }

    @NotNull
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public final KubernetesContainerObject getSourceContainerObject() {
        return this.sourceContainerObject;
    }

    @NotNull
    public String getSource() {
        KubernetesContainerObject kubernetesContainerObject = this.sourceContainerObject;
        Object object = this.sourceContainerObject;
        return (object != null && (object = ((KubernetesContainerObject)object).getParentPod()) != null && (object = ((V1Pod)object).getMetadata()) != null ? ((V1ObjectMeta)object).getName() : null) + " " + (kubernetesContainerObject != null ? kubernetesContainerObject.getName() : null);
    }

    @NotNull
    public final String getPrettyTimestamp() {
        return this.prettyTimestamp;
    }

    @NotNull
    public final String toString$intellij_clouds_kubernetes(@NotNull KubernetesLogPresentationSettings options) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (options.getShowTimestamp()) {
            $this$toString_u24lambda_u240.append("[" + this.prettyTimestamp + "]");
        }
        if (options.getShowTimestamp() && options.getShowSource()) {
            $this$toString_u24lambda_u240.append("\t");
        }
        if (options.getShowSource()) {
            $this$toString_u24lambda_u240.append("(" + this.getSource() + ")");
        }
        if ((options.getShowSource() || options.getShowTimestamp()) && options.getShowMessage()) {
            $this$toString_u24lambda_u240.append("\t");
        }
        if (options.getShowMessage()) {
            $this$toString_u24lambda_u240.append(this.getMessage());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return "[" + this.prettyTimestamp + "] (" + this.getSource() + ") " + this.getMessage();
    }

    public final int getSize() {
        return 1 + this.prettyTimestamp.length() + 3 + this.getSource().length() + 2 + this.getMessage().length() + 1;
    }

    @Override
    public int compareTo(@NotNull KubernetesContextLog other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return comparator.compare(this, other);
    }

    public boolean isEvent() {
        return this.isEvent;
    }

    static {
        Comparator comparator2 = new Comparator(){

            public final int compare(T a, T b) {
                KubernetesContextLog it = (KubernetesContextLog)a;
                boolean bl = false;
                Comparable comparable = it.getTimestamp();
                it = (KubernetesContextLog)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getTimestamp());
            }
        };
        comparator2 = new Comparator(comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    KubernetesContextLog it = (KubernetesContextLog)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getSource());
                    it = (KubernetesContextLog)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSource())));
                }
                return n;
            }
        };
        comparator = new Comparator(comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    KubernetesContextLog it = (KubernetesContextLog)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getMessage());
                    it = (KubernetesContextLog)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMessage())));
                }
                return n;
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u000ej\b\u0012\u0004\u0012\u00020\u0005`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesContextLog$Companion;", "", "<init>", "()V", "fromString", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "input", "", "source", "Lcom/intellij/kubernetes/view/KubernetesContainerObject;", "fromEvent", "event", "Lio/kubernetes/client/openapi/models/CoreV1Event;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesContextLogsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesContextLogsModel.kt\ncom/intellij/kubernetes/logs/KubernetesContextLog$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,261:1\n14#2:262\n*S KotlinDebug\n*F\n+ 1 KubernetesContextLogsModel.kt\ncom/intellij/kubernetes/logs/KubernetesContextLog$Companion\n*L\n67#1:262\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KubernetesContextLog fromString(@NotNull String input, @NotNull KubernetesContainerObject source) {
            Instant instant;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int index = StringsKt.indexOf$default((CharSequence)input, (char)' ', (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                return null;
            }
            String string = input.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String timestamp = string;
            String string2 = input.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String message2 = string2;
            try {
                instant = Instant.parse(timestamp);
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(KubernetesContextLog.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warnWithDebug(input, (Throwable)e);
                instant = Instant.now();
            }
            Instant instant2 = instant;
            Intrinsics.checkNotNull((Object)instant2);
            return new KubernetesContextLog(instant2, message2, source);
        }

        @NotNull
        public final KubernetesContextLog fromEvent(@NotNull CoreV1Event event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            return new KubernetesEventLog(event2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

