/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\u0000J\u001f\u0010\u0013\u001a\u00020\u00002\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0015\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u0013\u001a\u00020\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u0000J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0000J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0000J\u0013\u0010\u001f\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\\\u0010 \u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u000326\u0010#\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\u00190$H\u0002J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\u00a8\u0006-"}, d2={"Lcom/intellij/kubernetes/helm/model/ObjectPath;", "", "fullPath", "", "", "<init>", "(Ljava/util/List;)V", "getFullPath", "()Ljava/util/List;", "topObjectName", "getTopObjectName", "()Ljava/lang/String;", "topDefinitionName", "getTopDefinitionName", "definitionPath", "getDefinitionPath", "upshift", "newTopDefinitionName", "downshift", "append", "names", "", "([Ljava/lang/String;)Lcom/intellij/kubernetes/helm/model/ObjectPath;", "subpath", "startsWith", "", "other", "getRelativePathOf", "getParent", "weaklyEquivalent", "anotherPath", "equals", "comparePaths", "p1", "p2", "pathElementComparer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "e1", "e2", "hashCode", "", "toString", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nObjectPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectPath.kt\ncom/intellij/kubernetes/helm/model/ObjectPath\n+ 2 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,136:1\n129#2:137\n*S KotlinDebug\n*F\n+ 1 ObjectPath.kt\ncom/intellij/kubernetes/helm/model/ObjectPath\n*L\n52#1:137\n*E\n"})
public final class ObjectPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> fullPath;
    @Nullable
    private final String topObjectName;
    @Nullable
    private final String topDefinitionName;
    @NotNull
    private static final ObjectPath ROOT = new ObjectPath(CollectionsKt.emptyList());
    @NotNull
    private static final ObjectPath UNKNOWN;

    private ObjectPath(List<String> fullPath) {
        this.fullPath = fullPath;
        this.topObjectName = this.fullPath.isEmpty() ? null : (String)CollectionsKt.first(this.fullPath);
        this.topDefinitionName = (String)CollectionsKt.getOrNull(this.fullPath, (int)1);
    }

    @NotNull
    public final List<String> getFullPath() {
        return this.fullPath;
    }

    @Nullable
    public final String getTopObjectName() {
        return this.topObjectName;
    }

    @Nullable
    public final String getTopDefinitionName() {
        return this.topDefinitionName;
    }

    private final List<String> getDefinitionPath() {
        return this.fullPath.subList(1, this.fullPath.size());
    }

    @NotNull
    public final ObjectPath upshift(@NotNull String newTopDefinitionName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)newTopDefinitionName, (String)"newTopDefinitionName");
        boolean bl2 = bl = this.topObjectName != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = this.topObjectName;
        Intrinsics.checkNotNull((Object)string);
        return new ObjectPath(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)string), (Object)newTopDefinitionName), (Iterable)this.getDefinitionPath()));
    }

    @NotNull
    public final ObjectPath downshift() {
        boolean bl;
        boolean bl2 = bl = this.topObjectName != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.topDefinitionName == null) {
            throw new IllegalStateException("Cannot downshift an empty definition path");
        }
        String string = this.topObjectName;
        Intrinsics.checkNotNull((Object)string);
        return new ObjectPath(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)string), (Iterable)this.getDefinitionPath().subList(1, this.getDefinitionPath().size())));
    }

    @NotNull
    public final ObjectPath append(String ... names) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        return new ObjectPath(CollectionsKt.plus((Collection)this.fullPath, (Object[])names));
    }

    @NotNull
    public final ObjectPath append(@NotNull List<String> subpath) {
        Intrinsics.checkNotNullParameter(subpath, (String)"subpath");
        return new ObjectPath(CollectionsKt.plus((Collection)this.fullPath, (Iterable)subpath));
    }

    public final boolean startsWith(@NotNull ObjectPath other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.fullPath.size() > this.fullPath.size()) {
            return false;
        }
        return this.comparePaths(this.fullPath.subList(0, other.fullPath.size()), other.fullPath, (Function2<? super String, ? super String, Boolean>)((Function2)ObjectPath::startsWith$lambda$0));
    }

    @Nullable
    public final List<String> getRelativePathOf(@NotNull ObjectPath other) {
        List<String> list2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean condition$iv = this.startsWith(other);
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl = false;
            list2 = this.fullPath.subList(other.fullPath.size(), this.fullPath.size());
        } else {
            list2 = null;
        }
        return list2;
    }

    @Nullable
    public final ObjectPath getParent() {
        return this.fullPath.isEmpty() ? null : (this.fullPath.size() == 1 ? ROOT : new ObjectPath(this.fullPath.subList(0, this.fullPath.size() - 1)));
    }

    public final boolean weaklyEquivalent(@NotNull ObjectPath anotherPath) {
        Intrinsics.checkNotNullParameter((Object)anotherPath, (String)"anotherPath");
        return this.comparePaths(this.fullPath, anotherPath.fullPath, (Function2<? super String, ? super String, Boolean>)((Function2)ObjectPath::weaklyEquivalent$lambda$2));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.kubernetes.helm.model.ObjectPath");
        ObjectPath cfr_ignored_0 = (ObjectPath)other;
        return this.comparePaths(this.fullPath, ((ObjectPath)other).fullPath, (Function2<? super String, ? super String, Boolean>)((Function2)ObjectPath::equals$lambda$3));
    }

    private final boolean comparePaths(List<String> p1, List<String> p2, Function2<? super String, ? super String, Boolean> pathElementComparer) {
        if (p1.size() != p2.size()) {
            return false;
        }
        int n = ((Collection)p1).size();
        for (int i = 0; i < n; ++i) {
            if (((Boolean)pathElementComparer.invoke((Object)p1.get(i), (Object)p2.get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return ((Object)this.fullPath).hashCode();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.fullPath, (CharSequence)".", (CharSequence)".", null, (int)0, null, null, (int)60, null);
    }

    private static final boolean startsWith$lambda$0(String e1, String e2) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        return StringsKt.compareTo((String)e1, (String)e2, (boolean)true) == 0;
    }

    private static final boolean weaklyEquivalent$lambda$2(String e1, String e2) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        return Intrinsics.areEqual((Object)e1, (Object)"<iter>") || Intrinsics.areEqual((Object)e2, (Object)"<iter>") || StringsKt.compareTo((String)e1, (String)e2, (boolean)true) == 0;
    }

    private static final boolean equals$lambda$3(String e1, String e2) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        return StringsKt.compareTo((String)e1, (String)e2, (boolean)true) == 0;
    }

    public /* synthetic */ ObjectPath(List fullPath, DefaultConstructorMarker $constructor_marker) {
        this(fullPath);
    }

    static {
        String[] stringArray = new String[]{"<unknown>"};
        UNKNOWN = ROOT.append(stringArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/kubernetes/helm/model/ObjectPath$Companion;", "", "<init>", "()V", "ROOT", "Lcom/intellij/kubernetes/helm/model/ObjectPath;", "getROOT", "()Lcom/intellij/kubernetes/helm/model/ObjectPath;", "UNKNOWN", "getUNKNOWN", "fromDefinition", "rootObjectName", "", "definingElement", "Lcom/intellij/psi/PsiElement;", "capitalized", "", "buildPath", "", "keyVal", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "buildPathForYamlElement", "element", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "getPathElement", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nObjectPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectPath.kt\ncom/intellij/kubernetes/helm/model/ObjectPath$Companion\n+ 2 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,136:1\n53#2:137\n*S KotlinDebug\n*F\n+ 1 ObjectPath.kt\ncom/intellij/kubernetes/helm/model/ObjectPath$Companion\n*L\n130#1:137\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectPath getROOT() {
            return ROOT;
        }

        @NotNull
        public final ObjectPath getUNKNOWN() {
            return UNKNOWN;
        }

        @Nullable
        public final ObjectPath fromDefinition(@NotNull String rootObjectName, @NotNull PsiElement definingElement, boolean capitalized) {
            List<String> list2;
            Intrinsics.checkNotNullParameter((Object)rootObjectName, (String)"rootObjectName");
            Intrinsics.checkNotNullParameter((Object)definingElement, (String)"definingElement");
            PsiElement psiElement = definingElement;
            if (psiElement instanceof YAMLKeyValue) {
                list2 = this.buildPath((YAMLKeyValue)definingElement, capitalized);
            } else if (psiElement instanceof YAMLDocument) {
                list2 = CollectionsKt.emptyList();
            } else {
                return null;
            }
            List<String> definitionPath = list2;
            return new ObjectPath(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)rootObjectName), (Iterable)definitionPath), null);
        }

        private final List<String> buildPath(YAMLKeyValue keyVal, boolean capitalized) {
            return this.buildPathForYamlElement((YAMLPsiElement)keyVal, capitalized);
        }

        private final List<String> buildPathForYamlElement(YAMLPsiElement element, boolean capitalized) {
            String pathElement = this.getPathElement(element, capitalized);
            Class[] classArray = new Class[]{YAMLKeyValue.class, YAMLSequenceItem.class};
            YAMLPsiElement yAMLPsiElement = (YAMLPsiElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), (Class[])classArray);
            if (yAMLPsiElement == null) {
                return CollectionsKt.listOf((Object)pathElement);
            }
            YAMLPsiElement containerElement = yAMLPsiElement;
            return CollectionsKt.plus((Collection)this.buildPathForYamlElement(containerElement, capitalized), (Object)pathElement);
        }

        private final String getPathElement(YAMLPsiElement element, boolean capitalized) {
            String string;
            YAMLPsiElement yAMLPsiElement = element;
            if (yAMLPsiElement instanceof YAMLKeyValue) {
                String $this$transformIf$iv = YamlUtilKt.getEffectiveKeyText((YAMLKeyValue)element);
                boolean $i$f$transformIf = false;
                if (capitalized) {
                    String it = $this$transformIf$iv;
                    boolean bl = false;
                    string = StringsKt.capitalize((String)it);
                } else {
                    string = $this$transformIf$iv;
                }
            } else if (yAMLPsiElement instanceof YAMLSequenceItem) {
                string = "<iter>";
            } else {
                throw new IllegalArgumentException("Unrecognized element type");
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

