/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.ContextKey;
import com.intellij.kubernetes.api.ContextsConfiguration;
import com.intellij.kubernetes.api.KubeConfigEntity;
import com.intellij.kubernetes.api.KubeConfigEx;
import com.intellij.kubernetes.api.KubePlugin;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesApiProviderKt;
import com.intellij.kubernetes.api.KubernetesConflictingContextsFoundException;
import com.intellij.kubernetes.api.KubernetesContextNotFoundException;
import com.intellij.kubernetes.api.KubernetesIllegalKindException;
import com.intellij.kubernetes.api.KubernetesKubeConfigParsingException;
import com.intellij.kubernetes.api.settings.KubeConfigPathProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import io.kubernetes.client.util.KubeConfig;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\b\u0010\u0007\u001a\u00020\bH\u0002\u001a\"\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\bH\u0003\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0003\u001a%\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u000b\u0010\u0013\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0014H\u0003\u001a*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0080@\u00a2\u0006\u0002\u0010\u001a\u001a\u0018\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0082@\u00a2\u0006\u0002\u0010\u001f\u001a\u001e\u0010 \u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0082@\u00a2\u0006\u0002\u0010#\u001a=\u0010$\u001a\u001f\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b%\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0\n0\n2\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010&\u001a\u00020'H\u0002\u001a\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0)H\u0000\u001a\u0018\u0010,\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0014*\u00070\u0003\u00a2\u0006\u0002\b\u0014H\u0002\u001a\u001e\u0010-\u001a\u0004\u0018\u00010\u0003*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010.\u001a\u00020\u0003H\u0002\u001a(\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"00*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010&\u001a\u00020'H\u0002\u001a\"\u00101\u001a\b\u0012\u0004\u0012\u00020\"02*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010&\u001a\u00020'H\u0002\u001a\u0014\u00103\u001a\u0004\u0018\u00010\u00032\b\u00104\u001a\u0004\u0018\u00010\"H\u0002\u001a\u0014\u00105\u001a\u0004\u0018\u00010\u00032\b\u00104\u001a\u0004\u0018\u00010\"H\u0002\u001a\u001e\u00106\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"002\b\u00104\u001a\u0004\u0018\u00010\"H\u0002\u001a\u0018\u00107\u001a\b\u0012\u0004\u0012\u00020\"022\b\u00104\u001a\u0004\u0018\u00010\"H\u0002\u001a4\u00108\u001a\u0002H9\"\f\b\u0000\u00109\u0018\u0001*\u0004\u0018\u00010\"2\b\u00104\u001a\u0004\u0018\u00010\"2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H90;H\u0082\b\u00a2\u0006\u0002\u0010<\u001a\u0015\u0010=\u001a\u00020>*\u00020?2\u0006\u0010@\u001a\u00020?H\u0081\u0002\u001a\u001e\u0010A\u001a\u0004\u0018\u00010\u00032\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001e0)H\u0080@\u00a2\u0006\u0002\u0010C\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ALL_NAMESPACES_TOKEN", "", "contextComparator", "Ljava/util/Comparator;", "Lcom/intellij/kubernetes/api/Context;", "createYaml", "Lorg/yaml/snakeyaml/Yaml;", "loadConfiguration", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "yaml", "parseAndValidateKubeConfiguration", "Lcom/intellij/kubernetes/api/ContextsConfiguration;", "kubeConfigFile", "parseKubeConfiguration", "configuration", "kubeConfigUrl", "Lorg/jetbrains/annotations/NonNls;", "mergeKubeConfigFile", "", "project", "Lcom/intellij/openapi/project/Project;", "contexts", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "defaultConfig", "createEmptyConfig", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fillEmptyConfigFileByDefaultConfig", "requestor", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "associateByName", "Lcom/intellij/openapi/util/NlsSafe;", "entity", "Lcom/intellij/kubernetes/api/KubeConfigEntity;", "detectNotInstalledAuthPluginsInConfig", "", "Lcom/intellij/kubernetes/api/KubePlugin;", "users", "toPath", "getAsNonBlankStringSafely", "key", "getAsMapSafely", "", "getAsListSafely", "", "asNonBlankStringSafely", "yamlNode", "asStringSafely", "asMapSafely", "asListSafely", "asTypeSafely", "T", "typeConstructor", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "plus", "Lcom/intellij/kubernetes/api/KubeConfigEx;", "Lio/kubernetes/client/util/KubeConfig;", "other", "extractNamespaceFromFiles", "filesPaths", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesApiProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesApiProvider.kt\ncom/intellij/kubernetes/api/KubernetesApiProviderKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1005:1\n904#1,8:1018\n904#1,8:1026\n904#1,8:1034\n126#2:1006\n153#2,2:1007\n155#2:1010\n1#3:1009\n1557#4:1011\n1628#4,3:1012\n1734#4,3:1015\n1863#4,2:1043\n19#5:1042\n19#5:1045\n14#6:1046\n*S KotlinDebug\n*F\n+ 1 KubernetesApiProvider.kt\ncom/intellij/kubernetes/api/KubernetesApiProviderKt\n*L\n895#1:1018,8\n897#1:1026,8\n899#1:1034,8\n669#1:1006\n669#1:1007,2\n669#1:1010\n690#1:1011\n690#1:1012,3\n691#1:1015,3\n754#1:1043,2\n762#1:1042\n759#1:1045\n55#1:1046\n*E\n"})
public final class KubernetesApiProviderKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String ALL_NAMESPACES_TOKEN = "Kubernetes.All.Namespaces.Label";
    @NotNull
    private static final Comparator<Context> contextComparator;
    @NotNull
    private static final String defaultConfig;

    private static final Yaml createYaml() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(AdvancedSettings.Companion.getInt("kubernetes.config.maxFileSizeMb") * 1024 * 1024);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml((BaseConstructor)new SafeConstructor(loaderOptions), new Representer(dumperOptions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresReadLock
    @RequiresBackgroundThread
    private static final Map<?, ?> loadConfiguration(VirtualFile file, Yaml yaml) {
        Object object;
        try {
            Map map2;
            object = file.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl = false;
                map2 = (Map)yaml.load(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = map2;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            String string = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            throw new KubernetesKubeConfigParsingException(string, t);
        }
        return object;
    }

    static /* synthetic */ Map loadConfiguration$default(VirtualFile virtualFile, Yaml yaml, int n, Object object) {
        if ((n & 2) != 0) {
            yaml = KubernetesApiProviderKt.createYaml();
        }
        return KubernetesApiProviderKt.loadConfiguration(virtualFile, yaml);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    private static final ContextsConfiguration parseAndValidateKubeConfiguration(VirtualFile kubeConfigFile) {
        ContextsConfiguration contextsConfiguration;
        try {
            Map map2 = KubernetesApiProviderKt.loadConfiguration$default(kubeConfigFile, null, 2, null);
            String string = kubeConfigFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            contextsConfiguration = KubernetesApiProviderKt.parseKubeConfiguration(map2, string);
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof CancellationException) {
                throw e;
            }
            if (throwable instanceof KubernetesContextNotFoundException) {
                throw e;
            }
            if (throwable instanceof KubernetesIllegalKindException) {
                throw e;
            }
            String string = kubeConfigFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            throw new KubernetesKubeConfigParsingException(string, e);
        }
        return contextsConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private static final ContextsConfiguration parseKubeConfiguration(Map<?, ?> configuration, String kubeConfigUrl) {
        KubeConfigEx kubeConfigEx;
        Iterator $this$mapTo$iv$iv;
        Object contextName;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv2;
        Map<String, Map<Object, Object>> map2;
        List<Object> clustersList = KubernetesApiProviderKt.getAsListSafely(configuration, KubeConfigEntity.Clusters);
        List<Object> contextsList = KubernetesApiProviderKt.getAsListSafely(configuration, KubeConfigEntity.Contexts);
        List<Object> usersList = KubernetesApiProviderKt.getAsListSafely(configuration, KubeConfigEntity.Users);
        Map clusterPaths = new LinkedHashMap();
        for (Object clusterNode : clustersList) {
            String clusterName;
            String clusterServer;
            Map<Object, Object> clusterDefinition;
            Map<Object, Object> clusterMap = KubernetesApiProviderKt.asMapSafely(clusterNode);
            if (KubernetesApiProviderKt.getAsNonBlankStringSafely(clusterMap, "name") == null || KubernetesApiProviderKt.getAsNonBlankStringSafely(clusterDefinition = KubernetesApiProviderKt.getAsMapSafely(clusterMap, KubeConfigEntity.Clusters), "server") == null) continue;
            Map map3 = clusterPaths;
            if (KubernetesApiProviderKt.toPath(clusterServer) == null) continue;
            map3.put(clusterName, map2);
        }
        String kind = KubernetesApiProviderKt.getAsNonBlankStringSafely(configuration, "kind");
        if (!Intrinsics.areEqual((Object)kind, (Object)"Config")) {
            throw new KubernetesIllegalKindException(kind, kubeConfigUrl);
        }
        Map<String, Map<Object, Object>> clusterDefinitions = KubernetesApiProviderKt.associateByName(configuration, KubeConfigEntity.Clusters);
        Map<String, Map<Object, Object>> contextDefinitions = KubernetesApiProviderKt.associateByName(configuration, KubeConfigEntity.Contexts);
        Map<String, Map<Object, Object>> userDefinitions = KubernetesApiProviderKt.associateByName(configuration, KubeConfigEntity.Users);
        Map<String, Map<Object, Object>> $this$map$iv = contextDefinitions;
        boolean $i$f$map = false;
        map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv2.entrySet()) {
            Map<Object, Object> map4;
            Map<Object, Object> map5;
            object = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            contextName = (String)object.getKey();
            Map contextDefinition = (Map)object.getValue();
            String string = KubernetesApiProviderKt.getAsNonBlankStringSafely(contextDefinition, KubeConfigEntity.Clusters.getSingularKey());
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                map5 = clusterDefinitions.get(it);
            } else {
                map5 = null;
            }
            Map<Object, Object> clusterDefinition = map5;
            String string2 = KubernetesApiProviderKt.getAsNonBlankStringSafely(contextDefinition, KubeConfigEntity.Users.getSingularKey());
            if (string2 != null) {
                String it = string2;
                boolean bl3 = false;
                map4 = userDefinitions.get(it);
            } else {
                map4 = null;
            }
            Map<Object, Object> userDefinition = map4;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)KubeConfigEntity.Clusters), clusterDefinition), TuplesKt.to((Object)((Object)KubeConfigEntity.Contexts), (Object)contextDefinition), TuplesKt.to((Object)((Object)KubeConfigEntity.Users), userDefinition)};
            Map definitions = MapsKt.mapOf((Pair[])pairArray);
            collection.add(TuplesKt.to((Object)new ContextKey((String)contextName, kubeConfigUrl), (Object)new Context((String)contextName, kubeConfigUrl, new EnumMap<KubeConfigEntity, Map<Object, Object>>(definitions))));
        }
        Map existingContexts = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String currentContextName = KubernetesApiProviderKt.getAsNonBlankStringSafely(configuration, "current-context");
        Iterable $this$map$iv2 = existingContexts.keySet();
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv = object.next();
            contextName = (ContextKey)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set contextNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        if (currentContextName != null) {
            boolean bl;
            block13: {
                Iterable $this$all$iv = contextNames;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)currentContextName)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            }
            if (bl) {
                throw new KubernetesContextNotFoundException(currentContextName, contextNames, kubeConfigUrl);
            }
        }
        KubeConfigEx $this$parseKubeConfiguration_u24lambda_u2410 = kubeConfigEx = new KubeConfigEx(contextsList, clustersList, usersList);
        boolean bl = false;
        $this$parseKubeConfiguration_u24lambda_u2410.setContext(currentContextName);
        $this$parseKubeConfiguration_u24lambda_u2410.setPreferences(configuration.get("preferences"));
        $this$parseKubeConfiguration_u24lambda_u2410.setFile(new File(kubeConfigUrl));
        KubeConfigEx kubeConfig = kubeConfigEx;
        return new ContextsConfiguration(existingContexts, kubeConfig);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object mergeKubeConfigFile(@NotNull Project var0, @NotNull Collection<Context> var1_1, @NotNull Continuation<? super Collection<Context>> $completion) {
        block12: {
            block13: {
                if (!($completion instanceof mergeKubeConfigFile.1)) ** GOTO lbl-1000
                var9_3 = $completion;
                if ((var9_3.label & -2147483648) != 0) {
                    var9_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl($completion){
                        Object L$0;
                        Object L$1;
                        /* synthetic */ Object result;
                        int label;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return KubernetesApiProviderKt.mergeKubeConfigFile(null, null, (Continuation<? super Collection<Context>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var4_6 = VirtualFileManager.getInstance().findFileByNioPath(KubeConfigPathProvider.Companion.getDefaultKubeConfigFilePath());
                        if (var4_6 == null) break block12;
                        it = var4_6;
                        $i$a$-let-KubernetesApiProviderKt$mergeKubeConfigFile$kubeConfigFile$1 = false;
                        if (!(((CharSequence)VirtualFileUtil.readText((VirtualFile)it)).length() == 0)) break;
                        $continuation.L$0 = project;
                        $continuation.L$1 = contexts;
                        $continuation.label = 1;
                        v0 = KubernetesApiProviderKt.fillEmptyConfigFileByDefaultConfig((VirtualFile)it, (Object)KubernetesApiProvider.Companion.getInstance(project), (Continuation<? super VirtualFile>)$continuation);
                        if (v0 == var10_5) {
                            return var10_5;
                        }
                        ** GOTO lbl30
                    }
                    case 1: {
                        $i$a$-let-KubernetesApiProviderKt$mergeKubeConfigFile$kubeConfigFile$1 = false;
                        contexts = (Collection)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        v1 = (ReadConstraint[])v0;
                        break block13;
                    }
                }
                v1 = it;
            }
            if ((var5_10 = v1) == null) break block12;
            v2 = var5_10;
            ** GOTO lbl53
        }
        $continuation.L$0 = project;
        $continuation.L$1 = contexts;
        $continuation.label = 2;
        v3 = KubernetesApiProviderKt.createEmptyConfig(KubeConfigPathProvider.Companion.getDefaultKubeConfigFilePath(), (Continuation<? super VirtualFile>)$continuation);
        if (v3 == var10_5) {
            return var10_5;
        }
        ** GOTO lbl51
        {
            case 2: {
                contexts = (Collection)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl51:
                // 2 sources

                if ((v2 = (VirtualFile)v3) == null) {
                    throw new IllegalStateException("Cannot create default kubeconfig file");
                }
lbl53:
                // 3 sources

                kubeConfigFile = v2;
                var4_6 = new ReadConstraint[]{ReadConstraint.Companion.withDocumentsCommitted(project)};
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v4 = CoroutinesKt.constrainedReadAndWriteAction((ReadConstraint[])var4_6, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, mergeKubeConfigFile$lambda$19(com.intellij.openapi.vfs.VirtualFile java.util.Collection com.intellij.openapi.application.ReadAndWriteScope ), (Lcom/intellij/openapi/application/ReadAndWriteScope;)Lcom/intellij/openapi/application/ReadResult;)((VirtualFile)kubeConfigFile, (Collection)contexts), (Continuation)$continuation);
                if (v4 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl65
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl65:
                // 2 sources

                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Object createEmptyConfig(Path path, Continuation<? super VirtualFile> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super VirtualFile>, Object>(path, null){
            int label;
            final /* synthetic */ Path $path;
            {
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Path newConfigFile = Files.createFile(NioFiles.createParentDirectories((Path)this.$path), new FileAttribute[0]);
                        Files.writeString(newConfigFile, (CharSequence)KubernetesApiProviderKt.access$getDefaultConfig$p(), new OpenOption[0]);
                        this.label = 1;
                        Object object3 = CoroutinesKt.writeAction(() -> createEmptyConfig.2.invokeSuspend$lambda$0(newConfigFile), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super VirtualFile> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final VirtualFile invokeSuspend$lambda$0(Path $newConfigFile) {
                return VirtualFileManager.getInstance().refreshAndFindFileByNioPath($newConfigFile);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private static final Object fillEmptyConfigFileByDefaultConfig(VirtualFile var0, Object var1_1, Continuation<? super VirtualFile> $completion) {
        if (!($completion instanceof fillEmptyConfigFileByDefaultConfig.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KubernetesApiProviderKt.access$fillEmptyConfigFileByDefaultConfig(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = file;
                $continuation.label = 1;
                v0 = CoroutinesKt.writeAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fillEmptyConfigFileByDefaultConfig$lambda$22(com.intellij.openapi.vfs.VirtualFile java.lang.Object ), ()Lkotlin/Unit;)((VirtualFile)file, (Object)requestor), (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                file = (VirtualFile)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return file;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Map<String, Map<Object, Object>> associateByName(Map<?, ?> configuration, KubeConfigEntity entity) {
        Map entities = new LinkedHashMap();
        for (Object entityNode : KubernetesApiProviderKt.getAsListSafely(configuration, entity)) {
            String entityName;
            Map<Object, Object> entityMap = KubernetesApiProviderKt.asMapSafely(entityNode);
            if (KubernetesApiProviderKt.getAsNonBlankStringSafely(entityMap, "name") == null) continue;
            entities.put(entityName, KubernetesApiProviderKt.getAsMapSafely(entityMap, entity));
        }
        return MapsKt.toMap((Map)entities);
    }

    @NotNull
    public static final List<KubePlugin> detectNotInstalledAuthPluginsInConfig(@NotNull List<? extends Object> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        Object[] objectArray = new KubePlugin[5];
        objectArray[0] = new KubePlugin("aws-iam-authenticator", "aws-iam-authenticator", CollectionsKt.emptyList(), null, "aws-iam-authenticator", 8, null);
        Object object = new String[]{"auth", "print-access-token"};
        objectArray[1] = new KubePlugin("gcloud", "gcloud", CollectionsKt.listOf((Object[])object), null, "google-cloud-sdk", 8, null);
        object = new String[]{"account", "get-access-token"};
        objectArray[2] = new KubePlugin("az", "az", CollectionsKt.listOf((Object[])object), null, "az", 8, null);
        object = new String[]{"oidc-login", "get-token"};
        objectArray[3] = new KubePlugin("kubelogin", "kubectl", CollectionsKt.listOf((Object[])object), null, "kubectl-oidc_login", 8, null);
        objectArray[4] = new KubePlugin("dex-k8s-authenticator", "dex-k8s-authenticator", CollectionsKt.emptyList(), null, "dex-k8s-authenticator", 8, null);
        List knownPlugins = CollectionsKt.listOf((Object[])objectArray);
        List installedPlugins = new ArrayList();
        for (Object e : users) {
            List args;
            String command;
            Map exec;
            Object object2;
            Map map2 = e instanceof Map ? (Map)e : null;
            if (map2 == null) continue;
            Map userMap = map2;
            Object v = userMap.get("user");
            Map map3 = v instanceof Map ? (Map)v : null;
            if (map3 == null) continue;
            Map userExec = map3;
            Object v2 = userExec.get("exec");
            Map v4 = v2 instanceof Map ? (Map)v2 : null;
            if (v4 == null || ((object2 = (exec = v4).get("command")) instanceof String ? (String)object2 : null) == null) continue;
            command = command;
            Object v3 = exec.get("args");
            if ((v3 instanceof List ? (List)v3 : null) == null) continue;
            args = args;
            object2 = knownPlugins.iterator();
            while (object2.hasNext()) {
                KubePlugin plugin = (KubePlugin)object2.next();
                if (!Intrinsics.areEqual((Object)command, (Object)plugin.getCommand()) || !args.containsAll((Collection)plugin.getArgs())) continue;
                installedPlugins.add(plugin);
            }
        }
        return installedPlugins;
    }

    private static final String toPath(String $this$toPath) {
        CharSequence charSequence;
        try {
            CharSequence charSequence2;
            charSequence = new URL($this$toPath).getPath();
            if (StringsKt.isBlank((CharSequence)charSequence)) {
                boolean bl = false;
                charSequence2 = null;
            } else {
                charSequence2 = charSequence;
            }
            charSequence = (String)charSequence2;
        }
        catch (MalformedURLException e) {
            LOG.warnWithDebug("Unable to parse cluster server URL: " + $this$toPath, (Throwable)e);
            charSequence = null;
        }
        return charSequence;
    }

    private static final String getAsNonBlankStringSafely(Map<?, ?> $this$getAsNonBlankStringSafely, String key) {
        return KubernetesApiProviderKt.asNonBlankStringSafely($this$getAsNonBlankStringSafely.get(key));
    }

    private static final Map<Object, Object> getAsMapSafely(Map<?, ?> $this$getAsMapSafely, KubeConfigEntity entity) {
        return KubernetesApiProviderKt.asMapSafely($this$getAsMapSafely.get(entity.getSingularKey()));
    }

    private static final List<Object> getAsListSafely(Map<?, ?> $this$getAsListSafely, KubeConfigEntity entity) {
        return KubernetesApiProviderKt.asListSafely($this$getAsListSafely.get(entity.getPluralKey()));
    }

    private static final String asNonBlankStringSafely(Object yamlNode) {
        String string;
        String string2 = KubernetesApiProviderKt.asStringSafely(yamlNode);
        if (string2 != null) {
            CharSequence charSequence;
            CharSequence charSequence2 = string2;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            string = (String)charSequence;
        } else {
            string = null;
        }
        return string;
    }

    private static final String asStringSafely(Object yamlNode) {
        Object object;
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode;
        if (object2 == null) {
            boolean bl = false;
            object = null;
        } else if (object2 instanceof String) {
            object = yamlNode;
        } else {
            LOG.warn("Unable to parse kubeconfig node. Expected: " + String.class + ", Actual: " + yamlNode.getClass() + " \n\t" + yamlNode);
            boolean bl = false;
            object = null;
        }
        return (String)object;
    }

    private static final Map<Object, Object> asMapSafely(Object yamlNode) {
        Object object;
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode;
        if (object2 == null) {
            boolean bl = false;
            object = new LinkedHashMap();
        } else if (TypeIntrinsics.isMutableMap((Object)object2)) {
            object = yamlNode;
        } else {
            LOG.warn("Unable to parse kubeconfig node. Expected: " + Map.class + ", Actual: " + yamlNode.getClass() + " \n\t" + yamlNode);
            boolean bl = false;
            object = new LinkedHashMap();
        }
        return (Map)object;
    }

    private static final List<Object> asListSafely(Object yamlNode) {
        Object object;
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode;
        if (object2 == null) {
            boolean bl = false;
            object = new ArrayList();
        } else if (TypeIntrinsics.isMutableList((Object)object2)) {
            object = yamlNode;
        } else {
            LOG.warn("Unable to parse kubeconfig node. Expected: " + List.class + ", Actual: " + yamlNode.getClass() + " \n\t" + yamlNode);
            boolean bl = false;
            object = new ArrayList();
        }
        return (List)object;
    }

    private static final /* synthetic */ <T> T asTypeSafely(Object yamlNode, Function0<? extends T> typeConstructor) {
        Object object;
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode;
        if (object2 == null) {
            object = typeConstructor.invoke();
        } else {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (object2 instanceof Object) {
                object = yamlNode;
            } else {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                LOG.warn("Unable to parse kubeconfig node. Expected: " + Object.class + ", Actual: " + yamlNode.getClass() + " \n\t" + yamlNode);
                object = typeConstructor.invoke();
            }
        }
        return (T)object;
    }

    @VisibleForTesting
    @NotNull
    public static final KubeConfigEx plus(@NotNull KubeConfig $this$plus, @NotNull KubeConfig other) {
        KubeConfigEx kubeConfigEx;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String currentContext = $this$plus.getCurrentContext() != null && other.getCurrentContext() == null ? $this$plus.getCurrentContext() : ($this$plus.getCurrentContext() == null && other.getCurrentContext() != null ? other.getCurrentContext() : null);
        KubeConfigEx $this$plus_u24lambda_u2433 = kubeConfigEx = new KubeConfigEx((List<? extends Object>)KubernetesApiProviderKt.plus$join($this$plus, other, (Function1<? super KubeConfig, ? extends ArrayList<Object>>)((Function1)KubernetesApiProviderKt::plus$lambda$30)), (List<? extends Object>)KubernetesApiProviderKt.plus$join($this$plus, other, (Function1<? super KubeConfig, ? extends ArrayList<Object>>)((Function1)KubernetesApiProviderKt::plus$lambda$31)), (List<? extends Object>)KubernetesApiProviderKt.plus$join($this$plus, other, (Function1<? super KubeConfig, ? extends ArrayList<Object>>)((Function1)KubernetesApiProviderKt::plus$lambda$32)));
        boolean bl = false;
        $this$plus_u24lambda_u2433.setContext(currentContext);
        return kubeConfigEx;
    }

    @Nullable
    public static final Object extractNamespaceFromFiles(@NotNull List<? extends Path> filesPaths, @NotNull Continuation<? super String> $completion) {
        Yaml yaml = new Yaml();
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(filesPaths, yaml, null){
            int label;
            final /* synthetic */ List<Path> $filesPaths;
            final /* synthetic */ Yaml $yaml;
            {
                this.$filesPaths = $filesPaths;
                this.$yaml = $yaml;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = InterruptibleKt.runInterruptible$default(null, () -> extractNamespaceFromFiles.2.invokeSuspend$lambda$5(this.$filesPaths, this.$yaml), (Continuation)((Continuation)this), (int)1, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$5$lambda$0(Path path) {
                return Files.readString(path);
            }

            private static final Iterable invokeSuspend$lambda$5$lambda$1(Yaml $yaml, String content2) {
                Iterable iterable = $yaml.loadAll(content2);
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"loadAll(...)");
                return iterable;
            }

            private static final Map invokeSuspend$lambda$5$lambda$2(Object it) {
                Object $this$asSafely$iv = it;
                boolean $i$f$asSafely = false;
                Object object = $this$asSafely$iv;
                if (!(object instanceof Map)) {
                    object = null;
                }
                return (Map)object;
            }

            private static final Map invokeSuspend$lambda$5$lambda$3(Map kubernetesObject) {
                V v = kubernetesObject.get("metadata");
                return v instanceof Map ? (Map)v : null;
            }

            private static final String invokeSuspend$lambda$5$lambda$4(Map metadata) {
                Map map2 = metadata;
                V v = map2 != null ? map2.get("namespace") : null;
                return v instanceof String ? (String)v : null;
            }

            private static final String invokeSuspend$lambda$5(List $filesPaths, Yaml $yaml) {
                Set namespaces2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$filesPaths), extractNamespaceFromFiles.2::invokeSuspend$lambda$5$lambda$0), arg_0 -> extractNamespaceFromFiles.2.invokeSuspend$lambda$5$lambda$1($yaml, arg_0)), extractNamespaceFromFiles.2::invokeSuspend$lambda$5$lambda$2), extractNamespaceFromFiles.2::invokeSuspend$lambda$5$lambda$3), extractNamespaceFromFiles.2::invokeSuspend$lambda$5$lambda$4));
                if (namespaces2.size() > 1) {
                    return null;
                }
                String string = (String)CollectionsKt.singleOrNull((Iterable)namespaces2);
                if (string == null) {
                    string = "default";
                }
                return string;
            }
        }), $completion);
    }

    private static final String contextComparator$lambda$0(Context it) {
        return it.getName();
    }

    private static final String contextComparator$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String contextComparator$lambda$2(Context it) {
        return it.getKubeConfigUrl();
    }

    private static final String contextComparator$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void mergeKubeConfigFile$lambda$19$updateConfiguration(Map<Object, Object> configuration, Collection<Context> $contexts, VirtualFile kubeConfigFile, KubeConfigEntity entity) {
        Map<String, Map<Object, Object>> entityDefinitions = KubernetesApiProviderKt.associateByName(configuration, entity);
        List<Object> entityNodes = KubernetesApiProviderKt.getAsListSafely(configuration, entity);
        for (Context context : $contexts) {
            String contextName = context.getName();
            Map<Object, Object> map2 = entityDefinitions.get(contextName);
            if (map2 != null) {
                Map<Object, Object> it = map2;
                boolean bl = false;
                String string = kubeConfigFile.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                throw new KubernetesConflictingContextsFoundException(contextName, string, context.getKubeConfigUrl());
            }
            Map map3 = context.getDefinitions().getOrDefault((Object)entity, MapsKt.emptyMap());
            if (map3 == null) {
                map3 = MapsKt.emptyMap();
            }
            Map newEntityDefinitions = MapsKt.toMutableMap(map3);
            Map map4 = new LinkedHashMap();
            if (entity.getNameFirst()) {
                Map map5 = map4;
                String string = "name";
                Map<Object, Object> map6 = context.getDefinitions().get((Object)KubeConfigEntity.Contexts);
                if (map6 == null || (map6 = map6.get("user")) == null) {
                    map6 = contextName;
                }
                Map<Object, Object> map7 = map6;
                map5.put(string, map7);
            }
            map4.put(entity.getSingularKey(), newEntityDefinitions);
            if (!entity.getNameFirst()) {
                map4.put("name", contextName);
            }
            ((Collection)entityNodes).add(map4);
        }
    }

    private static final Object mergeKubeConfigFile$lambda$19$lambda$14(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object $this$asSafely$iv = it;
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof Map)) {
            object = null;
        }
        Map map2 = (Map)object;
        return map2 != null ? map2.get("name") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Collection mergeKubeConfigFile$lambda$19$lambda$18(VirtualFile $kubeConfigFile, ReadAndWriteScope $this_constrainedReadAndWriteAction, ContextsConfiguration $contextsConfiguration, Yaml $yaml, Map $configuration) {
        Closeable closeable = $kubeConfigFile.getOutputStream((Object)$this_constrainedReadAndWriteAction);
        Throwable throwable = null;
        try {
            OutputStream stream = (OutputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stream);
            Closeable closeable2 = stream;
            Object object = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter((OutputStream)closeable2, (Charset)object);
            int n = 8192;
            closeable2 = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object = null;
            try {
                BufferedWriter writer2 = (BufferedWriter)closeable2;
                boolean bl2 = false;
                $yaml.dump((Object)$configuration, (Writer)writer2);
                writer = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return $contextsConfiguration.getContexts().values();
    }

    private static final ReadResult mergeKubeConfigFile$lambda$19(VirtualFile $kubeConfigFile, Collection $contexts, ReadAndWriteScope $this$constrainedReadAndWriteAction) {
        Intrinsics.checkNotNullParameter((Object)$this$constrainedReadAndWriteAction, (String)"$this$constrainedReadAndWriteAction");
        Yaml yaml = KubernetesApiProviderKt.createYaml();
        Map configuration = MapsKt.toMutableMap(KubernetesApiProviderKt.loadConfiguration($kubeConfigFile, yaml));
        Iterable $this$forEach$iv = (Iterable)KubeConfigEntity.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KubeConfigEntity it = (KubeConfigEntity)((Object)element$iv);
            boolean bl = false;
            KubernetesApiProviderKt.mergeKubeConfigFile$lambda$19$updateConfiguration(configuration, $contexts, $kubeConfigFile, it);
        }
        Object $this$asSafely$iv = configuration.get("current-context");
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof CharSequence)) {
            object = null;
        }
        if ((($this$asSafely$iv = (CharSequence)object) == null || $this$asSafely$iv.length() == 0) && ($this$asSafely$iv = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)KubernetesApiProviderKt.getAsListSafely(configuration, KubeConfigEntity.Contexts)), KubernetesApiProviderKt::mergeKubeConfigFile$lambda$19$lambda$14))) != null) {
            Object it = $this$asSafely$iv;
            boolean bl = false;
            configuration.put("current-context", it);
        }
        String string = $kubeConfigFile.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        ContextsConfiguration contextsConfiguration = KubernetesApiProviderKt.parseKubeConfiguration(configuration, string);
        return $this$constrainedReadAndWriteAction.writeAction(() -> KubernetesApiProviderKt.mergeKubeConfigFile$lambda$19$lambda$18($kubeConfigFile, $this$constrainedReadAndWriteAction, contextsConfiguration, yaml, configuration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit fillEmptyConfigFileByDefaultConfig$lambda$22(VirtualFile $file, Object $requestor) {
        Closeable closeable = $file.getOutputStream($requestor);
        Throwable throwable = null;
        try {
            OutputStream stream = (OutputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stream);
            Closeable closeable2 = stream;
            Object object = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter((OutputStream)closeable2, (Charset)object);
            int n = 8192;
            closeable2 = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object = null;
            try {
                BufferedWriter writer2 = (BufferedWriter)closeable2;
                boolean bl2 = false;
                writer2.write(defaultConfig);
                writer = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final ArrayList<Object> plus$join(KubeConfig $this_plus, KubeConfig $other, Function1<? super KubeConfig, ? extends ArrayList<Object>> keySelector) {
        ArrayList<Object> result2;
        block1: {
            ArrayList it;
            result2 = new ArrayList<Object>();
            ArrayList arrayList = (ArrayList)keySelector.invoke((Object)$this_plus);
            if (arrayList != null) {
                it = arrayList;
                boolean bl = false;
                result2.addAll(it);
            }
            ArrayList arrayList2 = (ArrayList)keySelector.invoke((Object)$other);
            if (arrayList2 == null) break block1;
            it = arrayList2;
            boolean bl = false;
            result2.addAll(it);
        }
        return result2;
    }

    private static final ArrayList plus$lambda$30(KubeConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContexts();
    }

    private static final ArrayList plus$lambda$31(KubeConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getClusters();
    }

    private static final ArrayList plus$lambda$32(KubeConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUsers();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ ContextsConfiguration access$parseAndValidateKubeConfiguration(VirtualFile kubeConfigFile) {
        return KubernetesApiProviderKt.parseAndValidateKubeConfiguration(kubeConfigFile);
    }

    public static final /* synthetic */ String access$getAsNonBlankStringSafely(Map $receiver, String key) {
        return KubernetesApiProviderKt.getAsNonBlankStringSafely($receiver, key);
    }

    public static final /* synthetic */ String access$toPath(String $receiver) {
        return KubernetesApiProviderKt.toPath($receiver);
    }

    public static final /* synthetic */ Comparator access$getContextComparator$p() {
        return contextComparator;
    }

    public static final /* synthetic */ Object access$createEmptyConfig(Path path, Continuation $completion) {
        return KubernetesApiProviderKt.createEmptyConfig(path, (Continuation<? super VirtualFile>)$completion);
    }

    public static final /* synthetic */ String access$getDefaultConfig$p() {
        return defaultConfig;
    }

    public static final /* synthetic */ Object access$fillEmptyConfigFileByDefaultConfig(VirtualFile file, Object requestor, Continuation $completion) {
        return KubernetesApiProviderKt.fillEmptyConfigFileByDefaultConfig(file, requestor, (Continuation<? super VirtualFile>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesApiProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> KubernetesApiProviderKt.contextComparator$lambda$1(KubernetesApiProviderKt::contextComparator$lambda$0, arg_0)).thenComparing(arg_0 -> KubernetesApiProviderKt.contextComparator$lambda$3(KubernetesApiProviderKt::contextComparator$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"thenComparing(...)");
        contextComparator = comparator2;
        defaultConfig = "apiVersion: v1\nkind: Config\nclusters: []\ncontexts: []\nusers: []\ncurrent-context: \"\"\npreferences: {}";
    }
}

